# Copyright (c) 2010 Symbian Foundation Ltd.
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of the License "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Symbian Foundation - initial contribution.
#
# Contributors:
#
# Description: 
# Process file ROM log to make it suitable for re-use by buildrom.pl

use strict;
use Getopt::Long;

my $featurelist = "syborg_stem_features.iby";
GetOptions(
  "f|features=s" => \$featurelist,   # name of featurelist file
  );

print "ROM_IMAGE[0] {\n";
print "#include \"$featurelist\"\n";

my $line;
while ($line = <>)
	{
	# Put back original auto-btmap statements for any "mbm_rom" derived files
	$line =~ s/data="(.*mbm)_rom"(\s+)"(.*)"/auto-bitmap=$1$2$3/;
	
	# Put back original __ECOM_PLUGIN lines
	# REM expanded __ECOM_PLUGIN(\epoc32\release\ARMV5\urel,Sys\Bin,\epoc32\data\Z,Resource\Plugins, a3fFourCCConvertorPlugin.dll , a3fFourCCConvertorPlugin.dll ) 
	if ($line =~ /^REM expanded\s+__ECOM_PLUGIN/)
		{
		$line =~ s/REM expanded\s+//;
		my $discarded = <>;		# discard the derived file= line for the plugin
		}
	
	if ($line =~ /REM processed spidata/)
		{
		next;		# discard this line - it will be regenerated by the __ECOM_PLUGIN
		}
		
	if ($line =~ /REM processed \s*patchdata/i)
		{
		$line =~ s/REM processed\s+//;	# reinstate the original patchdata line
		my $discarded = <>;		# discard the final "patchdata ... addr" line
		}
		
	$line =~ s/REM processed //;	# re-enable other directives
	
	if ($line =~ /^time=/)
		{
		$line = "time=##TODAY## 12:00:00\n";
		}
	
	# remove lines added by buildrom for generated files
	
	if ($line =~ /^data=\S+\\([^\\]+)\s+"\S+"/)
		{
		my $file = $1;
		if ($file =~ /features.dat|ecom-\d-\d\.s/)
			{
			# print STDERR "Discarded: $line";
			next;
			}
		}

	if ($line =~ /^REM (ROM_IMAGE\[\d\])$/)
		{
		$line = "$1 {\n";
		print "}\n";		# close the preceeding ROM_IMAGE
		}

	print $line;
	}

print "}\n";
