/*
* Copyright (c) 2001-2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  EAP and WLAN authentication protocols.
*
*/

/*
* %version: %
*/

/**
 *  @mainpage EAP Core documentation.
 *  
 *  @section intro Introduction
 *  This is a EAP Core documentation generated by doxygen.
 *  First read <a href="../S60_3_1_EAP_Core.doc">S60_3_1_EAP_Core.doc</a>
 *  file from <a href="..">EAPOL/documentation</a> directory.
 *  Release notes are in file <a href="../../../../../wlan_linux/wlaneapol_linux/release_notes.txt">release_notes.txt</a>
 *  
 *  @section install Installation
 *  Installation instructions are in file <a href="../../../../../wlan_linux/wlaneapol_linux/readme.txt">EAPOL/readme.txt</a>.
 *  
 *  @section classes Most crucial classes
 *  The most crucial classes are dummy_eap_core_c, abs_eap_core_c,
 *  eap_base_type_c and abs_eap_base_type_c.
 *
 *  Header files are stored to a directory <a href="../../../include">EAPOL/include</a>.
 *  Implementation of dummy_eap_core_c class is in a file <a href="../../../core/eap_core.cpp">
 *  EAPOL/core/eap_core.cpp</a>. Implementation of eap_base_type_c class is in a file
 *  <a href="../../../common/eap_base_type.cpp">EAPOL/common/eap_base_type.cpp</a>.
 *  
 *  @section eap_types Implemented EAP-types
 *  
 *  @subsection GSMSIM EAP/SIM
 *  EAP/SIM implementation is in a directory
 *  <a href="../../../type/gsmsim">EAPOL/type/gsmsim</a>.
 *  EAP/SIM is specified in draft-haverinen-pppext-eap-sim-xx.txt.
 *  The most current is
 *  <a href="../../type/gsmsim/doc/rfc4186.txt">
 *  RFC 4186</a>.
 *  IETF drafts and RFC are stored to a directory <a href="../../type/gsmsim/doc">
 *  EAPOL/type/gsmsim/documentation</a>.
 *  The document
 *  <a href="../../type/gsmsim/doc/GSMSIM.doc">GSMSIM.doc</a>
 *  includes implementation notes of GSMSIM.
 *  
 *  @subsection EAP_AKA EAP/AKA
 *  EAP/AKA implementation is in a directory
 *  <a href="../../../type/aka">EAPOL/type/aka</a>.
 *  EAP/AKA is specified in draft-arkko-pppext-eap-aka-xx.txt.
 *  The most current is
 *  <a href="../../type/aka/doc/rfc4187.txt">
 *  RFC 4187</a>.
 *  IETF drafts are stored to a directory <a href="../../type/aka/doc">
 *  EAPOL/type/aka/documentation</a>.
 *  
 *  @subsection EAP_TLS_PEAP EAP/TLS, PEAP and TTLS
 *  Implementation design and architecture of EAP/TLS, PEAP and TTLS is in
 *  <a href="../../type/tls_peap/doc/EAP_TLS_PEAP.doc">EAP_TLS_PEAP.doc</a>
 *  file in <a href="../../type/tls_peap/doc">EAPOL/type/tls_peap/documentation</a> directory.
 *  EAP/TLS and PEAP implementation will be in a directory
 *  <a href="../../../type/tls_peap">EAPOL/type/tls_peap</a>.
 *  TLS is specified in <a href="../../type/tls_peap/doc/rfc2246.txt">rfc2246.txt</a>.
 *  EAP/TLS is specified in <a href="../../type/tls_peap/doc/rfc2716.txt">rfc2716.txt</a>.
 *  PEAPv2 is specified in <a href="../../type/tls_peap/doc/draft-josefsson-pppext-eap-tls-eap-08.txt">draft-josefsson-pppext-eap-tls-eap-08.txt</a>.
 *  PEAPv1 is specified in <a href="../../type/tls_peap/doc/draft-josefsson-pppext-eap-tls-eap-05.txt">draft-josefsson-pppext-eap-tls-eap-05.txt</a>.
 *  Windows XP- PEAPv0 is specified in <a href="../../type/tls_peap/doc/draft-kamath-pppext-peapv0-00.txt">draft-kamath-pppext-peapv0-00.txt</a>.
 *  TTLS is specified in <a href="../../type/tls_peap/doc/draft-ietf-pppext-eap-ttls-04.txt">draft-ietf-pppext-eap-ttls-04.txt</a>.
 *  
 *  @subsection EAP_MsChapv2 EAP/MsChapv2
 *  EAP/MsChapv2 implementation is in a directory
 *  <a href="../../../type/mschapv2">EAPOL/type/mschapv2</a>.
 *  EAP/MsChapv2 is specified in draft-kamath-pppext-eap-mschapv2-XX.txt, rfc2433.txt and rfc2759.txt.
 *  The most current is
 *  <a href="../../type/mschapv2/doc/draft-kamath-pppext-eap-mschapv2-01.txt">
 *  EAP/MsChapv2 draft version 2</a>.
 *  See also <a href="../../type/mschapv2/doc/rfc2433.txt">rfc2433.txt</a>
 *  and <a href="../../type/mschapv2/doc/rfc2759.txt">rfc2759.txt</a>.
 *  IETF drafts are stored to a directory <a href="../../type/mschapv2/doc">
 *  EAPOL/type/mschapv2/doc</a>.
 *  
 *  @subsection EAP_SecurID_GTC EAP/SecurID and GTC
 *  EAP/SecurID implementation is in a directory
 *  <a href="../../../type/securid">EAPOL/type/securid</a>.
 *  EAP/SecurID is specified in draft-josefsson-eap-securid-XX.txt.
 *  The most current is
 *  <a href="../../type/securid/doc/draft-josefsson-eap-securid-01.txt">
 *  EAP/SecurID draft version 1</a>.
 *  IETF drafts are stored to a directory <a href="../../type/securid/doc">
 *  EAPOL/type/securid/documentation</a>.
 *  
 *  @subsection EAP_LEAP EAP/LEAP
 *  EAP/LEAP implementation is in a directory
 *  <a href="../../../type/leap">EAPOL/type/leap</a>.
 *  EAP/LEAP documentation is not included here.
 *  
 *  @subsection SAE Experimental Security Association for EAPOL (not used)
 *  SAE implementation is in a directory <a href="../../../../../wlan_testing/wlaneapol_testing/SAE">EAPOL/SAE</a>.
 *  Document defining SAE is <a href="../../../../../wlan_testing/wlaneapol_testing/SAE/documentation/EAPOL_SA.doc">EAPOL_SA.doc</a>.
 *  This is a very experimental test implementation.
 *  Idea is to use Diffie-Hellman to create keys for a anonymous EAPOL tunnel.
 *  Any EAP-type could then run inside the tunnel.
 *  This fixes the problem of current EAPOL over WLAN.
 *  EAP was designed for poin to point environment and EAPOL to non-shared environment.
 *  
 *  NOTE SAE is not used anywhere.
 *
 *  @section Symbian Symbian Plug-in
 *  EAP Type Plug-in Architecture for Symbian is specified in
 *  <a href="../../am/type/symbian/plugin/doc/eap_plugin_architecture.doc">
 *  eap_plugin_architecture.doc</a>.
 *  
 */


#if !defined(_DUMMY_EAP_CORE_H_)
#define _DUMMY_EAP_CORE_H_

#include "eap_am_export.h"
// Start: added by script change_export_macros.sh.
#if defined(EAP_NO_EXPORT_DUMMY_EAP_CORE_H)
	#define EAP_CLASS_VISIBILITY_DUMMY_EAP_CORE_H EAP_NONSHARABLE 
	#define EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H 
	#define EAP_C_FUNC_VISIBILITY_DUMMY_EAP_CORE_H 
	#define EAP_FUNC_EXPORT_DUMMY_EAP_CORE_H 
	#define EAP_C_FUNC_EXPORT_DUMMY_EAP_CORE_H 
#elif defined(EAP_EXPORT_DUMMY_EAP_CORE_H)
	#define EAP_CLASS_VISIBILITY_DUMMY_EAP_CORE_H EAP_EXPORT 
	#define EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H EAP_FUNC_EXPORT 
	#define EAP_C_FUNC_VISIBILITY_DUMMY_EAP_CORE_H EAP_C_FUNC_EXPORT 
	#define EAP_FUNC_EXPORT_DUMMY_EAP_CORE_H EAP_FUNC_EXPORT 
	#define EAP_C_FUNC_EXPORT_DUMMY_EAP_CORE_H EAP_C_FUNC_EXPORT 
#else
	#define EAP_CLASS_VISIBILITY_DUMMY_EAP_CORE_H EAP_IMPORT 
	#define EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H EAP_FUNC_IMPORT 
	#define EAP_C_FUNC_VISIBILITY_DUMMY_EAP_CORE_H EAP_C_FUNC_IMPORT 
	#define EAP_FUNC_EXPORT_DUMMY_EAP_CORE_H 
	#define EAP_C_FUNC_EXPORT_DUMMY_EAP_CORE_H 
#endif
// End: added by script change_export_macros.sh.
#include "abs_eap_base_type.h"
#include "eap_core_map.h"
#include "eap_am_network_id.h"
#include "abs_eap_stack_interface.h"
#include "eap_configuration_field.h"
#include "abs_eap_core_map.h"
#include "eap_core.h"

class abs_eap_core_c;
class abs_eap_am_tools_c;
class eap_core_retransmission_c;
class eap_base_type_c;
class eap_variable_data_c;

//--------------------------------------------------------------------------------------------------

/**
 *  @defgroup EAP_Core_config_options Configuration options of EAP Core.
 *  The following configuration options are read through abs_eap_base_type_c::read_configure() function.
 *  @{
 */



//--------------------------------------------------------------------------------------------------



/// A eap_core_c class implements the basic functionality of EAP-type.
class EAP_CLASS_VISIBILITY_DUMMY_EAP_CORE_H dummy_eap_core_c
: public abs_eap_core_map_c
, public abs_eap_base_type_c
, public abs_eap_base_timer_c
, public abs_eap_stack_interface_c
{
private:
	//--------------------------------------------------

	/// This is back pointer to object which created this object.
	/// Packets are sent to the partner.
	abs_eap_core_c *m_partner;

	/// This is pointer to the tools class.
	abs_eap_am_tools_c * const m_am_tools;

	/// This stores eap_base_type objects using eap_variable_data selector.
	eap_core_map_c<eap_base_type_c, abs_eap_core_map_c, eap_variable_data_c> m_type_map;

	/// This stores the current EAP-type. When requested, we send our ID using 
	/// our default EAP-type. This is our best quess of other peer's EAP-type.
	/// Other peer will sent the real EAP-type later and we can NAK it then
	/// and send our own EAP-type. This is due the limitations of EAP-protocol.
	eap_type_value_e m_current_eap_type;

	/// This is our default EAP-type.
	eap_type_value_e m_default_eap_type;

	/// This is the queried EAP-identity.
	/// This is saved because other EAP-types may be load afterwards
	/// and they may query EAP-identity.
	eap_variable_data_c m_eap_identity;

	/// This is offset in bytes of the EAP-type header.
	u32_t m_eap_header_offset;

	/// This is maximum transfer unit in bytes.
	u32_t m_MTU;

	/// This is length of the trailer in bytes.
	u32_t m_trailer_length;

	/// This is network identity of the received packet.
	eap_am_network_id_c m_receive_network_id;

	/// Re-transmission is used to test protocols.
	/// This stores the information to resent a message. This is used for testing purposes.
	eap_core_retransmission_c *m_retransmission;

	/// Re-transmission is used to test protocols.
	/// This is the time after resent a message. This is used for testing purposes.
	u32_t m_retransmission_time;

	/// Re-transmission is used to test protocols.
	/// This is the maximum count of retransmission of one message. This is used for testing purposes.
	u32_t m_retransmission_counter;

	/// This is the maximum time authentication could succeed.
	/// Authentication is terminated after this time elapses.
	/// The EAP-type could change the timeout by calling set_session_timeout() function.
	u32_t m_session_timeout;

	u32_t m_eap_core_failure_received_timeout;

	u32_t m_remove_session_timeout;

#if defined(USE_EAP_CORE_WAIT_REQUEST_TYPE_TIMER)
	u32_t m_wait_eap_request_type_timeout;
	bool m_wait_eap_request_type_timeout_set;
#endif //#if defined(USE_EAP_CORE_WAIT_REQUEST_TYPE_TIMER)

	/// Latest received EAP-identifier. Used only for EAP-Request/Identity handling in client.
	/// Ensures that the EAP-Response/Identity is sent with the latest EAP-identifier.
	u8_t m_eap_identity_request_identifier_client;

	/// This indicates whether this object is client (true) or server (false).
	/// In terms of EAP-protocol whether this network entity is EAP-supplicant (true) or EAP-authenticator (false).
	bool m_is_client;

	/// This indicates whether the authentication role of this object is client (true) or server (false).
	/// In terms of EAP-protocol whether this network entitys authentication role is EAP-supplicant (true) or EAP-authenticator (false).
	/// NOTE the LEAP type changes authentication role during the authentication session.
	bool m_is_client_role;

	/// This indicates whether this object was generated successfully.
	bool m_is_valid;

	/// Client has initiated restart.
	bool m_client_restart_authentication_initiated;

	/// This flag indicates that this object is marked to removed asynchronously.
	/// The very same object could be taken use before the removing timer elapses.
	bool m_marked_removed;

	/// This flag prevents server receiving of multiple EAP-Response/Identity message.
	/// This is set true after the server accepts EAP-Response/Identity message.
	bool m_eap_identity_response_accepted;

	/// Function shutdown() is called already.
	bool m_shutdown_was_called;

	/// Server received EAP-Response from client. Server must not sent any other EAP-type. Server could send EAP-Failure or EAP-Success.
	/// Client sent a response. Client must not accept any other EAP-type.
	bool m_eap_type_response_sent;

	/// Tells whether this is tunneled EAP-session. For example inside PEAP or TTLS tunnel.
	/// This causes some changes to timeouts.
	bool m_is_tunneled_eap;

#if defined(USE_EAP_CORE_SERVER)
	/// If this flag is true EAP-Response/Nak is processed immediately.
	/// If this flag is false EAP-Response/Nak is processed after a timeout.
	/// There might be received more suitable EAP-Response.
	bool m_process_eap_nak_immediately;

	/// EAP-Response/Nak is initiated.
	bool m_nak_process_timer_active;

	/// This flag prevents server sending of multiple EAP-Request/Identity message.
	bool m_eap_identity_request_send;

	/// This is set true after the server receives EAP-Response/Identity message.
	bool m_eap_identity_response_received;

	/// This flag is set true after a EAP-Failure is sent.
	bool m_eap_failure_sent;

	/// This flag selects whether EAP-Success is send after state notification is forwarded to lower layer (true)
	/// or EAP-Success is send before state notification is forwarded to lower layer (false).
	bool m_send_eap_success_after_notification;

#if defined(USE_EAP_CORE_WAIT_REQUEST_TYPE_TIMER)
	// This flag selects whether EAP-Request/Identity is send (true) or not (false).
	bool m_skip_eap_request_identity;
#endif //#if defined(USE_EAP_CORE_WAIT_REQUEST_TYPE_TIMER)
#endif //#if defined(USE_EAP_CORE_SERVER)

	bool m_use_eap_expanded_type;

	/// Some of the protocols terminates with EAP-Failure. This flag tells to ignore EAP-Failure.
	bool m_ignore_eap_failure;

	bool m_ignore_notifications;

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	/**
	 * Re-transmission is used to test protocols.
	 * This function resends the packet.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e resend_packet(
		const eap_am_network_id_c * const send_network_id,
		eap_buf_chain_wr_c * const sent_packet,
		const u32_t header_offset,
		const u32_t data_length,
		const u32_t buffer_free,
		const u32_t retransmission_counter
		);

	/** 
	 * Re-transmission is used to test protocols.
	 * This function cancels retransmissions.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e cancel_retransmission();

	/**
	 * Re-transmission is used to test protocols.
	 * This function inits retransmission of sent packet.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e init_retransmission(
		const eap_am_network_id_c * const send_network_id,
		eap_buf_chain_wr_c * const sent_packet,
		const u32_t header_offset,
		const u32_t data_length,
		const eap_code_value_e eap_code,
		const u8_t eap_identifier,
		const eap_type_value_e eap_type
		);

	/**
	 * This function cancels previous session timeout and initializes new timeout for the session.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e initialize_session_timeout(
		const u32_t session_timeout_ms);

	/**
	 * This function cancels timeout for a session.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e cancel_session_timeout();

	/**
	 * This function calls shutdown() for one eap_base_type_c object.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H static eap_status_e shutdown_operation(
		eap_base_type_c * const value,
		abs_eap_am_tools_c * const m_am_tools);

	/**
	 * This function calls reset() for one eap_base_type_c object.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H static eap_status_e reset_operation(
		eap_base_type_c * const handler,
		abs_eap_am_tools_c * const m_am_tools);

	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e client_proposes_eap_types(
		const eap_am_network_id_c * const receive_network_id,
		const u8_t eap_identifier);

	/**
	 * This function processes EAP-packet with known EAP-type.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e packet_process_type(
		const eap_type_value_e used_eap_type,
		const eap_am_network_id_c * const receive_network_id,
		eap_general_header_base_c * const packet_data,
		const u32_t packet_length);

#if defined(USE_EAP_CORE_SERVER)
	/**
	 * This function re-starts authentication with new EAP-type.
	 * Only server calls this function.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e restart_with_new_type(
		const eap_type_value_e used_eap_type,
		const eap_am_network_id_c * const receive_network_id,
		const u8_t eap_identifier);
#endif //#if defined(USE_EAP_CORE_SERVER)

#if defined(USE_EAP_CORE_SERVER)
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e handle_eap_identity_response(
		eap_base_type_c * const handler,
		const eap_type_value_e used_eap_type,
		const eap_am_network_id_c * const receive_network_id,
		eap_header_wr_c * const eap,
		const u32_t packet_length);
#endif //#if defined(USE_EAP_CORE_SERVER)

	/**
	 * This function handles EAP-Request/Identity.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e handle_eap_identity_request(
		const eap_type_value_e used_eap_type,
		const u8_t eap_identifier,
		const eap_am_network_id_c * const receive_network_id);

	/**
	 * This function creates EAP-Response/Identity.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e create_eap_identity_response(
		eap_buf_chain_wr_c * const response_packet,
		const eap_variable_data_c * const identity,
		const u8_t eap_identifier
		);

	/**
	 * This function sends EAP-Response/Identity.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e send_eap_identity_response(
		const eap_am_network_id_c * const send_network_id,
		const eap_variable_data_c * const identity,
		const u8_t eap_identifier);

	/**
	 * This function sends EAP-Response/Notification.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e send_eap_notification_response(
		const eap_am_network_id_c * const send_network_id,
		const u8_t eap_identifier);

	/**
	 * This function initializes timeout for received EAP-Failure.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e set_eap_failure_timeout();

	/**
	 * This function cancels timeout for received EAP-Failure.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e cancel_eap_failure_timeout();

#if defined(USE_EAP_CORE_WAIT_REQUEST_TYPE_TIMER)
	eap_status_e set_wait_eap_request_type_timeout();

	eap_status_e cancel_wait_eap_request_type_timeout();
#endif //#if defined(USE_EAP_CORE_WAIT_REQUEST_TYPE_TIMER)

	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e asynchronous_init_remove_eap_session();

	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e initialize_asynchronous_init_remove_eap_session(
		const u32_t remove_session_timeout);

	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e cancel_asynchronous_init_remove_eap_session();

	eap_status_e init_end_of_session(
		const abs_eap_state_notification_c * const state);

	eap_status_e set_eap_identity_routing_info_and_nai_decoration(
		eap_variable_data_c * const identity);

	//--------------------------------------------------
protected:
	//--------------------------------------------------

	//--------------------------------------------------
public:
	//--------------------------------------------------

	/**
	 * The destructor of the eap_core class does nothing special.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H virtual ~dummy_eap_core_c();

	/**
	 * The constructor initializes member attributes using parameters passed to it.
	 * @param tools is pointer to the tools class. @see abs_eap_am_tools_c.
	 * @param partner is back pointer to object which created this object.
	 * @param is_client_when_true indicates whether the network entity should act
	 * @param is_tunneled_eap tells the EAP is run in tunnel (PEAP or other).
	 * as a client (true) or server (false), in terms of EAP-protocol
	 * whether this network entity is EAP-supplicant (true) or EAP-authenticator (false).
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H dummy_eap_core_c(
		abs_eap_am_tools_c * const tools,
		abs_eap_core_c * const partner,
		const bool is_client_when_true,
		const eap_am_network_id_c * const receive_network_id,
		const bool is_tunneled_eap);

	/**
	 * The load_type() function function indicates the lower level to load
	 * new module including EAP-type. The type parameter is the requested EAP-type.
	 * @param type is the identifier of the required EAP type.
	 * @return Function returns pointer to the EAP type object.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_base_type_c * load_type(
		const eap_type_value_e type,
		const eap_type_value_e tunneling_type,
		const eap_am_network_id_c * const receive_network_id);

	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void trace_eap_packet(
		eap_const_string prefix,
		const eap_header_wr_c * const eap_header);

	// This is documented in abs_eap_stack_interface_c::packet_process().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e packet_process(
		const eap_am_network_id_c * const receive_network_id,
		eap_general_header_base_c * const packet_data,
		const u32_t packet_length); 

	// This is documented in abs_eap_base_type_c::packet_send().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e packet_send(
		const eap_am_network_id_c * const send_network_id,
		eap_buf_chain_wr_c * const sent_packet,
		const u32_t header_offset,
		const u32_t data_length,
		const u32_t buffer_length); 

	/**
	 * The get_partner() function returns pointer to partner class.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H abs_eap_core_c * get_partner();

	/**
	 * The set_partner() function sets pointer to partner class.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void set_partner(abs_eap_core_c * const partner);

	// This is documented in abs_eap_base_type_c::get_header_offset().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H u32_t get_header_offset(
		u32_t * const MTU,
		u32_t * const trailer_length);

	// This is documented in abs_eap_base_type_c::load_module().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e load_module(
		const eap_type_value_e type,
		const eap_type_value_e /* tunneling_type */,
		abs_eap_base_type_c * const partner,
		eap_base_type_c ** const eap_type,
		const bool is_client_when_true,
		const eap_am_network_id_c * const receive_network_id);

	// This is documented in abs_eap_base_type_c::unload_module().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e unload_module(
		const eap_type_value_e type); 

	/**
	 * The adaptation module calls the eap_acknowledge() function after
	 * any Network Protocol packet is received. This is used as a success indication.
	 * This is described in RFC 2284 "PPP Extensible Authentication Protocol (EAP)".
	 * Mostly there is only one session in the client.
	 * The server does not need eap_acknowledge() function because
	 * server (EAP-authenticator) sends the EAP-success message.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e eap_acknowledge(
		const eap_am_network_id_c * const receive_network_id); 

	// This is documented in abs_eap_base_type_c::restart_authentication().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e restart_authentication(
		const eap_am_network_id_c * const send_network_id,
		const bool is_client_when_true);

	/**
	 * The EAP Core calls the send_eap_nak_response() function
	 * when EAP-authentication with requested EAP type is not possible.
	 * @param receive_network_id includes the addresses (network identity) and packet type.
	 * @param eap_identifier is the EAP-Identifier to be used with EAP-Nak message.
	 * @param preferred_eap_type is the acceptable EAP-Type to be informed with an other peer.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e send_eap_nak_response(
		const eap_am_network_id_c * const receive_network_id,
		const u8_t eap_identifier,
		const eap_array_c<eap_type_value_e> * const eap_type_list);


#if defined(USE_EAP_CORE_SERVER)

	/**
	 * The EAP Core calls the send_eap_identity_request() function
	 * when EAP-authentication is needed with another peer.
	 * @param network_id includes the addresses (network identity) and packet type.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e send_eap_identity_request(
		const eap_am_network_id_c * const network_id);

	/**
	 * This function sends EAP-Success.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e send_eap_success(
		const eap_am_network_id_c * const send_network_id,
		const u8_t eap_identifier);

	/**
	 * This function sends EAP-Failure.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e send_eap_failure(
		const eap_am_network_id_c * const send_network_id,
		const u8_t eap_identifier);

#endif //#if defined(USE_EAP_CORE_SERVER)


	// This is documented in abs_eap_base_type_c::packet_data_crypto_keys().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e packet_data_crypto_keys(
		const eap_am_network_id_c * const send_network_id,
		const eap_master_session_key_c * const master_session_key
		);

	// This is documented in abs_eap_stack_interface_c::configure().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e configure();

	// This is documented in abs_eap_stack_interface_c::shutdown().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e shutdown();

	// This is documented in abs_eap_base_type_c::read_configure().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H virtual eap_status_e read_configure(
		const eap_configuration_field_c * const field,
		eap_variable_data_c * const data);

	// This is documented in abs_eap_base_type_c::write_configure().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H virtual eap_status_e write_configure(
		const eap_configuration_field_c * const field,
		eap_variable_data_c * const data);

	// This is documented in abs_eap_stack_interface_c::set_is_valid().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void set_is_valid();

	// This is documented in abs_eap_stack_interface_c::get_is_valid().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H bool get_is_valid();

	// This is documented in abs_eap_base_type_c::state_notification().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void state_notification(
		const abs_eap_state_notification_c * const state);

	// See abs_eap_base_timer_c::timer_expired().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e timer_expired(
		const u32_t id, void *data);

	// See abs_eap_base_timer_c::timer_delete_data().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e timer_delete_data(
		const u32_t id, void *data);

	/**
	 * eap_core_map_c class increases reference count each time reference to stored object is get.
	 * Here is always just one state for one session so no references are used.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void object_increase_reference_count();

	/**
	 * eap_core_map_c class increases reference count each time reference to stored object is get.
	 *  Here is always just one state for one session so no references are used.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H u32_t object_decrease_reference_count();

	/**
	 * @{ Add configuration of accepted EAP-types. }
	 */
	// This is documented in abs_eap_base_type_c::check_is_valid_eap_type().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e check_is_valid_eap_type(const eap_type_value_e eap_type);

	// This is commented in abs_eap_base_type_c::get_eap_type_list().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e get_eap_type_list(
		eap_array_c<eap_type_value_e> * const eap_type_list);

	/**
	 * Gets flag whether this session is marked removed.
	 * Session is removed later if it is not reused.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H bool get_marked_removed();

	/**
	 * Marks this session removed.
	 * Session is removed later if it is not reused.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void set_marked_removed();

	/**
	 * Marks this session not removed.
	 * Session is not removed it is reused.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void unset_marked_removed();

	/**
	 * Prevents all notifications.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H void ignore_notifications();

	/**
	 * This function must reset the state of object to same as 
	 * state was after the configure() function call.
	 * If object reset succeeds this function must return eap_status_ok.
	 * If object reset fails this function must return corresponding error status.
	 * @return This function returns the status of reset operation.
	 */
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e reset();

	// This is documented in abs_eap_base_type_c::complete_eap_identity_query().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e complete_eap_identity_query(
		const eap_am_network_id_c * const send_network_id,
		const eap_variable_data_c * const identity,
		const u8_t eap_identifier);

	// This is documented in abs_eap_base_type_c::get_saved_eap_identity().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e get_saved_eap_identity(eap_variable_data_c * const identity);

	// This is documented in abs_eap_base_type_c::set_session_timeout().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e set_session_timeout(
		const u32_t session_timeout_ms);

	// This is documented in abs_eap_base_type_c::set_timer().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e set_timer(
		abs_eap_base_timer_c * const p_initializer, 
		const u32_t p_id, 
		void * const p_data,
		const u32_t p_time_ms);

	// This is documented in abs_eap_base_type_c::cancel_timer().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e cancel_timer(
		abs_eap_base_timer_c * const p_initializer, 
		const u32_t p_id);

	// This is documented in abs_eap_base_type_c::set_authentication_role().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e set_authentication_role(const bool when_true_set_client);

	// This is documented in abs_eap_base_type_c::add_rogue_ap().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H eap_status_e add_rogue_ap(eap_array_c<eap_rogue_ap_entry_c> & rogue_ap_list);

	// This is documented in abs_eap_base_type_c::get_is_tunneled().
	EAP_FUNC_VISIBILITY_DUMMY_EAP_CORE_H bool get_is_tunneled_eap() const;

	//--------------------------------------------------
}; // class dummy_eap_core_c


#endif //#if !defined(_DUMMY_EAP_CORE_H_)

//--------------------------------------------------



// End.
