/*
* Copyright (c) 2001-2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  EAP and WLAN authentication protocols.
*
*/

/*
* %version: 10 %
*/

#if !defined(_EAP_STATUS_H_)
#define _EAP_STATUS_H_

/** @file */ 

/// This is enumeration of status values used in EAP_Core.
/**
 * Most of the functions return type of eap_status value.
 * Each value is defined in eap_status.h. The eap_status_ok value indicates no errors. 
 * The eap_status_success value indicates the EAP-authentication was successful. 
 * Other values try to be self-documenting. 
 * The return value of every function MUST be checked. 
 * Execution of the current function MUST handle error case generated by called function. 
 * In most cases this means immediately returning the erroneous status 
 * from the current function. User MUST free the memory allocated before the error occurs. 
 * Look at the following example.
 * @code
 * // A new EAP-type is needed. The load_type() allocates new object.
 * eap_base_type *handler = load_type(used_eap_type);
 * if (handler != 0)
 * {
 *	if (handler->get_is_valid() == true)
 *	{
 * 		eap_status status = handler->configure();
 * 		if (status != eap_status_ok)
 * 		{
 * 			// Configuration failed.
 * 			delete handler;
 * 		}
 * 		EAP_TRACE_END(m_am_tools, TRACE_FLAGS_DEFAULT);
 * 		return status;
 *	}
 *	else
 *	{
 * 		// Handler not constructed successfully.
 * 		delete handler;
 * 		EAP_TRACE_END(m_am_tools, TRACE_FLAGS_DEFAULT);
 * 		return eap_status_allocation_error;
 *	}
 * }
 * else
 * {
 * 	EAP_TRACE_END(m_am_tools, TRACE_FLAGS_DEFAULT);
 * 	return eap_status_illegal_eap_type;
 * }
 * @endcode
 */

enum eap_status_e
{
	eap_status_ok, ///< This means successfull status.
	eap_status_success, ///< EAP-authentication is successful.
	eap_status_pending_request, ///< Request is pending. It will be completed later.
	eap_status_completed_request, ///< Request was completed already.
	eap_status_drop_packet_quietly, ///< Packet was dropped quietly. Just forget that packet.
	eap_status_not_supported, ///< You need to write some code to support this function.
	eap_status_process_general_error, ///< Most propably you need debugger to found reason to this error.
	eap_status_type_does_not_exists_error, ///< EAP-type is not implemented.
	eap_status_allocation_error, ///< Memory allocation failed. Try again later or release memory.
	eap_status_process_illegal_packet_error,
	eap_status_ethernet_type_not_supported,
	eap_status_illegal_eap_code,
	eap_status_illegal_eap_type,
	eap_status_illegal_eap_identity,
	eap_status_authentication_failure,
	eap_status_encryption_failure,
	eap_status_decryption_failure,
	eap_status_illegal_padding,
	eap_status_randomize_failure,
	eap_status_handler_exists_error,
	eap_status_handler_does_not_exists_error,
	eap_status_wrong_sae_state,
	eap_status_wrong_eapol_version,
	eap_status_wrong_eapol_type,
	eap_status_wrong_eapol_oui,
	eap_status_header_corrupted,
	eap_status_wrong_sae_sequence_number,
	eap_status_wrong_isakmp_header_version,
	eap_status_wrong_isakmp_exchange_type,
	eap_status_wrong_isakmp_flags,
	eap_status_wrong_isakmp_message_id,
	eap_status_wrong_isakmp_cookie,
	eap_status_unsupported_isakmp_payload,
	eap_status_key_error,
	eap_status_too_many_offers,
	eap_status_send_failed,
	eap_status_data_length_not_aligned_to_block_size,
	eap_status_wrong_network_id,
	eap_status_illegal_handle,
	eap_status_illegal_configure_field,
	eap_status_illegal_configure_type,
	eap_status_wrong_sae_header_version,
	eap_status_wrong_sae_exchange_type,
	eap_status_wrong_sae_flags,
	eap_status_unsupported_sae_payload,
	eap_status_wrong_sae_cookie,
	eap_status_illegal_encryption_parameter_size,
	eap_status_state_reference_count_not_zero,
	eap_status_illegal_nai,
	eap_status_illegal_nai_payload,
	eap_status_illegal_data_payload,
	eap_status_illegal_payload,
	eap_status_illegal_hashed_index,
	eap_status_wrong_gsmsim_state,
	eap_status_wrong_eap_type_state, ///< Use this instead of eap_status_wrong_gsmsim_state.
	eap_status_unsupported_gsmsim_payload,
	eap_status_unsupported_payload, ///< Use this instead of eap_status_unsupported_gsmsim_payload.
	eap_status_gsmsim_triplet_query_failed,
	eap_status_illegal_index,
	eap_status_timed_out,
	eap_status_wrong_eap_subtype,
	eap_status_exit_test,
	eap_status_no_matching_protocol_version,
	eap_status_too_short_message,
	eap_status_too_long_message,
	eap_status_hardware_not_ready,
	eap_status_wrong_protocol,
	eap_status_wrong_type,
	eap_status_illegal_parameter,
	eap_status_illegal_certificate,
	eap_status_illegal_cipher_suite,
	eap_status_bad_certificate,
	eap_status_unsupported_certificate,
	eap_status_certificate_revoked,
	eap_status_certificate_expired,
	eap_status_ca_certificate_unknown,
	eap_status_user_certificate_unknown,
	eap_status_unknown_ca,
	eap_status_access_denied,
	eap_status_unexpected_message,
	eap_status_buffer_too_short,
	eap_status_not_found,
	eap_status_not_enough_challenges,
	eap_status_not_fresh_challenges,
	eap_status_already_exists,
	eap_status_insufficient_security,
	eap_status_syncronization_failure,
	eap_status_file_does_not_exist,
	eap_status_end_of_file,
	eap_status_file_write_failed,
	eap_status_wrong_authentication_type,
	eap_status_section_ends,
	eap_status_missing_payload,
	eap_status_realm_check_failed,
	eap_status_identity_query_failed,
	eap_status_credential_query_failed,
	eap_status_user_has_not_subscribed_to_the_requested_service,
	eap_status_users_calls_are_barred,
	eap_status_restricted_logon_hours,
	eap_status_account_disabled,
	eap_status_no_dialin_permission,
	eap_status_password_expired,
	eap_status_wrong_password,
	eap_status_oob_interface_read_error,
	eap_status_decryption_crc_failure,
	eap_status_rf_band_2_4_ghz_not_supported,
	eap_status_rf_band_5_0_ghz_not_supported,
	eap_status_signal_too_weak,
	eap_status_network_authentication_failure,
	eap_status_network_association_failure,
	eap_status_no_dhcp_response,
	eap_status_failed_dhcp_configure,
	eap_status_ip_address_conflict,
	eap_status_could_not_connect_to_registrar,
	eap_status_multiple_pbc_sessions_detected,
	eap_status_rogue_activity_suspected,
	eap_status_device_busy,
	eap_status_setup_locked,
	eap_status_message_timeout,
	eap_status_registration_session_timeout,
	eap_status_device_password_authentication_failure,
	eap_status_pin_code_authentication_not_supported,
	eap_status_push_button_authentication_not_supported,
	eap_status_end_recursion,
	eap_status_tunnel_compromise_error,
	eap_status_unexpected_tlv_exhanged,
	eap_status_no_pac_nor_certs_to_authenticate_with_provision_disabled,
	eap_status_no_matching_pac_for_aid,
	eap_status_pac_store_corrupted,
	eap_status_user_cancel_authentication,
	eap_status_no_match,
};


#endif //#if !defined(_EAP_STATUS_H_)



// End.
