/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 242
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 59
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  ExprList* yy44;
  Expr * yy116;
  int yy124;
  TriggerStep* yy137;
  SrcList* yy149;
  Expr* yy162;
  struct LikeOp yy168;
  Token yy210;
  struct LimitVal yy278;
  Select* yy313;
  struct {int value; int mask;} yy317;
  IdList* yy326;
  struct TrigEvent yy412;
  int yy483;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 566
#define YYNRULE 299
#define YYERRORSYMBOL 138
#define YYERRSYMDT yy483
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   282,  866,  133,  375,  395,  183,    2,  425,   70,   70,
 /*    10 */    70,   70,  505,   66,   66,   66,   66,   63,   63,   62,
 /*    20 */    62,   62,   60,  221,  271,  292,  410,  416,   59,   66,
 /*    30 */    66,   66,   66,   63,   63,   62,   62,   62,   60,  221,
 /*    40 */    58,  448,   61,  152,   72,   79,  293,  420,  421,  417,
 /*    50 */   417,   67,   67,   70,   70,   70,   70,  201,   66,   66,
 /*    60 */    66,   66,   63,   63,   62,   62,   62,   60,  221,  282,
 /*    70 */   394,  508,  425,  292,  425,   78,  411,  412,  221,  505,
 /*    80 */    66,   66,   66,   66,   63,   63,   62,   62,   62,   60,
 /*    90 */   221,  382,  183,  231,  425,  410,  416,  414,  415,   94,
 /*   100 */   116,  273,  370,  269,  303,  174,  321,   57,  423,  423,
 /*   110 */   474,  396,  237,   72,   79,  293,  420,  421,  417,  417,
 /*   120 */    67,   67,   70,   70,   70,   70,  413,   66,   66,   66,
 /*   130 */    66,   63,   63,   62,   62,   62,   60,  221,  282,  425,
 /*   140 */   173,  231,  260,  352,  359,  364,  437,  188,  116,  273,
 /*   150 */   370,  269,  303,  174,  369,  476,  383,  384,  173,  425,
 /*   160 */   237,  352,  359,  364,  410,  416,  144,  145,  510,  167,
 /*   170 */   182,  161,  369,  536,  257,  503,  475,  520,   21,  371,
 /*   180 */   405,  282,   72,   79,  293,  420,  421,  417,  417,   67,
 /*   190 */    67,   70,   70,   70,   70,  125,   66,   66,   66,   66,
 /*   200 */    63,   63,   62,   62,   62,   60,  221,  410,  416,   87,
 /*   210 */   300,  535,  407,  407,  407,   63,   63,   62,   62,   62,
 /*   220 */    60,  221,  479,  480,  382,   72,   79,  293,  420,  421,
 /*   230 */   417,  417,   67,   67,   70,   70,   70,   70,  171,   66,
 /*   240 */    66,   66,   66,   63,   63,   62,   62,   62,   60,  221,
 /*   250 */   282,  477,  312,  223,  470,  418,  351,  428,  429,  510,
 /*   260 */   397,  340,  239,  241,  518,  312,  382,  556,  563,   21,
 /*   270 */   488,  147,  201,  149,  400,   36,  410,  416,  373,  378,
 /*   280 */    58,  468,   61,  152,  214,  555,  554,  400,   50,  383,
 /*   290 */   384,  186,  511,  437,   72,   79,  293,  420,  421,  417,
 /*   300 */   417,   67,   67,   70,   70,   70,   70,  401,   66,   66,
 /*   310 */    66,   66,   63,   63,   62,   62,   62,   60,  221,  282,
 /*   320 */   211,  433,  204,  475,  112,  401,  233,  405,  312,  313,
 /*   330 */   150,  383,  384,  312,  316,  312,  528,   74,  382,  173,
 /*   340 */   527,  553,  352,  359,  364,  410,  416,  552,  211,  332,
 /*   350 */   400,   37,  357,  369,  343,  400,   50,  400,   50,  407,
 /*   360 */   407,  407,  282,   72,   79,  293,  420,  421,  417,  417,
 /*   370 */    67,   67,   70,   70,   70,   70,  306,   66,   66,   66,
 /*   380 */    66,   63,   63,   62,   62,   62,   60,  221,  410,  416,
 /*   390 */   310,  200,   62,   62,   62,   60,  221,  313,  227,  307,
 /*   400 */   530,  464,  374,  383,  384,  282,   72,   79,  293,  420,
 /*   410 */   421,  417,  417,   67,   67,   70,   70,   70,   70,  213,
 /*   420 */    66,   66,   66,   66,   63,   63,   62,   62,   62,   60,
 /*   430 */   221,  410,  416,    1,  266,  460,  224,  382,  226,  309,
 /*   440 */   279,  165,  382,  435,  509,  170,  435,  365,  170,   72,
 /*   450 */    79,  293,  420,  421,  417,  417,   67,   67,   70,   70,
 /*   460 */    70,   70,  286,   66,   66,   66,   66,   63,   63,   62,
 /*   470 */    62,   62,   60,  221,  466,  401,  532,   90,  282,  469,
 /*   480 */   510,  250,  490,  125,  442,  431,  431,  166,  155,  393,
 /*   490 */    21,   58,  304,   61,  152,  284,  443,  433,  238,  298,
 /*   500 */   428,  429,  383,  384,  410,  416,  326,  383,  384,  444,
 /*   510 */    18,  481,    9,  146,  519,  801,  382,  225,  485,  486,
 /*   520 */    83,  482,   72,   79,  293,  420,  421,  417,  417,   67,
 /*   530 */    67,   70,   70,   70,   70,  215,   66,   66,   66,   66,
 /*   540 */    63,   63,   62,   62,   62,   60,  221,  282,  361,  424,
 /*   550 */   125,  473,  442,  556,  517,  491,  301,  382,  438,    8,
 /*   560 */   324,  516,  312,  211,  443,  321,  382,  423,  423,  355,
 /*   570 */   153,  555,  366,  410,  416,  349,  531,  444,  125,  330,
 /*   580 */   268,  383,  384,  399,  400,   27,  463,  398,  566,  377,
 /*   590 */   315,   72,   79,  293,  420,  421,  417,  417,   67,   67,
 /*   600 */    70,   70,   70,   70,  401,   66,   66,   66,   66,   63,
 /*   610 */    63,   62,   62,   62,   60,  221,  282,  302,  259,  158,
 /*   620 */   264,   91,  383,  384,   58,   22,   61,  152,  312,  425,
 /*   630 */   312,  383,  384,  323,  211,  321,  499,  423,  423,  400,
 /*   640 */     3,  258,  410,  416,  321,  558,  423,  423,  457,  236,
 /*   650 */   400,   37,  400,   46,  540,  503,   84,  456,  198,  282,
 /*   660 */    72,   79,  293,  420,  421,  417,  417,   67,   67,   70,
 /*   670 */    70,   70,   70,  312,   66,   66,   66,   66,   63,   63,
 /*   680 */    62,   62,   62,   60,  221,  410,  416,  385,  386,  387,
 /*   690 */   299,  210,  401,  256,  425,  400,   46,  503,  289,  454,
 /*   700 */   503,  503,  282,   72,   79,  293,  420,  421,  417,  417,
 /*   710 */    67,   67,   70,   70,   70,   70,  342,   66,   66,   66,
 /*   720 */    66,   63,   63,   62,   62,   62,   60,  221,  410,  416,
 /*   730 */    60,  221,  209,  223,  320,  287,  297,  450,  539,  347,
 /*   740 */   159,  288,  453,  493,  451,  282,   72,   77,  293,  420,
 /*   750 */   421,  417,  417,   67,   67,   70,   70,   70,   70,  312,
 /*   760 */    66,   66,   66,   66,   63,   63,   62,   62,   62,   60,
 /*   770 */   221,  410,  416,  193,  549,  223,   84,  376,  223,  223,
 /*   780 */     2,  400,   23,  270,  462,  318,  159,   88,  282,   89,
 /*   790 */    79,  293,  420,  421,  417,  417,   67,   67,   70,   70,
 /*   800 */    70,   70,  261,   66,   66,   66,   66,   63,   63,   62,
 /*   810 */    62,   62,   60,  221,  410,  416,  526,  360,  526,  277,
 /*   820 */   433,  204,  399,  495,  494,  426,  398,   20,  285,   19,
 /*   830 */   276,  140,  201,  143,  293,  420,  421,  417,  417,   67,
 /*   840 */    67,   70,   70,   70,   70,  341,   66,   66,   66,   66,
 /*   850 */    63,   63,   62,   62,   62,   60,  221,   71,  348,  312,
 /*   860 */     4,  312,  184,  312,  295,  377,  315,  196,  312,  460,
 /*   870 */   345,  312,  334,   71,  348,  344,    4,  498,  199,    5,
 /*   880 */   295,  400,   25,  400,   16,  400,   98,  312,  334,  335,
 /*   890 */   400,  113,  460,  400,   48,  312,  401,  193,  156,  437,
 /*   900 */   312,  496,  312,  551,  312,  335,  178,  155,  252,  400,
 /*   910 */   111,  500,  401,  125,  503,  437,  312,  400,  101,   75,
 /*   920 */    73,  497,  400,   28,  400,   42,  400,  100,   71,  325,
 /*   930 */   328,  262,  401,  405,  464,   75,   73,  467,  400,   95,
 /*   940 */   329,  312,  464,  434,   71,  325,  328,   71,  348,  405,
 /*   950 */     4,  201,  285,  312,  295,  312,  189,  237,  512,  201,
 /*   960 */   600,  343,  334,  400,   30,  407,  407,  407,  408,  409,
 /*   970 */    14,  243,  331,  296,  164,  400,   47,  400,   97,  335,
 /*   980 */   202,  407,  407,  407,  408,  409,   14,   55,  452,  437,
 /*   990 */   401,  168,  249,  256,  312,  291,  242,  272,  274,  109,
 /*  1000 */   533,  480,  312,  358,  142,  312,  350,  312,  401,   75,
 /*  1010 */    73,  265,  181,  230,  222,  244,  400,   53,   71,  325,
 /*  1020 */   328,  228,  312,  405,  400,   52,  203,  400,  115,  400,
 /*  1030 */    45,  312,  216,  179,  333,  535,  256,  256,  538,  172,
 /*  1040 */   234,  312,  176,  312,  400,  114,  232,  312,  459,  562,
 /*  1050 */   312,  267,  312,  400,   35,  407,  407,  407,  408,  409,
 /*  1060 */    14,  117,  455,  400,   96,  400,   39,  312,  256,  400,
 /*  1070 */    54,  312,  400,   41,  400,   38,  312,  254,  542,  446,
 /*  1080 */   256,  312,  346,  312,  381,  336,  219,  241,  492,  400,
 /*  1090 */    34,  283,  312,  400,   33,  312,  201,  229,  400,   49,
 /*  1100 */   312,  256,  312,  400,   31,  400,   32,  406,  432,  217,
 /*  1110 */   312,  256,  312,  356,  400,   43,  312,  400,   29,  501,
 /*  1120 */   322,  220,  400,   44,  400,   51,  312,  256,  504,  148,
 /*  1130 */   339,  391,  400,   10,  400,   24,  491,  430,  400,   26,
 /*  1140 */   449,  190,  544,  548,  135,  290,  136,  396,  400,   40,
 /*  1150 */   502,  118,  545,  137,  455,  134,   74,  404,  559,   92,
 /*  1160 */   547,  218,  337,  121,  206,  122,  541,   86,  546,  560,
 /*  1170 */   126,  130,  506,  561,   85,  110,  280,  294,  564,  207,
 /*  1180 */   507,  138,  106,  447,  191,   56,  403,  534,  192,  388,
 /*  1190 */   278,  354,  327,  177,  372,  513,  311,   76,  514,  205,
 /*  1200 */    69,  240,  247,   65,  305,  524,  363,  523,  251,  253,
 /*  1210 */   308,    7,  461,  248,  338,  160,  515,  162,  263,  367,
 /*  1220 */   465,  402,  169,  187,  255,  521,  488,  489,  380,  275,
 /*  1230 */   389,  390,  478,  484,  208,  487,  472,   64,   99,  483,
 /*  1240 */    17,  123,  151,  132,  102,  458,  197,   80,   11,   13,
 /*  1250 */     6,  195,  565,  314,  445,  103,  235,  185,  319,  422,
 /*  1260 */   104,  557,  441,  601,  550,  157,  602,  368,  128,  440,
 /*  1270 */   127,   15,  129,   93,  154,  543,  392,  439,  194,   12,
 /*  1280 */   163,   82,   81,  276,  537,  124,  139,  281,  108,  353,
 /*  1290 */   427,  107,  175,  245,  246,  159,  105,  362,  529,  180,
 /*  1300 */    68,  141,  120,  131,  436,  522,  317,  212,  119,  419,
 /*  1310 */   525,  379,  471,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  139,  140,  141,  168,   21,  144,   23,   69,   70,
 /*    10 */    71,   72,  176,   74,   75,   76,   77,   78,   79,   80,
 /*    20 */    81,   82,   83,   84,  172,   16,   42,   43,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    40 */   217,  218,  219,  220,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,  110,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   167,  168,   88,   16,   23,   22,   42,   43,   84,  176,
 /*    80 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    90 */    84,   23,   21,   84,   23,   42,   43,   63,   64,   46,
 /*   100 */    91,   92,   93,   94,   95,   96,  106,   19,  108,  109,
 /*   110 */   169,   23,  103,   60,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   92,   74,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   88,
 /*   140 */    90,   84,   20,   93,   94,   95,   58,   90,   91,   92,
 /*   150 */    93,   94,   95,   96,  104,  169,   88,   89,   90,   88,
 /*   160 */   103,   93,   94,   95,   42,   43,   78,   79,  147,   99,
 /*   170 */   100,  101,  104,   11,  153,  147,   88,  156,  157,   16,
 /*   180 */    92,   16,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   190 */    68,   69,   70,   71,   72,   22,   74,   75,   76,   77,
 /*   200 */    78,   79,   80,   81,   82,   83,   84,   42,   43,   44,
 /*   210 */   182,   49,  124,  125,  126,   78,   79,   80,   81,   82,
 /*   220 */    83,   84,  185,  186,   23,   60,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   22,   74,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    16,  160,  147,  225,   20,   92,  164,  165,  166,  147,
 /*   260 */   169,   99,  100,  101,  181,  147,   23,  147,  156,  157,
 /*   270 */    97,   22,  110,  155,  169,  170,   42,   43,  142,  143,
 /*   280 */   217,   80,  219,  220,  148,  165,  166,  169,  170,   88,
 /*   290 */    89,  155,  181,   58,   60,   61,   62,   63,   64,   65,
 /*   300 */    66,   67,   68,   69,   70,   71,   72,  189,   74,   75,
 /*   310 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*   320 */   228,   78,   79,   88,   21,  189,  221,   92,  147,  211,
 /*   330 */   147,   88,   89,  147,  216,  147,   25,  121,   23,   90,
 /*   340 */    29,   98,   93,   94,   95,   42,   43,  227,  228,  213,
 /*   350 */   169,  170,   41,  104,  147,  169,  170,  169,  170,  124,
 /*   360 */   125,  126,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   370 */    67,   68,   69,   70,   71,   72,  147,   74,   75,   76,
 /*   380 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   390 */   209,  210,   80,   81,   82,   83,   84,  211,   14,  211,
 /*   400 */    18,  147,  216,   88,   89,   16,   60,   61,   62,   63,
 /*   410 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  212,
 /*   420 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   430 */    84,   42,   43,   19,  190,  161,   52,   23,   54,  147,
 /*   440 */   158,  155,   23,  161,  162,  163,  161,  162,  163,   60,
 /*   450 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   460 */    71,   72,  208,   74,   75,   76,   77,   78,   79,   80,
 /*   470 */    81,   82,   83,   84,  200,  189,   94,  131,   16,   20,
 /*   480 */   147,   20,   20,   22,   12,  124,  125,  201,  202,  156,
 /*   490 */   157,  217,  206,  219,  220,  150,   24,   78,  147,  164,
 /*   500 */   165,  166,   88,   89,   42,   43,  186,   88,   89,   37,
 /*   510 */    19,   39,   19,  180,  181,  133,   23,  133,    7,    8,
 /*   520 */   131,   49,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   530 */    68,   69,   70,   71,   72,  147,   74,   75,   76,   77,
 /*   540 */    78,   79,   80,   81,   82,   83,   84,   16,   20,   20,
 /*   550 */    22,   20,   12,  147,  176,  177,   80,   23,   20,   68,
 /*   560 */   147,  183,  147,  228,   24,  106,   23,  108,  109,  224,
 /*   570 */   155,  165,  233,   42,   43,  230,   20,   37,   22,   39,
 /*   580 */    14,   88,   89,  107,  169,  170,  147,  111,    0,    1,
 /*   590 */     2,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   600 */    69,   70,   71,   72,  189,   74,   75,   76,   77,   78,
 /*   610 */    79,   80,   81,   82,   83,   84,   16,  147,   52,  232,
 /*   620 */    54,   21,   88,   89,  217,   19,  219,  220,  147,   23,
 /*   630 */   147,   88,   89,  227,  228,  106,  178,  108,  109,  169,
 /*   640 */   170,  147,   42,   43,  106,  238,  108,  109,  114,  147,
 /*   650 */   169,  170,  169,  170,   20,  147,   22,  114,  155,   16,
 /*   660 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   670 */    70,   71,   72,  147,   74,   75,   76,   77,   78,   79,
 /*   680 */    80,   81,   82,   83,   84,   42,   43,    7,    8,    9,
 /*   690 */   182,  210,  189,  147,   88,  169,  170,  147,  215,  203,
 /*   700 */   147,  147,   16,   60,   61,   62,   63,   64,   65,   66,
 /*   710 */    67,   68,   69,   70,   71,   72,  213,   74,   75,   76,
 /*   720 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   730 */    83,   84,  182,  225,  188,  182,  182,   27,   20,  236,
 /*   740 */    22,  215,   22,  178,   34,   16,   60,   61,   62,   63,
 /*   750 */    64,   65,   66,   67,   68,   69,   70,   71,   72,  147,
 /*   760 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   770 */    84,   42,   43,   43,   20,  225,   22,  141,  225,  225,
 /*   780 */   144,  169,  170,  145,   20,  239,   22,  130,   16,  132,
 /*   790 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   800 */    71,   72,  147,   74,   75,   76,   77,   78,   79,   80,
 /*   810 */    81,   82,   83,   84,   42,   43,   99,  100,  101,   92,
 /*   820 */    78,   79,  107,   91,   92,   20,  111,   22,   98,   19,
 /*   830 */   103,   21,  110,  113,   62,   63,   64,   65,   66,   67,
 /*   840 */    68,   69,   70,   71,   72,  123,   74,   75,   76,   77,
 /*   850 */    78,   79,   80,   81,   82,   83,   84,   16,   17,  147,
 /*   860 */    19,  147,  155,  147,   23,    1,    2,   19,  147,  161,
 /*   870 */    16,  147,   31,   16,   17,  147,   19,  178,  155,  191,
 /*   880 */    23,  169,  170,  169,  170,  169,  170,  147,   31,   48,
 /*   890 */   169,  170,  161,  169,  170,  147,  189,   43,  155,   58,
 /*   900 */   147,   30,  147,  147,  147,   48,  201,  202,  200,  169,
 /*   910 */   170,   20,  189,   22,  147,   58,  147,  169,  170,   78,
 /*   920 */    79,   50,  169,  170,  169,  170,  169,  170,   87,   88,
 /*   930 */    89,  200,  189,   92,  147,   78,   79,   80,  169,  170,
 /*   940 */    91,  147,  147,  161,   87,   88,   89,   16,   17,   92,
 /*   950 */    19,  110,   98,  147,   23,  147,  155,  103,  147,  110,
 /*   960 */   112,  147,   31,  169,  170,  124,  125,  126,  127,  128,
 /*   970 */   129,  147,  123,  102,  155,  169,  170,  169,  170,   48,
 /*   980 */   192,  124,  125,  126,  127,  128,  129,  199,  172,   58,
 /*   990 */   189,    5,  225,  147,  147,  208,   10,   11,   12,   13,
 /*  1000 */   185,  186,  147,  208,  191,  147,  147,  147,  189,   78,
 /*  1010 */    79,  193,   26,  147,   28,  147,  169,  170,   87,   88,
 /*  1020 */    89,   35,  147,   92,  169,  170,  212,  169,  170,  169,
 /*  1030 */   170,  147,  147,   47,  188,   49,  147,  147,  194,   53,
 /*  1040 */   147,  147,   56,  147,  169,  170,  147,  147,  147,  147,
 /*  1050 */   147,  147,  147,  169,  170,  124,  125,  126,  127,  128,
 /*  1060 */   129,  147,   22,  169,  170,  169,  170,  147,  147,  169,
 /*  1070 */   170,  147,  169,  170,  169,  170,  147,  188,  188,  147,
 /*  1080 */   147,  147,  147,  147,  147,   99,  100,  101,  147,  169,
 /*  1090 */   170,  105,  147,  169,  170,  147,  110,  147,  169,  170,
 /*  1100 */   147,  147,  147,  169,  170,  169,  170,  147,  229,  188,
 /*  1110 */   147,  147,  147,  173,  169,  170,  147,  169,  170,  172,
 /*  1120 */   134,  188,  169,  170,  169,  170,  147,  147,  172,   89,
 /*  1130 */   223,  149,  169,  170,  169,  170,  177,  229,  169,  170,
 /*  1140 */   172,  112,  188,  194,  152,  152,   19,   23,  169,  170,
 /*  1150 */   160,   60,  188,  214,  114,  184,  121,  160,   33,  237,
 /*  1160 */   194,   84,   15,  187,  226,  187,  194,  237,  188,  152,
 /*  1170 */   187,  187,  160,  152,  130,   19,  174,   40,  137,  222,
 /*  1180 */   179,  214,  240,  152,  184,  120,  198,  184,    6,  146,
 /*  1190 */   174,  152,   15,  151,   98,  171,  116,  119,  171,  226,
 /*  1200 */   130,  197,  196,   98,  115,  235,   38,  152,  234,  204,
 /*  1210 */   118,   22,  205,  195,  154,  152,  171,  151,  204,  152,
 /*  1220 */   205,  189,  151,  151,  194,  152,   97,  171,  146,  171,
 /*  1230 */   146,  146,  171,  179,  175,  173,   20,   19,  159,  171,
 /*  1240 */   231,   20,  112,   19,  175,  114,  112,   22,   22,  117,
 /*  1250 */   117,  112,    4,    3,   20,   19,  136,  135,   57,  107,
 /*  1260 */    14,   20,   20,  112,  123,   22,  112,   16,  122,   20,
 /*  1270 */   113,   19,  102,   19,   19,   17,   20,   11,  113,   19,
 /*  1280 */   122,   68,   68,  103,    1,  102,   19,    5,   19,   44,
 /*  1290 */    20,   19,   98,  133,   20,   22,   19,   36,   45,   96,
 /*  1300 */    19,   21,   45,   98,   20,   17,   44,   44,   32,   92,
 /*  1310 */    51,    1,   20,
};
#define YY_SHIFT_USE_DFLT (-62)
#define YY_SHIFT_MAX 374
static const short yy_shift_ofst[] = {
 /*     0 */   864,  841,  986,  -16,  841,  931,  931,   68,  243,  -53,
 /*    10 */   165,  931,  931,  931,  931,  931,  -45,  162,  419,  315,
 /*    20 */   742,   51,  742,   53,  600,  531,  303,  234,  462,  346,
 /*    30 */   122,  389,  643,  643,  643,  643,  643,  643,  643,  643,
 /*    40 */   643,  643,  643,  643,  643,  643,  643,  643,  686,  643,
 /*    50 */   643,  643,  729,  772,  772,  857,  931,  931,  931,  931,
 /*    60 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    70 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    80 */   931,  931,  931,  931,  931,  931,  931,  931,  931,  931,
 /*    90 */   931,  931,  931,  931,  931,  -61,  -61,    6,    6,   57,
 /*   100 */   137,  312,  854,  315,  315,  315,  315,  315,  315,  382,
 /*   110 */   315,  647,   51,   -6,  -62,  -62,   88,    9,  472,  472,
 /*   120 */   315,  315,  315,   71,  315,  315,  315,  315,  315,  315,
 /*   130 */   315,  315,  315,  588,  315,   71,  315,  849,  722,  -53,
 /*   140 */   -53,  -53,  -62,  -62,  235,  235,  249,   50,  543,  529,
 /*   150 */   534,  201,  414,  459,  540,  493,  538,  315,  717,  315,
 /*   160 */   311,  871,  315,  315,    0,    0, 1040,  871,  680,  315,
 /*   170 */   606,  315,  315,  315,  315,  315,  315,  315, 1040,  315,
 /*   180 */   315,  315,  871,  315,    0,  315,    0,  315,  315,    0,
 /*   190 */   315,  315,  315,  315,  315,  315,  476,  315,    0,    0,
 /*   200 */   710,  715,  720,  216,  361,  710,  710,  657,  730,  173,
 /*   210 */   710,  361,  710,  216,  810, 1029, 1029, 1127, 1124, 1091,
 /*   220 */  1035, 1124, 1125, 1077, 1147, 1147, 1147, 1147, 1125, 1035,
 /*   230 */  1029, 1124, 1029, 1044, 1156, 1041, 1127, 1137, 1029, 1091,
 /*   240 */  1065, 1091, 1182, 1156, 1029, 1177, 1096, 1080, 1078, 1077,
 /*   250 */  1096, 1070, 1105, 1089, 1168, 1092, 1029, 1189, 1029, 1177,
 /*   260 */  1096, 1029, 1105, 1089, 1177, 1035,  -53, 1029, 1177, 1096,
 /*   270 */  1182, 1096, 1182, 1096, 1182, 1129, 1137, 1096,  -62,  -62,
 /*   280 */   -62,  -62,   34,  384,  566,   70,  718,  556,  634,  754,
 /*   290 */   491,  764,  727,  163,  511,  848,  732,  891,  805,  461,
 /*   300 */   528, 1216, 1130, 1218, 1221, 1224, 1131, 1225, 1132, 1134,
 /*   310 */  1226, 1133, 1139, 1225, 1248, 1250, 1234, 1236, 1120, 1122,
 /*   320 */  1201, 1152, 1246, 1241, 1242, 1151, 1243, 1251, 1154, 1141,
 /*   330 */  1249, 1252, 1146, 1170, 1254, 1255, 1157, 1258, 1256, 1266,
 /*   340 */  1165, 1260, 1158, 1213, 1214, 1180, 1183, 1283, 1267, 1282,
 /*   350 */  1269, 1270, 1245, 1272, 1194, 1160, 1274, 1253, 1273, 1277,
 /*   360 */  1257, 1203, 1259, 1261, 1281, 1284, 1205, 1280, 1288, 1262,
 /*   370 */  1263, 1217, 1276, 1310, 1292,
};
#define YY_REDUCE_USE_DFLT (-178)
#define YY_REDUCE_MAX 281
static const short yy_reduce_ofst[] = {
 /*     0 */  -138,  118,  136,  274,  415,  186,  181,  333,  120,  286,
 /*    10 */   407,  481,  526,  188,  105,  483, -177,  503,  406,   21,
 /*    20 */    92,  282,  335,   63,   63,   63,   63,   63,   63,   63,
 /*    30 */    63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
 /*    40 */    63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
 /*    50 */    63,   63,   63,   63,   63,  470,  612,  712,  714,  716,
 /*    60 */   721,  724,  740,  748,  753,  755,  757,  769,  794,  806,
 /*    70 */   808,  847,  855,  858,  860,  875,  884,  894,  896,  900,
 /*    80 */   903,  905,  920,  924,  929,  934,  936,  945,  948,  953,
 /*    90 */   955,  963,  965,  969,  979,   63,   63,   63,   63,  -97,
 /*   100 */    63,   63,  378,   28,  546,  508,  112,  550,  553,  345,
 /*   110 */   554,   63,  285,   63,   63,   63,   91, -164,  815,   37,
 /*   120 */   795,  980,  964,  731,  814,  767,  954,  933,  921,  207,
 /*   130 */   890,  889,  787,  636,  846,  708,  254,  723,  707,  743,
 /*   140 */   801,  819,  788,  705,  -59,  -14,   83,  111,  183,  244,
 /*   150 */   229,  292,  351,  244,  320,  388,  244,  413,  339,  439,
 /*   160 */   387,  458,  494,  502,  244,  244,  496,  565,  638,  655,
 /*   170 */   782,  728,  756,  811,  824,  859,  866,  868,  496,  885,
 /*   180 */   893,  899,  699,  901,  244,  902,  244,  904,  914,  244,
 /*   190 */   932,  935,  937,  941,  950,  292,  688,  960,  244,  244,
 /*   200 */   816,  813,  818,  844,  879,  947,  956,  907,  959,  940,
 /*   210 */   968,  908, -148,  949,  982,  992,  993,  939,  990,  971,
 /*   220 */   966,  997,  922,  938,  976,  978,  983,  984,  930,  972,
 /*   230 */  1017, 1012, 1021,  957, 1002,  942,  967, 1001, 1031, 1000,
 /*   240 */   988, 1003, 1043, 1016, 1039, 1042, 1024, 1004, 1006,  973,
 /*   250 */  1027,  970, 1005, 1007,  974, 1018, 1055, 1060, 1063, 1066,
 /*   260 */  1045, 1067, 1014, 1015, 1071, 1030, 1032, 1073, 1072, 1056,
 /*   270 */  1082, 1058, 1084, 1061, 1085, 1062, 1054, 1068, 1059, 1079,
 /*   280 */  1069, 1009,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   572,  796,  865,  687,  865,  796,  865,  865,  823,  691,
 /*    10 */   852,  865,  865,  865,  794,  865,  769,  865,  823,  865,
 /*    20 */   823,  603,  823,  720,  865,  865,  865,  865,  865,  865,
 /*    30 */   865,  865,  851,  790,  728,  718,  793,  711,  727,  722,
 /*    40 */   721,  797,  703,  853,  791,  725,  735,  836,  865,  734,
 /*    50 */   798,  789,  757,  775,  756,  865,  865,  865,  865,  865,
 /*    60 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*    70 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*    80 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*    90 */   865,  865,  865,  865,  865,  759,  780,  758,  768,  596,
 /*   100 */   760,  761,  656,  865,  865,  865,  865,  865,  865,  591,
 /*   110 */   865,  762,  865,  763,  777,  776,  865,  865,  865,  865,
 /*   120 */   865,  865,  865,  687,  865,  865,  865,  865,  865,  865,
 /*   130 */   865,  865,  865,  572,  865,  687,  865,  865,  865,  865,
 /*   140 */   865,  865,  681,  691,  865,  865,  647,  865,  865,  865,
 /*   150 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*   160 */   829,  865,  865,  865,  668,  694,  695,  865,  579,  865,
 /*   170 */   605,  865,  810,  865,  865,  865,  856,  865,  689,  865,
 /*   180 */   865,  858,  865,  865,  841,  865,  670,  865,  865,  593,
 /*   190 */   865,  865,  577,  865,  865,  865,  679,  865,  843,  730,
 /*   200 */   714,  679,  688,  724,  865,  714,  714,  792,  626,  629,
 /*   210 */   714,  865,  714,  724,  865,  696,  696,  736,  865,  660,
 /*   220 */   724,  865,  855,  807,  667,  667,  667,  667,  855,  724,
 /*   230 */   696,  865,  696,  865,  802,  863,  736,  643,  696,  660,
 /*   240 */   719,  660,  576,  802,  696,  588,  658,  707,  717,  807,
 /*   250 */   658,  835,  704,  706,  833,  715,  696,  646,  696,  588,
 /*   260 */   658,  696,  704,  706,  588,  724,  865,  696,  588,  658,
 /*   270 */   576,  658,  576,  658,  576,  629,  643,  658,  631,  613,
 /*   280 */   631,  838,  865,  865,  865,  865,  865,  865,  865,  865,
 /*   290 */   816,  865,  865,  865,  865,  743,  865,  865,  865,  865,
 /*   300 */   865,  865,  865,  865,  865,  865,  865,  716,  865,  745,
 /*   310 */   708,  865,  865,  795,  865,  573,  865,  865,  865,  865,
 /*   320 */   862,  673,  865,  865,  865,  748,  865,  865,  744,  865,
 /*   330 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*   340 */   865,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*   350 */   865,  865,  865,  865,  865,  865,  865,  865,  832,  865,
 /*   360 */   831,  865,  865,  865,  865,  865,  865,  865,  865,  865,
 /*   370 */   865,  865,  865,  865,  865,  568,  567,  570,  569,  571,
 /*   380 */   575,  578,  600,  601,  602,  580,  581,  582,  583,  584,
 /*   390 */   585,  586,  592,  594,  612,  614,  598,  616,  677,  678,
 /*   400 */   740,  671,  672,  676,  751,  742,  746,  747,  749,  750,
 /*   410 */   764,  765,  767,  773,  779,  782,  766,  771,  772,  774,
 /*   420 */   778,  781,  674,  675,  785,  599,  606,  607,  610,  611,
 /*   430 */   819,  821,  820,  822,  609,  608,  752,  755,  787,  788,
 /*   440 */   844,  845,  846,  847,  848,  783,  697,  786,  770,  709,
 /*   450 */   712,  713,  710,  680,  690,  699,  700,  701,  702,  685,
 /*   460 */   686,  692,  705,  738,  739,  693,  682,  683,  684,  784,
 /*   470 */   741,  753,  754,  617,  618,  748,  619,  620,  621,  659,
 /*   480 */   662,  663,  664,  622,  641,  644,  645,  623,  630,  624,
 /*   490 */   625,  632,  633,  634,  637,  638,  639,  640,  635,  636,
 /*   500 */   803,  804,  808,  806,  805,  627,  628,  642,  615,  604,
 /*   510 */   597,  648,  651,  652,  653,  654,  655,  657,  649,  650,
 /*   520 */   595,  587,  589,  698,  825,  834,  830,  826,  827,  828,
 /*   530 */   590,  799,  800,  661,  732,  733,  824,  837,  839,  737,
 /*   540 */   840,  842,  665,  666,  669,  809,  849,  723,  726,  729,
 /*   550 */   731,  811,  812,  813,  814,  817,  818,  815,  850,  854,
 /*   560 */   857,  859,  860,  861,  864,  574,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "ANY",         
  "OR",            "AND",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ALTER",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "ifnotexists", 
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typetoken",     "typename",    
  "signed",        "plus_num",      "minus_num",     "carg",        
  "ccons",         "term",          "expr",          "onconf",      
  "sortorder",     "autoinc",       "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "ifexists",    
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "nexprlist",   
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "exprlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "uniqueflag",    "idxitem",       "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "ccons ::= DEFAULT term",
 /*  51 */ "ccons ::= DEFAULT LP expr RP",
 /*  52 */ "ccons ::= DEFAULT PLUS term",
 /*  53 */ "ccons ::= DEFAULT MINUS term",
 /*  54 */ "ccons ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW ifnotexists nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 144 */ "sortlist ::= sortitem sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "groupby_opt ::=",
 /* 150 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 151 */ "having_opt ::=",
 /* 152 */ "having_opt ::= HAVING expr",
 /* 153 */ "limit_opt ::=",
 /* 154 */ "limit_opt ::= LIMIT expr",
 /* 155 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 156 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 157 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 158 */ "where_opt ::=",
 /* 159 */ "where_opt ::= WHERE expr",
 /* 160 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 161 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 162 */ "setlist ::= nm EQ expr",
 /* 163 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 182 */ "term ::= STRING",
 /* 183 */ "expr ::= REGISTER",
 /* 184 */ "expr ::= VARIABLE",
 /* 185 */ "expr ::= expr COLLATE id",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT|BITNOT expr",
 /* 210 */ "expr ::= MINUS expr",
 /* 211 */ "expr ::= PLUS expr",
 /* 212 */ "between_op ::= BETWEEN",
 /* 213 */ "between_op ::= NOT BETWEEN",
 /* 214 */ "expr ::= expr between_op expr AND expr",
 /* 215 */ "in_op ::= IN",
 /* 216 */ "in_op ::= NOT IN",
 /* 217 */ "expr ::= expr in_op LP exprlist RP",
 /* 218 */ "expr ::= LP select RP",
 /* 219 */ "expr ::= expr in_op LP select RP",
 /* 220 */ "expr ::= expr in_op nm dbnm",
 /* 221 */ "expr ::= EXISTS LP select RP",
 /* 222 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 223 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 224 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 225 */ "case_else ::= ELSE expr",
 /* 226 */ "case_else ::=",
 /* 227 */ "case_operand ::= expr",
 /* 228 */ "case_operand ::=",
 /* 229 */ "exprlist ::= nexprlist",
 /* 230 */ "exprlist ::=",
 /* 231 */ "nexprlist ::= nexprlist COMMA expr",
 /* 232 */ "nexprlist ::= expr",
 /* 233 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 234 */ "uniqueflag ::= UNIQUE",
 /* 235 */ "uniqueflag ::=",
 /* 236 */ "idxlist_opt ::=",
 /* 237 */ "idxlist_opt ::= LP idxlist RP",
 /* 238 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 239 */ "idxlist ::= idxitem collate sortorder",
 /* 240 */ "idxitem ::= nm",
 /* 241 */ "collate ::=",
 /* 242 */ "collate ::= COLLATE id",
 /* 243 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 244 */ "cmd ::= VACUUM",
 /* 245 */ "cmd ::= VACUUM nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "nmnum ::= plus_num",
 /* 252 */ "nmnum ::= nm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER|FLOAT",
 /* 256 */ "plus_opt ::= PLUS",
 /* 257 */ "plus_opt ::=",
 /* 258 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 259 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 260 */ "trigger_time ::= BEFORE",
 /* 261 */ "trigger_time ::= AFTER",
 /* 262 */ "trigger_time ::= INSTEAD OF",
 /* 263 */ "trigger_time ::=",
 /* 264 */ "trigger_event ::= DELETE|INSERT",
 /* 265 */ "trigger_event ::= UPDATE",
 /* 266 */ "trigger_event ::= UPDATE OF inscollist",
 /* 267 */ "foreach_clause ::=",
 /* 268 */ "foreach_clause ::= FOR EACH ROW",
 /* 269 */ "when_clause ::=",
 /* 270 */ "when_clause ::= WHEN expr",
 /* 271 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 272 */ "trigger_cmd_list ::=",
 /* 273 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 276 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 277 */ "trigger_cmd ::= select",
 /* 278 */ "expr ::= RAISE LP IGNORE RP",
 /* 279 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 280 */ "raisetype ::= ROLLBACK",
 /* 281 */ "raisetype ::= ABORT",
 /* 282 */ "raisetype ::= FAIL",
 /* 283 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 284 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 285 */ "cmd ::= DETACH database_kw_opt expr",
 /* 286 */ "key_opt ::=",
 /* 287 */ "key_opt ::= KEY expr",
 /* 288 */ "database_kw_opt ::= DATABASE",
 /* 289 */ "database_kw_opt ::=",
 /* 290 */ "cmd ::= REINDEX",
 /* 291 */ "cmd ::= REINDEX nm dbnm",
 /* 292 */ "cmd ::= ANALYZE",
 /* 293 */ "cmd ::= ANALYZE nm dbnm",
 /* 294 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 295 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 296 */ "add_column_fullname ::= fullname",
 /* 297 */ "kwcolumn_opt ::=",
 /* 298 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 155:
    case 189:
    case 206:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy313));}
#line 1252 "parse.c"
      break;
    case 169:
    case 170:
    case 194:
    case 196:
    case 204:
    case 210:
    case 218:
    case 221:
    case 223:
    case 235:
#line 623 "parse.y"
{sqlite3ExprDelete((yypminor->yy162));}
#line 1266 "parse.c"
      break;
    case 174:
    case 182:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 211:
    case 212:
    case 215:
    case 216:
    case 222:
#line 862 "parse.y"
{sqlite3ExprListDelete((yypminor->yy44));}
#line 1282 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 487 "parse.y"
{sqlite3SrcListDelete((yypminor->yy149));}
#line 1290 "parse.c"
      break;
    case 205:
    case 208:
    case 214:
#line 504 "parse.y"
{sqlite3IdListDelete((yypminor->yy326));}
#line 1297 "parse.c"
      break;
    case 231:
    case 236:
#line 963 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy137));}
#line 1303 "parse.c"
      break;
    case 233:
#line 949 "parse.y"
{sqlite3IdListDelete((yypminor->yy412).b);}
#line 1308 "parse.c"
      break;
    case 238:
#line 1036 "parse.y"
{sqlite3ExprDelete((yypminor->yy116));}
#line 1313 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1477 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 139, 1 },
  { 140, 2 },
  { 140, 1 },
  { 142, 1 },
  { 141, 1 },
  { 141, 3 },
  { 144, 0 },
  { 144, 1 },
  { 144, 3 },
  { 143, 3 },
  { 146, 0 },
  { 146, 1 },
  { 146, 2 },
  { 145, 0 },
  { 145, 1 },
  { 145, 1 },
  { 145, 1 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 143, 2 },
  { 148, 6 },
  { 151, 0 },
  { 151, 3 },
  { 150, 1 },
  { 150, 0 },
  { 149, 4 },
  { 149, 2 },
  { 153, 3 },
  { 153, 1 },
  { 156, 3 },
  { 157, 1 },
  { 160, 1 },
  { 161, 1 },
  { 147, 1 },
  { 147, 1 },
  { 147, 1 },
  { 158, 0 },
  { 158, 1 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 163, 1 },
  { 163, 2 },
  { 164, 1 },
  { 164, 1 },
  { 159, 2 },
  { 159, 0 },
  { 167, 3 },
  { 167, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 5 },
  { 168, 2 },
  { 168, 4 },
  { 168, 4 },
  { 168, 1 },
  { 168, 2 },
  { 173, 0 },
  { 173, 1 },
  { 175, 0 },
  { 175, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 1 },
  { 178, 1 },
  { 176, 3 },
  { 176, 2 },
  { 179, 0 },
  { 179, 2 },
  { 179, 2 },
  { 154, 0 },
  { 154, 2 },
  { 180, 3 },
  { 180, 2 },
  { 180, 1 },
  { 181, 2 },
  { 181, 7 },
  { 181, 5 },
  { 181, 5 },
  { 181, 10 },
  { 183, 0 },
  { 183, 1 },
  { 171, 0 },
  { 171, 3 },
  { 184, 0 },
  { 184, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 143, 4 },
  { 187, 2 },
  { 187, 0 },
  { 143, 8 },
  { 143, 4 },
  { 143, 1 },
  { 155, 1 },
  { 155, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 152, 0 },
  { 152, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 4 },
  { 209, 2 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 143, 4 },
  { 194, 0 },
  { 194, 2 },
  { 143, 6 },
  { 212, 5 },
  { 212, 3 },
  { 143, 8 },
  { 143, 5 },
  { 143, 6 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 208, 3 },
  { 208, 1 },
  { 170, 1 },
  { 170, 3 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 5 },
  { 169, 1 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 3 },
  { 170, 6 },
  { 170, 5 },
  { 170, 4 },
  { 169, 1 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 170, 3 },
  { 217, 1 },
  { 217, 2 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 170, 4 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 4 },
  { 170, 2 },
  { 170, 2 },
  { 170, 2 },
  { 219, 1 },
  { 219, 2 },
  { 170, 5 },
  { 220, 1 },
  { 220, 2 },
  { 170, 5 },
  { 170, 3 },
  { 170, 5 },
  { 170, 4 },
  { 170, 4 },
  { 170, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 1 },
  { 216, 0 },
  { 211, 3 },
  { 211, 1 },
  { 143, 11 },
  { 224, 1 },
  { 224, 0 },
  { 174, 0 },
  { 174, 3 },
  { 182, 5 },
  { 182, 3 },
  { 225, 1 },
  { 226, 0 },
  { 226, 2 },
  { 143, 4 },
  { 143, 1 },
  { 143, 2 },
  { 143, 5 },
  { 143, 5 },
  { 143, 5 },
  { 143, 6 },
  { 143, 3 },
  { 227, 1 },
  { 227, 1 },
  { 165, 2 },
  { 166, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 143, 5 },
  { 230, 11 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 170, 4 },
  { 170, 6 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 143, 4 },
  { 143, 6 },
  { 143, 3 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 143, 1 },
  { 143, 3 },
  { 143, 1 },
  { 143, 3 },
  { 143, 6 },
  { 143, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 4:
      case 5:
      case 10:
      case 11:
      case 12:
      case 20:
      case 28:
      case 29:
      case 37:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 55:
      case 82:
      case 83:
      case 84:
      case 85:
      case 256:
      case 257:
      case 267:
      case 268:
      case 288:
      case 289:
      case 297:
      case 298:
#line 97 "parse.y"
{
}
#line 1915 "parse.c"
        break;
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1920 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1925 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1930 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1935 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy124);}
#line 1940 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy124 = TK_DEFERRED;}
#line 1945 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy124 = yymsp[0].major;}
#line 1954 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1960 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1965 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210,yymsp[-4].minor.yy124,0,0,yymsp[-2].minor.yy124);
}
#line 1972 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 212:
      case 215:
#line 132 "parse.y"
{yygotominor.yy124 = 0;}
#line 1987 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 213:
      case 216:
#line 133 "parse.y"
{yygotominor.yy124 = 1;}
#line 1999 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy0,0);
}
#line 2006 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy313);
  sqlite3SelectDelete(yymsp[0].minor.yy313);
}
#line 2014 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy210.z = yymsp[-2].minor.yy210.z;
  yygotominor.yy210.n = (pParse->sLastToken.z-yymsp[-2].minor.yy210.z) + pParse->sLastToken.n;
}
#line 2022 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy210);
  yygotominor.yy210 = yymsp[0].minor.yy210;
}
#line 2030 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 255:
#line 168 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 2040 "parse.c"
        break;
      case 38:
#line 229 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy210);}
#line 2045 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 240:
      case 242:
      case 251:
      case 252:
      case 253:
      case 254:
#line 230 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2060 "parse.c"
        break;
      case 40:
#line 231 "parse.y"
{
  yygotominor.yy210.z = yymsp[-3].minor.yy210.z;
  yygotominor.yy210.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy210.z;
}
#line 2068 "parse.c"
        break;
      case 41:
#line 235 "parse.y"
{
  yygotominor.yy210.z = yymsp[-5].minor.yy210.z;
  yygotominor.yy210.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy210.z;
}
#line 2076 "parse.c"
        break;
      case 43:
#line 241 "parse.y"
{yygotominor.yy210.z=yymsp[-1].minor.yy210.z; yygotominor.yy210.n=yymsp[0].minor.yy210.n+(yymsp[0].minor.yy210.z-yymsp[-1].minor.yy210.z);}
#line 2081 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy162);}
#line 2087 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy162);}
#line 2092 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2100 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy210);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2108 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy124);}
#line 2113 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy124,yymsp[0].minor.yy124,yymsp[-2].minor.yy124);}
#line 2118 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy124,0,0,0,0);}
#line 2123 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy162);}
#line 2128 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy210,yymsp[-1].minor.yy44,yymsp[0].minor.yy124);}
#line 2133 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy124);}
#line 2138 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy210.z, yymsp[0].minor.yy210.n);}
#line 2143 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy124 = OE_Restrict * 0x010101; }
#line 2148 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy124 = (yymsp[-1].minor.yy124 & yymsp[0].minor.yy317.mask) | yymsp[0].minor.yy317.value; }
#line 2153 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy317.value = 0;     yygotominor.yy317.mask = 0x000000; }
#line 2158 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124;     yygotominor.yy317.mask = 0x0000ff; }
#line 2163 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124<<8;  yygotominor.yy317.mask = 0x00ff00; }
#line 2168 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124<<16; yygotominor.yy317.mask = 0xff0000; }
#line 2173 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy124 = OE_SetNull; }
#line 2178 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy124 = OE_SetDflt; }
#line 2183 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy124 = OE_Cascade; }
#line 2188 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy124 = OE_Restrict; }
#line 2193 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 166:
#line 302 "parse.y"
{yygotominor.yy124 = yymsp[0].minor.yy124;}
#line 2204 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy210.n = 0; yygotominor.yy210.z = 0;}
#line 2209 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy0;}
#line 2214 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy44,yymsp[0].minor.yy124,yymsp[-2].minor.yy124,0);}
#line 2219 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy44,yymsp[0].minor.yy124,0,0,0,0);}
#line 2224 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy162);}
#line 2229 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy44, &yymsp[-3].minor.yy210, yymsp[-2].minor.yy44, yymsp[-1].minor.yy124);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy124);
}
#line 2237 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy124 = OE_Default;}
#line 2243 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy124 = OE_Ignore;}
#line 2248 "parse.c"
        break;
      case 98:
      case 167:
#line 344 "parse.y"
{yygotominor.yy124 = OE_Replace;}
#line 2254 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy149, 0, yymsp[-1].minor.yy124);
}
#line 2261 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy210, &yymsp[-2].minor.yy210, yymsp[0].minor.yy313, yymsp[-6].minor.yy124, yymsp[-4].minor.yy124);
}
#line 2268 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy149, 1, yymsp[-1].minor.yy124);
}
#line 2275 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy313, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy313);
}
#line 2283 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy313 = yymsp[0].minor.yy313;}
#line 2289 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy313 ){
    yymsp[0].minor.yy313->op = yymsp[-1].minor.yy124;
    yymsp[0].minor.yy313->pPrior = yymsp[-2].minor.yy313;
  }
  yygotominor.yy313 = yymsp[0].minor.yy313;
}
#line 2300 "parse.c"
        break;
      case 108:
#line 389 "parse.y"
{yygotominor.yy124 = TK_ALL;}
#line 2305 "parse.c"
        break;
      case 110:
#line 393 "parse.y"
{
  yygotominor.yy313 = sqlite3SelectNew(yymsp[-6].minor.yy44,yymsp[-5].minor.yy149,yymsp[-4].minor.yy162,yymsp[-3].minor.yy44,yymsp[-2].minor.yy162,yymsp[-1].minor.yy44,yymsp[-7].minor.yy124,yymsp[0].minor.yy278.pLimit,yymsp[0].minor.yy278.pOffset);
}
#line 2312 "parse.c"
        break;
      case 114:
      case 237:
#line 414 "parse.y"
{yygotominor.yy44 = yymsp[-1].minor.yy44;}
#line 2318 "parse.c"
        break;
      case 115:
      case 141:
      case 149:
      case 230:
      case 236:
#line 415 "parse.y"
{yygotominor.yy44 = 0;}
#line 2327 "parse.c"
        break;
      case 116:
#line 416 "parse.y"
{
   yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-2].minor.yy44,yymsp[-1].minor.yy162,yymsp[0].minor.yy210.n?&yymsp[0].minor.yy210:0);
}
#line 2334 "parse.c"
        break;
      case 117:
#line 419 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-1].minor.yy44, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2341 "parse.c"
        break;
      case 118:
#line 422 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-3].minor.yy44, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2350 "parse.c"
        break;
      case 121:
#line 434 "parse.y"
{yygotominor.yy210.n = 0;}
#line 2355 "parse.c"
        break;
      case 122:
#line 446 "parse.y"
{yygotominor.yy149 = sqliteMalloc(sizeof(*yygotominor.yy149));}
#line 2360 "parse.c"
        break;
      case 123:
#line 447 "parse.y"
{
  yygotominor.yy149 = yymsp[0].minor.yy149;
  sqlite3SrcListShiftJoinType(yygotominor.yy149);
}
#line 2368 "parse.c"
        break;
      case 124:
#line 455 "parse.y"
{
   yygotominor.yy149 = yymsp[-1].minor.yy149;
   if( yygotominor.yy149 && yygotominor.yy149->nSrc>0 ) yygotominor.yy149->a[yygotominor.yy149->nSrc-1].jointype = yymsp[0].minor.yy124;
}
#line 2376 "parse.c"
        break;
      case 125:
#line 459 "parse.y"
{yygotominor.yy149 = 0;}
#line 2381 "parse.c"
        break;
      case 126:
#line 460 "parse.y"
{
  yygotominor.yy149 = sqlite3SrcListAppendFromTerm(yymsp[-5].minor.yy149,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,0,yymsp[-1].minor.yy162,yymsp[0].minor.yy326);
}
#line 2388 "parse.c"
        break;
      case 127:
#line 465 "parse.y"
{
    yygotominor.yy149 = sqlite3SrcListAppendFromTerm(yymsp[-6].minor.yy149,0,0,&yymsp[-2].minor.yy210,yymsp[-4].minor.yy313,yymsp[-1].minor.yy162,yymsp[0].minor.yy326);
  }
#line 2395 "parse.c"
        break;
      case 129:
#line 476 "parse.y"
{
     sqlite3SrcListShiftJoinType(yymsp[0].minor.yy149);
     yygotominor.yy313 = sqlite3SelectNew(0,yymsp[0].minor.yy149,0,0,0,0,0,0,0);
  }
#line 2403 "parse.c"
        break;
      case 130:
#line 483 "parse.y"
{yygotominor.yy210.z=0; yygotominor.yy210.n=0;}
#line 2408 "parse.c"
        break;
      case 132:
#line 488 "parse.y"
{yygotominor.yy149 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210);}
#line 2413 "parse.c"
        break;
      case 133:
#line 492 "parse.y"
{ yygotominor.yy124 = JT_INNER; }
#line 2418 "parse.c"
        break;
      case 134:
#line 493 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2423 "parse.c"
        break;
      case 135:
#line 494 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy210,0); }
#line 2428 "parse.c"
        break;
      case 136:
#line 496 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy210,&yymsp[-1].minor.yy210); }
#line 2433 "parse.c"
        break;
      case 137:
      case 145:
      case 152:
      case 159:
      case 174:
      case 202:
      case 225:
      case 227:
#line 500 "parse.y"
{yygotominor.yy162 = yymsp[0].minor.yy162;}
#line 2445 "parse.c"
        break;
      case 138:
      case 151:
      case 158:
      case 203:
      case 226:
      case 228:
#line 501 "parse.y"
{yygotominor.yy162 = 0;}
#line 2455 "parse.c"
        break;
      case 139:
      case 171:
#line 505 "parse.y"
{yygotominor.yy326 = yymsp[-1].minor.yy326;}
#line 2461 "parse.c"
        break;
      case 140:
      case 170:
#line 506 "parse.y"
{yygotominor.yy326 = 0;}
#line 2467 "parse.c"
        break;
      case 142:
      case 150:
      case 229:
#line 517 "parse.y"
{yygotominor.yy44 = yymsp[0].minor.yy44;}
#line 2474 "parse.c"
        break;
      case 143:
#line 518 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-3].minor.yy44,yymsp[-1].minor.yy162,0);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2482 "parse.c"
        break;
      case 144:
#line 522 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(0,yymsp[-1].minor.yy162,0);
  if( yygotominor.yy44 && yygotominor.yy44->a ) yygotominor.yy44->a[0].sortOrder = yymsp[0].minor.yy124;
}
#line 2490 "parse.c"
        break;
      case 146:
      case 148:
#line 530 "parse.y"
{yygotominor.yy124 = SQLITE_SO_ASC;}
#line 2496 "parse.c"
        break;
      case 147:
#line 531 "parse.y"
{yygotominor.yy124 = SQLITE_SO_DESC;}
#line 2501 "parse.c"
        break;
      case 153:
#line 557 "parse.y"
{yygotominor.yy278.pLimit = 0; yygotominor.yy278.pOffset = 0;}
#line 2506 "parse.c"
        break;
      case 154:
#line 558 "parse.y"
{yygotominor.yy278.pLimit = yymsp[0].minor.yy162; yygotominor.yy278.pOffset = 0;}
#line 2511 "parse.c"
        break;
      case 155:
#line 560 "parse.y"
{yygotominor.yy278.pLimit = yymsp[-2].minor.yy162; yygotominor.yy278.pOffset = yymsp[0].minor.yy162;}
#line 2516 "parse.c"
        break;
      case 156:
#line 562 "parse.y"
{yygotominor.yy278.pOffset = yymsp[-2].minor.yy162; yygotominor.yy278.pLimit = yymsp[0].minor.yy162;}
#line 2521 "parse.c"
        break;
      case 157:
#line 566 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy149,yymsp[0].minor.yy162);}
#line 2526 "parse.c"
        break;
      case 160:
#line 577 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy149,yymsp[-1].minor.yy44,yymsp[0].minor.yy162,yymsp[-4].minor.yy124);}
#line 2531 "parse.c"
        break;
      case 161:
#line 583 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44,yymsp[0].minor.yy162,&yymsp[-2].minor.yy210);}
#line 2536 "parse.c"
        break;
      case 162:
#line 584 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(0,yymsp[0].minor.yy162,&yymsp[-2].minor.yy210);}
#line 2541 "parse.c"
        break;
      case 163:
#line 590 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy149, yymsp[-1].minor.yy44, 0, yymsp[-4].minor.yy326, yymsp[-7].minor.yy124);}
#line 2546 "parse.c"
        break;
      case 164:
#line 592 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy149, 0, yymsp[0].minor.yy313, yymsp[-1].minor.yy326, yymsp[-4].minor.yy124);}
#line 2551 "parse.c"
        break;
      case 165:
#line 594 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy149, 0, 0, yymsp[-2].minor.yy326, yymsp[-5].minor.yy124);}
#line 2556 "parse.c"
        break;
      case 168:
      case 231:
#line 604 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-2].minor.yy44,yymsp[0].minor.yy162,0);}
#line 2562 "parse.c"
        break;
      case 169:
      case 232:
#line 605 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(0,yymsp[0].minor.yy162,0);}
#line 2568 "parse.c"
        break;
      case 172:
#line 614 "parse.y"
{yygotominor.yy326 = sqlite3IdListAppend(yymsp[-2].minor.yy326,&yymsp[0].minor.yy210);}
#line 2573 "parse.c"
        break;
      case 173:
#line 615 "parse.y"
{yygotominor.yy326 = sqlite3IdListAppend(0,&yymsp[0].minor.yy210);}
#line 2578 "parse.c"
        break;
      case 175:
#line 626 "parse.y"
{yygotominor.yy162 = yymsp[-1].minor.yy162; sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2583 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
#line 627 "parse.y"
{yygotominor.yy162 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2590 "parse.c"
        break;
      case 177:
      case 178:
#line 628 "parse.y"
{yygotominor.yy162 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2596 "parse.c"
        break;
      case 179:
#line 630 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  yygotominor.yy162 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2605 "parse.c"
        break;
      case 180:
#line 635 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy210);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy162 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2616 "parse.c"
        break;
      case 183:
#line 644 "parse.y"
{yygotominor.yy162 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2621 "parse.c"
        break;
      case 184:
#line 645 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy162 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2630 "parse.c"
        break;
      case 185:
#line 650 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy162, &yymsp[0].minor.yy210);
}
#line 2637 "parse.c"
        break;
      case 186:
#line 654 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy162, 0, &yymsp[-1].minor.yy210);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2645 "parse.c"
        break;
      case 187:
#line 659 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprFunction(yymsp[-1].minor.yy44, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy124 && yygotominor.yy162 ){
    yygotominor.yy162->flags |= EP_Distinct;
  }
}
#line 2656 "parse.c"
        break;
      case 188:
#line 666 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2664 "parse.c"
        break;
      case 189:
#line 670 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy162 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->op = TK_CONST_FUNC;  
    yygotominor.yy162->span = yymsp[0].minor.yy0;
  }
}
#line 2677 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 679 "parse.y"
{yygotominor.yy162 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy162, yymsp[0].minor.yy162, 0);}
#line 2689 "parse.c"
        break;
      case 198:
      case 200:
#line 689 "parse.y"
{yygotominor.yy168.eOperator = yymsp[0].minor.yy0; yygotominor.yy168.not = 0;}
#line 2695 "parse.c"
        break;
      case 199:
      case 201:
#line 690 "parse.y"
{yygotominor.yy168.eOperator = yymsp[0].minor.yy0; yygotominor.yy168.not = 1;}
#line 2701 "parse.c"
        break;
      case 204:
#line 697 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy162, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy162, 0);
  if( yymsp[0].minor.yy162 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy162, 0);
  }
  yygotominor.yy162 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy168.eOperator);
  if( yymsp[-2].minor.yy168.not ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162, &yymsp[-3].minor.yy162->span, &yymsp[-1].minor.yy162->span);
  if( yygotominor.yy162 ) yygotominor.yy162->flags |= EP_InfixFunc;
}
#line 2717 "parse.c"
        break;
      case 205:
#line 710 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2725 "parse.c"
        break;
      case 206:
#line 714 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2733 "parse.c"
        break;
      case 207:
#line 718 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2741 "parse.c"
        break;
      case 208:
#line 722 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2749 "parse.c"
        break;
      case 209:
#line 726 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2757 "parse.c"
        break;
      case 210:
#line 730 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2765 "parse.c"
        break;
      case 211:
#line 734 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2773 "parse.c"
        break;
      case 214:
#line 741 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy162, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy162, 0);
  yygotominor.yy162 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy162, 0, 0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy162->span);
}
#line 2789 "parse.c"
        break;
      case 217:
#line 757 "parse.y"
{
    yygotominor.yy162 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pList = yymsp[-1].minor.yy44;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy44);
    }
    if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy0);
  }
#line 2803 "parse.c"
        break;
      case 218:
#line 767 "parse.y"
{
    yygotominor.yy162 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = yymsp[-1].minor.yy313;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy313);
    }
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2816 "parse.c"
        break;
      case 219:
#line 776 "parse.y"
{
    yygotominor.yy162 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = yymsp[-1].minor.yy313;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy313);
    }
    if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy0);
  }
#line 2830 "parse.c"
        break;
      case 220:
#line 786 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210);
    yygotominor.yy162 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy162->span,yymsp[0].minor.yy210.z?&yymsp[0].minor.yy210:&yymsp[-1].minor.yy210);
  }
#line 2845 "parse.c"
        break;
      case 221:
#line 797 "parse.y"
{
    Expr *p = yygotominor.yy162 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy313;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy313);
    }
  }
#line 2858 "parse.c"
        break;
      case 222:
#line 809 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy162, yymsp[-1].minor.yy162, 0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->pList = yymsp[-2].minor.yy44;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy44);
  }
  sqlite3ExprSpan(yygotominor.yy162, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2871 "parse.c"
        break;
      case 223:
#line 820 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44, yymsp[-2].minor.yy162, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(yygotominor.yy44, yymsp[0].minor.yy162, 0);
}
#line 2879 "parse.c"
        break;
      case 224:
#line 824 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy162, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(yygotominor.yy44, yymsp[0].minor.yy162, 0);
}
#line 2887 "parse.c"
        break;
      case 233:
#line 850 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy210, &yymsp[-5].minor.yy210, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy210,0), yymsp[-1].minor.yy44, yymsp[-9].minor.yy124,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy124);
}
#line 2895 "parse.c"
        break;
      case 234:
      case 281:
#line 856 "parse.y"
{yygotominor.yy124 = OE_Abort;}
#line 2901 "parse.c"
        break;
      case 235:
#line 857 "parse.y"
{yygotominor.yy124 = OE_None;}
#line 2906 "parse.c"
        break;
      case 238:
#line 867 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy210.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy210.z, yymsp[-1].minor.yy210.n);
  }
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44, p, &yymsp[-2].minor.yy210);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2919 "parse.c"
        break;
      case 239:
#line 876 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy210.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy210.z, yymsp[-1].minor.yy210.n);
  }
  yygotominor.yy44 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy210);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2932 "parse.c"
        break;
      case 241:
#line 888 "parse.y"
{yygotominor.yy210.z = 0; yygotominor.yy210.n = 0;}
#line 2937 "parse.c"
        break;
      case 243:
#line 894 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy149, yymsp[-1].minor.yy124);}
#line 2942 "parse.c"
        break;
      case 244:
      case 245:
#line 900 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2948 "parse.c"
        break;
      case 246:
#line 908 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 2953 "parse.c"
        break;
      case 247:
#line 909 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy0,0);}
#line 2958 "parse.c"
        break;
      case 248:
#line 910 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,1);
}
#line 2965 "parse.c"
        break;
      case 249:
#line 913 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210,&yymsp[-1].minor.yy210,0);}
#line 2970 "parse.c"
        break;
      case 250:
#line 914 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210,0,0);}
#line 2975 "parse.c"
        break;
      case 258:
#line 928 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy210.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy210.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy137, &all);
}
#line 2985 "parse.c"
        break;
      case 259:
#line 937 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy210, &yymsp[-6].minor.yy210, yymsp[-5].minor.yy124, yymsp[-4].minor.yy412.a, yymsp[-4].minor.yy412.b, yymsp[-2].minor.yy149, yymsp[0].minor.yy162, yymsp[-10].minor.yy124, yymsp[-8].minor.yy124);
  yygotominor.yy210 = (yymsp[-6].minor.yy210.n==0?yymsp[-7].minor.yy210:yymsp[-6].minor.yy210);
}
#line 2993 "parse.c"
        break;
      case 260:
      case 263:
#line 943 "parse.y"
{ yygotominor.yy124 = TK_BEFORE; }
#line 2999 "parse.c"
        break;
      case 261:
#line 944 "parse.y"
{ yygotominor.yy124 = TK_AFTER;  }
#line 3004 "parse.c"
        break;
      case 262:
#line 945 "parse.y"
{ yygotominor.yy124 = TK_INSTEAD;}
#line 3009 "parse.c"
        break;
      case 264:
      case 265:
#line 950 "parse.y"
{yygotominor.yy412.a = yymsp[0].major; yygotominor.yy412.b = 0;}
#line 3015 "parse.c"
        break;
      case 266:
#line 952 "parse.y"
{yygotominor.yy412.a = TK_UPDATE; yygotominor.yy412.b = yymsp[0].minor.yy326;}
#line 3020 "parse.c"
        break;
      case 269:
#line 959 "parse.y"
{ yygotominor.yy162 = 0; }
#line 3025 "parse.c"
        break;
      case 270:
#line 960 "parse.y"
{ yygotominor.yy162 = yymsp[0].minor.yy162; }
#line 3030 "parse.c"
        break;
      case 271:
#line 964 "parse.y"
{
  if( yymsp[-2].minor.yy137 ){
    yymsp[-2].minor.yy137->pLast->pNext = yymsp[-1].minor.yy137;
  }else{
    yymsp[-2].minor.yy137 = yymsp[-1].minor.yy137;
  }
  yymsp[-2].minor.yy137->pLast = yymsp[-1].minor.yy137;
  yygotominor.yy137 = yymsp[-2].minor.yy137;
}
#line 3043 "parse.c"
        break;
      case 272:
#line 973 "parse.y"
{ yygotominor.yy137 = 0; }
#line 3048 "parse.c"
        break;
      case 273:
#line 979 "parse.y"
{ yygotominor.yy137 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy210, yymsp[-1].minor.yy44, yymsp[0].minor.yy162, yymsp[-4].minor.yy124); }
#line 3053 "parse.c"
        break;
      case 274:
#line 984 "parse.y"
{yygotominor.yy137 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy210, yymsp[-4].minor.yy326, yymsp[-1].minor.yy44, 0, yymsp[-7].minor.yy124);}
#line 3058 "parse.c"
        break;
      case 275:
#line 987 "parse.y"
{yygotominor.yy137 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy210, yymsp[-1].minor.yy326, 0, yymsp[0].minor.yy313, yymsp[-4].minor.yy124);}
#line 3063 "parse.c"
        break;
      case 276:
#line 991 "parse.y"
{yygotominor.yy137 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy210, yymsp[0].minor.yy162);}
#line 3068 "parse.c"
        break;
      case 277:
#line 994 "parse.y"
{yygotominor.yy137 = sqlite3TriggerSelectStep(yymsp[0].minor.yy313); }
#line 3073 "parse.c"
        break;
      case 278:
#line 997 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy162 ){
    yygotominor.yy162->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy162, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3084 "parse.c"
        break;
      case 279:
#line 1004 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  if( yygotominor.yy162 ) {
    yygotominor.yy162->iColumn = yymsp[-3].minor.yy124;
    sqlite3ExprSpan(yygotominor.yy162, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3095 "parse.c"
        break;
      case 280:
#line 1014 "parse.y"
{yygotominor.yy124 = OE_Rollback;}
#line 3100 "parse.c"
        break;
      case 282:
#line 1016 "parse.y"
{yygotominor.yy124 = OE_Fail;}
#line 3105 "parse.c"
        break;
      case 283:
#line 1021 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy149,yymsp[-1].minor.yy124);
}
#line 3112 "parse.c"
        break;
      case 284:
#line 1028 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy162, yymsp[-1].minor.yy162, yymsp[0].minor.yy116);
}
#line 3119 "parse.c"
        break;
      case 285:
#line 1031 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy162);
}
#line 3126 "parse.c"
        break;
      case 286:
#line 1037 "parse.y"
{ yygotominor.yy116 = 0; }
#line 3131 "parse.c"
        break;
      case 287:
#line 1038 "parse.y"
{ yygotominor.yy116 = yymsp[0].minor.yy162; }
#line 3136 "parse.c"
        break;
      case 290:
#line 1046 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3141 "parse.c"
        break;
      case 291:
#line 1047 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy210, &yymsp[0].minor.yy210);}
#line 3146 "parse.c"
        break;
      case 292:
#line 1052 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3151 "parse.c"
        break;
      case 293:
#line 1053 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy210, &yymsp[0].minor.yy210);}
#line 3156 "parse.c"
        break;
      case 294:
#line 1058 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy149,&yymsp[0].minor.yy210);
}
#line 3163 "parse.c"
        break;
      case 295:
#line 1061 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy210);
}
#line 3170 "parse.c"
        break;
      case 296:
#line 1064 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy149);
}
#line 3177 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3245 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
