#
# Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
# All rights reserved.
# This component and the accompanying materials are made available
# under the terms of the License "Eclipse Public License v1.0"
# which accompanies this distribution, and is available
# at the URL "http://www.eclipse.org/legal/epl-v10.html".
#
# Initial Contributors:
# Nokia Corporation - initial contribution.
#
# Contributors:
#
# Description: 
#

use strict;
use Getopt::Std;
use File::Copy;
use Cwd;
my %opt;

my $makesis = "$ENV{EPOCROOT}epoc32/tools/makesis.exe";
my $signsis = "$ENV{EPOCROOT}epoc32/tools/signsis.exe";
my $outdir =  "$ENV{EPOCROOT}epoc32/winscw/c/tswi/tsis/data";
my $cert_path = "$ENV{'SECURITYSOURCEDIR'}\\installationservices\\switestfw\\testcertificates";

# --------------------------------------------------------------------------

sub usage() {
    print STDERR << "EOF";
    usage: $0 [-hvc]
     -h        : this (help) message
     -v        : verbose output
     -c        : clean up signed .sis files
EOF
   exit;
}

# --------------------------------------------------------------------------

sub mtimeFile($) {
	my ($file) = shift;
	my ( $dev,$ino,$mode,$nlink,$uid,$gid,$rdev,
	  $size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($file);
	
	$mtime = 0 if ! defined( $mtime );
	return $mtime;
}

# --------------------------------------------------------------------------

sub MakeSISFile($$$) {

	my ($pkgfile, $cert, $key) = @_;
	$pkgfile =~ s/\.pkg//;
	my $sisout = "$pkgfile.sis";
	my $pkgfile_nopath = $pkgfile;
	$pkgfile_nopath =~ s!^.*\\!!;
	my $sisfinal = "$outdir/$pkgfile_nopath.sis";

	if ( $opt{c} ) {
            if ( -f $sisfinal ) {
	        print "Removing $sisfinal\n" if $opt{v};
	        unlink( "$sisfinal" );
	    }
	    return;
	}

	# Look at modification time for the .sis file, and compare with
	# the modified time for makesis, signsis and the .pkg source.
	# Only re-generate .sis file if .pkg/makesis/signsis is more recent
	my $mtime = mtimeFile( $sisfinal );
	if ( $mtime < mtimeFile( "$pkgfile.pkg" ) ||
	     $mtime < mtimeFile( "$makesis" ) ||
	     $mtime < mtimeFile( "$signsis" ))
	{
		system("$makesis $pkgfile.pkg $pkgfile-tmp.sis");
		print "$makesis $pkgfile.pkg $pkgfile-tmp.sis\n";
		system("$signsis -s $pkgfile-tmp.sis $sisout $cert $key");
		print("\n") if !$opt{v};
		print "$signsis -s $pkgfile-tmp.sis $sisout $cert $key\n" if $opt{v};
		unlink("$pkgfile-tmp.sis");

		# Grrr, makesis -d doesn't work, so use current dir
		# Need to keep .sis files in cwd for embedding in each other
		copy("$sisout", "$sisfinal");
	} else {
		print "$sisfinal is up-to-date\n";
	}
}

sub MakeSISFileOnly($$$$) {
    my ($pkgfile, $cert, $key, $del) = @_;

    MakeSISFile($pkgfile,$cert,$key);

    if ($del eq "yes")
     {
	$pkgfile =~ s/\.pkg//;
	my $sisout = "$pkgfile.sis";

	# Remove the sis file, so that the test would not be generated by preparesisx.pl later
	unlink("$pkgfile.sis");
      }
  }

# --------------------------------------------------------------------------

# Perl script that creates and signs SIS files from the $PWD

getopts( "vch:", \%opt ) or usage();
usage() if $opt{h};

# A certain number of SIS files must be generated in the correct order

print "** Running makesis/signsis on all package files\n** and copying them to their destination\n";

MakeSISFile("logo.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("sub.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("locked-emb.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("testupgrade_upgradeembedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("testupgrade_upgradeembedded2.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("testupgrade_baseembedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");

MakeSISFile("053177a_0.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_0.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_1.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_2.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_3.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_4.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_5.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177b_6.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_0.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_1.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_2.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_3.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_4.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_5.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_6.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_7.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("053177c_8.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");

MakeSISFile("def10049_update1_embedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("def10049_update2_embedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("def10049_additionalTests_B.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("def10049_putest_update_embedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("def10049_satest_update_embedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("embedded.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
MakeSISFile("zeros.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");

#The file executes on install, so it should not be self-signed
MakeSISFile("testuninstall_def101378.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");

MakeSISFile("testuninstall_embedA.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_embedB.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_embedC.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_embeddependD.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_embeddependE.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_embeddependF.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");

MakeSISFile("testuninstall_scenario1__b.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario1_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario1_c.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario2_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario3__b_sp.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario3_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario4__b_pu.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario4_c.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario5_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario5_c.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario6_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario6_c.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario7_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario7_c.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario8_a.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");
MakeSISFile("testuninstall_scenario8_c.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");

# Just make and sign only the following packages
MakeSISFileOnly("data_no_tests\\testupgrade_root5sp.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key","yes");
MakeSISFileOnly("data_no_tests\\testupgrade_root5partial.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114language_pu.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114language_sa.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114language_sp.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114upgrade_partial.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114upgrade_puru.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114upgrade_purunr.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114upgrade_sanr.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114upgrade_saru.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");
MakeSISFileOnly("data_no_tests\\preq2114upgrade_sarunr.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key","yes");

print "Processing B\n";
MakeSISFile("testdependency_b.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
print "Processing D\n";
MakeSISFile("testdependency_d.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
print "Processing C\n";
MakeSISFile("testdependency_c.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
print "Processing A\n";
MakeSISFile("testdependency_a.pkg","$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
print "Processing END\n";

MakeSISFile("testuninstall_PDEF118284.pkg","$cert_path/swi/test/tsisfile/data/signedsis/Root5CA/cert_chain_dsa_len1/first.dsa.cer","signedsis/Root5CA/cert_chain_dsa_len1/dsa1.key");

# Test SA+RU+SU+NR -> SP+RU+SU+NR -> SA+RU+SU
MakeSISFile("testspnr_appsarusunr.pkg", 
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucert.pem",
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucertkey.pem");

MakeSISFile("testspnr_sprusunr.pkg", 
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucert.pem",
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucertkey.pem");

MakeSISFile("testspnr_appsarusu.pkg", 
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucert.pem",
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucertkey.pem");

# Not a system-upgrade because the RU flag is not set in the package header. However, it should still be legal
# for this to embed a valid system upgrade (testspnr_sprusunr.sis)
MakeSISFile("testspnr_embed.pkg", 
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucert.pem",
"$cert_path/swi/test/tsisfile/data/signedsis/sucert/sucertkey.pem");

# Now create the rest of the .sis files, after the ones
# which are required to be created first have completed.
#
opendir DIR, ".";
my @pkgfiles = grep (/\.pkg$/, readdir(DIR));
closedir DIR;

foreach my $pkgfile (@pkgfiles) {
    MakeSISFile($pkgfile,"$cert_path/swi/test/tsisfile/data/files/default.cer","files/default.key");
}

# Copy file required by test case for DEF093323
copy("expected_license_text.txt", "$outdir/expected_license_text.txt");
