/*
* Copyright (c) 2007-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   Implements CCatalogsHttpRequestAdapter
*
*/


#include "catalogshttprequestadapter.h"

#include "catalogshttprequestparser.h"
#include "catalogshttpsession.h"
#include "catalogshttpoperation.h"
#include "catalogshttpobserver.h"
#include "catalogshttpconfig.h"
#include "catalogshttpheaders.h"

#include "catalogsdebug.h"


// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
CCatalogsHttpRequestAdapter* CCatalogsHttpRequestAdapter::NewL(
    MCatalogsHttpSession& aHttpSession )
    {
    CCatalogsHttpRequestAdapter* self = new( ELeave ) 
        CCatalogsHttpRequestAdapter( aHttpSession );
    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop( self );
    return self;    
    }
    
    
// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
CCatalogsHttpRequestAdapter::~CCatalogsHttpRequestAdapter()
    {
    DLTRACEIN((""));
    delete iParser;
    if ( iTransaction ) 
        {
        iTransaction->Release();
        }
    iHttpSession.Release();
    }



// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
MCatalogsHttpOperation* CCatalogsHttpRequestAdapter::CreateTransactionL(
    const TDesC8& aUri,
    const TDesC8& aRequest,
    MCatalogsHttpObserver& aObserver )
    {
    DLTRACEIN((""));
    iHttpObserver = &aObserver;
    DASSERT( !iTransaction );
    iUri.Set( aUri );
    
    // Request parsing leads to callbacks to ParsedHttpXXX methods which
    // create the transaction to iTransaction
    TRAPD( err, iParser->ParseRequestL( aRequest, *this ) );
    
    iHttpObserver = NULL;
    if ( err != KErrNone ) 
        {
        DLERROR(("Error %d occurred, leaving", err ));
        if ( iTransaction ) 
            {
            iTransaction->Release();
            iTransaction = NULL;
            }
        User::Leave( err );
        }
    
    if ( !iTransaction ) 
        {
        DLERROR(("Transaction creation failed"));
        User::Leave( KErrCorrupt );
        }
        
    MCatalogsHttpOperation* operation = iTransaction;
    iTransaction = NULL;
    
    return operation;
    }


// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
void CCatalogsHttpRequestAdapter::ParsedHttpRequestLineL( 
    const TDesC8& aMethod, 
    const TDesC8& aUri,
    const TDesC8& aVersion )
    {
    DLTRACEIN(("Method: %S, URI: %S, version: %S",
        &aMethod, &aUri, &aVersion ));
    
    DASSERT( iHttpObserver );
    (void) aUri;
    (void) aVersion;
    
    iTransaction = iHttpSession.CreateTransactionL( 
        iUri, 
        iHttpObserver );
    
    // Set the correct HTTP method
    TCatalogsHttpMethod method( ECatalogsHttpPost );
    
    if ( aMethod.Compare( KCatalogsHttpGet ) == 0 ) 
        {
        method = ECatalogsHttpGet;
        }
    else if ( aMethod.Compare( KCatalogsHttpHead ) == 0 ) 
        {
        method = ECatalogsHttpHead;
        }
    
    iTransaction->Config().SetHttpMethod( method );    
    
    
    }


// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
void CCatalogsHttpRequestAdapter::ParsedHttpHeaderL( 
    const TDesC8& aHeader,
    const TDesC8& aHeaderData )
    {
    DLTRACEIN(("Header: %S data: %S", &aHeader, &aHeaderData ));
    DASSERT( iTransaction );
    
    // skip host, host header is generated by the platform
    if ( aHeader.CompareF( KCatalogsHttpHeaderHost ) != 0 )
        {
        iTransaction->RequestHeadersL().AddHeaderL( aHeader, aHeaderData );        
        }
    }
    

// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
void CCatalogsHttpRequestAdapter::ParsedHttpBodyL(
    const TDesC8& aBody )
    {
    DLTRACEIN(("Body: %S", &aBody ));
    DASSERT( iTransaction );
    iTransaction->SetBodyL( aBody );
    }


// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
CCatalogsHttpRequestAdapter::CCatalogsHttpRequestAdapter( 
    MCatalogsHttpSession& aHttpSession ) 
    : iHttpSession( aHttpSession )
    {
    iHttpSession.AddRef();
    }
    
    
// ---------------------------------------------------------------------------
// 
// ---------------------------------------------------------------------------
//
void CCatalogsHttpRequestAdapter::ConstructL()
    {
    DLTRACEIN((""));
    iParser = CCatalogsHttpRequestParser::NewL();
    }

