BEGIN TRANSACTION CreateScrDatabase;
CREATE TABLE SoftwareTypes(SoftwareTypeId INTEGER PRIMARY KEY NOT NULL,SoftwareTypeName TEXT NOT NULL UNIQUE,SifPluginUid INTEGER,InstallerSecureId INTEGER,ExecutionLayerSecureId INTEGER);
CREATE INDEX idx_SoftwareTypes_MimeType ON SoftwareTypes(SoftwareTypeName);
CREATE TABLE MimeTypes(MimeTypeId INTEGER PRIMARY KEY NOT NULL,SoftwareTypeId INTEGER NOT NULL,MimeType TEXT NOT NULL UNIQUE COLLATE NOCASE);
CREATE INDEX idx_MimeTypes_SoftwareType ON MimeTypes(SoftwareTypeId);
CREATE TABLE Components(ComponentId INTEGER PRIMARY KEY AUTOINCREMENT,SoftwareTypeId INTEGER NOT NULL,Size INTEGER DEFAULT 0,Removable BOOLEAN DEFAULT 1,ScomoState INTEGER DEFAULT 0,DRMProtected INTEGER DEFAULT 0,Hidden INTEGER DEFAULT 0,KnownRevoked INTEGER DEFAULT 0,OriginVerified INTEGER DEFAULT 0,InstalledDrives INTEGER DEFAULT 0,GlobalIdHash INTEGER DEFAULT 0,GlobalId TEXT UNIQUE,Version TEXT,InstallTime TEXT NOT NULL,CompPresence BOOLEAN DEFAULT 1);
CREATE INDEX idx_Components_SoftwareTypeId ON Components(SoftwareTypeId);
CREATE INDEX idx_Components_GlobalIdIdHash ON Components(GlobalIdHash);
CREATE TABLE ComponentLocalizables(CompLocalId INTEGER PRIMARY KEY AUTOINCREMENT, ComponentId INTEGER DEFAULT 0,ApplicationId INTEGER DEFAULT 0,Locale INTEGER DEFAULT 0,Name TEXT NOT NULL,Vendor TEXT);
CREATE INDEX idx_ComponentLocalizables_ComponentId ON ComponentLocalizables(ComponentId);
CREATE TABLE ComponentDependencies(GlobalIdHash INTEGER PRIMARY KEY NOT NULL,DependantGlobalIdHash INTEGER NOT NULL, SupplierGlobalIdHash INTEGER NOT NULL, DependantGlobalId TEXT NOT NULL,SupplierGlobalId TEXT NOT NULL,VersionFrom TEXT, VersionTo TEXT);
CREATE INDEX idx_ComponentDependencies_DependantGlobalId ON ComponentDependencies(DependantGlobalIdHash);
CREATE INDEX idx_ComponentDependencies_SupplierGlobalId ON ComponentDependencies(SupplierGlobalIdHash);
CREATE TABLE ComponentsFiles(CmpFileId INTEGER PRIMARY KEY NOT NULL,ComponentId INTEGER NOT NULL,LocationHash INTEGER DEFAULT 0,Location TEXT NOT NULL COLLATE NOCASE);
CREATE INDEX idx_ComponentsFiles_ComponentId ON ComponentsFiles(ComponentId);
CREATE INDEX idx_ComponentsFiles_LocationHash ON ComponentsFiles(LocationHash);
CREATE TABLE ComponentProperties(PropertyId INTEGER PRIMARY KEY NOT NULL,Name TEXT NOT NULL COLLATE NOCASE,Locale INTEGER DEFAULT 0,ComponentId INTEGER NOT NULL,IntValue INTEGER,StrValue TEXT,IsStr8Bit BOOLEAN DEFAULT 0);
CREATE INDEX idx_ComponentProperties_Name ON ComponentProperties(Name);
CREATE INDEX idx_ComponentProperties_ComponentId ON ComponentProperties(ComponentId);
CREATE INDEX idx_ComponentProperties_IntValue ON ComponentProperties(IntValue);
CREATE TABLE FileProperties(PropertyId INTEGER PRIMARY KEY NOT NULL,Name TEXT NOT NULL COLLATE NOCASE,CmpFileId INTEGER NOT NULL,IntValue INTEGER,StrValue TEXT, Locale INTEGER DEFAULT 0,IsStr8Bit BOOLEAN DEFAULT 0);
CREATE INDEX idx_FileProperties_Name ON FileProperties(Name);
CREATE INDEX idx_FileProperties_CmpFileId ON FileProperties(CmpFileId);
CREATE TABLE ScrVersion(MajorVersion INTEGER NOT NULL, MinorVersion INTEGER NOT NULL, BuildNumber INTEGER NOT NULL);
INSERT INTO ScrVersion(MajorVersion, MinorVersion, BuildNumber) VALUES(1, 1, 1);
END TRANSACTION CreateScrDatabase;
