/*
* Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


/**
 @file
*/

#include <e32def.h>
#include <e32err.h>
#include <f32file.h>
#include <e32debug.h>

namespace 
{
	TUint8 rawdata[] = 
	{
	0x54,0x68,0x69,0x73,0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,
	0x65,0x65,0x6e,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,
	0x6f,0x72,0x20,0x74,0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,
	0x69,0x73,0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,
	0x6e,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,0x72,
	0x20,0x74,0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,0x69,0x73,
	0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,
	0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x74,
	0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,0x69,0x73,0x20,0x66,
	0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x67,0x65,
	0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x74,0x65,0x73,
	0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,0x69,0x73,0x20,0x66,0x69,0x6c,
	0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x67,0x65,0x6e,0x65,
	0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x74,0x65,0x73,0x74,0x69,
	0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,0x69,0x73,0x20,0x66,0x69,0x6c,0x65,0x20,
	0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,
	0x74,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x74,0x65,0x73,0x74,0x69,0x6e,0x67,
	0x2e,0x0d,0x0a,0x54,0x68,0x69,0x73,0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,
	0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,
	0x64,0x20,0x66,0x6f,0x72,0x20,0x74,0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,
	0x0a,0x54,0x68,0x69,0x73,0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,
	0x62,0x65,0x65,0x6e,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,
	0x66,0x6f,0x72,0x20,0x74,0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,
	0x68,0x69,0x73,0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,
	0x65,0x6e,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,
	0x72,0x20,0x74,0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,0x69,
	0x73,0x20,0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,
	0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,
	0x74,0x65,0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a,0x54,0x68,0x69,0x73,0x20,
	0x66,0x69,0x6c,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x67,
	0x65,0x6e,0x65,0x72,0x61,0x74,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x74,0x65,
	0x73,0x74,0x69,0x6e,0x67,0x2e,0x0d,0x0a
	};

	_LIT(KSwiCertstoreDatfile, "\\Resource\\SwiCertstore\\dat\\afile");
	_LIT(KSwiCertstoreTmpfile, "\\Resource\\SwiCertstore\\tmp\\afile");
	_LIT(KSwiCertstoreDirfile, "\\Resource\\SwiCertstore\\afile");
}

void CreateFileL(RFs &rfssession, const TDesC &afn)
	{
	RFile file;	
	CleanupClosePushL(file);
	
	// If the temp file already exists we will overwrite it.  UIDs are
	// unique after all.
	User::LeaveIfError(file.Replace(rfssession, afn, 
									EFileWrite | EFileShareExclusive));
	
	TPtr8 data(rawdata, sizeof(rawdata), sizeof(rawdata));

	// write is not atomic
	User::LeaveIfError(file.Write(data, sizeof(rawdata)));
	
	User::LeaveIfError(file.Flush());
	file.Close();
	CleanupStack::Pop(); // Pop the file
	}

void StartL()
	{
	RFs rfssession;
	User::LeaveIfError(rfssession.Connect());	
	CleanupClosePushL(rfssession);
	
	TDriveUnit sysDrive (rfssession.GetSystemDrive());
	TDriveName sysDriveName (sysDrive.Name());
	
	TBuf<128> datFile (sysDriveName);
	datFile.Append(KSwiCertstoreDatfile);
	CreateFileL(rfssession, datFile);
	
	datFile.Copy(sysDriveName);
	datFile.Append(KSwiCertstoreTmpfile);
	CreateFileL(rfssession, datFile);
	
	datFile.Copy(sysDriveName);
	datFile.Append(KSwiCertstoreDirfile);
	CreateFileL(rfssession, datFile);
	
	rfssession.Close();
	CleanupStack::Pop(); // poop rfssession
	}

/*Main.
 *
 * @return A status code.
 */
TInt E32Main(void)
	// No arguments are permitted
	{
	__UHEAP_MARK;
	
	const CTrapCleanup *const stack(CTrapCleanup::New());
	TInt result(KErrNoMemory);
	
	if (stack)
		{
		TRAP(result, StartL());
		
		delete stack;
		}
	
	__UHEAP_MARKEND;

	return result;
	}
