/*
* Copyright (c) 2006-2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   NCD Provider error code definitions.
*
*/


#ifndef NCD_ERRORS_H
#define NCD_ERRORS_H

const TInt KNcdErrorBase = -10000;

/**
 * No content sources received from server.
 */
const TInt KNcdErrorNoContentSources = -10001;

/**
 * No valid purchase information
 */
const TInt KNcdErrorNoPurchaseInformation = -10002;

/**
 * Requested node removed from server.
 */
const TInt KNcdErrorNodeWasRemoved = -10003;

/**
 * Purchasing a subscription failed since the payment was already done.
 */
const TInt KNcdErrorSubscriptionPaymentAlreadyDone = -10004;

/**
 * Tried to buy an item which belongs to subscription which is not subscribed.
 */
const TInt KNcdErrorSubscriptionNotSubscribed = -10005;

/**
 * Tried to use subscription which is invalid.
 */
const TInt KNcdErrorSubscriptionInvalid = -10006;

/**
 * Tried to use subscription which has not enough credits or downloads.
 */
const TInt KNcdErrorSubscriptionNotEnoughCredits = -10007;

/**
 * General "not found" error.
 */
const TInt KNcdErrorNotFound = -10008;

/**
 * Purchase failed because no purchase information was received.
 */
const TInt KNcdErrorNoPurchaseInformationReceived = -10009;


/**
 * Errors used in purchase and subscription interfaces
 */

/**
 * Tried to use purchase option or subscription that is obsolete.
 */
const TInt KNcdErrorObsolete = -10010;

/**
 * Subscription cannot be subscribed anymore.
 */
const TInt KNcdErrorSubscriptionNotSubscribableAnymore = -10011;

/**
 * Tried to use purchase option that is not a valid purchase option
 * of type SubscriptionPurchase.
 */
const TInt KNcdErrorPurchaseOptionNotValidSubscriptionPurchase = -10012;

/**
 * A mandatory query has been rejected and as a result an operation cannot
 * continue.
 */
const TInt KNcdErrorMandatoryQueryRejected = -10013;

/**
 * Some catalogs failed to load.
 */
const TInt KNcdErrorSomeCatalogsFailedToLoad = -10014;

/**
 * Master server URI has not been set
 */
const TInt KNcdErrorNoMasterServerUri = KNcdErrorBase - 15;


/**
 * Nothing to install, either everything has been installed or
 * no files have been downloaded that should be installed
 */
const TInt KNcdErrorNothingToInstall = KNcdErrorBase - 16;

/**
 * Creation of fixed AP fails.
 */
const TInt KNcdErrorApCreationFailed = KNcdErrorBase - 17;

/**
 * When doing manage subscription request to different servers,
 * some of the requests failed.
 */
const TInt KNcdErrorSomeSubscriptionsFailedToUpdate = KNcdErrorBase - 18;

/**
 * Tried to start an operation for a node that already had an on-going operation on
 * another client (with the same family uid).
 * Parallel operations on one node metadata are not supported. Previous
 * operation must complete before starting a new one.
 */
const TInt KNcdErrorParallelOperationNotAllowed = KNcdErrorBase - 19;

/**
 * Protocol error codes start here.
 * They are generated by subtracting the protocol error from
 * KNcdProtocolErrorBase.
 */
const TInt KNcdProtocolErrorBase = -20000;


/**
 * Status code for indicating that a theme was reinstalled.
 * It is possible that this code is returned even if the theme installation
 * failed when reinstalling a theme.
 */
const TInt KNcdThemeReinstalled = 50000;

/**
 * Status code for indicating that a theme was possibly reinstalled.
 * It is possible that this code is returned even if the theme installation
 * failed.
 */
const TInt KNcdThemePossiblyReinstalled = 50001;


/**
 * Provider creation will succeed with status code 1 if all of client's
 * databases were deleted because the client had crashed the provider too 
 * many times
 */
const TInt KNcdDatabasesClearedAfterCrash = 1;

/**
 * Provider creation will succeed with status code 2 if the purchase
 * history was deleted because it was of wrong version
 * 
 * This will be combined with KNcdGeneralDatabaseVersionMismatch if
 * both purchase history and all other databases are of wrong version or
 * if the version information can not be read at all
 */
const TInt KNcdPurchaseHistoryVersionMismatch = 2;

/**
 * Provider creation will succeed with status code 4 if general databases
 * (everything else but purchase history) were deleted because they were
 * of wrong version
 * 
 * @see KNcdPurchaseHistoryVersionMismatch
 */
const TInt KNcdGeneralDatabaseVersionMismatch = 4;

#endif // NCD_ERRORS_H
