// Copyright (c) 2003-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// BufferTest module
// compares unicode buffers obtained by
// (1)passing the entire narrow buffer to CCnvCharacterSetConverter::ConvertToUnicode
// (2)using CHtmlToCrtConvBuffer::ReadCharacterL
// 
//

#include <e32std.h>
#include <e32test.h>
#include "CHtmlToCrtConvBuffer.h"
#include <charconv.h>


_LIT(KTestName,"bufferTest");
_LIT(KTest1,"@SYMTestCaseID PIM-BUFFERTEST-0001 buffer test");

LOCAL_D RTest test(KTestName);

void getCharacterSetL(TDesC8& aSource, RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter);
void convertBufferDirectlyL(TDesC8& aSource, TDes& aUnicode, CCnvCharacterSetConverter* aCnvCharacterSetConverter);
void convertBufferUsingCHtmlToCrtConvBufferL(TDesC8& aSource, TDes& aUnicode, RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter);
bool doComparisonL(TDes8& aSource, RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter);
void comparisonForVariousCharsetsL(RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter);

//=========================================================================================

/**
@SYMTestCaseID PIM-BUFFERTEST-0001
*/
void doMainL()
	{
	test.Start(KTest1);

	RFs fs;
	User::LeaveIfError(fs.Connect());
	CleanupClosePushL(fs);
	CCnvCharacterSetConverter* cnvCharacterSetConverter=CCnvCharacterSetConverter::NewLC();

	comparisonForVariousCharsetsL(fs, cnvCharacterSetConverter);

	CleanupStack::PopAndDestroy(2); //cnvCharacterSetConverter, fs

	test.End();
	test.Close();
	}

//=========================================================================================

GLDEF_C TInt E32Main()
	{	
	__UHEAP_MARK;

	CTrapCleanup* theCleanup=CTrapCleanup::New();
	TRAPD(ret,doMainL());	
	test(ret==KErrNone);
	delete theCleanup;	

	__UHEAP_MARKEND;
	return(KErrNone);
	}
//=========================================================================================
//getCharacterSetL
//=========================================================================================
void getCharacterSetL(TDesC8& aSource, RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter)
	{
	CArrayFix<CCnvCharacterSetConverter::SCharacterSet>* arrayOfCharacterSetsAvailable=CCnvCharacterSetConverter::CreateArrayOfCharacterSetsAvailableLC(aFs);
	TInt confidence;
	TUint characterSetIdentifier;

	aCnvCharacterSetConverter->AutoDetectCharacterSetL(confidence, characterSetIdentifier, *arrayOfCharacterSetsAvailable, aSource);
	aCnvCharacterSetConverter->PrepareToConvertToOrFromL(characterSetIdentifier, *arrayOfCharacterSetsAvailable, aFs);
	CleanupStack::PopAndDestroy(arrayOfCharacterSetsAvailable);
	}
//=========================================================================================
//convertBufferDirectlyL
//=========================================================================================
void convertBufferDirectlyL(TDesC8& aSource, TDes& aUnicode, CCnvCharacterSetConverter* aCnvCharacterSetConverter)
	{
	TInt state=CCnvCharacterSetConverter::KStateDefault;
	TInt returnValue=aCnvCharacterSetConverter->ConvertToUnicode(aUnicode, aSource, state);

	//return value is 0 if entire buffer converted
	if(returnValue!=0)
		User::Leave(KErrGeneral);
	}
//=========================================================================================
//convertBufferUsingCHtmlToCrtConvBufferL
//=========================================================================================
void convertBufferUsingCHtmlToCrtConvBufferL(TDesC8& aSource, TDes& aUnicode, RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter)
	{
	//write source buffer to source file for passing to CHtmlToCrtConvBuffer::NewL()
	_LIT(KSourceFile,"c:\\source file");
	TBufC<15> sourceFile=KSourceFile();
	RFile	source;
	User::LeaveIfError(source.Replace(aFs, sourceFile, EFileWrite));
	test(source.Write(aSource)==KErrNone);
	source.Close();

	CHtmlToCrtConvBuffer* buffer=CHtmlToCrtConvBuffer::NewL(sourceFile, aFs, *aCnvCharacterSetConverter);
	CleanupStack::PushL(buffer);

	TChar character;
	TInt position=0;
	TBool endOfBuffer=EFalse;
	while(buffer->ReadCharacterL(character, position, endOfBuffer))
		{
		aUnicode.Append(character);
		}

	CleanupStack::PopAndDestroy(buffer);
	}
//=========================================================================================
//doComparisonL
//=========================================================================================
bool doComparisonL(TDes8& aSource, RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter)
	{
	TBuf<512> directUnicode;
	TBuf<512> bufferUnicode;

	getCharacterSetL(aSource, aFs, aCnvCharacterSetConverter);
	convertBufferDirectlyL(aSource, directUnicode, aCnvCharacterSetConverter);
	convertBufferUsingCHtmlToCrtConvBufferL(aSource, bufferUnicode, aFs, aCnvCharacterSetConverter);
	
	//compare the two buffers
	return (directUnicode.Compare(bufferUnicode)==0);
	}
//=========================================================================================
//comparisonForVariousCharsetsL
//=========================================================================================
void comparisonForVariousCharsetsL(RFs& aFs, CCnvCharacterSetConverter* aCnvCharacterSetConverter)
	{
	_LIT8(KSJISPhrase, "\x81@\x81y\x83o\x83\x93\x83R\x83N\x82Q\x82T\x93\xfa\x81\x81\x89\xaa\x93""c\x8e\xa0\x8ds\x81z\x83\x84\x83\x93\x83S\x83\x93\x82\xa9\x82\xe7\x82\xcc\x8f\xee\x95\xf1\x82\xc9\x82\xe6\x82\xe9\x82\xc6\x81""A\x83~\x83\x83\x83\x93\x83}\x81[\x82\xcc\x96\xaf\x8e\xe5\x89\xbb\x89^\x93\xae\x8ew\x93\xb1\x8e\xd2\x83""A\x83""E\x83\x93\x81""E\x83T\x83\x93\x81""E\x83X\x81[\x81""E\x83`\x81[\x82\xb3\x82\xf1\x82\xe7\x8d\x91\x96\xaf\x96\xaf\x8e\xe5\x98""A\x96\xbf\x81i\x82m\x82k\x82""c\x81j\x82\xcc\x83\x81\x83\x93\x83o\x81[\x82\xaa\x93\xf1\x8f\\x8el\x93\xfa\x81""A\x8e\xd4\x82\xc5\x83\x84\x83\x93\x83S\x83\x93\x8dx\x8aO\x82\xc9\x8fo\x82\xbd\x82\xc6\x82\xb1\x82\xeb\x81""A\x8cR\x90\xad\x93\x96\x8b\xc7\x82\xc9\x90\xa7\x8e~\x82\xb3\x82\xea\x82\xbd\x82\xbd\x82\xdf\x81""A\x93\xb9\x98H\x82\xed\x82\xab\x82\xc9\x88\xda\x82\xb3\x82\xea\x82\xbd\x8e\xd4\x93\xf1\x91\xe4\x82\xcc\x92\x86\x82\xc5\x82\xeb\x82\xa4\x8f\xe9\x82\xf0\x8en\x82\xdf\x82\xbd\x81""B\x83X\x81[\x81""E\x83`\x81[\x82\xb3\x82\xf1\x82\xaa\x81""A\x93\x96\x8b\xc7\x82\xcc\x8ds\x93\xae\x90\xa7\x8c\xc0\x82\xf0\x94j\x82\xc1\x82\xc4\x8dx\x8aO\x82\xc9\x8fo\x82\xbd\x82\xcc\x82\xcd\x8b\xe3\x94\xaa\x94N\x94\xaa\x8c\x8e\x88\xc8\x97\x88\x81""A\x93\xf1\x94N\x82\xd4\x82\xe8\x81""B\x96\xaf\x8e\xe5\x89\xbb\x89^\x93\xae\x82\xd6\x82\xcc\x8d\x91\x8d\xdb\x93I\x82\xc8\x8ex\x8e\x9d\x8fW\x82\xdf\x82\xf0\x91_\x82\xc1\x82\xc4\x92\xb7\x8a\xfa\x82\xeb\x82\xa4\x8f\xe9\x82\xf0\x8ds\x82\xa4\x89\xc2\x94\\x90\xab\x82\xe0\x82\xa0\x82\xe8\x81""A\x8cR\x90\xad\x91\xa4\x82\xcd\x91\xce\x89\x9e\x82\xc9\x8b\xea\x97\xb6\x82\xb5\x82\xc4\x82\xa2\x82\xe9\x81""B<p>");
	_LIT8(KBig5, "\xa1@\xa1@\xa5\xbb\xb3\xf8\xb0T\xa1]\xb0O\xaa\xcc\xb1\xe4\xd9y\xa1^\xac\xb0\xb3""e\xb9\xfd\xb8\xa8\xb9\xea\xa4\xa4\xa5\xa1\xa6\xe8\xb3\xa1\xa4j\xb6}\xb5o\xbe\xd4\xb2\xa4\xa9M\xa7\xf5\xb4P\xb2M\xb0\xc6\xc1`\xb2z\xc3\xf6\xa4_\xb1\xd0\xa8|\xb9\xef\xa4""f\xa4\xe4\xb4\xa9\xab\xfc\xa5\xdc\xba\xeb\xaf\xab\xa1""A\xa5\xbb\xa5\xab\xb1N\xb2\xd5\xc2\xb4\xb1\xd0\xaev\xb9\xce\xadu\xa4\xba\xbbX\xa5j\xb6}\xaei\xb9\xef\xa4""f\xa4\xe4\xb4\xa9\xa1""A\xad\xba\xa7\xe5""115\xa6W\xb1\xd0\xaev\xb1N\xa6""b\xb7s\xbe\xc7\xb4\xc1\xb6}\xbe\xc7\xa4\xa7\xbb\xda\xb1\xd2\xb5{\xadu\xa4\xba\xbbX\xa5j\xa1""C\xacQ\xa4\xd1\xa4W\xa4\xc8\xa1""A\xa5\xab\xa9""e\xae\xd1\xb0O");
	_LIT8(KBig52, "\xa7\xda\xacO\xa6""b\xbcw\xb0\xea\xb6}\xa9l\xbb{\xc3\xd1\xb0\xf2\xb7\xfe\xad""C\xbfq\xa1M\xa8\xc3\xa6""b\xbcw\xb0\xea\xaa\xba\xaai\xa9\xf9\xa8\xfc\xac~\xa1""C\xa6\xfd\xa7\xda\xafu\xa5\xbf\xb7P\xa8\xfc\xa8\xec\xa5""D\xb9\xef\xa7\xda\xaa\xba\xae\xa6\xa8\xe5\xacO\xa6""b\xa7\xf9\xa5\xec\xb4\xb5\xb3\xf9\xa1M\xa6""b\xbb{\xc3\xd1\xa4""FReinhold\xa9MWerner\xb5\xa5\xaa""B\xa4\xcd\xad\xcc\xab\xe1\xa1""C\xa8""C\xa4\xd1\xa7\xda\xb3\xa3\xa8""D\xa7i\xa5""D\xaf\xe0\xabO\xa6u\xa7\xda\xad\xcc\xaa\xba\xc3\xf6\xabY\xa1""C\xa7\xda\xb4\xc1\xb1\xe6\xa7O\xa4H\xaf\xe0\xb1q\xa7\xda\xa8\xad\xa4W\xb7P\xa8\xfc\xa8\xec\xa5""D\xa1""C");
	_LIT8(KEUP, "\xa1\xcb\xa1\xa3\xa4\xb3\xa4\xec\xa4\xcf\xa1\xa4\xb9\xe2\xc9\xe9\xb2\xd9\xa4\xce\xa5\xd9\xa5\xf3\xa5\xc1\xa5\xde\xa1\xbc\xa5\xaf\xa4\xe4\xa5\xa2\xa5\xd7\xa5\xea\xa5\xb1\xa1\xbc\xa5\xb7\xa5\xe7\xa5\xf3\xa4\xf2\xbc\xc2\xb9\xd4\xa4\xb9\xa4\xeb\xa4\xc8\xa1\xa4\xbd\xe8\xcd\xfd\xa4\xac\xb4\xb0\xce\xbb\xa4\xb9\xa4\xeb\xc1\xb0\xa4\xcb\xa5\xd5\xa5\xea\xa1\xbc\xa5\xba\xa4\xb9\xa4\xeb\xc9\xd4\xb6\xf1\xb9\xe7\xa4\xac\xb3\xce\xc7\xa7\xa4\xb5\xa4\xec\xa4\xbf\xa4\xbf\xa4\xe1\xa1\xa3\xa4\xb7\xa4\xab\xa4\xb7\xcc\xe4\xc2\xea\xa4\xcf\xa1\xa4\xa4\xbd\xa4\xce\xb8\xb6\xb0\xf8\xa4\xac\xa1\xd6\xa5\xb7\xa5\xea\xa5\xb3\xa5\xf3\xa4\xce\xa5\xde\xa1\xbc\xa5\xb8\xa5\xf3\xc9\xd4\xc2\xad\xa1\xd7\xa4\xc0\xa4\xc3\xa4\xbf\xc5\xc0\xa4\xc0\xa1\xa3");
	_LIT8(KEUC2, "Enlightenment\xa4\xce\xa5\xc6\xa1\xbc\xa5\xde\xa4\xc8\xa4\xcf\xa1\xa2\xa5\xa6\xa5\xa3\xa5\xf3\xa5\xc9\xa5\xa6\xa5\xde\xa5\xcd\xa1\xbc\xa5\xb8\xa5\xe3\xa4\xce\xb3\xb0\xb4\xd1\xc9\xf4\xca\xac\xa4\xce\xcd\xd7\xc1\xc7\xa4\xf2\xa4\xd2\xa4\xc8\xa4\xde\xa4\xc8\xa4\xe1\xa4\xcb\xa4\xb7\xa4\xc6\xc0\xda\xa4\xea\xc2\xd8\xa4\xa8\xa4\xe9\xa4\xec\xa4\xeb\xa4\xe8\xa4\xa6\xa4\xcb\xa4\xb7\xa4\xbf\xa4\xe2\xa4\xce\xa1\xa2\xa4\xc8\xb9\xcd\xa4\xa8\xa4\xeb\xa4\xb3\xa4\xc8\xa4\xac\xa4\xc7\xa4\xad\xa4\xde\xa4\xb9\xa1\xa3\xa4\xc4\xa4\xde\xa4\xea\xa1\xa2""1\xa4\xc4\xa4\xce\xa5\xa6\xa5\xa3\xa5\xf3\xa5\xc9\xa5\xa6\xa5\xde\xa5\xcd\xa1\xbc\xa5\xb8\xa5\xe3\xa4\xca\xa4\xce\xa4\xcb\xa1\xa2Windows\xc9\xf7\xa4\xcb\xa4\xe2\xa1\xa2Mac\xc9\xf7\xa4\xcb\xa4\xe2\xa1\xa2\xa4\xb5\xa4\xde\xa4\xb6\xa4\xde\xa4\xcb\xa5\xab\xa5\xb9\xa5\xbf\xa5\xde\xa5\xa4\xa5\xba\xa4\xb9\xa4\xeb\xa4\xb3\xa4\xc8\xa4\xac\xa4\xc7\xa4\xad\xa4\xde\xa4\xb9\xa1\xa3");
	_LIT8(KSJIS, "\x82\xb1\x82\xcc\x83z\x81[\x83\x80\x83y\x81[\x83W\x82\xcd\x81""A\x82\xa9\x82\xed\x82\xa2\x82\xa2\x83L\x83\x83\x83\x89\x83N\x83^\x81[\x81g\x83s\x83\x93\x83O\x81[\x81h\x82\xf0\x82\xbd\x82\xad\x82\xb3\x82\xf1\x82\xcc\x90l\x82\xbd\x82\xbf\x82\xc9\x8f\xd0\x89\xee\x82\xb5\x81""A\x82\xdc\x82\xbd\x81""A\x8c\xf0\x97\xac\x82\xf0\x8e\x9d\x82\xc1\x82\xc4\x82\xa2\x82\xbd\x82\xbe\x82\xab\x82\xbd\x82\xa2\x82\xc6\x8ev\x82\xc1\x82\xc4\x8d\xec\x90\xac\x82\xb3\x82\xea\x82\xbd\x83y\x81[\x83W\x82\xc5\x82\xb7\x81""B<B>\x82\xb1\x82\xcc\x83z\x81[\x83\x80\x83y\x81[\x83W\x82\xcd\x8a""F\x82\xb3\x82\xf1\x82\xcc\x81g\x83N\x83`\x83R\x83~\x81h\x82\xc5\x90\xac\x82\xe8\x97\xa7\x82\xc1\x82\xc4\x82\xa2\x82\xdc\x82\xb7\x81""B</B>\x82\xba\x82\xd0\x8f\xee\x95\xf1\x82\xf0\x82\xa8\x8a\xf1\x82\xb9\x89\xba\x82\xb3\x82\xa2\x81I");
	_LIT8(KISO2022, "\x1b$B?M8F$s$GBjL>$N$J$$%%k%P%`!#%P!<%:$G8@$($P!V%%s\x1b(B\x1b$B%?%$%H%k%I!W$G$9$M!#$=$s$JOC$O$H$b$+$/!#\x1b(B");
	_LIT8(KISO2022JP, "\x1b$B$*5R$5$^$K:#8e$H$b$4K~B-$7$F%5!<%S%9$r$4MxMQ$$$?$@$1$k$h$&!8r495!Ey$N5!G=8~>e$N$?$a$N9);v$r<B;\\$9$kM=Dj$G$9!#");
	_LIT8(SJISNET, "20\x94NTRUSTe\x93\xfa\x96{\x82\xcd\x81""A\x8f\xee\x95\xf1\x82\xcc\x8aJ\x8e\xa6\x82\xc6\x8d\x90\x92m\x8b`\x96\xb1\x82\xc9\x8a\xd6\x82\xb7\x82\xe9\x8c\xb4\x91\xa5\x82\xf0\x8dL\x82\xdf\x82\xe9\x82\xb1\x82\xc6\x82\xc9\x82\xe6\x82\xe8\x81""A\x83""C\x83\x93\x83^\x81[\x83l\x83""b\x83g\x8f\xe3\x82\xc9\x82\xa8\x82\xaf\x82\xe9\x83\x86\x81[\x83U\x81[\x82\xc6\x82\xcc\x8f\xee\x95\xf1\x8aJ\x8e\xa6\x82\xc9\x8a\xd6\x82\xb7\x82\xe9\x90M\x97\x8a\x8a\xd6\x8cW\x82\xf0\x91\xc5\x82\xbf\x97\xa7\x82\xc4\x82\xe9\x82\xb1\x82\xc6\x82\xf0\x8eg\x96\xbd\x82\xc6\x82\xb7\x82\xe9\x81""A\x93\xc6\x97\xa7\x82\xcc\x94\xf1\x89""c\x97\x98\x91g\x90""D\x82\xc5\x82\xb7\x81""B\x82\xb1\x82\xcc\x83""E\x83""F\x83u\x83T\x83""C\x83g\x82\xcd\x8bM\x93""a\x82\xcc\x83v\x83\x89\x83""C\x83o\x83V\x81[\x82\xc9\x91\xce\x82\xb7\x82\xe9\x82\xbb\x82\xcc\x8c\xf6\x96\xf1\x82\xf0\x8e\xc0\x8f\xd8\x82\xb7\x82\xe9\x88\xd3\x96\xa1\x82\xc5\x81""A\x82\xb1\x82\xb1\x82\xc9\x8f\xee\x95\xf1\x82\xcc\x8e\xe6\x82\xe8\x88\xb5\x82\xa2\x8a\xee\x8f\x80\x82\xf0\x8aJ\x8e\xa6\x82\xb5\x82\xbd\x82\xe0\x82\xcc\x82\xc5\x81""A\x82\xb1\x82\xcc\x83v\x83\x89\x83""C\x83o\x83V\x81[\x8e\xe6\x82\xe8\x88\xb5\x82\xa2\x8a\xee\x8f\x80\x82\xc9\x82\xc2\x82\xa2\x82\xc4\x82\xcd\x81""ATRUSTe\x82\xc9\x82\xe6\x82\xe8\x81""A\x82\xbb\x82\xcc\x8f\x87\x8e\xe7\x82\xc9\x8a\xd6\x82\xb7\x82\xe9\x8c\x9f\x93\xa2\x82\xc6\x8a\xc4\x8d\xb8\x82\xc6\x82\xf0\x8e\xf3\x82\xaf\x82\xbd\x82\xe0\x82\xcc\x82\xc5\x82\xb7\x81""B");
	_LIT8(GB2312, "\xce\xd2\xca\xc7\xd4\xda\xb5\xc2\xb9\xfa\xbf\xaa\xca\xbc\xc8\xcf\xca\xb6\xbb\xf9\xb6\xbd\xd2\xae\xf6\xd5\xa3\xac\xb2\xa2\xd4\xda\xb5\xc2\xb9\xfa\xb5\xc4\xb2\xa8\xb0\xba\xca\xdc\xcf\xb4\xa1\xa3\xb5\xab\xce\xd2\xd5\xe6\xd5\xfd\xb8\xd0\xca\xdc\xb5\xbd\xd6\xf7\xb6\xd4\xce\xd2\xb5\xc4\xb6\xf7\xb5\xe4\xca\xc7\xd4\xda\xb6\xc5\xd2\xc1\xcb\xb9\xb1\xa4\xa3\xac\xd4\xda\xc8\xcf\xca\xb6\xc1\xcbReinhold\xba\xcdWerner\xb5\xc8\xc5\xf3\xd3\xd1\xc3\xc7\xba\xf3\xa1\xa3\xc3\xbf\xcc\xec\xce\xd2\xb6\xbc\xc7\xf3\xb8\xe6\xd6\xf7\xc4\xdc\xb1\xa3\xca\xd8\xce\xd2\xc3\xc7\xb5\xc4\xb9\xd8\xcf\xb5\xa1\xa3\xce\xd2\xc6\xda\xcd\xfb\xb1\xf0\xc8\xcb\xc4\xdc\xb4\xd3\xce\xd2\xc9\xed\xc9\xcf\xb8\xd0\xca\xdc\xb5\xbd\xd6\xf7\xa1\xa3");
	_LIT8(GB2312A, "1. \xd0\xde\xd5\xfd\xc1\xcb\xd3\xeb\xbd\xf0\xc9\xbd\xb4\xca\xb0\xd4\xb3\xe5\xcd\xbb\xb5\xc4\xce\xca\xcc\xe2\xa1\xa3 <br>                2. \xd4\xda\xb9\xfa\xb1\xea\xbc\xf2\xcc\xe5\xcf\xc2\xcc\xed\xbc\xd3\xc1\xcb\xa1\xb0\xb2\xd6\xf2\xa1\xa1\xb1\xba\xcd\xa1\xb0\xbc\xf2\xd2\xd7\xa1\xb1\xca\xe4\xc8\xeb\xb7\xa8\xa1\xa3\xd4\xda\xb4\xf3\xce\xe5\xc2\xeb\xcf\xc2\xcc\xed\xbc\xd3\xc1\xcb\xa1\xb0\xc0\xfb\xb7\xbd\xc6\xb4\xd2\xf4\xa1\xb1\xca\xe4\xc8\xeb\xb7\xa8\xa1\xa3 <br>                3. \xb4\xf3\xce\xe5\xc2\xeb\xcf\xc2\xa1\xb0\xb2\xd6\xf2\xa1\xa1\xb1\xba\xcd\xa1\xb0\xbc\xf2\xd2\xd7\xa1\xb1\xca\xe4\xc8\xeb\xb7\xa8\xd6\xa7\xb3\xd6\xcf\xe3\xb8\xdb""4700\xd7\xd6\xa1\xa3 <br>                4. \xd0\xde\xd5\xfd\xc1\xcb\xa1\xb0\xd7\xd4\xb6\xaf\xca\xb6\xb1\xf0\xa1\xb1\xcf\xd4\xca\xbe\xc2\xd2\xc2\xeb\xce\xca\xcc\xe2\xa1\xa3 <br>                5. \xbf\xc9\xd7\xd4\xd0\xd0\xc9\xe8\xd6\xc3\xa1\xb0\xd6\xa7\xb3\xd6MSOffice\xa1\xb1\xba\xcd\xa1\xb0\xba\xba\xd7\xd6\xd7\xd4\xb6\xaf\xca\xb6\xb1\xf0\xa1\xb1\xb5\xc4\xc6\xf4\xb6\xaf\xc8\xb1\xca\xa1\xd7\xb4\xcc\xac\xa1\xa3 </font><br>");
	_LIT8(BIG5A, "\xb0\xea\xae""a\xbcs\xbc\xbd\xb9q\xb5\xf8\xbd\xe8\xb6q\xba\xca\xb7\xfe\xc0\xcb\xc5\xe7\xb4\xfa\xb8\xd5\xa4\xa4\xa4\xdf</a> - \xb9\xef\xad\xb5\xb5\xf8\xc0W\xb2\xa3\xab~\xaa\xba\xb1`\xb7\xc5\xb9q\xa9\xca\xaf\xe0\xa1""B\xa6w\xa5\xfe\xa1""B\xb9q\xba\xcf\xad\xdd\xae""e\xa7@\xc0\xf4\xb9\xd2\xb4\xfa\xb8\xd5\xa9M\xba\xca\xb7\xfe\xa9\xe2\xac""d");
	_LIT8(BIG5C, "\xac\xfc \xb0\xea \xb0\xc8 \xb0| \xa8\xc8 \xa4\xd3 \xb0\xc6 \xa7U \xad\xeb \xc1\xc2 \xb2Q \xc4R \xa4\xb5 \xa4\xe9 \xa6""b \xa6\xb9 \xb6\xa1 \xa4@ \xa6\xb8 \xbcy \xaf\xac \xa4\xa4 \xa6@ \xab\xd8 \xac""F \xa4\xad \xa4Q \xa9P \xa6~ \xaa\xba \xa4j \xab\xac \xac\xe3 \xb0Q \xb7| \xa4\xa4 \xaa\xed \xa5\xdc \xa1""A \xa4\xa4 \xa6@ \xc0\xb3 \xb8\xd3 \xb9\xef \xa5x \xc6W \xb1\xc4");
	_LIT8(GB2312B, "\xd0\xc2\xce\xc5, \xd0\xa1\xcb\xb5\xa3\xac\xd4\xd3\xd6\xbe\xa3\xac\xb6\xc1\xd5\xdf\xa3\xac\xc2\xdb\xcc\xb3\xa3\xac\xce\xc4\xd5\xaa\xa3\xac\xb1\xa8\xd6\xbd\xa3\xac\xd0\xa6\xbb\xb0\xa3\xac\xcc\xe5\xd3\xfd\xa3\xac\xc7\xe9\xb8\xd0\xa3\xac\xc1\xf4\xd1\xa7\xa3\xac\xbf\xe1\xd5\xbe\xa3\xac");
	_LIT8(GB2312Dhalf, "romance.cgi>\xc1\xb5\xc1\xb5\xb7\xe7\xb3\xbe</A>");
	_LIT8(GB2312C,       "\xa1\xa1\xa1\xf1\xcd\xf5\xbb\xdb\xa3\xa8\xb1\xbe\xb1\xa8\xcc\xd8\xd4\xbc\xa3\xa9\xb1\xb1\xbe\xa9\xb1\xa8\xb5\xc0<p>\xa1\xa1\xa1\xa1\xc0\xfa\xbd\xec\xb0\xc2\xd4\xcb\xbb\xe1\xca\xd7");
//=========================================================================================
	TBuf8<512> source;

	source=KSJISPhrase;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KSJISPhrase\n"));
	else
		User::Leave(KErrGeneral);

	source=KBig5;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KBig5\n"));
	else
		User::Leave(KErrGeneral);

	source=KBig52;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KBig52\n"));
	else
		User::Leave(KErrGeneral);

	source=KEUP;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KEUP\n"));
	else
		User::Leave(KErrGeneral);

	source=KEUC2;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KEUC2\n"));
	else
		User::Leave(KErrGeneral);

	source=KSJIS;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KSJIS\n"));
	else
		User::Leave(KErrGeneral);

	source=KISO2022;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KISO2022\n"));
	else
		User::Leave(KErrGeneral);

	source=KISO2022JP;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("KISO2022JP\n"));
	else
		User::Leave(KErrGeneral);

	source=SJISNET;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("SJISNET\n"));
	else
		User::Leave(KErrGeneral);

	source=GB2312;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("GB2312\n"));
	else
		User::Leave(KErrGeneral);

	source=GB2312A;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("GB2312A\n"));
	else
		User::Leave(KErrGeneral);

	source=BIG5A;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("BIG5A\n"));
	else
		User::Leave(KErrGeneral);

	source=BIG5C;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("BIG5C\n"));
	else
		User::Leave(KErrGeneral);

	source=GB2312B;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("GB2312B\n"));
	else
		User::Leave(KErrGeneral);

	source=GB2312Dhalf;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("GB2312Dhalf\n"));
	else
		User::Leave(KErrGeneral);

	source=GB2312C;
	if(doComparisonL(source, aFs, aCnvCharacterSetConverter))
	test.Printf(_L("GB2312C\n"));
	else
		User::Leave(KErrGeneral);
	}
//=========================================================================================
