// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// This test requires Cone\Tef\TConeTestExe to be built first.\n
// This test is fully automated and performs the following tasks\n
// 1. Launches TConeTestExe.\n
// 2. Closes TConeTestExe.\n
// 3. Compares the standard results file with results file generated by TConeTestExe.\n
// 
//

/**
 @file
 @internalComponent - Internal Symbian test code
*/
#include <e32test.h>
#include <coemain.h>
#include <coecntrl.h>
#include <coeaui.h>
#include <e32keys.h>
#include <basched.h>
#include <apgtask.h>
#include <apacmdln.h>
#include <apgcli.h>
#include <apgwgnam.h>
#include <e32base.h>
#include <eikenv.h>
#include <ecom/ecom.h>

#include "TCone4StepExe.h"
//! Sample Executable Name used in TCone4 TestExe Step.\n
_LIT(KAppName, "TConeTestExe");
//! Executable launched in TCone4 TestExe Step.\n
_LIT(KAppFileName, "z:\\sys\\bin\\TConeTestExe.exe");


//! File which stores the results of TCone4Step .
_LIT(KConeTestResultsFileName, "c:\\system\\conetest\\ConeTestResultsFile2.txt");

//! File which contains the expected results which needs to be compared with the results 
//! generated form the test
_LIT(KConeTestStdFileName,"z:\\conetest\\ConeTestStdFile.txt");

 //!random error code
const TInt KErrFileContentNotMatched  = -421;
	
//! A CTestCoeAppUi derived class.\n
/**
  The class is the AppUi class for the TCone4Step test case.\n
*/
class CCone4ExeTestAppUi : public CTestCoeAppUi
    {
public:	// from CCoeAppUi
	//! Single Argument Constructor for CCone4ExeTestAppUi Class.\n
	CCone4ExeTestAppUi(CTmsTestStep* aStep) :
	CTestCoeAppUi(aStep){}
	~CCone4ExeTestAppUi();
	// from CCoeAppUi
	void ConstructL();
	void RunTestStepL(TInt aNumStep);

	void LoadAppL();
	void CompareConeTestFileL();
	TInt CloseApp();
    };
/**
  Second phase constructor for the CCone4ExeTestAppUi class.\n
  Invokes the base class CTestCoeAppUi ConstructL function.\n
  Starts the asynchronous execution of tests using Auto test manager.\n
*/    
void CCone4ExeTestAppUi::ConstructL()
	{
	CTestCoeAppUi::ConstructL();
	AutoTestManager().StartAutoTest();
	}

/**
  Destructor for CCone4ExeTestAppUi class.\n
*/
CCone4ExeTestAppUi::~CCone4ExeTestAppUi()
	{
	}
/**
  Auxilliary Function for all test cases.\n
  This function is iteratively called by the RunL function of the Autotestmanager
  asynchronously.\n
  Calls the following functions in succession\n
  1. LoadAppL()\n
  2. CloseApp()\n
  3. CompareConeTestFileL()\n
*/
void CCone4ExeTestAppUi::RunTestStepL(TInt aNumStep)
	{
	User::After(TTimeIntervalMicroSeconds32(2000000));
	switch(aNumStep)
		{	 
		case 1:		
			{
			SetTestStepID(_L("UIF-TCone4StepExe-LoadAppL"));			
			INFO_PRINTF1(_L("Loading TConeTestApp"));
			TRAPD(ret, LoadAppL());
			TEST(ret==KErrNone);
			RecordTestResultL();
			}
			break;
		case 2:
			SetTestStepID(_L("UIF-TCone4StepExe-CloseApp"));			
			INFO_PRINTF1(_L("Closing TConeTestApp"));
			TEST(CloseApp()==KErrNone);
			RecordTestResultL();			
			break;
		case 3:
			{
			SetTestStepID(_L("UIF-TCone4StepExe-CompareConeTestFileL"));			
			INFO_PRINTF1(_L("Comparing the results file with standard results file"));
			TRAPD(ret, CompareConeTestFileL());
			TEST(ret==KErrNone);
			RecordTestResultL();
			CloseTMSGraphicsStep();
			}
			break;
		case 4:
			AutoTestManager().FinishAllTestCases(CAutoTestManager::EPass);
			break;
		default:
			break;
		}
	}
	
/**
   @SYMTestCaseID UIF-TCone4StepExe-LoadAppL
  
   @SYMPREQ
  
   @SYMTestCaseDesc Launches the TConeTestApp application.\n
  
   @SYMTestPriority High
  
   @SYMTestStatus Implemented
   
   @SYMTestActions : Launches an test application as follows.\n
   Instantiates a CApaCommandLine object and sets the appName as the LibraryName.\n
   Sets the command to EApaCommandOpen.\n
   Opens a RApaLsSession.\n
   Sends a request to the apparc server to start the application.\n
  
   @SYMTestExpectedResults The application should be started without any error.\n
  
   @SYMTestType : CIT 
 */
void CCone4ExeTestAppUi::LoadAppL()
	{
	TBuf<256> fileNameBuf(KAppFileName());
	TFileName appName = fileNameBuf;

	CApaCommandLine* cmdLine=CApaCommandLine::NewLC();
	cmdLine->SetExecutableNameL(appName);
	cmdLine->SetCommandL(EApaCommandOpen);
	RApaLsSession ls;

	User::LeaveIfError(ls.Connect());
	CleanupClosePushL(ls);
	User::LeaveIfError(ls.StartApp(*cmdLine));
	CleanupStack::PopAndDestroy(2); // ls and cmdLine
	}


/**
   @SYMTestCaseID UIF-TCone4StepExe-CloseApp
  
   @SYMPREQ
  
   @SYMTestCaseDesc Closes the TConeTestApp application.\n
  
   @SYMTestPriority High
  
   @SYMTestStatus Implemented
   
   @SYMTestActions : Closes a test application as follows.\n
   Gets the currently running tasks list using TApaTaskList.\n
   Gets the current task using TApaTaskList::FindApp() \n
   Ends the application using TApaTaskList::EndTask().\n
  
   @SYMTestExpectedResults The application should be closed without any error.\n
  
   @SYMTestType : CIT 
 */

TInt CCone4ExeTestAppUi::CloseApp()
	{
	TApaTaskList taskList(CCoeEnv::Static()->WsSession());
	TApaTask task = taskList.FindApp(KAppName);
	task.EndTask();
	return KErrNone;
	}

/**
   @SYMTestCaseID UIF-TCone4StepExe-CompareConeTestFileL
  
   @SYMPREQ
  
   @SYMTestCaseDesc Tests standard results file with the generated results file.
  	
   @SYMTestPriority High
  
   @SYMTestStatus Implemented
   
   @SYMTestActions Reads in the standard result file and the one generated.
   
   @SYMTestExpectedResults. The test verifies that the files are the same.
  
   @SYMTestType : CIT  
 */
void CCone4ExeTestAppUi::CompareConeTestFileL()
	{
	RFs fs;
	RFile rFileResults;
	RFile rFileStd;

	User::LeaveIfError(fs.Connect());
	CleanupClosePushL( fs );
	
	User::LeaveIfError( rFileResults.Open(fs,KConeTestResultsFileName,EFileRead | EFileShareAny) );
	CleanupClosePushL( rFileResults );
	
	User::LeaveIfError( rFileStd.Open(fs,KConeTestStdFileName,EFileRead) );
	CleanupClosePushL( rFileStd );

	TBuf8<240> bufReadStd;
	TBuf8<240> bufReadResults;
	
	// Read from the results generated for the static object test
	User::LeaveIfError( rFileResults.Read(bufReadResults) );
	// Read from the standard file which contains the results that has to be generated 
	User::LeaveIfError( rFileStd.Read(bufReadStd) );
	
	CleanupStack::PopAndDestroy( 3, &fs );
	
	
	// Compare the generated results with the standard results
	if( (bufReadResults.Compare(bufReadStd)) != 0 )
		{
		TBuf<256> resultsWide;
		TBuf<256> stdWide;
		resultsWide.Copy( bufReadResults );
		stdWide.Copy( bufReadStd );
		
		ERR_PRINTF1( _L("Results files differ.") );	
		INFO_PRINTF2( _L("results descriptor length %d"), bufReadResults.Length() );
		ERR_PRINTF2( _L("Test results:-\n%S"), &resultsWide );
		ERR_PRINTF2( _L("Expected results:-\n%S"), &stdWide );
		
		User::Leave( KErrFileContentNotMatched );
		}
	}
/**
  Constructor for CTCone4StepExe class.\n
  Sets the test step name.\n
*/
CTCone4StepExe::CTCone4StepExe()
	{
	SetTestStepName(KTCone4StepExe);
	}
/**
  Destructor for CTCone4StepExe class.\n
*/
CTCone4StepExe::~CTCone4StepExe()
	{
	}
/**
  Completes the construction of the Control Environment(CCoeEnv object).\n
  Instantiates the CCone4TestAppUi class which serves as a AppUi class.\n
  Sets the CCone4ExeTestAppUi object as the application's user interface object.\n
  Invokes the second phase constructor of the application's UI.\n
*/
void CTCone4StepExe::ConstructAppL(CCoeEnv* aCoe)
	{ // runs inside a TRAP harness
	aCoe->ConstructL();
	CCone4ExeTestAppUi* appUi= new (ELeave) CCone4ExeTestAppUi(this);
	aCoe->SetAppUi(appUi);
	appUi->ConstructL();
	}
/**
  Entry function for CTCone4Exe Test Step.\n
  Sets up the control environment.\n
  Constructs and Launches the CTCone4 Test application.\n
*/
TVerdict CTCone4StepExe::doTestStepL() // main function called by E32
	{

	PreallocateHALBuffer();
	__UHEAP_MARK;

	CCoeEnv* coe=new(ELeave) CCoeEnv;
	TRAPD(err,ConstructAppL(coe));

	if (!err)
		coe->ExecuteD();
	else
		{
		SetTestStepResult(EFail);
		delete coe;
		}
	REComSession::FinalClose();	
	__UHEAP_MARKEND;
	
	INFO_PRINTF1(_L("Test Finished"));
	return TestStepResult();
	}
