/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
*
*/


// [INCLUDE FILES]
#include <e32svr.h>
#include <stifparser.h>
#include <stiftestinterface.h>

#include "testsdklists.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// Ctestsdklists::RunMethodL
// Run specified method. Contains also table of test mothods and their names.
// -----------------------------------------------------------------------------
//
TInt CTestSDKLists::RunMethodL( CStifItemParser& aItem ) 
    {
    static TStifFunctionInfo const KFunctions[] =
        {  
        // AknListBoxLayoutDecorator.h
        ENTRY( "TestLBLDNewL", CTestSDKLists::TestLBLDNewL ),
        ENTRY( "TestLBLDNewLC", CTestSDKLists::TestLBLDNewLC ),
        ENTRY( "TestLBLDDelete", CTestSDKLists::TestLBLDDelete ),
        ENTRY( "TestLBLDArray", CTestSDKLists::TestLBLDArrayL ),
        ENTRY( "TestLBLDSetArray", CTestSDKLists::TestLBLDSetArrayL ),
        ENTRY( "TestLBLDSetLeadingDecorationTextL",
                CTestSDKLists::TestLBLDSetLeadingDecorationTextL ),
        ENTRY( "TestLBLDSetTrailingDecorationTextL",
                CTestSDKLists::TestLBLDSetTrailingDecorationTextL ),
        ENTRY( "TestLBLDSetActive", CTestSDKLists::TestLBLDSetActive ),
        ENTRY( "TestLBLDMdcaCount", CTestSDKLists::TestLBLDMdcaCountL ),
        ENTRY( "TestLBLDMdcaPoint", CTestSDKLists::TestLBLDMdcaPointL ),

        // AknListBoxSettingPage.h
        ENTRY( "TestLBSPHandleListBoxEventL", CTestSDKLists::TestLBSPHandleListBoxEventL ),
        ENTRY( "TestLBSPCheckAndSetDataValidity",
                CTestSDKLists::TestLBSPCheckAndSetDataValidityL ),
        ENTRY( "TestLBSPUpdateCbaL", CTestSDKLists::TestLBSPUpdateCbaL ),
        ENTRY( "TestLBSPSizeChanged", CTestSDKLists::TestLBSPSizeChangedL ),
        ENTRY( "TestLBSPDraw", CTestSDKLists::TestLBSPDrawL ),

        // AknSelectionList.h
        // class CAknSelectionListDialog
        ENTRY( "TestSLDNewL", CTestSDKLists::TestSLDNewL ),
        ENTRY( "TestSLDNewLC", CTestSDKLists::TestSLDNewLC ),
        ENTRY( "TestSLDConstructL", CTestSDKLists::TestSLDConstructL ),
        ENTRY( "TestSLDSetupFind", CTestSDKLists::TestSLDSetupFindL ),
        ENTRY( "TestSLDIconArray", CTestSDKLists::TestSLDIconArrayL ),
        ENTRY( "TestSLDSetIconArrayL", CTestSDKLists::TestSLDSetIconArrayL ),
        ENTRY( "TestSLDHandlePointerEventL", CTestSDKLists::TestSLDHandlePointerEventL ),
        ENTRY( "Constructor", CTestSDKLists::TestSLDConstructorL ),
        ENTRY( "Destructor", CTestSDKLists::TestSLDDestructor ),
        ENTRY( "TestSLDSelectionListProcessCommandL",
                CTestSDKLists::TestSLDSelectionListProcessCommandL ),
        ENTRY( "TestSLDIsAcceptableListBoxType", 
                CTestSDKLists::TestSLDIsAcceptableListBoxType ),
        ENTRY( "TestSLDProcessCommandL", CTestSDKLists::TestSLDProcessCommandL ),
        ENTRY( "TestSLDPreLayoutDynInitL", CTestSDKLists::TestSLDPreLayoutDynInitL ),
        ENTRY( "TestSLDPostLayoutDynInitL", CTestSDKLists::TestSLDPostLayoutDynInitL ),
        ENTRY( "TestSLDSetSizeAndPosition", CTestSDKLists::TestSLDSetSizeAndPosition ),
        ENTRY( "TestSLDOkToExitL", CTestSDKLists::TestSLDOkToExitL ),
        ENTRY( "TestSLDHandleListBoxEventL", CTestSDKLists::TestSLDHandleListBoxEventL ),
        ENTRY( "TestSLDCountComponentControls",
                CTestSDKLists::TestSLDCountComponentControls ),
        ENTRY( "TestSLDComponentControl", CTestSDKLists::TestSLDComponentControl ),
        ENTRY( "TestSLDOfferKeyEventL", CTestSDKLists::TestSLDOfferKeyEventL ),
        ENTRY( "TestSLDCreateCustomControlL", CTestSDKLists::TestSLDCreateCustomControlL ),
        ENTRY( "TestSLDListBox", CTestSDKLists::TestSLDListBox ),
        ENTRY( "TestSLDFindBox", CTestSDKLists::TestSLDFindBox ),
        ENTRY( "TestSLDIsFormattedCellListBox",
                CTestSDKLists::TestSLDIsFormattedCellListBox ),
        ENTRY( "TestSLDDraw", CTestSDKLists::TestSLDDraw ),
        // class CAknMarkableListDialog
        ENTRY( "TestMLDNewL", CTestSDKLists::TestMLDNewL ),
        ENTRY( "TestMLDNewLC", CTestSDKLists::TestMLDNewLCL ),
        ENTRY( "TestMLDDeprecatedNewL", CTestSDKLists::TestMLDDeprecatedNewL ),
        ENTRY( "TestMLDDeprecatedNewLC", CTestSDKLists::TestMLDDeprecatedNewLCL ),
        ENTRY( "TestMLDConstructL", CTestSDKLists::TestMLDConstructL ),
        ENTRY( "TestMLDDestructor", CTestSDKLists::TestMLDDestructor ),
        ENTRY( "TestMLDHandlePointerEventL", CTestSDKLists::TestMLDHandlePointerEventL ),
        ENTRY( "TestMLDConstructorL", CTestSDKLists::TestMLDConstructorL ),
        ENTRY( "TestMLDDeprecatedConstructorL", CTestSDKLists::TestMLDDeprecatedConstructorL ),
        ENTRY( "TestMLDPreLayoutDynInitL", CTestSDKLists::TestMLDPreLayoutDynInitL ),
        ENTRY( "TestMLDPostLayoutDynInitL", CTestSDKLists::TestMLDPostLayoutDynInitL ),
        ENTRY( "TestMLDSelectionListProcessCommandL",
                CTestSDKLists::TestMLDSelectionListProcessCommandL ),
        ENTRY( "TestMLDProcessCommandL", CTestSDKLists::TestMLDProcessCommandL ),
        ENTRY( "TestMLDDynInitMenuPaneL", CTestSDKLists::TestMLDDynInitMenuPaneL ),
        ENTRY( "TestMLDHandleListBoxEventL", CTestSDKLists::TestMLDHandleListBoxEventL ),
        ENTRY( "TestMLDOfferKeyEventL", CTestSDKLists::TestMLDOfferKeyEventL ),
        ENTRY( "TestMLDOkToExitL", CTestSDKLists::TestMLDOkToExitL ),

        //EIKCLB.H
        // class CColumnListBoxItemDrawer
        ENTRY( "TestCLBIDConstructor", CTestSDKLists::TestCLBIDConstructorL ),
        ENTRY( "TestCLBIDConstructorWithParameterL",
                CTestSDKLists::TestCLBIDConstructorWithParameterL ),
        ENTRY( "TestCLBIDDestructor", CTestSDKLists::TestCLBIDDestructor ),
        ENTRY( "TestCLBIDColumnData", CTestSDKLists::TestCLBIDColumnData ),
        ENTRY( "TestCLBIDClearAllPropertiesL", CTestSDKLists::TestCLBIDClearAllPropertiesL ),
        ENTRY( "TestCLBIDSetPropertiesL", CTestSDKLists::TestCLBIDSetPropertiesL ),
        ENTRY( "TestCLBIDProperties", CTestSDKLists::TestCLBIDProperties ),
        ENTRY( "TestCLBIDDrawItemText", CTestSDKLists::TestCLBIDDrawItemTextL ),
        ENTRY( "TestCLBIDDrawItemMark", CTestSDKLists::TestCLBIDDrawItemMark ),
        ENTRY( "TestCLBIDMinimumCellSize", CTestSDKLists::TestCLBIDMinimumCellSize ),
        ENTRY( "TestCLBIDItemWidthInPixels", CTestSDKLists::TestCLBIDItemWidthInPixels ),
        ENTRY( "TestCLBIDSetItemCellSize", CTestSDKLists::TestCLBIDSetItemCellSize ),
        // class CEikColumnListBox
        ENTRY( "TestCLBConstructorL", CTestSDKLists::TestCLBConstructorL ),
        ENTRY( "TestCLBConstructFromResourceL", CTestSDKLists::TestCLBConstructFromResourceL ),
        ENTRY( "TestCLBConstructL", CTestSDKLists::TestCLBConstructL ),
        ENTRY( "TestCLBEditItemL", CTestSDKLists::TestCLBEditItemL ),
        ENTRY( "TestCLBModelL", CTestSDKLists::TestCLBModelL ),
        ENTRY( "TestCLBItemDrawerL", CTestSDKLists::TestCLBItemDrawerL ),
        ENTRY( "TestCLBEnableExtendedDrawingL", CTestSDKLists::TestCLBEnableExtendedDrawingL ),
        ENTRY( "TestCLBEnableStretchingL", CTestSDKLists::TestCLBEnableStretchingL ),
        ENTRY( "TestCLBMakeViewClassInstanceL", CTestSDKLists::TestCLBMakeViewClassInstanceL ),
        ENTRY( "TestCLBFocusChangedL", CTestSDKLists::TestCLBFocusChangedL ),
        ENTRY( "TestCLBGetColorUseListL", CTestSDKLists::TestCLBGetColorUseListL ),
        ENTRY( "TestCLBHandleResourceChangeL", CTestSDKLists::TestCLBHandleResourceChangeL ),
        ENTRY( "TestCLBMopSupplyObjectL", CTestSDKLists::TestCLBMopSupplyObjectL ),
        ENTRY( "TestCLBHandlePointerEventL", CTestSDKLists::TestCLBHandlePointerEventL ),
        ENTRY( "TestCLBCreateItemDrawerL", CTestSDKLists::TestCLBCreateItemDrawerL ),
        ENTRY( "TestCLBCreateModelL", CTestSDKLists::TestCLBCreateModelL ),
        //class CEikColumnListBoxEditor
        ENTRY( "TestCLBEConstructorL", CTestSDKLists::TestCLBEConstructorL ),
        ENTRY( "TestCLBEDestructorL", CTestSDKLists::TestCLBEDestructorL ),
        ENTRY( "TestCLBEConstructL", CTestSDKLists::TestCLBEConstructL ),
        ENTRY( "TestCLBEItemTextL", CTestSDKLists::TestCLBEItemTextL ),
        ENTRY( "TestCLBEUpdateModelL", CTestSDKLists::TestCLBEUpdateModelL ),
        ENTRY( "TestCLBEHandlePointerEventL", CTestSDKLists::TestCLBEHandlePointerEventL ),
        ENTRY( "TestCLBEColumnL", CTestSDKLists::TestCLBEColumnL ),
        // class CColumnListBoxView
        ENTRY( "TestCLBVDrawL", CTestSDKLists::TestCLBVDrawL ),
        ENTRY( "TestCLBVCalcBottomItemIndexL", CTestSDKLists::TestCLBVCalcBottomItemIndexL ),

        // EIKCLBD
        ENTRY( "TestCLBDTColors", CTestSDKLists::TestCLBDTColorsL ),
        ENTRY( "TestCLBDNewL", CTestSDKLists::TestCLBDNewL ),
        ENTRY( "TestCLBDDestructorL", CTestSDKLists::TestCLBDDestructorL ),
        ENTRY( "TestCLBDLastColumnL", CTestSDKLists::TestCLBDLastColumnL ),
        ENTRY( "TestCLBDColumnWidthPixelL", CTestSDKLists::TestCLBDColumnWidthPixelL ),
        ENTRY( "TestCLBDSetColumnWidthPixelL", CTestSDKLists::TestCLBDSetColumnWidthPixelL ),
        ENTRY( "TestCLBDColumnHorizontalGapL", CTestSDKLists::TestCLBDColumnHorizontalGapL ),
        ENTRY( "TestCLBDSetColumnHorizontalGapL",
                CTestSDKLists::TestCLBDSetColumnHorizontalGapL ),
        ENTRY( "TestCLBDColumnBaselinePosL", CTestSDKLists::TestCLBDColumnBaselinePosL ),
        ENTRY( "TestCLBDSetColumnBaselinePosL", CTestSDKLists::TestCLBDSetColumnBaselinePosL ),
        ENTRY( "TestCLBDColumnMarginsL", CTestSDKLists::TestCLBDColumnMarginsL ),
        ENTRY( "TestCLBDSetColumnMarginsL", CTestSDKLists::TestCLBDSetColumnMarginsL ),
        ENTRY( "TestCLBDColumnFontL", CTestSDKLists::TestCLBDColumnFontL ),
        ENTRY( "TestCLBDSetColumnFontL", CTestSDKLists::TestCLBDSetColumnFontL ),
        ENTRY( "TestCLBDColumnAlignmentL", CTestSDKLists::TestCLBDColumnAlignmentL ),
        ENTRY( "TestCLBDSetColumnAlignmentL", CTestSDKLists::TestCLBDSetColumnAlignmentL ),
        ENTRY( "TestCLBDColumnSeparatorStyleL", CTestSDKLists::TestCLBDColumnSeparatorStyleL ),
        ENTRY( "TestCLBDSetColumnSeparatorStyleL",
                CTestSDKLists::TestCLBDSetColumnSeparatorStyleL ),
        ENTRY( "TestCLBDColumnIsOptionalL", CTestSDKLists::TestCLBDColumnIsOptionalL ),
        ENTRY( "TestCLBDSetOptionalColumnL", CTestSDKLists::TestCLBDSetOptionalColumnL ),
        ENTRY( "TestCLBDColumnIsGraphicsL", CTestSDKLists::TestCLBDColumnIsGraphicsL ),
        ENTRY( "TestCLBDSetGraphicsColumnL", CTestSDKLists::TestCLBDSetGraphicsColumnL ),
        ENTRY( "TestCLBDColumnIsNumberL", CTestSDKLists::TestCLBDColumnIsNumberL ),
        ENTRY( "TestCLBDSetNumberColumnL", CTestSDKLists::TestCLBDSetNumberColumnL ),
        ENTRY( "TestCLBDIconArrayL", CTestSDKLists::TestCLBDIconArrayL ),
        ENTRY( "TestCLBDSetIconArrayL", CTestSDKLists::TestCLBDSetIconArrayL ),
        ENTRY( "TestCLBDColumnTextClipGapL", CTestSDKLists::TestCLBDColumnTextClipGapL ),
        ENTRY( "TestCLBDSetColumnTextClipGapL", CTestSDKLists::TestCLBDSetColumnTextClipGapL ),
        ENTRY( "TestCLBDFontL", CTestSDKLists::TestCLBDFontL ),
        ENTRY( "TestCLBDMakeColumnRectL", CTestSDKLists::TestCLBDMakeColumnRectL ),
        ENTRY( "TestCLBDDrawL", CTestSDKLists::TestCLBDDrawL ),
        ENTRY( "TestCLBDSetSeparatorLinePositionL",
                CTestSDKLists::TestCLBDSetSeparatorLinePositionL ),
        ENTRY( "TestCLBDSeparatorLinePositionL", CTestSDKLists::TestCLBDSeparatorLinePositionL ),
        ENTRY( "TestCLBDLayoutDataL", CTestSDKLists::TestCLBDLayoutDataL ),
        ENTRY( "TestCLBDLayoutInitL", CTestSDKLists::TestCLBDLayoutInitL ),
        ENTRY( "TestCLBDSetLayoutInitL", CTestSDKLists::TestCLBDSetLayoutInitL ),
        ENTRY( "TestCLBDSetColumnUnderlinedL", CTestSDKLists::TestCLBDSetColumnUnderlinedL ),
        ENTRY( "TestCLBDControlL", CTestSDKLists::TestCLBDControlL ),
        ENTRY( "TestCLBDSetControlL", CTestSDKLists::TestCLBDSetControlL ),
        ENTRY( "TestCLBDSkinBackgroundContextL", CTestSDKLists::TestCLBDSkinBackgroundContextL ),
        ENTRY( "TestCLBDSetSkinStyleL", CTestSDKLists::TestCLBDSetSkinStyleL ),
        ENTRY( "TestCLBDSetListEndSkinStyleL", CTestSDKLists::TestCLBDSetListEndSkinStyleL ),
        ENTRY( "TestCLBDSetSkinHighlightFrameL", CTestSDKLists::TestCLBDSetSkinHighlightFrameL ),
        ENTRY( "TestCLBDSetSkinEnabledL", CTestSDKLists::TestCLBDSetSkinEnabledL ),
        ENTRY( "TestCLBDEnableMarqueeL", CTestSDKLists::TestCLBDEnableMarqueeL ),
        ENTRY( "TestCLBDSetColumnFontForRowL", CTestSDKLists::TestCLBDSetColumnFontForRowL ),
        ENTRY( "TestCLBDRowAndColumnFontL", CTestSDKLists::TestCLBDRowAndColumnFontL ),
        ENTRY( "TestCLBDSetSubCellIconSizeL", CTestSDKLists::TestCLBDSetSubCellIconSizeL ),
        ENTRY( "TestCLBDHighlightAnimL", CTestSDKLists::TestCLBDHighlightAnimL ),
        ENTRY( "TestCLBDAboutToDrawHighlightAnimL",
                CTestSDKLists::TestCLBDAboutToDrawHighlightAnimL ),
        ENTRY( "TestCLBDSetHighlightAnimBackgroundDrawerL",
                CTestSDKLists::TestCLBDSetHighlightAnimBackgroundDrawerL ),
        ENTRY( "TestCLBDSetItemCellSizeL", CTestSDKLists::TestCLBDSetItemCellSizeL ),
        ENTRY( "TestCLBDHasHighlightAnimL", CTestSDKLists::TestCLBDHasHighlightAnimL ),
        ENTRY( "TestCLBDDrawHighlightAnimL", CTestSDKLists::TestCLBDDrawHighlightAnimL ),
        ENTRY( "TestCLBDSetGraphicSubCellL", CTestSDKLists::TestCLBDSetGraphicSubCellL ),
        ENTRY( "TestCLBDSetTextSubCellL", CTestSDKLists::TestCLBDSetTextSubCellL ),
        ENTRY( "TestCLBDSetConditionalSubCellL", CTestSDKLists::TestCLBDSetConditionalSubCellL ),
        ENTRY( "TestCLBDSubCellsMightIntersectL", 
                CTestSDKLists::TestCLBDSubCellsMightIntersectL ),
        ENTRY( "TestCLBDSetStretchableGraphicSubCellL",
                CTestSDKLists::TestCLBDSetStretchableGraphicSubCellL ),
        ENTRY( "TestCLBDResetSLSubCellArrayL", CTestSDKLists::TestCLBDResetSLSubCellArrayL ),
        ENTRY( "TestCLBDStretchingEnabledL", CTestSDKLists::TestCLBDStretchingEnabledL ),
        ENTRY( "TestCLBDSetMarqueeParamsL", CTestSDKLists::TestCLBDSetMarqueeParamsL ),
        ENTRY( "TestCLBDSetMarqueeParamsWithIntervalL",
                CTestSDKLists::TestCLBDSetMarqueeParamsWithIntervalL ),
        ENTRY( "TestCLBDCurrentItemTextWasClippedL",
                CTestSDKLists::TestCLBDCurrentItemTextWasClippedL ),
        ENTRY( "TestCLBDSetStretchableTextSubCellL",
                CTestSDKLists::TestCLBDSetStretchableTextSubCellL ),
        ENTRY( "TestCLBDSetStretchableConditionalSubCellL",
                CTestSDKLists::TestCLBDSetStretchableConditionalSubCellL ),
        ENTRY( "TestCLBDConstructorL", CTestSDKLists::TestCLBDConstructorL ),
        ENTRY( "TestCLBDConstructLDL", CTestSDKLists::TestCLBDConstructLDL ),
        ENTRY( "TestCLBDConstructLDWithParaL", CTestSDKLists::TestCLBDConstructLDWithParaL ),
        ENTRY( "TestCLBDDrawTextL", CTestSDKLists::TestCLBDDrawTextL ),

        // eikfrlb.h
        // class CFormattedCellListBoxItemDrawer
        ENTRY( "TestFCLBIDConstructorL", CTestSDKLists::TestFCLBIDConstructorL ),
        ENTRY( "TestFCLBIDDestructor", CTestSDKLists::TestFCLBIDDestructorL ),
        ENTRY( "TestFCLBIDFormattedCellData", CTestSDKLists::TestFCLBIDFormattedCellDataL ),
        ENTRY( "TestFCLBIDColumnData", CTestSDKLists::TestFCLBIDColumnDataL ),
        ENTRY( "TestFCLBIDDrawEmptyItem", CTestSDKLists::TestFCLBIDDrawEmptyItemL ),
        ENTRY( "TestFCLBIDSetTopItemIndex", CTestSDKLists::TestFCLBIDSetTopItemIndexL ),
        ENTRY( "TestFCLBIDClearAllPropertiesL", CTestSDKLists::TestFCLBIDClearAllPropertiesL ),
        ENTRY( "TestFCLBIDSetPropertiesL", CTestSDKLists::TestFCLBIDSetPropertiesL ),
        ENTRY( "TestFCLBIDPropertiesL", CTestSDKLists::TestFCLBIDPropertiesL ),
        ENTRY( "TestFCLBIDDrawItemTextL", CTestSDKLists::TestFCLBIDDrawItemTextL ),
        ENTRY( "TestFCLBIDDrawItemMarkL", CTestSDKLists::TestFCLBIDDrawItemMarkL ),
        ENTRY( "TestFCLBIDMinimumCellSizeL", CTestSDKLists::TestFCLBIDMinimumCellSizeL ),
        ENTRY( "TestFCLBIDItemWidthInPixelsL", CTestSDKLists::TestFCLBIDItemWidthInPixelsL ),
        ENTRY( "TestFCLBIDSetItemCellSizeL", CTestSDKLists::TestFCLBIDSetItemCellSizeL ),
        // class CFormattedCellListBoxData
        ENTRY( "TestFCLBConstructorL", CTestSDKLists::TestFCLBConstructorL ),
        ENTRY( "TestFCLBConstructFromResourceL", CTestSDKLists::TestFCLBConstructFromResourceL ),
        ENTRY( "TestFCLBConstructL", CTestSDKLists::TestFCLBConstructL ),
        ENTRY( "TestFCLBModelL", CTestSDKLists::TestFCLBModelL ),
        ENTRY( "TestFCLBItemDrawerL", CTestSDKLists::TestFCLBItemDrawerL ),
        ENTRY( "TestFCLBUseLogicalToVisualConversionL",
                CTestSDKLists::TestFCLBUseLogicalToVisualConversionL ),
        ENTRY( "TestFCLBEnableExtendedDrawingL", CTestSDKLists::TestFCLBEnableExtendedDrawingL ),
        ENTRY( "TestFCLBEnableStretchingL", CTestSDKLists::TestFCLBEnableStretchingL ),
        ENTRY( "TestFCLBHideSecondRowL", CTestSDKLists::TestFCLBHideSecondRowL ),
        ENTRY( "TestFCLBMakeViewClassInstanceL", CTestSDKLists::TestFCLBMakeViewClassInstanceL ),
        ENTRY( "TestFCLBFocusChangedL", CTestSDKLists::TestFCLBFocusChangedL ),
        ENTRY( "TestFCLBGetColorUseListL", CTestSDKLists::TestFCLBGetColorUseListL ),
        ENTRY( "TestFCLBHandleResourceChangeL", CTestSDKLists::TestFCLBHandleResourceChangeL ),
        ENTRY( "TestFCLBHandlePointerEventL", CTestSDKLists::TestFCLBHandlePointerEventL ),
        ENTRY( "TestFCLBCreateItemDrawerL", CTestSDKLists::TestFCLBCreateItemDrawerL ),
        ENTRY( "TestFCLBAdjustRectHeightToWholeNumberOfItemsL",
                CTestSDKLists::TestFCLBAdjustRectHeightToWholeNumberOfItemsL ),
        ENTRY( "TestFCLBMopSupplyObjectL", CTestSDKLists::TestFCLBMopSupplyObjectL ),
        // class CFormattedCellListBoxData
        ENTRY( "TestFCLBVDrawL", CTestSDKLists::TestFCLBVDrawL ),
        ENTRY( "TestFCLBVDrawEmptyListL", CTestSDKLists::TestFCLBVDrawEmptyListL ),
        ENTRY( "TestFCLBVCalcBottomItemIndexL", CTestSDKLists::TestFCLBVCalcBottomItemIndexL ),

        // eikfrlbd.h
        ENTRY( "TestFCLBDTColorsL", CTestSDKLists::TestFCLBDTColorsL ),
        ENTRY( "TestFCLBDNewL", CTestSDKLists::TestFCLBDNewL ),
        ENTRY( "TestFCLBDDestructorL", CTestSDKLists::TestFCLBDDestructorL ),
        ENTRY( "TestFCLBDSubCellColorsL", CTestSDKLists::TestFCLBDSubCellColorsL ),
        ENTRY( "TestFCLBDSetSubCellColorsL", CTestSDKLists::TestFCLBDSetSubCellColorsL ),
        ENTRY( "TestFCLBDSubCellBaselinePosL", CTestSDKLists::TestFCLBDSubCellBaselinePosL ),
        ENTRY( "TestFCLBDSetSubCellBaselinePosL", CTestSDKLists::TestFCLBDSetSubCellBaselinePosL ),
        ENTRY( "TestFCLBDSubCellSizeL", CTestSDKLists::TestFCLBDSubCellSizeL ),
        ENTRY( "TestFCLBDSetSubCellSizeL", CTestSDKLists::TestFCLBDSetSubCellSizeL ),
        ENTRY( "TestFCLBDSubCellPositionL", CTestSDKLists::TestFCLBDSubCellPositionL ),
        ENTRY( "TestFCLBDSetSubCellPositionL", CTestSDKLists::TestFCLBDSetSubCellPositionL ),
        ENTRY( "TestFCLBDSubCellIsTransparentL", CTestSDKLists::TestFCLBDSubCellIsTransparentL ),
        ENTRY( "TestFCLBDSetTransparentSubCellL", CTestSDKLists::TestFCLBDSetTransparentSubCellL ),
        ENTRY( "TestFCLBDSubCellIsNotAlwaysDrawnL",
                CTestSDKLists::TestFCLBDSubCellIsNotAlwaysDrawnL ),
        ENTRY( "TestFCLBDSetNotAlwaysDrawnSubCellL",
                CTestSDKLists::TestFCLBDSetNotAlwaysDrawnSubCellL ),
        ENTRY( "TestFCLBDSubCellMarginsL", CTestSDKLists::TestFCLBDSubCellMarginsL ),
        ENTRY( "TestFCLBDSetSubCellMarginsL", CTestSDKLists::TestFCLBDSetSubCellMarginsL ),
        ENTRY( "TestFCLBDSubCellFontL", CTestSDKLists::TestFCLBDSubCellFontL ),
        ENTRY( "TestFCLBDSetSubCellFontL", CTestSDKLists::TestFCLBDSetSubCellFontL ),
        ENTRY( "TestFCLBDSubCellAlignmentL", CTestSDKLists::TestFCLBDSubCellAlignmentL ),
        ENTRY( "TestFCLBDSetSubCellAlignmentL", CTestSDKLists::TestFCLBDSetSubCellAlignmentL ),
        ENTRY( "TestFCLBDSubCellIsGraphicsL", CTestSDKLists::TestFCLBDSubCellIsGraphicsL ),
        ENTRY( "TestFCLBDSetGraphicsSubCellL", CTestSDKLists::TestFCLBDSetGraphicsSubCellL ),
        ENTRY( "TestFCLBDSubCellRightSeparatorStyleL",
                CTestSDKLists::TestFCLBDSubCellRightSeparatorStyleL ),
        ENTRY( "TestFCLBDSetSubCellRightSeparatorStyleL",
                CTestSDKLists::TestFCLBDSetSubCellRightSeparatorStyleL ),
        ENTRY( "TestFCLBDSubCellTextClipGapL", CTestSDKLists::TestFCLBDSubCellTextClipGapL ),
        ENTRY( "TestFCLBDSetSubCellTextClipGapL", CTestSDKLists::TestFCLBDSetSubCellTextClipGapL ),
        ENTRY( "TestFCLBDSkinEnabledL", CTestSDKLists::TestFCLBDSkinEnabledL ),
        ENTRY( "TestFCLBDSetSkinEnabledL", CTestSDKLists::TestFCLBDSetSkinEnabledL ),
        ENTRY( "TestFCLBDSubCellIsNumberCellL", CTestSDKLists::TestFCLBDSubCellIsNumberCellL ),
        ENTRY( "TestFCLBDSetNumberCellL", CTestSDKLists::TestFCLBDSetNumberCellL ),
        ENTRY( "TestFCLBDIconArrayL", CTestSDKLists::TestFCLBDIconArrayL ),
        ENTRY( "TestFCLBDSetIconArrayLL", CTestSDKLists::TestFCLBDSetIconArrayLL ),
        ENTRY( "TestFCLBDSetIconArrayL", CTestSDKLists::TestFCLBDSetIconArrayL ),
        ENTRY( "TestFCLBDFontL", CTestSDKLists::TestFCLBDFontL ),
        ENTRY( "TestFCLBDDrawL", CTestSDKLists::TestFCLBDDrawL ),
        ENTRY( "TestFCLBDUseSubCellColorsL", CTestSDKLists::TestFCLBDUseSubCellColorsL ),
        ENTRY( "TestFCLBDControlL", CTestSDKLists::TestFCLBDControlL ),
        ENTRY( "TestFCLBDSetControlL", CTestSDKLists::TestFCLBDSetControlL ),
        ENTRY( "TestFCLBDSkinBackgroundContextL", CTestSDKLists::TestFCLBDSkinBackgroundContextL ),
        ENTRY( "TestFCLBDSetBackgroundSkinStyleL", CTestSDKLists::TestFCLBDSetBackgroundSkinStyleL ),
        ENTRY( "TestFCLBDSetSkinStyleL", CTestSDKLists::TestFCLBDSetSkinStyleL ),
        ENTRY( "TestFCLBDSetSkinParentPosL", CTestSDKLists::TestFCLBDSetSkinParentPosL ),
        ENTRY( "TestFCLBDSetListEndSkinStyleL", CTestSDKLists::TestFCLBDSetListEndSkinStyleL ),
        ENTRY( "TestFCLBDRespectFocusL", CTestSDKLists::TestFCLBDRespectFocusL ),
        ENTRY( "TestFCLBDSetRespectFocusL", CTestSDKLists::TestFCLBDSetRespectFocusL ),
        ENTRY( "TestFCLBDSetSkinHighlightFrameL", CTestSDKLists::TestFCLBDSetSkinHighlightFrameL ),
        ENTRY( "TestFCLBDSetSkinPopupFrameL", CTestSDKLists::TestFCLBDSetSkinPopupFrameL ),
        ENTRY( "TestFCLBDSetSkinPopupFramePositionL",
                CTestSDKLists::TestFCLBDSetSkinPopupFramePositionL ),
        ENTRY( "TestFCLBDUseLogicalToVisualConversionL",
                CTestSDKLists::TestFCLBDUseLogicalToVisualConversionL ),
        ENTRY( "TestFCLBDEnableMarqueeL", CTestSDKLists::TestFCLBDEnableMarqueeL ),
        ENTRY( "TestFCLBDIsMarqueeOnL", CTestSDKLists::TestFCLBDIsMarqueeOnL ),
        ENTRY( "TestFCLBDHighlightAnimL", CTestSDKLists::TestFCLBDHighlightAnimL ),
        ENTRY( "TestFCLBDAboutToDrawHighlightAnimL",
                CTestSDKLists::TestFCLBDAboutToDrawHighlightAnimL ),
        ENTRY( "TestFCLBDSetHighlightAnimBackgroundDrawerL",
                CTestSDKLists::TestFCLBDSetHighlightAnimBackgroundDrawerL ),
        ENTRY( "TestFCLBDSetItemCellSizeL", CTestSDKLists::TestFCLBDSetItemCellSizeL ),
        ENTRY( "TestFCLBDHasHighlightAnimL", CTestSDKLists::TestFCLBDHasHighlightAnimL ),
        ENTRY( "TestFCLBDDrawHighlightAnimL", CTestSDKLists::TestFCLBDDrawHighlightAnimL ),
        ENTRY( "TestFCLBDSetSubCellFontForRowL", CTestSDKLists::TestFCLBDSetSubCellFontForRowL ),
        ENTRY( "TestFCLBDRowAndSubCellFontL", CTestSDKLists::TestFCLBDRowAndSubCellFontL ),
        ENTRY( "TestFCLBDSetDrawBackgroundL", CTestSDKLists::TestFCLBDSetDrawBackgroundL ),
        ENTRY( "TestFCLBDSetSeparatorLinePositionL", CTestSDKLists::TestFCLBDSetSeparatorLinePositionL ),
        ENTRY( "TestFCLBDSeparatorLinePositionL", CTestSDKLists::TestFCLBDSeparatorLinePositionL ),
        ENTRY( "TestFCLBDLayoutDataL", CTestSDKLists::TestFCLBDLayoutDataL ),
        ENTRY( "TestFCLBDLayoutInitL", CTestSDKLists::TestFCLBDLayoutInitL ),
        ENTRY( "TestFCLBDSetLayoutInitL", CTestSDKLists::TestFCLBDSetLayoutInitL ),
        ENTRY( "TestFCLBDSetSubcellUnderlinedL", CTestSDKLists::TestFCLBDSetSubcellUnderlinedL ),
        ENTRY( "TestFCLBDSetMarqueeParamsL", CTestSDKLists::TestFCLBDSetMarqueeParamsL ),
        ENTRY( "TestFCLBDCurrentItemTextWasClippedL",
                CTestSDKLists::TestFCLBDCurrentItemTextWasClippedL ),
        ENTRY( "TestFCLBDSetSubCellIconSizeL", CTestSDKLists::TestFCLBDSetSubCellIconSizeL ),
        ENTRY( "TestFCLBDConstructorL", CTestSDKLists::TestFCLBDConstructorL ),
        ENTRY( "TestFCLBDConstructLDL", CTestSDKLists::TestFCLBDConstructLDL ),
        ENTRY( "TestFCLBDConstructLDWithParaL", CTestSDKLists::TestFCLBDConstructLDWithParaL ),
        ENTRY( "TestFCLBDDrawFormattedL", CTestSDKLists::TestFCLBDDrawFormattedL ),
        ENTRY( "TestSIELBDNewL", CTestSDKLists::TestSIELBDNewL ),
        ENTRY( "TestSIELBDDrawL", CTestSDKLists::TestSIELBDDrawL ),
        ENTRY( "TestFGLBDNewL", CTestSDKLists::TestFGLBDNewL ),
        ENTRY( "TestFGLBDDrawL", CTestSDKLists::TestFGLBDDrawL ),
        ENTRY( "TestPFLBDNewL", CTestSDKLists::TestPFLBDNewL ),
        ENTRY( "TestPFLBDDrawL", CTestSDKLists::TestPFLBDDrawL ),
        ENTRY( "TestFCGDNewL", CTestSDKLists::TestFCGDNewL ),
        ENTRY( "TestFCGDDrawL", CTestSDKLists::TestFCGDDrawL ),
        
        // eiklbd.h
        // class TListFontBoundValues
        ENTRY( "TestLFBVConstructorL", CTestSDKLists::TestLFBVConstructorL ),
        // class CListBoxData
        ENTRY( "TestLBDConstructor", CTestSDKLists::TestLBDConstructorL ),
        ENTRY( "TestLBDDestructor", CTestSDKLists::TestLBDDestructor ),
        ENTRY( "TestLBDConstructL", CTestSDKLists::TestLBDConstructL ),
        ENTRY( "TestLBDFont", CTestSDKLists::TestLBDFont ),
        ENTRY( "TestLBDSetupGc", CTestSDKLists::TestLBDSetupGc ),
        ENTRY( "TestLBDFontBoundValues", CTestSDKLists::TestLBDFontBoundValues ),
        ENTRY( "TestLBDSetFontHeight", CTestSDKLists::TestLBDSetFontHeight ),
        ENTRY( "TestLBDSetSearchStringL", CTestSDKLists::TestLBDSetSearchStringL ),
        ENTRY( "TestLBDIsSearchString", CTestSDKLists::TestLBDIsSearchStringL ),
        ENTRY( "TestLBDDrawItem", CTestSDKLists::TestLBDDrawItemL ),
        ENTRY( "TestLBDSetAlignmentL", CTestSDKLists::TestLBDSetAlignmentL ),
        ENTRY( "TestLBDAlignmentL", CTestSDKLists::TestLBDAlignmentL ),
        ENTRY( "TestLBDSkinBackgroundControlContext",
                CTestSDKLists::TestLBDSkinBackgroundControlContext ),
        ENTRY( "TestLBDSetSkinBackgroundControlContextL",
                CTestSDKLists::TestLBDSetSkinBackgroundControlContextL ),
        ENTRY( "TestLBDSetSkinEnabledL", CTestSDKLists::TestLBDSetSkinEnabledL ),
        ENTRY( "TestLBDConstructFontL", CTestSDKLists::TestLBDConstructFontL ),
        ENTRY( "TestLBDUpdateFontBoundValuesL",
                CTestSDKLists::TestLBDUpdateFontBoundValuesL ),
        ENTRY( "TestLBDRegenerateFontsL", CTestSDKLists::TestLBDRegenerateFontsL ),
        ENTRY( "TestLBDFWSReleaseFontsL", CTestSDKLists::TestLBDFWSReleaseFontsL ),
        ENTRY( "TestLBDFWSFontStyleL", CTestSDKLists::TestLBDFWSFontStyleL ),
        ENTRY( "TestLBDFWSSetFontStyleL", CTestSDKLists::TestLBDFWSSetFontStyleL ),

        // eiklbed.h
        ENTRY( "TestLBTEConstructorL", CTestSDKLists::TestLBTEConstructorL ),
        ENTRY( "TestLBTEDestructorL", CTestSDKLists::TestLBTEDestructorL ),
        ENTRY( "TestLBTESetFontL", CTestSDKLists::TestLBTESetFontL ),
        ENTRY( "TestLBTEEditorL", CTestSDKLists::TestLBTEEditorL ),
        ENTRY( "TestLBTESetListBoxEditorObserverL",
                CTestSDKLists::TestLBTESetListBoxEditorObserverL ),
        ENTRY( "TestLBTEItemTextL", CTestSDKLists::TestLBTEItemTextL ),
        ENTRY( "TestLBTEStartEditingL", CTestSDKLists::TestLBTEStartEditingL ),
        ENTRY( "TestLBTEStopEditingL", CTestSDKLists::TestLBTEStopEditingL ),
        ENTRY( "TestLBTEUpdateModelL", CTestSDKLists::TestLBTEUpdateModelL ),
        ENTRY( "TestLBTEOfferKeyEventL", CTestSDKLists::TestLBTEOfferKeyEventL ),
        ENTRY( "TestLBTEHandlePointerEventL", CTestSDKLists::TestLBTEHandlePointerEventL ),
        ENTRY( "TestLBTEReleaseL", CTestSDKLists::TestLBTEReleaseL ),
        ENTRY( "TestLBTEListBoxModelL", CTestSDKLists::TestLBTEListBoxModelL ),
        ENTRY( "TestLBTEItemIndexL", CTestSDKLists::TestLBTEItemIndexL ),
        ENTRY( "TestLBTEWriteInternalStateL", CTestSDKLists::TestLBTEWriteInternalStateL ),

        // eiklbi.h
        // class CListItemDrawer
        ENTRY( "TestLIDDrawItemL", CTestSDKLists::TestLIDDrawItemL ),
        ENTRY( "TestLIDClearRectL", CTestSDKLists::TestLIDClearRectL ),
        ENTRY( "TestLIDItemWidthInPixelsL", CTestSDKLists::TestLIDItemWidthInPixelsL ),
        ENTRY( "TestLIDMinimumCellSizeL", CTestSDKLists::TestLIDMinimumCellSizeL ),
        ENTRY( "TestLIDSetGcL", CTestSDKLists::TestLIDSetGcL ),
        ENTRY( "TestLIDGcL", CTestSDKLists::TestLIDGcL ),
        ENTRY( "TestLIDSetMarkColumnWidthL", CTestSDKLists::TestLIDSetMarkColumnWidthL ),
        ENTRY( "TestLIDSetMarkGutterL", CTestSDKLists::TestLIDSetMarkGutterL ),
        ENTRY( "TestLIDMarkColumnL", CTestSDKLists::TestLIDMarkColumnL ),
        ENTRY( "TestLIDMarkGutterL", CTestSDKLists::TestLIDMarkGutterL ),
        ENTRY( "TestLIDSetItemCellSizeL", CTestSDKLists::TestLIDSetItemCellSizeL ),
        ENTRY( "TestLIDItemCellSizeL", CTestSDKLists::TestLIDItemCellSizeL ),
        ENTRY( "TestLIDSetViewRectL", CTestSDKLists::TestLIDSetViewRectL ),
        ENTRY( "TestLIDSetDrawMarkL", CTestSDKLists::TestLIDSetDrawMarkL ),
        ENTRY( "TestLIDMatcherCursorRectL", CTestSDKLists::TestLIDMatcherCursorRectL ),
        ENTRY( "TestLIDMatcherCursorAscentL", CTestSDKLists::TestLIDMatcherCursorAscentL ),
        ENTRY( "TestLIDDrawItemMarkL", CTestSDKLists::TestLIDDrawItemMarkL ),
        ENTRY( "TestLIDSetSymbolFontL", CTestSDKLists::TestLIDSetSymbolFontL ),
        ENTRY( "TestLIDSetVerticalInterItemGapL", CTestSDKLists::TestLIDSetVerticalInterItemGapL ),
        ENTRY( "TestLIDSetDataL", CTestSDKLists::TestLIDSetDataL ),
        ENTRY( "TestLIDFontL", CTestSDKLists::TestLIDFontL ),
        ENTRY( "TestLIDPropertiesL", CTestSDKLists::TestLIDPropertiesL ),
        ENTRY( "TestLIDDrawFrameL", CTestSDKLists::TestLIDDrawFrameL ),
        ENTRY( "TestLIDSetTextColorL", CTestSDKLists::TestLIDSetTextColorL ),
        ENTRY( "TestLIDSetBackColorL", CTestSDKLists::TestLIDSetBackColorL ),
        ENTRY( "TestLIDSetHighlightedTextColorL", CTestSDKLists::TestLIDSetHighlightedTextColorL ),
        ENTRY( "TestLIDSetHighlightedBackColorL", CTestSDKLists::TestLIDSetHighlightedBackColorL ),
        ENTRY( "TestLIDSetDimmedTextColorL", CTestSDKLists::TestLIDSetDimmedTextColorL ),
        ENTRY( "TestLIDSetDimmedBackColorL", CTestSDKLists::TestLIDSetDimmedBackColorL ),
        ENTRY( "TestLIDTextColorL", CTestSDKLists::TestLIDTextColorL ),
        ENTRY( "TestLIDBackColorL", CTestSDKLists::TestLIDBackColorL ),
        ENTRY( "TestLIDHighlightedTextColorL", CTestSDKLists::TestLIDHighlightedTextColorL ),
        ENTRY( "TestLIDHighlightedBackColorL", CTestSDKLists::TestLIDHighlightedBackColorL ),
        ENTRY( "TestLIDDimmedTextColorL", CTestSDKLists::TestLIDDimmedTextColorL ),
        ENTRY( "TestLIDDimmedBackColorL", CTestSDKLists::TestLIDDimmedBackColorL ),
        ENTRY( "TestLIDFlagsL", CTestSDKLists::TestLIDFlagsL ),
        ENTRY( "TestLIDSetFlagsL", CTestSDKLists::TestLIDSetFlagsL ),
        ENTRY( "TestLIDClearFlagsL", CTestSDKLists::TestLIDClearFlagsL ),
        ENTRY( "TestLIDSkinBackgroundControlContextL",
                CTestSDKLists::TestLIDSkinBackgroundControlContextL ),
        ENTRY( "TestLIDSetSkinEnabledL", CTestSDKLists::TestLIDSetSkinEnabledL ),
        ENTRY( "TestLIDConstructorL", CTestSDKLists::TestLIDConstructorL ),
        ENTRY( "TestLIDDestructorL", CTestSDKLists::TestLIDDestructorL ),
        ENTRY( "TestLIDResetGcL", CTestSDKLists::TestLIDResetGcL ),
        ENTRY( "TestLIDMarkColorL", CTestSDKLists::TestLIDMarkColorL ),
        ENTRY( "TestLIDVerticalInterItemGapL", CTestSDKLists::TestLIDVerticalInterItemGapL ),
        ENTRY( "TestLIDSetupGcL", CTestSDKLists::TestLIDSetupGcL ),
        // class CTextListItemDrawer
        ENTRY( "TestTLIDConstructor", CTestSDKLists::TestTLIDConstructorL ),
        ENTRY( "TestTLIDDestructor", CTestSDKLists::TestTLIDDestructor ),
        ENTRY( "TestTLIDConstructorWithParaL", CTestSDKLists::TestTLIDConstructorWithParaL ),
        ENTRY( "TestTLIDConstructL", CTestSDKLists::TestTLIDConstructL ),
        ENTRY( "TestTLIDDrawActualItem", CTestSDKLists::TestTLIDDrawActualItem ),
        ENTRY( "TestTLIDItemWidthInPixels", CTestSDKLists::TestTLIDItemWidthInPixels ),
        ENTRY( "TestTLIDMinimumCellSize", CTestSDKLists::TestTLIDMinimumCellSize ),
        ENTRY( "TestTLIDSetGc", CTestSDKLists::TestTLIDSetGc ),
        ENTRY( "TestTLIDSetCellWidthInChars", CTestSDKLists::TestTLIDSetCellWidthInChars ),
        ENTRY( "TestTLIDMatcherCursorRect", CTestSDKLists::TestTLIDMatcherCursorRect ),
        ENTRY( "TestTLIDMatcherCursorAscent", CTestSDKLists::TestTLIDMatcherCursorAscent ),
        ENTRY( "TestTLIDSetFont", CTestSDKLists::TestTLIDSetFont ),
        ENTRY( "TestTLIDSetSearchStringL", CTestSDKLists::TestTLIDSetSearchStringL ),
        ENTRY( "TestTLIDFont", CTestSDKLists::TestTLIDFont ),
        ENTRY( "TestTLIDSetItemMarkPosition", CTestSDKLists::TestTLIDSetItemMarkPosition ),
        ENTRY( "TestTLIDItemMarkPosition", CTestSDKLists::TestTLIDItemMarkPosition ),
        ENTRY( "TestTLIDSetItemMarkReplacement", CTestSDKLists::TestTLIDSetItemMarkReplacement ),
        ENTRY( "TestTLIDItemMarkReplacement", CTestSDKLists::TestTLIDItemMarkReplacement ),
        ENTRY( "TestTLIDSetItemMarkReverse", CTestSDKLists::TestTLIDSetItemMarkReverse ),
        ENTRY( "TestTLIDItemMarkReverse", CTestSDKLists::TestTLIDItemMarkReverse ),
        ENTRY( "TestTLIDDoDrawItemText", CTestSDKLists::TestTLIDDoDrawItemTextL ),
        ENTRY( "TestTLIDDrawItemText", CTestSDKLists::TestTLIDDrawItemTextL ),
        ENTRY( "TestTLIDResetGc", CTestSDKLists::TestTLIDResetGcL ),
        // class TListItemProperties
        ENTRY( "TestLIPConstructorL", CTestSDKLists::TestLIPConstructorL ),
        ENTRY( "TestLIPSetBold", CTestSDKLists::TestLIPSetBold ),
        ENTRY( "TestLIPIsBold", CTestSDKLists::TestLIPIsBold ),
        ENTRY( "TestLIPSetItalics", CTestSDKLists::TestLIPSetItalics ),
        ENTRY( "TestLIPIsItalics", CTestSDKLists::TestLIPIsItalics ),
        ENTRY( "TestLIPSetUnderlined", CTestSDKLists::TestLIPSetUnderlined ),
        ENTRY( "TestLIPIsUnderlined", CTestSDKLists::TestLIPIsUnderlined ),
        ENTRY( "TestLIPSetDimmed", CTestSDKLists::TestLIPSetDimmed ),
        ENTRY( "TestLIPIsDimmed", CTestSDKLists::TestLIPIsDimmed ),
        ENTRY( "TestLIPSetColor", CTestSDKLists::TestLIPSetColor ),
        ENTRY( "TestLIPColor", CTestSDKLists::TestLIPColor ),
        ENTRY( "TestLIPSetSeparatorAfter", CTestSDKLists::TestLIPSetSeparatorAfter ),
        ENTRY( "TestLIPIsSeparatorAfter", CTestSDKLists::TestLIPIsSeparatorAfter ),
        ENTRY( "TestLIPSetHiddenSelection", CTestSDKLists::TestLIPSetHiddenSelection ),
        ENTRY( "TestLIPIsSelectionHidden", CTestSDKLists::TestLIPIsSelectionHidden ),

        // eiklbv.h
        // class CListBoxView
        ENTRY( "TestLBVConstructorL", CTestSDKLists::TestLBVConstructorL ),
        ENTRY( "TestLBVDestructorL", CTestSDKLists::TestLBVDestructorL ),
        ENTRY( "TestLBVConstructL", CTestSDKLists::TestLBVConstructL ),
        ENTRY( "TestLBVViewRectL", CTestSDKLists::TestLBVViewRectL ),
        ENTRY( "TestLBVSetViewRectL", CTestSDKLists::TestLBVSetViewRectL ),
        ENTRY( "TestLBVCurrentItemIndexL", CTestSDKLists::TestLBVCurrentItemIndexL ),
        ENTRY( "TestLBVSetCurrentItemIndexL", CTestSDKLists::TestLBVSetCurrentItemIndexL ),
        ENTRY( "TestLBVTopItemIndexL", CTestSDKLists::TestLBVTopItemIndexL ),
        ENTRY( "TestLBVSetTopItemIndexL", CTestSDKLists::TestLBVSetTopItemIndexL ),
        ENTRY( "TestLBVBottomItemIndexL", CTestSDKLists::TestLBVBottomItemIndexL ),
        ENTRY( "TestLBVCalcBottomItemIndexL", CTestSDKLists::TestLBVCalcBottomItemIndexL ),
        ENTRY( "TestLBVSetItemHeightL", CTestSDKLists::TestLBVSetItemHeightL ),
        ENTRY( "TestLBVSetMatcherCursorColorL", CTestSDKLists::TestLBVSetMatcherCursorColorL ),
        ENTRY( "TestLBVSetMatcherCursorPosL", CTestSDKLists::TestLBVSetMatcherCursorPosL ),
        ENTRY( "TestLBVMatcherCursorPosL", CTestSDKLists::TestLBVMatcherCursorPosL ),
        ENTRY( "TestLBVDrawMatcherCursorL", CTestSDKLists::TestLBVDrawMatcherCursorL ),
        ENTRY( "TestLBVHideMatcherCursorL", CTestSDKLists::TestLBVHideMatcherCursorL ),
        ENTRY( "TestLBVSetMatcherCursorL", CTestSDKLists::TestLBVSetMatcherCursorL ),
        ENTRY( "TestLBVSetEmphasizedL", CTestSDKLists::TestLBVSetEmphasizedL ),
        ENTRY( "TestLBVSetDimmedL", CTestSDKLists::TestLBVSetDimmedL ),
        ENTRY( "TestLBVSetDisableRedrawL", CTestSDKLists::TestLBVSetDisableRedrawL ),
        ENTRY( "TestLBVRedrawDisabledL", CTestSDKLists::TestLBVRedrawDisabledL ),
        ENTRY( "TestLBVSetPaintedSelectionL", CTestSDKLists::TestLBVSetPaintedSelectionL ),
        ENTRY( "TestLBVSelectionIndexesL", CTestSDKLists::TestLBVSelectionIndexesL ),
        ENTRY( "TestLBVGetSelectionIndexesL", CTestSDKLists::TestLBVGetSelectionIndexesL ),
        ENTRY( "TestLBVSetSelectionIndexesL", CTestSDKLists::TestLBVSetSelectionIndexesL ),
        ENTRY( "TestLBVClearSelectionL", CTestSDKLists::TestLBVClearSelectionL ),
        ENTRY( "TestLBVUpdateSelectionL", CTestSDKLists::TestLBVUpdateSelectionL ),
        ENTRY( "TestLBVToggleItemL", CTestSDKLists::TestLBVToggleItemL ),
        ENTRY( "TestLBVSelectItemL", CTestSDKLists::TestLBVSelectItemL ),
        ENTRY( "TestLBVDeselectItemL", CTestSDKLists::TestLBVDeselectItemL ),
        ENTRY( "TestLBVSetAnchorL", CTestSDKLists::TestLBVSetAnchorL ),
        ENTRY( "TestLBVClearSelectionAnchorAndActiveIndexL",
                CTestSDKLists::TestLBVClearSelectionAnchorAndActiveIndexL ),
        ENTRY( "TestLBVScrollToMakeItemVisibleL", CTestSDKLists::TestLBVScrollToMakeItemVisibleL ),
        ENTRY( "TestLBVVScrollToL", CTestSDKLists::TestLBVVScrollToL ),
        ENTRY( "TestLBVVScrollToWithTRectL", CTestSDKLists::TestLBVVScrollToWithTRectL ),
        ENTRY( "TestLBVHScrollL", CTestSDKLists::TestLBVHScrollL ),
        ENTRY( "TestLBVHScrollOffsetL", CTestSDKLists::TestLBVHScrollOffsetL ),
        ENTRY( "TestLBVSetHScrollOffsetL", CTestSDKLists::TestLBVSetHScrollOffsetL ),
        ENTRY( "TestLBVDataWidthL", CTestSDKLists::TestLBVDataWidthL ),
        ENTRY( "TestLBVCalcDataWidthL", CTestSDKLists::TestLBVCalcDataWidthL ),
        ENTRY( "TestLBVVisibleWidthL", CTestSDKLists::TestLBVVisibleWidthL ),
        ENTRY( "TestLBVCalcNewTopItemIndexSoItemIsVisibleL",
                CTestSDKLists::TestLBVCalcNewTopItemIndexSoItemIsVisibleL ),
        ENTRY( "TestLBVDrawL", CTestSDKLists::TestLBVDrawL ),
        ENTRY( "TestLBVDrawItemL", CTestSDKLists::TestLBVDrawItemL ),
        ENTRY( "TestLBVSetListEmptyTextL", CTestSDKLists::TestLBVSetListEmptyTextL ),
        ENTRY( "TestLBVEmptyListTextL", CTestSDKLists::TestLBVEmptyListTextL ),
        ENTRY( "TestLBVItemIsSelectedL", CTestSDKLists::TestLBVItemIsSelectedL ),
        ENTRY( "TestLBVItemIsVisibleL", CTestSDKLists::TestLBVItemIsVisibleL ),
        ENTRY( "TestLBVItemPosL", CTestSDKLists::TestLBVItemPosL ),
        ENTRY( "TestLBVItemSizeL", CTestSDKLists::TestLBVItemSizeL ),
        ENTRY( "TestLBVSetTextColorL", CTestSDKLists::TestLBVSetTextColorL ),
        ENTRY( "TestLBVSetBackColorL", CTestSDKLists::TestLBVSetBackColorL ),
        ENTRY( "TestLBVTextColorL", CTestSDKLists::TestLBVTextColorL ),
        ENTRY( "TestLBVBackColorL", CTestSDKLists::TestLBVBackColorL ),
        ENTRY( "TestLBVMoveCursorL", CTestSDKLists::TestLBVMoveCursorL ),
        ENTRY( "TestLBVVerticalMoveToItemL", CTestSDKLists::TestLBVVerticalMoveToItemL ),
        ENTRY( "TestLBVXYPosToItemIndexL", CTestSDKLists::TestLBVXYPosToItemIndexL ),
        ENTRY( "TestLBVNumberOfItemsThatFitInRectL",
                CTestSDKLists::TestLBVNumberOfItemsThatFitInRectL ),
        ENTRY( "TestLBVIsVisibleL", CTestSDKLists::TestLBVIsVisibleL ),
        ENTRY( "TestLBVItemDrawerL", CTestSDKLists::TestLBVItemDrawerL ),
        ENTRY( "TestLBVDrawEmptyListL", CTestSDKLists::TestLBVDrawEmptyListL ),
        ENTRY( "TestLBVDeselectRangeL", CTestSDKLists::TestLBVDeselectRangeL ),
        ENTRY( "TestLBVFlagsL", CTestSDKLists::TestLBVFlagsL ),
        ENTRY( "TestLBVSetFlagsL", CTestSDKLists::TestLBVSetFlagsL ),
        ENTRY( "TestLBVClearFlagsL", CTestSDKLists::TestLBVClearFlagsL ),
        ENTRY( "TestLBVSelectRangeL", CTestSDKLists::TestLBVSelectRangeL ),
        // class CSnakingListBoxView
        ENTRY( "TestSLBVConstructorL", CTestSDKLists::TestSLBVConstructorL ),
        ENTRY( "TestSLBVDestructor", CTestSDKLists::TestSLBVDestructor ),
        ENTRY( "TestSLBVColumnWidth", CTestSDKLists::TestSLBVColumnWidth ),
        ENTRY( "TestSLBVSetColumnWidth", CTestSDKLists::TestSLBVSetColumnWidth ),
        ENTRY( "TestSLBVMoveCursorL", CTestSDKLists::TestSLBVMoveCursorL ),
        ENTRY( "TestSLBVSetTopItemIndex", CTestSDKLists::TestSLBVSetTopItemIndex ),
        ENTRY( "TestSLBVSetItemHeight", CTestSDKLists::TestSLBVSetItemHeight ),
        ENTRY( "TestSLBVXYPosToItemIndex", CTestSDKLists::TestSLBVXYPosToItemIndex ),
        ENTRY( "TestSLBVNumberOfItemsThatFitInRect",
                CTestSDKLists::TestSLBVNumberOfItemsThatFitInRect ),
        ENTRY( "TestSLBVHScroll", CTestSDKLists::TestSLBVHScroll ),
        ENTRY( "TestSLBVCalcDataWidth", CTestSDKLists::TestSLBVCalcDataWidth ),
        ENTRY( "TestSLBVCalcBottomItemIndex", CTestSDKLists::TestSLBVCalcBottomItemIndex ),
        ENTRY( "TestSLBVDraw", CTestSDKLists::TestSLBVDraw ),
        ENTRY( "TestSLBVVisibleWidth", CTestSDKLists::TestSLBVVisibleWidth ),
        ENTRY( "TestSLBVScrollToMakeItemVisible",
                CTestSDKLists::TestSLBVScrollToMakeItemVisible ),
        ENTRY( "TestSLBVCalculateHScrollOffsetSoItemIsVisible",
                CTestSDKLists::TestSLBVCalculateHScrollOffsetSoItemIsVisible ),
        ENTRY( "TestSLBVCalcNewTopItemIndexSoItemIsVisible",
                CTestSDKLists::TestSLBVCalcNewTopItemIndexSoItemIsVisible ),
        ENTRY( "TestSLBVItemPos", CTestSDKLists::TestSLBVItemPos ),
        ENTRY( "TestSLBVItemSize", CTestSDKLists::TestSLBVItemSize ),
        ENTRY( "TestSLBVCalcRowAndColIndexesFromItemIndex",
                CTestSDKLists::TestSLBVCalcRowAndColIndexesFromItemIndex ),
        ENTRY( "TestSLBVCalcItemIndexFromRowAndColIndexes",
                CTestSDKLists::TestSLBVCalcItemIndexFromRowAndColIndexes ),
        ENTRY( "TestSLBVNumberOfItemsPerColumn",
                CTestSDKLists::TestSLBVNumberOfItemsPerColumn ),
        ENTRY( "TestSLBVDrawItemRange", CTestSDKLists::TestSLBVDrawItemRangeL ),
        ENTRY( "TestSLBVDrawColumnRangeL", CTestSDKLists::TestSLBVDrawColumnRangeL ),
        ENTRY( "TestSLBVMoveToPreviousColumnL", CTestSDKLists::TestSLBVMoveToPreviousColumnL ),
        ENTRY( "TestSLBVMoveToNextColumnL", CTestSDKLists::TestSLBVMoveToNextColumnL ),
        ENTRY( "TestSLBVClearUnusedItemSpaceL", CTestSDKLists::TestSLBVClearUnusedItemSpaceL ),
        ENTRY( "TestSLBVUpdateHScrollOffsetBasedOnTopItemIndexL",
                CTestSDKLists::TestSLBVUpdateHScrollOffsetBasedOnTopItemIndexL ),
        ENTRY( "TestSLBVSetItemOffsetInPixelsL",
                CTestSDKLists::TestSLBVSetItemOffsetInPixelsL ),
        
        // eiklbx.h
        // class CEikListBox
        ENTRY( "TestLBConstructorL", CTestSDKLists::TestLBConstructorL ),
        ENTRY( "TestLBDestructor", CTestSDKLists::TestLBDestructor ),
        ENTRY( "TestLBConstructL", CTestSDKLists::TestLBConstructL ),
        ENTRY( "TestLBConstructWithTGulBorderL",
                CTestSDKLists::TestLBConstructWithTGulBorderL ),
        ENTRY( "TestLBOfferKeyEventL", CTestSDKLists::TestLBOfferKeyEventL ),
        ENTRY( "TestLBHandlePointerEventL", CTestSDKLists::TestLBHandlePointerEventL ),
        ENTRY( "TestLBSetContainerWindowL", CTestSDKLists::TestLBSetContainerWindowL ),
        ENTRY( "TestLBMinimumSize", CTestSDKLists::TestLBMinimumSize ),
        ENTRY( "TestLBSetDimmed", CTestSDKLists::TestLBSetDimmed ),
        ENTRY( "TestLBHandleScrollEventL", CTestSDKLists::TestLBHandleScrollEventL ),
        ENTRY( "TestLBModel", CTestSDKLists::TestLBModelL ),
        ENTRY( "TestLBView", CTestSDKLists::TestLBViewL ),
        ENTRY( "TestLBTopItemIndex", CTestSDKLists::TestLBTopItemIndex ),
        ENTRY( "TestLBSetTopItemIndex", CTestSDKLists::TestLBSetTopItemIndex ),
        ENTRY( "TestLBBottomItemIndex", CTestSDKLists::TestLBBottomItemIndex ),
        ENTRY( "TestLBCurrentItemIndex", CTestSDKLists::TestLBCurrentItemIndex ),
        ENTRY( "TestLBSetCurrentItemIndex", CTestSDKLists::TestLBSetCurrentItemIndex ),
        ENTRY( "TestLBSetCurrentItemIndexAndDraw",
                CTestSDKLists::TestLBSetCurrentItemIndexAndDraw ),
        ENTRY( "TestLBSelectionIndexes", CTestSDKLists::TestLBSelectionIndexesL ),
        ENTRY( "TestLBSetSelectionIndexesL", CTestSDKLists::TestLBSetSelectionIndexesL ),
        ENTRY( "TestLBClearSelection", CTestSDKLists::TestLBClearSelection ),
        ENTRY( "TestLBHandleItemAdditionL", CTestSDKLists::TestLBHandleItemAdditionL ),
        ENTRY( "TestLBHandleItemRemovalL", CTestSDKLists::TestLBHandleItemRemovalL ),
        ENTRY( "TestLBHandleItemAdditionWIthParaL",
                CTestSDKLists::TestLBHandleItemAdditionWIthParaL ),
        ENTRY( "TestLBHandleItemRemovalWIthParaL",
                CTestSDKLists::TestLBHandleItemRemovalWIthParaL ),
        ENTRY( "TestLBReset", CTestSDKLists::TestLBReset ),
        ENTRY( "TestLBAddItemChangeObserverL", CTestSDKLists::TestLBAddItemChangeObserverL ),
        ENTRY( "TestLBRemoveItemChangeObserver",
                CTestSDKLists::TestLBRemoveItemChangeObserverL ),
        ENTRY( "TestLBSetItemHeightL", CTestSDKLists::TestLBSetItemHeightL ),
        ENTRY( "TestLBItemHeight", CTestSDKLists::TestLBItemHeight ),
        ENTRY( "TestLBCreateScrollBarFrameL", CTestSDKLists::TestLBCreateScrollBarFrameL ),
        ENTRY( "TestLBSetScrollBarFrameL", CTestSDKLists::TestLBSetScrollBarFrameL ),
        ENTRY( "TestLBScrollBarFrameL", CTestSDKLists::TestLBScrollBarFrameL ),
        ENTRY( "TestLBUpdateScrollBarsL", CTestSDKLists::TestLBUpdateScrollBarsL ),
        ENTRY( "TestLBCalculatePopoutRect", CTestSDKLists::TestLBCalculatePopoutRect ),
        ENTRY( "TestLBCalcSizeInPixels", CTestSDKLists::TestLBCalcSizeInPixels ),
        ENTRY( "TestLBCalcWidthBasedOnNumOfChars",
                CTestSDKLists::TestLBCalcWidthBasedOnNumOfChars ),
        ENTRY( "TestLBCalcHeightBasedOnNumOfItems",
                CTestSDKLists::TestLBCalcHeightBasedOnNumOfItems ),
        ENTRY( "TestLBCalcWidthBasedOnRequiredItemWidth",
                CTestSDKLists::TestLBCalcWidthBasedOnRequiredItemWidth ),
        ENTRY( "TestLBDrawItem", CTestSDKLists::TestLBDrawItem ),
        ENTRY( "TestLBScrollToMakeItemVisible",
                CTestSDKLists::TestLBScrollToMakeItemVisible ),
        ENTRY( "TestLBRedrawItem", CTestSDKLists::TestLBRedrawItem ),
        ENTRY( "TestLBSetListBoxObserver", CTestSDKLists::TestLBSetListBoxObserver ),
        ENTRY( "TestLBVerticalInterItemGap", CTestSDKLists::TestLBVerticalInterItemGap ),
        ENTRY( "TestLBSetLaunchingButton", CTestSDKLists::TestLBSetLaunchingButton ),
        ENTRY( "TestLBSetItemEditor", CTestSDKLists::TestLBSetItemEditorL ),
        ENTRY( "TestLBResetItemEditor", CTestSDKLists::TestLBResetItemEditor ),
        ENTRY( "TestLBItemEditorL", CTestSDKLists::TestLBItemEditorL ),
        ENTRY( "TestLBEditItemL", CTestSDKLists::TestLBEditItemL ),
        ENTRY( "TestLBStopEditingL", CTestSDKLists::TestLBStopEditingL ),
        ENTRY( "TestLBShortcutValueForNextList",
                CTestSDKLists::TestLBShortcutValueForNextList ),
        ENTRY( "TestLBSetShortcutValueFromPrevList",
                CTestSDKLists::TestLBSetShortcutValueFromPrevList ),
        ENTRY( "TestLBHighlightRect", CTestSDKLists::TestLBHighlightRect ),
        ENTRY( "TestLBGetColorUseListL", CTestSDKLists::TestLBGetColorUseListL ),
        ENTRY( "TestLBHandleResourceChange", CTestSDKLists::TestLBHandleResourceChange ),
        ENTRY( "TestLBActivateL", CTestSDKLists::TestLBActivateL ),
        ENTRY( "TestLBInputCapabilities", CTestSDKLists::TestLBInputCapabilities ),
        ENTRY( "TestLBEventModifiers", CTestSDKLists::TestLBEventModifiers ),
        ENTRY( "TestLBIsMultiselection", CTestSDKLists::TestLBIsMultiselection ),
        ENTRY( "TestLBCreateScrollBarFrameWithTwoParaL",
                CTestSDKLists::TestLBCreateScrollBarFrameWithTwoParaL ),
        ENTRY( "TestLBCreateScrollBarFrameWithThreeParaL",
                CTestSDKLists::TestLBCreateScrollBarFrameWithThreeParaL ),
        ENTRY( "TestLBEnableMSKObserver", CTestSDKLists::TestLBEnableMSKObserver ),
        ENTRY( "TestLBAddSelectionObserverL", CTestSDKLists::TestLBAddSelectionObserverL ),
        ENTRY( "TestLBRemoveSelectionObserver",
                CTestSDKLists::TestLBRemoveSelectionObserverL ),
        ENTRY( "TestLBFocusChangedL", CTestSDKLists::TestLBFocusChangedL ),
        ENTRY( "TestLBSizeChangedL", CTestSDKLists::TestLBSizeChangedL ),
        ENTRY( "TestLBHandleViewRectSizeChangeL",
                CTestSDKLists::TestLBHandleViewRectSizeChangeL ),
        ENTRY( "TestLBCountComponentControlsL",
                CTestSDKLists::TestLBCountComponentControlsL ),
        ENTRY( "TestLBComponentControlL", CTestSDKLists::TestLBComponentControlL ),
        ENTRY( "TestLBCreateMatchBufferL", CTestSDKLists::TestLBCreateMatchBufferL ),
        ENTRY( "TestLBClearMatchBufferL", CTestSDKLists::TestLBClearMatchBufferL ),
        ENTRY( "TestLBMatchTypedCharL", CTestSDKLists::TestLBMatchTypedCharL ),
        ENTRY( "TestLBUndoLastCharL", CTestSDKLists::TestLBUndoLastCharL ),
        ENTRY( "TestLBLastCharMatchedL", CTestSDKLists::TestLBLastCharMatchedL ),
        ENTRY( "TestLBUpdateScrollBarThumbsL", CTestSDKLists::TestLBUpdateScrollBarThumbsL ),
        ENTRY( "TestLBHorizScrollGranularityInPixelsL",
                CTestSDKLists::TestLBHorizScrollGranularityInPixelsL ),
        ENTRY( "TestLBHorizontalNudgeValueL", CTestSDKLists::TestLBHorizontalNudgeValueL ),
        ENTRY( "TestLBAdjustTopItemIndexL", CTestSDKLists::TestLBAdjustTopItemIndexL ),
        ENTRY( "TestLBSimulateArrowKeyEventL", CTestSDKLists::TestLBSimulateArrowKeyEventL ),
        ENTRY( "TestLBHandleLeftArrowKeyL", CTestSDKLists::TestLBHandleLeftArrowKeyL ),
        ENTRY( "TestLBHandleRightArrowKeyL", CTestSDKLists::TestLBHandleRightArrowKeyL ),
        ENTRY( "TestLBRestoreCommonListBoxPropertiesL",
                CTestSDKLists::TestLBRestoreCommonListBoxPropertiesL ),
        ENTRY( "TestLBProtectedConstructL", CTestSDKLists::TestLBProtectedConstructL ),
        ENTRY( "TestLBCreateViewL", CTestSDKLists::TestLBCreateViewL ),
        ENTRY( "TestLBMakeViewClassInstanceL", CTestSDKLists::TestLBMakeViewClassInstanceL ),
        ENTRY( "TestLBSetViewRectFromClientRectL",
                CTestSDKLists::TestLBSetViewRectFromClientRectL ),
        ENTRY( "TestLBRestoreClientRectFromViewRectL",
                CTestSDKLists::TestLBRestoreClientRectFromViewRectL ),
        ENTRY( "TestLBAdjustRectHeightToWholeNumberOfItemsL",
                CTestSDKLists::TestLBAdjustRectHeightToWholeNumberOfItemsL ),
        ENTRY( "TestLBListBoxMarginsL", CTestSDKLists::TestLBListBoxMarginsL ),
        ENTRY( "TestLBHorizontalMarginL", CTestSDKLists::TestLBHorizontalMarginL ),
        ENTRY( "TestLBVerticalMarginL", CTestSDKLists::TestLBVerticalMarginL ),
        ENTRY( "TestLBSetHorizontalMarginL", CTestSDKLists::TestLBSetHorizontalMarginL ),
        ENTRY( "TestLBSetVerticalMarginL", CTestSDKLists::TestLBSetVerticalMarginL ),
        ENTRY( "TestLBMatchBufferL", CTestSDKLists::TestLBMatchBufferL ),
        ENTRY( "TestLBViewRectHeightAdjustmentL",
                CTestSDKLists::TestLBViewRectHeightAdjustmentL ),
        ENTRY( "TestLBBackColorL", CTestSDKLists::TestLBBackColorL ),
        ENTRY( "TestLBSetViewRectHeightAdjustmentL",
                CTestSDKLists::TestLBSetViewRectHeightAdjustmentL ),
        ENTRY( "TestLBReportListBoxEventL", CTestSDKLists::TestLBReportListBoxEventL ),
        ENTRY( "TestLBDrawL", CTestSDKLists::TestLBDrawL ),
        ENTRY( "TestLBClearMarginsL", CTestSDKLists::TestLBClearMarginsL ),
        ENTRY( "TestLBUpdateCurrentItemL", CTestSDKLists::TestLBUpdateCurrentItemL ),
        ENTRY( "TestLBHandleDragEventL", CTestSDKLists::TestLBHandleDragEventL ),
        ENTRY( "TestLBItemExistsL", CTestSDKLists::TestLBItemExistsL ),
        ENTRY( "TestLBDrawMatcherCursorL", CTestSDKLists::TestLBDrawMatcherCursorL ),
        ENTRY( "TestLBInterItemGapL", CTestSDKLists::TestLBInterItemGapL ),
        ENTRY( "TestLBUpdateViewColorsL", CTestSDKLists::TestLBUpdateViewColorsL ),
        ENTRY( "TestLBUpdateItemDrawerColorsL",
                CTestSDKLists::TestLBUpdateItemDrawerColorsL ),
        ENTRY( "TestLBFireItemChangeL", CTestSDKLists::TestLBFireItemChangeL ),
        ENTRY( "TestLBSetReasonForFocusLostL", CTestSDKLists::TestLBSetReasonForFocusLostL ),
        ENTRY( "TestLBReasonForFocusLostL", CTestSDKLists::TestLBReasonForFocusLostL ),
        ENTRY( "TestLBIsMatchBufferL", CTestSDKLists::TestLBIsMatchBufferL ),
        ENTRY( "TestLBCreateScrollBarFrameLayoutL",
                CTestSDKLists::TestLBCreateScrollBarFrameLayoutL ),
        ENTRY( "TestLBDisableScrolling", CTestSDKLists::TestLBDisableScrolling ),
        ENTRY( "TestLBSetItemsInSingleLine", CTestSDKLists::TestLBSetItemsInSingleLine ),
        ENTRY( "TestLBBackgroundDrawingSuppressed",
                CTestSDKLists::TestLBBackgroundDrawingSuppressed ),
        ENTRY( "TestLBHandlePhysicsScrollEventL",
                CTestSDKLists::TestLBHandlePhysicsScrollEventL ),

        ENTRY( "TestLBDisableSingleClick", CTestSDKLists::TestLBDisableSingleClick ),
        ENTRY( "TestLBDisableItemSpecificMenu", CTestSDKLists::TestLBDisableItemSpecificMenu ),
        ENTRY( "TestLBItemsInSingleLine", CTestSDKLists::TestLBItemsInSingleLine ),
        
        // class CEikSnakingListBox
        ENTRY( "TestSLBConstructorL", CTestSDKLists::TestSLBConstructorL ),
        ENTRY( "TestSLBDestructorL", CTestSDKLists::TestSLBDestructorL ),
        ENTRY( "TestSLBMakeViewClassInstanceL", CTestSDKLists::TestSLBMakeViewClassInstanceL ),
        ENTRY( "TestSLBSetTopItemIndexL", CTestSDKLists::TestSLBSetTopItemIndexL ),
        ENTRY( "TestSLBColumnWidthL", CTestSDKLists::TestSLBColumnWidthL ),
        ENTRY( "TestSLBSetColumnWidthL", CTestSDKLists::TestSLBSetColumnWidthL ),
        ENTRY( "TestSLBHandlePointerEventL", CTestSDKLists::TestSLBHandlePointerEventL ),
        ENTRY( "TestSLBHandleViewRectSizeChangeL",
                CTestSDKLists::TestSLBHandleViewRectSizeChangeL ),
        ENTRY( "TestSLBHandleLeftArrowKeyL", CTestSDKLists::TestSLBHandleLeftArrowKeyL ),
        ENTRY( "TestSLBHandleRightArrowKeyL", CTestSDKLists::TestSLBHandleRightArrowKeyL ),
        ENTRY( "TestSLBHorizontalNudgeValueL", CTestSDKLists::TestSLBHorizontalNudgeValueL ),
        ENTRY( "TestSLBHorizScrollGranularityInPixelsL",
                CTestSDKLists::TestSLBHorizScrollGranularityInPixelsL ),
        ENTRY( "TestSLBAdjustTopItemIndexL", CTestSDKLists::TestSLBAdjustTopItemIndexL ),
        ENTRY( "TestSLBHandleDragEventL", CTestSDKLists::TestSLBHandleDragEventL ),
        ENTRY( "TestSLBRestoreClientRectFromViewRectL",
                CTestSDKLists::TestSLBRestoreClientRectFromViewRectL ),
        ENTRY( "TestSLBAdjustRectHeightToWholeNumberOfItemsL",
                CTestSDKLists::TestSLBAdjustRectHeightToWholeNumberOfItemsL ),
        ENTRY( "TestSLBMoveToNextOrPreviousItemL",
                CTestSDKLists::TestSLBMoveToNextOrPreviousItemL ),
        ENTRY( "TestSLBSizeChangedL", CTestSDKLists::TestSLBSizeChangedL ),
        ENTRY( "TestSLBGetColorUseListL", CTestSDKLists::TestSLBGetColorUseListL ),
        ENTRY( "TestSLBHandleResourceChangeL", CTestSDKLists::TestSLBHandleResourceChangeL ),

        // eikslb.h
        // class CSettingsListBoxItemDrawer
        ENTRY( "TestSLBIDConstructorL", CTestSDKLists::TestSLBIDConstructorL ),
        ENTRY( "TestSLBIDDetructorL", CTestSDKLists::TestSLBIDDetructorL ),
        ENTRY( "TestSLBIDSettingsDataL", CTestSDKLists::TestSLBIDSettingsDataL ),
        ENTRY( "TestSLBIDDrawItemTextL", CTestSDKLists::TestSLBIDDrawItemTextL ),
        // class CEikSettingsListBox
        ENTRY( "TestSettingsLBConstructorL", CTestSDKLists::TestSettingsLBConstructorL ),
        ENTRY( "TestSettingsLBItemDrawerL", CTestSDKLists::TestSettingsLBItemDrawerL ),
        ENTRY( "TestSettingsLBMakeViewClassInstanceL",
                CTestSDKLists::TestSettingsLBMakeViewClassInstanceL ),
        ENTRY( "TestSettingsLBHandlePointerEventL",
                CTestSDKLists::TestSettingsLBHandlePointerEventL ),
        ENTRY( "TestSettingsLBCreateItemDrawerL",
                CTestSDKLists::TestSettingsLBCreateItemDrawerL ),
        // class CSettingsListBoxView
        ENTRY( "TestSettingsLBVDrawL", CTestSDKLists::TestSettingsLBVDrawL ),
        ENTRY( "TestSettingsLBVDrawItemL", CTestSDKLists::TestSettingsLBVDrawItemL ),
        ENTRY( "TestSettingsLBVItemDrawerL", CTestSDKLists::TestSettingsLBVItemDrawerL ),

        // eiktxlbm.h
        ENTRY( "TestTXLBMConstructorL", CTestSDKLists::TestTXLBMConstructorL ),
        ENTRY( "TestTXLBMDestructorL", CTestSDKLists::TestTXLBMDestructorL ),
        ENTRY( "TestTXLBMNumberOfItemsL", CTestSDKLists::TestTXLBMNumberOfItemsL ),
        ENTRY( "TestTXLBMMatchableTextArrayL", CTestSDKLists::TestTXLBMMatchableTextArrayL ),
        ENTRY( "TestTXLBMItemTextL", CTestSDKLists::TestTXLBMItemTextL ),
        ENTRY( "TestTXLBMConstructL", CTestSDKLists::TestTXLBMConstructL ),
        ENTRY( "TestTXLBMSetItemTextArrayL", CTestSDKLists::TestTXLBMSetItemTextArrayL ),
        ENTRY( "TestTXLBMSetOwnershipTypeL", CTestSDKLists::TestTXLBMSetOwnershipTypeL ),
        ENTRY( "TestTXLBMItemTextArrayL", CTestSDKLists::TestTXLBMItemTextArrayL ),
        ENTRY( "TestTXLBMItemArrayOwnershipTypeL",
                CTestSDKLists::TestTXLBMItemArrayOwnershipTypeL ),

        // eiktxlbx.h
        // class CEikTextListBox
        ENTRY( "TestTXLBConstructorL", CTestSDKLists::TestTXLBConstructorL ),
        ENTRY( "TestTXLBDestructorL", CTestSDKLists::TestTXLBDestructorL ),
        ENTRY( "TestTXLBConstructFromResourceL",
                CTestSDKLists::TestTXLBConstructFromResourceL ),
        ENTRY( "TestTXLBConstructL", CTestSDKLists::TestTXLBConstructL ),
        ENTRY( "TestTXLBModelL", CTestSDKLists::TestTXLBModelL ),
        ENTRY( "TestTXLBGetColorUseListL", CTestSDKLists::TestTXLBGetColorUseListL ),
        ENTRY( "TestTXLBHandleResourceChangeL", CTestSDKLists::TestTXLBHandleResourceChangeL ),
        ENTRY( "TestTXLBHandlePointerEventL", CTestSDKLists::TestTXLBHandlePointerEventL ),
        ENTRY( "TestTXLBWriteInternalStateL", CTestSDKLists::TestTXLBWriteInternalStateL ),
        ENTRY( "TestTXLBCreateItemDrawerL", CTestSDKLists::TestTXLBCreateItemDrawerL ),
        // class CEikSnakingTextListBox
        ENTRY( "TestSTXLBConstructorL", CTestSDKLists::TestSTXLBConstructorL ),
        ENTRY( "TestSTXLBDestructorL", CTestSDKLists::TestSTXLBDestructorL ),
        ENTRY( "TestSTXLBConstructL", CTestSDKLists::TestSTXLBConstructL ),
        ENTRY( "TestSTXLBModelL", CTestSDKLists::TestSTXLBModelL ),
        ENTRY( "TestSTXLBGetColorUseListL", CTestSDKLists::TestSTXLBGetColorUseListL ),
        ENTRY( "TestSTXLBHandleResourceChangeL",
                CTestSDKLists::TestSTXLBHandleResourceChangeL ),
        ENTRY( "TestSTXLBHandlePointerEventL", CTestSDKLists::TestSTXLBHandlePointerEventL ),

        // aknlists.h
        // class CAknColumnListBox
        ENTRY( "TestACLBMakeViewClassInstanceL",
                CTestSDKLists::TestACLBMakeViewClassInstanceL ),
        ENTRY( "TestACLBCreateModelL", CTestSDKLists::TestACLBCreateModelL ),
        ENTRY( "TestACLBAdjustRectHeightToWholeNumberOfItemsL",
                CTestSDKLists::TestACLBAdjustRectHeightToWholeNumberOfItemsL ),
        ENTRY( "TestACLBHandlePointerEventL", CTestSDKLists::TestACLBHandlePointerEventL ),
        // class AknListBoxLinesTemplate
        ENTRY( "TestLinesTemplateConstructorL", CTestSDKLists::TestLinesTemplateConstructorL ),
        ENTRY( "TestLinesTemplateSizeChangedL", CTestSDKLists::TestLinesTemplateSizeChangedL ),
        ENTRY( "TestLinesTemplateDrawL", CTestSDKLists::TestLinesTemplateDrawL ),
        ENTRY( "TestLinesTemplateCountComponentControlsL",
                CTestSDKLists::TestLinesTemplateCountComponentControlsL ),
        ENTRY( "TestLinesTemplateComponentControlL",
                CTestSDKLists::TestLinesTemplateComponentControlL ),
        // class  CAknSingleStyleListBox
        ENTRY( "TestASSLBConstructorL", CTestSDKLists::TestASSLBConstructorL ),
        ENTRY( "TestASSLBSizeChangedL", CTestSDKLists::TestASSLBSizeChangedL ),
        ENTRY( "TestASSLBMinimumSizeL", CTestSDKLists::TestASSLBMinimumSizeL ),
        ENTRY( "TestASSLBHandlePointerEventL", CTestSDKLists::TestASSLBHandlePointerEventL ),
        // class  CAknSingleNumberStyleListBox
        ENTRY( "TestASNSLBConstructorL", CTestSDKLists::TestASNSLBConstructorL ),
        ENTRY( "TestASNSLBSizeChangedL", CTestSDKLists::TestASNSLBSizeChangedL ),
        ENTRY( "TestASNSLBMinimumSizeL", CTestSDKLists::TestASNSLBMinimumSizeL ),
        ENTRY( "TestASNSLBHandlePointerEventL", CTestSDKLists::TestASNSLBHandlePointerEventL ),
        // class  CAknSingleHeadingStyleListBox
        ENTRY( "TestASHSLBConstructorL", CTestSDKLists::TestASHSLBConstructorL ),
        ENTRY( "TestASHSLBSizeChangedL", CTestSDKLists::TestASHSLBSizeChangedL ),
        ENTRY( "TestASHSLBMinimumSizeL", CTestSDKLists::TestASHSLBMinimumSizeL ),
        ENTRY( "TestASHSLBHandlePointerEventL", CTestSDKLists::TestASHSLBHandlePointerEventL ),
        ENTRY( "TestASHSLBCreateItemDrawerL", CTestSDKLists::TestASHSLBCreateItemDrawerL ),
        ENTRY( "TestASHSLBMakeViewClassInstanceL", 
                CTestSDKLists::TestASHSLBMakeViewClassInstanceL ),
        // class  CAknSingleGraphicStyleListBox
        ENTRY( "TestASGSLBConstructorL", CTestSDKLists::TestASGSLBConstructorL ),
        ENTRY( "TestASGSLBSizeChangedL", CTestSDKLists::TestASGSLBSizeChangedL ),
        ENTRY( "TestASGSLBMinimumSizeL", CTestSDKLists::TestASGSLBMinimumSizeL ),
        ENTRY( "TestASGSLBHandlePointerEventL", CTestSDKLists::TestASGSLBHandlePointerEventL ),
        // class  CAknSingleGraphicHeadingStyleListBox
        ENTRY( "TestASGHSLBConstructorL", CTestSDKLists::TestASGHSLBConstructorL ),
        ENTRY( "TestASGHSLBSizeChangedL", CTestSDKLists::TestASGHSLBSizeChangedL ),
        ENTRY( "TestASGHSLBMinimumSizeL", CTestSDKLists::TestASGHSLBMinimumSizeL ),
        ENTRY( "TestASGHSLBHandlePointerEventL",
                CTestSDKLists::TestASGHSLBHandlePointerEventL ),
        ENTRY( "TestASGHSLBCreateItemDrawerL", CTestSDKLists::TestASGHSLBCreateItemDrawerL ),
        ENTRY( "TestASGHSLBMakeViewClassInstanceL",
                CTestSDKLists::TestASGHSLBMakeViewClassInstanceL ),
        // class  CAknSingleNumberHeadingStyleListBox
        ENTRY( "TestASNHSLBConstructorL", CTestSDKLists::TestASNHSLBConstructorL ),
        ENTRY( "TestASNHSLBSizeChangedL", CTestSDKLists::TestASNHSLBSizeChangedL ),
        ENTRY( "TestASNHSLBMinimumSizeL", CTestSDKLists::TestASNHSLBMinimumSizeL ),
        ENTRY( "TestASNHSLBHandlePointerEventL",
                CTestSDKLists::TestASNHSLBHandlePointerEventL ),
        ENTRY( "TestASNHSLBCreateItemDrawerL", CTestSDKLists::TestASNHSLBCreateItemDrawerL ),
        ENTRY( "TestASNHSLBMakeViewClassInstanceL",
                CTestSDKLists::TestASNHSLBMakeViewClassInstanceL ),
        // class  CAknSingleLargeStyleListBox
        ENTRY( "TestASLSLBConstructorL", CTestSDKLists::TestASLSLBConstructorL ),
        ENTRY( "TestASLSLBSizeChangedL", CTestSDKLists::TestASLSLBSizeChangedL ),
        ENTRY( "TestASLSLBMinimumSizeL", CTestSDKLists::TestASLSLBMinimumSizeL ),
        ENTRY( "TestASLSLBHandlePointerEventL", CTestSDKLists::TestASLSLBHandlePointerEventL ),
        // class  CAknDoubleStyleListBox
        ENTRY( "TestADSLBConstructorL", CTestSDKLists::TestADSLBConstructorL ),
        ENTRY( "TestADSLBSizeChangedL", CTestSDKLists::TestADSLBSizeChangedL ),
        ENTRY( "TestADSLBMinimumSizeL", CTestSDKLists::TestADSLBMinimumSizeL ),
        ENTRY( "TestADSLBHandlePointerEventL", CTestSDKLists::TestADSLBHandlePointerEventL ),
        // class  CAknDoubleStyle2ListBox
        ENTRY( "TestADS2LBSizeChangedL", CTestSDKLists::TestADS2LBSizeChangedL ),
        ENTRY( "TestADS2LBCreateItemDrawerL", CTestSDKLists::TestADS2LBCreateItemDrawerL ),
        ENTRY( "TestADS2LBHandlePointerEventL", CTestSDKLists::TestADS2LBHandlePointerEventL ),
        // class  CAknDoubleNumberStyleListBox
        ENTRY( "TestADNSLBConstructorL", CTestSDKLists::TestADNSLBConstructorL ),
        ENTRY( "TestADNSLBSizeChangedL", CTestSDKLists::TestADNSLBSizeChangedL ),
        ENTRY( "TestADNSLBMinimumSizeL", CTestSDKLists::TestADNSLBMinimumSizeL ),
        ENTRY( "TestADNSLBHandlePointerEventL", CTestSDKLists::TestADNSLBHandlePointerEventL ),
        // class  CAknDoubleTimeStyleListBox
        ENTRY( "TestADTSLBConstructorL", CTestSDKLists::TestADTSLBConstructorL ),
        ENTRY( "TestADTSLBSizeChangedL", CTestSDKLists::TestADTSLBSizeChangedL ),
        ENTRY( "TestADTSLBMinimumSizeL", CTestSDKLists::TestADTSLBMinimumSizeL ),
        ENTRY( "TestADTSLBHandlePointerEventL", CTestSDKLists::TestADTSLBHandlePointerEventL ),
        // class  CAknDoubleLargeStyleListBox
        ENTRY( "TestADLSLBConstructorL", CTestSDKLists::TestADLSLBConstructorL ),
        ENTRY( "TestADLSLBSizeChangedL", CTestSDKLists::TestADLSLBSizeChangedL ),
        ENTRY( "TestADLSLBMinimumSizeL", CTestSDKLists::TestADLSLBMinimumSizeL ),
        ENTRY( "TestADLSLBCreateItemDrawerL", CTestSDKLists::TestADLSLBCreateItemDrawerL ),
        ENTRY( "TestADLSLBHandlePointerEventL", CTestSDKLists::TestADLSLBHandlePointerEventL ),
        // class  CAknDoubleGraphicStyleListBox
        ENTRY( "TestADGSLBConstructorL", CTestSDKLists::TestADGSLBConstructorL ),
        ENTRY( "TestADGSLBSizeChangedL", CTestSDKLists::TestADGSLBSizeChangedL ),
        ENTRY( "TestADGSLBMinimumSizeL", CTestSDKLists::TestADGSLBMinimumSizeL ),
        ENTRY( "TestADGSLBHandlePointerEventL", CTestSDKLists::TestADGSLBHandlePointerEventL ),
        // class  CAknDouble2GraphicStyleListBox
        ENTRY( "TestAD2GSLBConstructorL", CTestSDKLists::TestAD2GSLBConstructorL ),
        ENTRY( "TestAD2GSLBSizeChangedL", CTestSDKLists::TestAD2GSLBSizeChangedL ),
        ENTRY( "TestAD2GSLBMinimumSizeL", CTestSDKLists::TestAD2GSLBMinimumSizeL ),
        ENTRY( "TestAD2GSLBCreateItemDrawerL", CTestSDKLists::TestAD2GSLBCreateItemDrawerL ),
        ENTRY( "TestAD2GSLBHandlePointerEventL",
                CTestSDKLists::TestAD2GSLBHandlePointerEventL ),
        // class  CAknDouble2LargeStyleListBox
        ENTRY( "TestAD2LSLBConstructorL", CTestSDKLists::TestAD2LSLBConstructorL ),
        ENTRY( "TestAD2LSLBSizeChangedL", CTestSDKLists::TestAD2LSLBSizeChangedL ),
        ENTRY( "TestAD2LSLBMinimumSizeL", CTestSDKLists::TestAD2LSLBMinimumSizeL ),
        ENTRY( "TestAD2LSLBCreateItemDrawerL", CTestSDKLists::TestAD2LSLBCreateItemDrawerL ),
        ENTRY( "TestAD2LSLBHandlePointerEventL",
                CTestSDKLists::TestAD2LSLBHandlePointerEventL ),
        // class  CAknDouble2GraphicLargeGraphicStyleListBox
        ENTRY( "TestAD2GLGSLBConstructorL", CTestSDKLists::TestAD2GLGSLBConstructorL ),
        ENTRY( "TestAD2GLGSLBSizeChangedL", CTestSDKLists::TestAD2GLGSLBSizeChangedL ),
        ENTRY( "TestAD2GLGSLBMinimumSizeL", CTestSDKLists::TestAD2GLGSLBMinimumSizeL ),
        ENTRY( "TestAD2GLGSLBCreateItemDrawerL",
                CTestSDKLists::TestAD2GLGSLBCreateItemDrawerL ),
        ENTRY( "TestAD2GLGSLBHandlePointerEventL",
                CTestSDKLists::TestAD2GLGSLBHandlePointerEventL ),
        // class  CAknFormDoubleGraphicStyleListBox
        ENTRY( "TestAFDGSLBSizeChangedL", CTestSDKLists::TestAFDGSLBSizeChangedL ),
        ENTRY( "TestAFDGSLBHandlePointerEventL",
                CTestSDKLists::TestAFDGSLBHandlePointerEventL ),
        // class  CAknFormDoubleStyleListBox
        ENTRY( "TestAFDSLBSizeChangedL", CTestSDKLists::TestAFDSLBSizeChangedL ),
        ENTRY( "TestAFDSLBHandlePointerEventL",
                CTestSDKLists::TestAFDSLBHandlePointerEventL ),
        // class  CAknSettingStyleListBox
        ENTRY( "TestSettingSLBConstructorL", CTestSDKLists::TestSettingSLBConstructorL ),
        ENTRY( "TestSettingSLBSizeChangedL", CTestSDKLists::TestSettingSLBSizeChangedL ),
        ENTRY( "TestSettingSLBMinimumSizeL", CTestSDKLists::TestSettingSLBMinimumSizeL ),
        ENTRY( "TestSettingSLBHandlePointerEventL",
                CTestSDKLists::TestSettingSLBHandlePointerEventL ),
        // class  CAknSettingNumberStyleListBox
        ENTRY( "TestSettingNSLBConstructorL", CTestSDKLists::TestSettingNSLBConstructorL ),
        ENTRY( "TestSettingNSLBSizeChangedL", CTestSDKLists::TestSettingNSLBSizeChangedL ),
        ENTRY( "TestSettingNSLBMinimumSizeL", CTestSDKLists::TestSettingNSLBMinimumSizeL ),
        ENTRY( "TestSettingNSLBHandlePointerEventL",
                CTestSDKLists::TestSettingNSLBHandlePointerEventL ),
        // class  CAknSinglePopupMenuStyleListBox
        ENTRY( "TestSPMSLBSizeChangedL", CTestSDKLists::TestSPMSLBSizeChangedL ),
        ENTRY( "TestSPMSLBMinimumSizeL", CTestSDKLists::TestSPMSLBMinimumSizeL ),
        ENTRY( "TestSPMSLBCreateItemDrawerL", CTestSDKLists::TestSPMSLBCreateItemDrawerL ),
        ENTRY( "TestSPMSLBHandlePointerEventL",
                CTestSDKLists::TestSPMSLBHandlePointerEventL ),
        // class  CAknSingleGraphicPopupMenuStyleListBox
        ENTRY( "TestSGPMSLBSizeChangedL", CTestSDKLists::TestSGPMSLBSizeChangedL ),
        ENTRY( "TestSGPMSLBMinimumSizeL", CTestSDKLists::TestSGPMSLBMinimumSizeL ),
        ENTRY( "TestSGPMSLBCreateItemDrawerL",
                CTestSDKLists::TestSGPMSLBCreateItemDrawerL ),
        ENTRY( "TestSGPMSLBHandlePointerEventL",
                CTestSDKLists::TestSGPMSLBHandlePointerEventL ),
        // class  CAknSingleGraphicBtPopupMenuStyleListBox
        ENTRY( "TestSGBPMSLBSizeChangedL", CTestSDKLists::TestSGBPMSLBSizeChangedL ),
        ENTRY( "TestSGBPMSLBHandlePointerEventL",
                CTestSDKLists::TestSGBPMSLBHandlePointerEventL ),
        // class  CAknSingleHeadingPopupMenuStyleListBox
        ENTRY( "TestSHPMSLBConstructorL", CTestSDKLists::TestSHPMSLBConstructorL ),
        ENTRY( "TestSHPMSLBSizeChangedL", CTestSDKLists::TestSHPMSLBSizeChangedL ),
        ENTRY( "TestSHPMSLBMinimumSizeL", CTestSDKLists::TestSHPMSLBMinimumSizeL ),
        ENTRY( "TestSHPMSLBHandlePointerEventL",
                CTestSDKLists::TestSHPMSLBHandlePointerEventL ),
        ENTRY( "TestSHPMSLBCreateItemDrawerL",
                CTestSDKLists::TestSHPMSLBCreateItemDrawerL ),
        // class  CAknSingleGraphicHeadingPopupMenuStyleListBox
        ENTRY( "TestSGHPMSLBConstructorL", CTestSDKLists::TestSGHPMSLBConstructorL ),
        ENTRY( "TestSGHPMSLBSizeChangedL", CTestSDKLists::TestSGHPMSLBSizeChangedL ),
        ENTRY( "TestSGHPMSLBMinimumSizeL", CTestSDKLists::TestSGHPMSLBMinimumSizeL ),
        ENTRY( "TestSGHPMSLBHandlePointerEventL",
                CTestSDKLists::TestSGHPMSLBHandlePointerEventL ),
        ENTRY( "TestSGHPMSLBCreateItemDrawerL", CTestSDKLists::TestSGHPMSLBCreateItemDrawerL ),
        // class  CAknDoublePopupMenuStyleListBox
        ENTRY( "TestDPMSLBSizeChangedL", CTestSDKLists::TestDPMSLBSizeChangedL ),
        ENTRY( "TestDPMSLBMinimumSizeL", CTestSDKLists::TestDPMSLBMinimumSizeL ),
        ENTRY( "TestDPMSLBHandlePointerEventL", CTestSDKLists::TestDPMSLBHandlePointerEventL ),
        ENTRY( "TestDPMSLBCreateItemDrawerL", CTestSDKLists::TestDPMSLBCreateItemDrawerL ),
        // class  CAknSinglePopupSubmenuStyleListBox
        ENTRY( "TestSPSSLBSizeChangedL", CTestSDKLists::TestSPSSLBSizeChangedL ),
        ENTRY( "TestSPSSLBMinimumSizeL", CTestSDKLists::TestSPSSLBMinimumSizeL ),
        ENTRY( "TestSPSSLBHandlePointerEventL", CTestSDKLists::TestSPSSLBHandlePointerEventL ),
        // class  CAknDoubleLargeGraphicPopupMenuStyleListBox
        ENTRY( "TestDLGPMSLBSizeChangedL", CTestSDKLists::TestDLGPMSLBSizeChangedL ),
        ENTRY( "TestDLGPMSLBMinimumSizeL", CTestSDKLists::TestDLGPMSLBMinimumSizeL ),
        ENTRY( "TestDLGPMSLBHandlePointerEventL",
                CTestSDKLists::TestDLGPMSLBHandlePointerEventL ),
        ENTRY( "TestDLGPMSLBCreateItemDrawerL", CTestSDKLists::TestDLGPMSLBCreateItemDrawerL ),
        // class  CAknDouble2PopupMenuStyleListBox
        ENTRY( "TestD2PMSLBSizeChangedL", CTestSDKLists::TestD2PMSLBSizeChangedL ),
        ENTRY( "TestD2PMSLBMinimumSizeL", CTestSDKLists::TestD2PMSLBMinimumSizeL ),
        ENTRY( "TestD2PMSLBHandlePointerEventL",
                CTestSDKLists::TestD2PMSLBHandlePointerEventL ),
        ENTRY( "TestD2PMSLBCreateItemDrawerL", CTestSDKLists::TestD2PMSLBCreateItemDrawerL ),
        // class  CAknSingle2GraphicPopupMenuStyleListBox
        ENTRY( "TestS2GPMSLBConstructorL", CTestSDKLists::TestS2GPMSLBConstructorL ),
        ENTRY( "TestS2GPMSLBSizeChangedL", CTestSDKLists::TestS2GPMSLBSizeChangedL ),
        ENTRY( "TestS2GPMSLBMinimumSizeL", CTestSDKLists::TestS2GPMSLBMinimumSizeL ),
        ENTRY( "TestS2GPMSLBCreateItemDrawerL",
                CTestSDKLists::TestS2GPMSLBCreateItemDrawerL ),
        ENTRY( "TestS2GPMSLBHandlePointerEventL",
                CTestSDKLists::TestS2GPMSLBHandlePointerEventL ),
        // class  CAknDoubleGraphicPopupMenuStyleListBox
        ENTRY( "TestDGPMSLBConstructorL", CTestSDKLists::TestDGPMSLBConstructorL ),
        ENTRY( "TestDGPMSLBSizeChangedL", CTestSDKLists::TestDGPMSLBSizeChangedL ),
        ENTRY( "TestDGPMSLBMinimumSizeL", CTestSDKLists::TestDGPMSLBMinimumSizeL ),
        ENTRY( "TestDGPMSLBCreateItemDrawerL",
                CTestSDKLists::TestDGPMSLBCreateItemDrawerL ),
        ENTRY( "TestDGPMSLBHandlePointerEventL",
                CTestSDKLists::TestDGPMSLBHandlePointerEventL ),
        // class  CAknSetStyleListBox
        ENTRY( "TestSetSLBConstructWithWindowL",
                CTestSDKLists::TestSetSLBConstructWithWindowL ),
        ENTRY( "TestSetSLBSizeChangedL", CTestSDKLists::TestSetSLBSizeChangedL ),
        ENTRY( "TestSetSLBMinimumSizeL", CTestSDKLists::TestSetSLBMinimumSizeL ),
        ENTRY( "TestSetSLBDrawL", CTestSDKLists::TestSetSLBDrawL ),
        ENTRY( "TestSetSLBMopSupplyObjectL", CTestSDKLists::TestSetSLBMopSupplyObjectL ),
        ENTRY( "TestSetSLBHandlePointerEventL",
                CTestSDKLists::TestSetSLBHandlePointerEventL ),
        ENTRY( "TestSetSLBCreateItemDrawerL", CTestSDKLists::TestSetSLBCreateItemDrawerL ),
        ENTRY( "TestSetSLBMakeViewClassInstanceL",
                CTestSDKLists::TestSetSLBMakeViewClassInstanceL ),
        // class  CAknFormGraphicStyleListBox
        ENTRY( "TestFGSLBConstructWithWindowL",
                CTestSDKLists::TestFGSLBConstructWithWindowL ),
        ENTRY( "TestFGSLBSizeChangedL", CTestSDKLists::TestFGSLBSizeChangedL ),
        ENTRY( "TestFGSLBMinimumSizeL", CTestSDKLists::TestFGSLBMinimumSizeL ),
        ENTRY( "TestFGSLBCreateItemDrawerL", CTestSDKLists::TestFGSLBCreateItemDrawerL ),
        ENTRY( "TestFGSLBAdjustRectHeightToWholeNumberOfItemsL",
                CTestSDKLists::TestFGSLBAdjustRectHeightToWholeNumberOfItemsL ),
        ENTRY( "TestFGSLBHandlePointerEventL",
                CTestSDKLists::TestFGSLBHandlePointerEventL ),
        // class  CAknFormGraphicStyleListBox
        ENTRY( "TestFGWSLBSizeChangedL", CTestSDKLists::TestFGWSLBSizeChangedL ),
        ENTRY( "TestFGWSLBMinimumSizeL", CTestSDKLists::TestFGWSLBMinimumSizeL ),
        ENTRY( "TestFGWSLBHandlePointerEventL",
                CTestSDKLists::TestFGWSLBHandlePointerEventL ),
        // class  CAknPinbStyleGrid
        ENTRY( "TestPSGSizeChangedL", CTestSDKLists::TestPSGSizeChangedL ),
        ENTRY( "TestPSGMinimumSizeL", CTestSDKLists::TestPSGMinimumSizeL ),
        ENTRY( "TestPSGHandlePointerEventL", CTestSDKLists::TestPSGHandlePointerEventL ),
        // class  CAknQdialStyleGrid
        ENTRY( "TestQSGSizeChangedL", CTestSDKLists::TestQSGSizeChangedL ),
        ENTRY( "TestQSGMinimumSizeL", CTestSDKLists::TestQSGMinimumSizeL ),
        ENTRY( "TestQSGHandlePointerEventL", CTestSDKLists::TestQSGHandlePointerEventL ),
        // class  CAknCaleMonthStyleGrid
        ENTRY( "TestCMSGSizeChangedL", CTestSDKLists::TestCMSGSizeChangedL ),
        ENTRY( "TestCMSGMinimumSizeL", CTestSDKLists::TestCMSGMinimumSizeL ),
        ENTRY( "TestCMSGHandlePointerEventL",
                CTestSDKLists::TestCMSGHandlePointerEventL ),
        // class  CAknColumnListBoxView
        ENTRY( "TestACLBVEnableFindEmptyListL",
                CTestSDKLists::TestACLBVEnableFindEmptyListL ),
        ENTRY( "TestACLBVSetFindEmptyListStateL",
                CTestSDKLists::TestACLBVSetFindEmptyListStateL ),
        ENTRY( "TestACLBVDrawEmptyListL", CTestSDKLists::TestACLBVDrawEmptyListL ),
        ENTRY( "TestACLBVCalcBottomItemIndexL",
                CTestSDKLists::TestACLBVCalcBottomItemIndexL ),
        // class  CAknSetStyleListBoxView
        ENTRY( "TestSSLBVDrawEmptyListL", CTestSDKLists::TestSSLBVDrawEmptyListL ),
        // class  CSingleHeadingStyleView
        ENTRY( "TestSHSVDrawL", CTestSDKLists::TestSHSVDrawL ),
        ENTRY( "TestSHSVDrawEmptyListL", CTestSDKLists::TestSHSVDrawEmptyListL ),
        // class  CSingleHeadingStyleItemDrawer
        ENTRY( "TestSHSIDConstructorL", CTestSDKLists::TestSHSIDConstructorL ),
        ENTRY( "TestSHSIDDestructorL", CTestSDKLists::TestSHSIDDestructorL ),
        ENTRY( "TestSHSIDDrawItemL", CTestSDKLists::TestSHSIDDrawItemL ),
        ENTRY( "TestSHSIDSetTopItemIndexL", CTestSDKLists::TestSHSIDSetTopItemIndexL ),
        // class  CDoubleLargeStyleItemDrawer
        ENTRY( "TestDLSIDConstructorL", CTestSDKLists::TestDLSIDConstructorL ),
        ENTRY( "TestDLSIDDrawItemL", CTestSDKLists::TestDLSIDDrawItemL ),
        // class  CWordWrappedFormattedCellItemDrawer
        ENTRY( "TestWWFCIDConstructorL", CTestSDKLists::TestWWFCIDConstructorL ),
        ENTRY( "TestWWFCIDDrawItemL", CTestSDKLists::TestWWFCIDDrawItemL ),
        ENTRY( "TestWWFCIDDrawItemTextL", CTestSDKLists::TestWWFCIDDrawItemTextL ),
        // class  AknListBoxLayouts
        ENTRY( "TestLBLSetupStandardListBoxL",
                CTestSDKLists::TestLBLSetupStandardListBoxL ),
        ENTRY( "TestLBLSetupGridPosL", CTestSDKLists::TestLBLSetupGridPosL ),
        ENTRY( "TestLBLSetupListboxPosL", CTestSDKLists::TestLBLSetupListboxPosL ),
        ENTRY( "TestLBLSetupStandardColumnListboxL",
                CTestSDKLists::TestLBLSetupStandardColumnListboxL ),
        ENTRY( "TestLBLSetupStandardFormListboxL",
                CTestSDKLists::TestLBLSetupStandardFormListboxL ),
        ENTRY( "TestLBLSetupStandardGridL", CTestSDKLists::TestLBLSetupStandardGridL ),
        ENTRY( "TestLBLSetupColumnGfxCellL", CTestSDKLists::TestLBLSetupColumnGfxCellL ),
        ENTRY( "TestLBLSetupColumnTextCellL", CTestSDKLists::TestLBLSetupColumnTextCellL ),
        ENTRY( "TestLBLSetupColumnTextCellTwoL",
                CTestSDKLists::TestLBLSetupColumnTextCellTwoL ),
        ENTRY( "TestLBLSetupFormGfxCellL", CTestSDKLists::TestLBLSetupFormGfxCellL ),
        ENTRY( "TestLBLSetupGridFormGfxCellL",
                CTestSDKLists::TestLBLSetupGridFormGfxCellL ),
        ENTRY( "TestLBLSetupGridFormGfxCellTwoL",
                CTestSDKLists::TestLBLSetupGridFormGfxCellTwoL ),
        ENTRY( "TestLBLSetupFormTextCellL", CTestSDKLists::TestLBLSetupFormTextCellL ),
        ENTRY( "TestLBLSetupFormAntiFlickerTextCellL",
                CTestSDKLists::TestLBLSetupFormAntiFlickerTextCellL ),
        ENTRY( "TestLBLSetupFormTextCellTwoL",
                CTestSDKLists::TestLBLSetupFormTextCellTwoL ),
        ENTRY( "TestLBLSetupFormAntiFlickerTextCellTwoL",
                CTestSDKLists::TestLBLSetupFormAntiFlickerTextCellTwoL ),
        ENTRY( "TestLBLSetupColumnGfxCellTwoL",
                CTestSDKLists::TestLBLSetupColumnGfxCellTwoL ),
        ENTRY( "TestLBLSetupFormGfxCellTwoL", CTestSDKLists::TestLBLSetupFormGfxCellTwoL ),
        ENTRY( "TestLBLSetupListboxPosTwoL", CTestSDKLists::TestLBLSetupListboxPosTwoL ),
        // class AknListBoxUtils
        ENTRY( "TestLBUHandleItemRemovalAndPositionHighlightL",
                CTestSDKLists::TestLBUHandleItemRemovalAndPositionHighlightL ),
        ENTRY( "TestLBUHandleItemRemovalAndPositionHighlightTwoL",
                CTestSDKLists::TestLBUHandleItemRemovalAndPositionHighlightTwoL ),
        ENTRY( "TestLBUListBoxLinesShownL", CTestSDKLists::TestLBUListBoxLinesShownL ),
        // [test cases entries]

        };

    const TInt count = sizeof( KFunctions ) / sizeof( TStifFunctionInfo );

    return RunInternalL( KFunctions, count, aItem );
    }

//  [End of File]
