/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Test application_framework_api
*
*/



#ifndef C_TESTSDKAPPFWAPPUI_H
#define C_TESTSDKAPPFWAPPUI_H

//  INCLUDES
#include "testsdkappfw.h"

/**
*  CTestSDKAppFWAppUi test class for STIF Test Framework TestScripter.
*  @since S60 5.0
*/
NONSHARABLE_CLASS( CTestSDKAppFWAppUiBase ) : public CAknAppUiBase
    {
public:

    /**
     * Constructor.
     */
    CTestSDKAppFWAppUiBase();

    /**
     * Destructor.
     */
    virtual ~CTestSDKAppFWAppUiBase();

    /**
    * From @c CCoeAppUiBase.   
    * Calls CCoeAppUi::HandleScreenDeviceChangedL().
    */
    void ProtectedHandleScreenDeviceChangedL(); // was Reserved_1()

    /**
    * From @c CCoeAppUi. Handles an application specific event.
    * @param aType The type of the event that occurred. This should be a 
    * unique identifier constant.
    * @param aEvent The window server event that occurred. 
    */
    void ProtectedHandleApplicationSpecificEventL( TInt aType, const TWsEvent& aEvent);

    /**
    * Set the application to be a full screen application.
    * @param aIsFullScreen is @c ETrue if the application is a full screen
    * application, @c EFlase otherwise.
    */
    void ProtectedSetFullScreenApp( TBool aIsFullScreen );

    /**
    * Replace current key sound server with new one.
    * @param aUid ID of the new key sound server.
    */
    void ProtectedReplaceKeySoundsL( TInt aUid );

    // from MObjectProvider
    void ProtectedMopSupplyObject( TTypeUid aId );

    // from MEikStatusPaneObserver
    /**
    * From @c MEikStatusPaneObserver. Handles a change in the position or size
    * of the screen area occupied by the status pane.
    */  
    void ProtectedHandleStatusPaneSizeChange();

    };

/**
*  CTestSDKAppFWAppUi test class for STIF Test Framework TestScripter.
*  @since S60 5.0
*/
NONSHARABLE_CLASS( CTestSDKAppFWAppUi ) : public CAknAppUi
    {
public:

    /**
     * Constructor.
     */
    CTestSDKAppFWAppUi();

    /**
     * Destructor.
     */
    virtual ~CTestSDKAppFWAppUi();

    // from MEikStatusPaneObserver
    /**
    * From @c MEikStatusPaneObserver. Handles a change in the position or size
    * of the screen area occupied by the status pane.
    */  
    void ProtectedHandleStatusPaneSizeChange();

    // from CCoeAppUi
    /**
    * From @c CCoeAppUi. Handles system events generated by the window server.
    * @param aEvent The window server event that occurred.
    */
    void ProtectedHandleSystemEventL( const TWsEvent& aEvent );

    /*
     * formerly from MTopSetMember<CEikMenuBar>, now reserved
     */
    void ProtectedReserved_MtsmPosition();

    /*
     * formerly from MTopSetMember<CEikMenuBar>, now reserved
     */
    void ProtectedReserved_MtsmObject();

    /**
    * Handles changes in keyboard focus when an application switches to, 
    * or from, the foreground.
    * @param aForeground @c ETrue if the application is in the foreground,
    * otherwise @c EFalse.
    */
    void ProtectedHandleForegroundEventL( TBool aForeground );

    /**
    * Handles window server events.
    * @param aEvent The window server event that occurred.
    * @param aDestination The control associated with the event.
    */
    void ProtectedHandleWsEventL( const TWsEvent& aEvent,
        CCoeControl* aDestination );

    /**
    * Set key block mode.
    * In default mode, the S60 Developer Platform blocks simultaneous key
    * presses.
    * @param aMode @c ENoKeyBlock if no key block, otherwise
    * @c EDefaultBlockMode
    */
    void ProtectedSetKeyBlockMode( TAknKeyBlockMode aMode );

    void ProtectedHandleErrorL( TInt aError, HBufC** aErrorDesc,
        TBool aShowNote = ETrue );

    };

#endif      // C_TESTSDKAPPFWAPPUI_H

// End of File
