/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  test Aknedsts.h aknipfed.h AknLocationEd.h aknnumed.h AknNumEdwin.h
                      Aknnumseced.h aknuniteditor.h EikCcpu.h EIKEDWIN.H EIKFPNE.H
                      EIKGTED.H EIKMFNE.H EIKRTED.H EIKSECED.H
*
*/



// [INCLUDE FILES]
#include <e32svr.h>
#include <stifparser.h>
#include <stiftestinterface.h>

#include "testsdkeditors.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CTestSDKEditors::RunMethodL
// Run specified method. Contains also table of test mothods and their names.
// -----------------------------------------------------------------------------
//
TInt CTestSDKEditors::RunMethodL( CStifItemParser& aItem ) 
    {

    static TStifFunctionInfo const KFunctions[] =
        {  
        // For editors_api
        // Aknedsts.h
        ENTRY( "TestECSTAknEditorCaseStateL", CTestSDKEditors::TestECSTAknEditorCaseStateL ),
        ENTRY( "TestECSSetCurrentCaseL", CTestSDKEditors::TestECSSetCurrentCaseL ),
        ENTRY( "TestECSSetPreviousCaseL", CTestSDKEditors::TestECSSetPreviousCaseL ),
        ENTRY( "TestECSSetPreviousCaseUsedToEnterTextL", CTestSDKEditors::TestECSSetPreviousCaseUsedToEnterTextL ),
        ENTRY( "TestECSCurrentCaseL", CTestSDKEditors::TestECSCurrentCaseL ),
        ENTRY( "TestECSPreviousCaseL", CTestSDKEditors::TestECSPreviousCaseL ),
        ENTRY( "TestECSPreviousCaseUsedToEnterTextL", CTestSDKEditors::TestECSPreviousCaseUsedToEnterTextL ),
        ENTRY( "TestECSSetFlagL", CTestSDKEditors::TestECSSetFlagL ),
        ENTRY( "TestECSClearFlagL", CTestSDKEditors::TestECSClearFlagL ),
        ENTRY( "TestECSIsFlagSetL", CTestSDKEditors::TestECSIsFlagSetL ),
        ENTRY( "TestESCAknEdwinStateL", CTestSDKEditors::TestESCAknEdwinStateL ),
        ENTRY( "TestESSetObserverL", CTestSDKEditors::TestESSetObserverL ),
        ENTRY( "TestESReportAknEdStateEventL", CTestSDKEditors::TestESReportAknEdStateEventL ),
        ENTRY( "TestESFlagsL", CTestSDKEditors::TestESFlagsL ),
        ENTRY( "TestESDefaultInputModeL", CTestSDKEditors::TestESDefaultInputModeL ),
        ENTRY( "TestESCurrentInputModeL", CTestSDKEditors::TestESCurrentInputModeL ),
        ENTRY( "TestESPermittedInputModesL", CTestSDKEditors::TestESPermittedInputModesL ),
        ENTRY( "TestESDefaultCaseL", CTestSDKEditors::TestESDefaultCaseL ),
        ENTRY( "TestESCurrentCaseL", CTestSDKEditors::TestESCurrentCaseL ),
        ENTRY( "TestESPermittedCasesL", CTestSDKEditors::TestESPermittedCasesL ),
        ENTRY( "TestESDefaultLanguageL", CTestSDKEditors::TestESDefaultLanguageL ),
        ENTRY( "TestESSpecialCharacterTableResourceIdL", CTestSDKEditors::TestESSpecialCharacterTableResourceIdL ),
        ENTRY( "TestESNumericKeymapL", CTestSDKEditors::TestESNumericKeymapL ),
        ENTRY( "TestESCurrentInlineEditSpanL", CTestSDKEditors::TestESCurrentInlineEditSpanL ),
        ENTRY( "TestESCbaStateL", CTestSDKEditors::TestESCbaStateL ),
        ENTRY( "TestESMenuBarL", CTestSDKEditors::TestESMenuBarL ),
        ENTRY( "TestESCcpuStateL", CTestSDKEditors::TestESCcpuStateL ),
        ENTRY( "TestESObjectProviderL", CTestSDKEditors::TestESObjectProviderL ),
        ENTRY( "TestESLocalLanguageL", CTestSDKEditors::TestESLocalLanguageL ),
        ENTRY( "TestESFormAccessorL", CTestSDKEditors::TestESFormAccessorL ),
        ENTRY( "TestESSetFlagsL", CTestSDKEditors::TestESSetFlagsL ),
        ENTRY( "TestESSetDefaultInputModeL", CTestSDKEditors::TestESSetDefaultInputModeL ),
        ENTRY( "TestESSetCurrentInputModeL", CTestSDKEditors::TestESSetCurrentInputModeL ),
        ENTRY( "TestESSetPermittedInputModesL", CTestSDKEditors::TestESSetPermittedInputModesL ),
        ENTRY( "TestESSetDefaultCaseL", CTestSDKEditors::TestESSetDefaultCaseL ),
        ENTRY( "TestESSetCurrentCaseL", CTestSDKEditors::TestESSetCurrentCaseL ),
        ENTRY( "TestESSetPermittedCasesL", CTestSDKEditors::TestESSetPermittedCasesL ),
        ENTRY( "TestESSetDefaultLanguageL", CTestSDKEditors::TestESSetDefaultLanguageL ),
        ENTRY( "TestESSetSpecialCharacterTableResourceIdL", CTestSDKEditors::TestESSetSpecialCharacterTableResourceIdL ),
        ENTRY( "TestESSetNumericKeymapL", CTestSDKEditors::TestESSetNumericKeymapL ),
        ENTRY( "TestESSetInlineEditSpanL", CTestSDKEditors::TestESSetInlineEditSpanL ),
        ENTRY( "TestESSetCbaL", CTestSDKEditors::TestESSetCbaL ),
        ENTRY( "TestESSetMenuL", CTestSDKEditors::TestESSetMenuL ),
        ENTRY( "TestESSetObjectProviderL", CTestSDKEditors::TestESSetObjectProviderL ),
        ENTRY( "TestESSetLocalLanguageL", CTestSDKEditors::TestESSetLocalLanguageL ),
        ENTRY( "TestESSetFormAccessorL", CTestSDKEditors::TestESSetFormAccessorL ),
        ENTRY( "TestESSetCcpuStateL", CTestSDKEditors::TestESSetCcpuStateL ),
        ENTRY( "TestESSetMiddleSoftkeyCommandIdL", CTestSDKEditors::TestESSetMiddleSoftkeyCommandIdL ),
        ENTRY( "TestESMiddleSoftkeyCommandIdL", CTestSDKEditors::TestESMiddleSoftkeyCommandIdL ),
        
        // aknipfed.h
        ENTRY( "TestIPFECAknIpFieldEditorL", CTestSDKEditors::TestIPFECAknIpFieldEditorL ),
        ENTRY( "TestIPFEPNewL", CTestSDKEditors::TestIPFEPNewL ),
        ENTRY( "TestIPFENewL", CTestSDKEditors::TestIPFENewL ),
        ENTRY( "TestIPFESetAddressL", CTestSDKEditors::TestIPFESetAddressL ),
        ENTRY( "TestIPFEAddressL", CTestSDKEditors::TestIPFEAddressL ),
        ENTRY( "TestIPFESetMinimumAndMaximumL", CTestSDKEditors::TestIPFESetMinimumAndMaximumL ),
        ENTRY( "TestIPFEGetMinimumAndMaximumL", CTestSDKEditors::TestIPFEGetMinimumAndMaximumL ),
        ENTRY( "TestIPFEReadIPAddressL", CTestSDKEditors::TestIPFEReadIPAddressL ),
        ENTRY( "TestIPFEConstructFromResourceL", CTestSDKEditors::TestIPFEConstructFromResourceL ),
        ENTRY( "TestIPFEOfferKeyEventL", CTestSDKEditors::TestIPFEOfferKeyEventL ),
        ENTRY( "TestIPFEHandlePointerEventL", CTestSDKEditors::TestIPFEHandlePointerEventL ),
        
        // AknLocationEd.h
        ENTRY( "TestLECAknLocationEditorL", CTestSDKEditors::TestLECAknLocationEditorL ),
        ENTRY( "TestLEDeconstructorL", CTestSDKEditors::TestLEDeconstructorL ),
        ENTRY( "TestLENewL", CTestSDKEditors::TestLENewL ),
        ENTRY( "TestLEConstructFromResourceL", CTestSDKEditors::TestLEConstructFromResourceL ),
        ENTRY( "TestLEDisplayableLocationL", CTestSDKEditors::TestLEDisplayableLocationL ),
        ENTRY( "TestLEPrepareForFocusLossL", CTestSDKEditors::TestLEPrepareForFocusLossL ),
        ENTRY( "TestLESetL", CTestSDKEditors::TestLESetL ),
        ENTRY( "TestLEGetL", CTestSDKEditors::TestLEGetL ),
        ENTRY( "TestLEOfferKeyEventL", CTestSDKEditors::TestLEOfferKeyEventL ),
        ENTRY( "TestLECAknLocationEditor_ExtensionInterfaceL", CTestSDKEditors::TestLECAknLocationEditor_ExtensionInterfaceL ),
        
        // AknNumed.h
        ENTRY( "TestNEDeconstructorL", CTestSDKEditors::TestNEDeconstructorL ),
        ENTRY( "TestNEMapKeyEventL", CTestSDKEditors::TestNEMapKeyEventL ),
        ENTRY( "TestNEHandlePointerEventL", CTestSDKEditors::TestNEHandlePointerEventL ),
        
        // AknNumEdwin.h
        ENTRY( "TestIENewL", CTestSDKEditors::TestIENewL ),
        ENTRY( "TestIEConstructFromResourceL", CTestSDKEditors::TestIEConstructFromResourceL ),
        ENTRY( "TestIEConstructL", CTestSDKEditors::TestIEConstructL ),
        ENTRY( "TestIESetValueL", CTestSDKEditors::TestIESetValueL ),
        ENTRY( "TestIESetUnsetValueL", CTestSDKEditors::TestIESetUnsetValueL ),
        ENTRY( "TestIEGetTextAsIntegerL", CTestSDKEditors::TestIEGetTextAsIntegerL ),
        ENTRY( "TestIESetMinimumIntegerValueL", CTestSDKEditors::TestIESetMinimumIntegerValueL ),
        ENTRY( "TestIESetMaximumIntegerValueL", CTestSDKEditors::TestIESetMaximumIntegerValueL ),
        ENTRY( "TestIEPrepareForFocusLossL", CTestSDKEditors::TestIEPrepareForFocusLossL ),
        ENTRY( "TestIEHandleResourceChangeL", CTestSDKEditors::TestIEHandleResourceChangeL ),
        ENTRY( "TestIEOfferKeyEventL", CTestSDKEditors::TestIEOfferKeyEventL ),
        ENTRY( "TestIEHandlePointerEventL", CTestSDKEditors::TestIEHandlePointerEventL ),
        ENTRY( "TestIECheckNumberL", CTestSDKEditors::TestIECheckNumberL ),
        
        // Aknnumseced.h
        ENTRY( "TestNSECAknNumericSecretEditorL", CTestSDKEditors::TestNSECAknNumericSecretEditorL ),
        ENTRY( "TestNSEInputCapabilitiesL", CTestSDKEditors::TestNSEInputCapabilitiesL ),
        ENTRY( "TestNSEHandlePointerEventL", CTestSDKEditors::TestNSEHandlePointerEventL ),
        ENTRY( "TestNSEAppendCharacterL", CTestSDKEditors::TestNSEAppendCharacterL ),
        ENTRY( "TestNSECreateFepStateL", CTestSDKEditors::TestNSECreateFepStateL ),
        
        // aknuniteditor.h
        ENTRY( "TestUENewL", CTestSDKEditors::TestUENewL ),
        ENTRY( "TestUENewLC", CTestSDKEditors::TestUENewLC ),
        ENTRY( "TestUEConstructL", CTestSDKEditors::TestUEConstructL ),
        ENTRY( "TestUEConstructFromResourceL", CTestSDKEditors::TestUEConstructFromResourceL ),
        ENTRY( "TestUESetValueL", CTestSDKEditors::TestUESetValueL ),
        ENTRY( "TestUEValueL", CTestSDKEditors::TestUEValueL ),
        ENTRY( "TestUESupportsUnitL", CTestSDKEditors::TestUESupportsUnitL ),
        ENTRY( "TestUESetUnitL", CTestSDKEditors::TestUESetUnitL ),
        ENTRY( "TestUESetUnitUL", CTestSDKEditors::TestUESetUnitUL ),
        ENTRY( "TestUEGetUnitL", CTestSDKEditors::TestUEGetUnitL ),
        ENTRY( "TestUEUnitL", CTestSDKEditors::TestUEUnitL ),
        ENTRY( "TestUESetMaxFractionalDigitsL", CTestSDKEditors::TestUESetMaxFractionalDigitsL ),
        ENTRY( "TestUEMaxFractionalDigitsL", CTestSDKEditors::TestUEMaxFractionalDigitsL ),
        ENTRY( "TestUESetMinimumAndMaximumL", CTestSDKEditors::TestUESetMinimumAndMaximumL ),
        ENTRY( "TestUEGetMinimumAndMaximumL", CTestSDKEditors::TestUEGetMinimumAndMaximumL ),
        ENTRY( "TestUESetFlagsL", CTestSDKEditors::TestUESetFlagsL ),
        ENTRY( "TestUEFlagsL", CTestSDKEditors::TestUEFlagsL ),
        ENTRY( "TestUEPrepareForFocusLossL", CTestSDKEditors::TestUEPrepareForFocusLossL ),
        
        // EikCcpu.h
        ENTRY( "TestCCAknCcpuSupportL", CTestSDKEditors::TestCCAknCcpuSupportL ),
        ENTRY( "TestCDeconstructorL", CTestSDKEditors::TestCDeconstructorL ),
        ENTRY( "TestCConstructL", CTestSDKEditors::TestCConstructL ),
        ENTRY( "TestCHandleSelectionChangeL", CTestSDKEditors::TestCHandleSelectionChangeL ),
        ENTRY( "TestCHandleFocusChangeL", CTestSDKEditors::TestCHandleFocusChangeL ),
        ENTRY( "TestCOfferKeyEventL", CTestSDKEditors::TestCOfferKeyEventL ),
        ENTRY( "TestCHandlePointerEventL", CTestSDKEditors::TestCHandlePointerEventL ),
        ENTRY( "TestCDynInitMenuPaneL", CTestSDKEditors::TestCDynInitMenuPaneL ),
        ENTRY( "TestCProcessCommandL", CTestSDKEditors::TestCProcessCommandL ),
        
        // EIKFPNE.h
        ENTRY( "TestFPECEikFloatingPointEditorL", CTestSDKEditors::TestFPECEikFloatingPointEditorL ),
        ENTRY( "TestFPEConstructL", CTestSDKEditors::TestFPEConstructL ),
        ENTRY( "TestFPEValueL", CTestSDKEditors::TestFPEValueL ),
        ENTRY( "TestFPEGetValueAsRealL", CTestSDKEditors::TestFPEGetValueAsRealL ),
        ENTRY( "TestFPESetValueL", CTestSDKEditors::TestFPESetValueL ),
        ENTRY( "TestFPESetMinMaxL", CTestSDKEditors::TestFPESetMinMaxL ),
        ENTRY( "TestFPEGetMinMaxL", CTestSDKEditors::TestFPEGetMinMaxL ),
        ENTRY( "TestFPEConstructFromResourceL", CTestSDKEditors::TestFPEConstructFromResourceL ),
        ENTRY( "TestFPEPrepareForFocusLossL", CTestSDKEditors::TestFPEPrepareForFocusLossL ),
        ENTRY( "TestFPEInputCapabilitiesL", CTestSDKEditors::TestFPEInputCapabilitiesL ),
        ENTRY( "TestFPEOfferKeyEventL", CTestSDKEditors::TestFPEOfferKeyEventL ),
        ENTRY( "TestFPEHandleResourceChangeL", CTestSDKEditors::TestFPEHandleResourceChangeL ),
        ENTRY( "TestFPEHandlePointerEventL", CTestSDKEditors::TestFPEHandlePointerEventL ),
        ENTRY( "TestXPECEikFixedPointEditorL", CTestSDKEditors::TestXPECEikFixedPointEditorL ),
        ENTRY( "TestXPEConstructL", CTestSDKEditors::TestXPEConstructL ),
        ENTRY( "TestXPEValueL", CTestSDKEditors::TestXPEValueL ),
        ENTRY( "TestXPEGetValueAsIntegerL", CTestSDKEditors::TestXPEGetValueAsIntegerL ),
        ENTRY( "TestXPESetValueL", CTestSDKEditors::TestXPESetValueL ),
        ENTRY( "TestXPESetMinMaxrL", CTestSDKEditors::TestXPESetMinMaxrL ),
        ENTRY( "TestXPEGetMinMaxL", CTestSDKEditors::TestXPEGetMinMaxL ),
        ENTRY( "TestXPESetDecimalPlacesL", CTestSDKEditors::TestXPESetDecimalPlacesL ),
        ENTRY( "TestXPEDecimalPlacesL", CTestSDKEditors::TestXPEDecimalPlacesL ),
        ENTRY( "TestXPEConstructFromResourceL", CTestSDKEditors::TestXPEConstructFromResourceL ),
        ENTRY( "TestXPEPrepareForFocusLossL", CTestSDKEditors::TestXPEPrepareForFocusLossL ),
        ENTRY( "TestXPEInputCapabilitiesL", CTestSDKEditors::TestXPEInputCapabilitiesL ),
        ENTRY( "TestXPEOfferKeyEventL", CTestSDKEditors::TestXPEOfferKeyEventL ),
        ENTRY( "TestXPEHandleResourceChangeL", CTestSDKEditors::TestXPEHandleResourceChangeL ),
        ENTRY( "TestXPEHandlePointerEventL", CTestSDKEditors::TestXPEHandlePointerEventL ),
                
        // EIKEDWIN.h
        ENTRY( "TestEFAFormAccessorL", CTestSDKEditors::TestEFAFormAccessorL ),
        ENTRY( "TestEFASetFormAccessorL", CTestSDKEditors::TestEFASetFormAccessorL ),
        ENTRY( "TestEFASetScrollBarSetterL", CTestSDKEditors::TestEFASetScrollBarSetterL ),
        ENTRY( "TestEFAScrollBarSetterL", CTestSDKEditors::TestEFAScrollBarSetterL ),
        ENTRY( "TestEFATextWrapperL", CTestSDKEditors::TestEFATextWrapperL ),
        ENTRY( "TestEFAFormCursorModifierL", CTestSDKEditors::TestEFAFormCursorModifierL ),
        ENTRY( "TestEDeconstrutorL", CTestSDKEditors::TestEDeconstrutorL ),
        ENTRY( "TestECEikEdwinL", CTestSDKEditors::TestECEikEdwinL ),
        ENTRY( "TestECEikEdwinPL", CTestSDKEditors::TestECEikEdwinPL ),
        ENTRY( "TestEConstructL", CTestSDKEditors::TestEConstructL ),
        ENTRY( "TestESetEdwinObserverL", CTestSDKEditors::TestESetEdwinObserverL ),
        ENTRY( "TestEAddEdwinObserverL", CTestSDKEditors::TestEAddEdwinObserverL ),
        ENTRY( "TestERemoveEdwinObserverL", CTestSDKEditors::TestERemoveEdwinObserverL ),
        ENTRY( "TestESetContainerWindowL", CTestSDKEditors::TestESetContainerWindowL ),
        ENTRY( "TestESetDocumentContentL", CTestSDKEditors::TestESetDocumentContentL ),
        ENTRY( "TestEOfferKeyEventL", CTestSDKEditors::TestEOfferKeyEventL ),
        ENTRY( "TestEFocusChangedL", CTestSDKEditors::TestEFocusChangedL ),
        ENTRY( "TestEActivateL", CTestSDKEditors::TestEActivateL ),
        ENTRY( "TestEConstructFromResourceL", CTestSDKEditors::TestEConstructFromResourceL ),
        ENTRY( "TestEHandlePointerEventL", CTestSDKEditors::TestEHandlePointerEventL ),
        ENTRY( "TestEMinimumSizeL", CTestSDKEditors::TestEMinimumSizeL ),
        ENTRY( "TestEDrawL", CTestSDKEditors::TestEDrawL ),
        ENTRY( "TestESetDimmedL", CTestSDKEditors::TestESetDimmedL ),
        ENTRY( "TestESetContainerWindowPL", CTestSDKEditors::TestESetContainerWindowPL ),
        ENTRY( "TestEGetColorUseListL", CTestSDKEditors::TestEGetColorUseListL ),
        ENTRY( "TestEHandleResourceChangeL", CTestSDKEditors::TestEHandleResourceChangeL ),
        ENTRY( "TestEInputCapabilitiesL", CTestSDKEditors::TestEInputCapabilitiesL ),
        ENTRY( "TestESetInputCapabilitiesL", CTestSDKEditors::TestESetInputCapabilitiesL ),
        ENTRY( "TestEWriteInternalStateL", CTestSDKEditors::TestEWriteInternalStateL ),
        ENTRY( "TestEHandleScrollEventL", CTestSDKEditors::TestEHandleScrollEventL ),
        ENTRY( "TestEOnReformatL", CTestSDKEditors::TestEOnReformatL ),
        ENTRY( "TestETextLengthL", CTestSDKEditors::TestETextLengthL ),
        ENTRY( "TestECursorPosL", CTestSDKEditors::TestECursorPosL ),
        ENTRY( "TestESelectionLengthL", CTestSDKEditors::TestESelectionLengthL ),
        ENTRY( "TestESelectionL", CTestSDKEditors::TestESelectionL ),
        ENTRY( "TestEClearSelectionL", CTestSDKEditors::TestEClearSelectionL ),
        ENTRY( "TestESetSelectionL", CTestSDKEditors::TestESetSelectionL ),
        ENTRY( "TestESetCursorPosL", CTestSDKEditors::TestESetCursorPosL ),
        ENTRY( "TestESelectAllL", CTestSDKEditors::TestESelectAllL ),
        ENTRY( "TestECalculateWidthL", CTestSDKEditors::TestECalculateWidthL ),
        ENTRY( "TestEGetTextL", CTestSDKEditors::TestEGetTextL ),
        ENTRY( "TestEGetTextInHBufL", CTestSDKEditors::TestEGetTextInHBufL ),
        ENTRY( "TestESetTextL", CTestSDKEditors::TestESetTextL ),
        ENTRY( "TestEClipboardL", CTestSDKEditors::TestEClipboardL ),
        ENTRY( "TestEInsertFieldL", CTestSDKEditors::TestEInsertFieldL ),
        ENTRY( "TestEUpdateAllFieldsL", CTestSDKEditors::TestEUpdateAllFieldsL ),
        ENTRY( "TestEUpdateCurrentFieldL", CTestSDKEditors::TestEUpdateCurrentFieldL ),
        ENTRY( "TestECountWordsL", CTestSDKEditors::TestECountWordsL ),
        ENTRY( "TestEInsertFromTextFileL", CTestSDKEditors::TestEInsertFromTextFileL ),
        ENTRY( "TestEIdleL", CTestSDKEditors::TestEIdleL ),
        ENTRY( "TestETextL", CTestSDKEditors::TestETextL ),
        ENTRY( "TestECancelFepTransactionL", CTestSDKEditors::TestECancelFepTransactionL ),
        ENTRY( "TestEHandleTextChangedL", CTestSDKEditors::TestEHandleTextChangedL ),
        ENTRY( "TestELayoutWidthL", CTestSDKEditors::TestELayoutWidthL ),
        ENTRY( "TestENotifyNewDocumentL", CTestSDKEditors::TestENotifyNewDocumentL ),
        ENTRY( "TestENotifyNewFormatL", CTestSDKEditors::TestENotifyNewFormatL ),
        ENTRY( "TestEFindL", CTestSDKEditors::TestEFindL ),
        ENTRY( "TestEFindTextL", CTestSDKEditors::TestEFindTextL ),
        ENTRY( "TestEReplaceL", CTestSDKEditors::TestEReplaceL ),
        ENTRY( "TestEReplaceAllL", CTestSDKEditors::TestEReplaceAllL ),
        ENTRY( "TestEGetFindTextL", CTestSDKEditors::TestEGetFindTextL ),
        ENTRY( "TestEUpdateScrollBarsL", CTestSDKEditors::TestEUpdateScrollBarsL ),
        ENTRY( "TestECreateScrollBarFrameL", CTestSDKEditors::TestECreateScrollBarFrameL ),
        ENTRY( "TestECreatePreAllocatedScrollBarFrameL", CTestSDKEditors::TestECreatePreAllocatedScrollBarFrameL ),
        ENTRY( "TestEScrollBarFrameL", CTestSDKEditors::TestEScrollBarFrameL ),
        ENTRY( "TestESetWordWrapL", CTestSDKEditors::TestESetWordWrapL ),
        ENTRY( "TestELineCursorWidthL", CTestSDKEditors::TestELineCursorWidthL ),
        ENTRY( "TestESetZoomFactorL", CTestSDKEditors::TestESetZoomFactorL ),
        ENTRY( "TestESetBackgroundColorL", CTestSDKEditors::TestESetBackgroundColorL ),
        ENTRY( "TestESetWysiwygModeOnL", CTestSDKEditors::TestESetWysiwygModeOnL ),
        ENTRY( "TestESetWysiwygModeOffL", CTestSDKEditors::TestESetWysiwygModeOffL ),
        ENTRY( "TestEUpdateLayoutWidthL", CTestSDKEditors::TestEUpdateLayoutWidthL ),
        ENTRY( "TestESendDataOverIrL", CTestSDKEditors::TestESendDataOverIrL ),
        ENTRY( "TestEReceiveDataOverIrL", CTestSDKEditors::TestEReceiveDataOverIrL ),
        ENTRY( "TestESetAmountToFormatL", CTestSDKEditors::TestESetAmountToFormatL ),
        ENTRY( "TestESetAmountToFormatPL", CTestSDKEditors::TestESetAmountToFormatPL ),
        ENTRY( "TestESetPasteFromIrStoreL", CTestSDKEditors::TestESetPasteFromIrStoreL ),
        ENTRY( "TestEPasteFromStoreL", CTestSDKEditors::TestEPasteFromStoreL ),
        ENTRY( "TestECopyToStoreL", CTestSDKEditors::TestECopyToStoreL ),
        ENTRY( "TestESetBorderViewMarginsL", CTestSDKEditors::TestESetBorderViewMarginsL ),
        ENTRY( "TestEForceScrollBarUpdateL", CTestSDKEditors::TestEForceScrollBarUpdateL ),
        ENTRY( "TestESetDocumentOwnershipL", CTestSDKEditors::TestESetDocumentOwnershipL ),
        ENTRY( "TestESetTextLimitL", CTestSDKEditors::TestESetTextLimitL ),
        ENTRY( "TestERunCharMapDialogL", CTestSDKEditors::TestERunCharMapDialogL ),
        ENTRY( "TestEMarginsL", CTestSDKEditors::TestEMarginsL ),
        ENTRY( "TestEUpperFullFormattingLengthL", CTestSDKEditors::TestEUpperFullFormattingLengthL ),
        ENTRY( "TestELowerPartialFormattingLengthL", CTestSDKEditors::TestELowerPartialFormattingLengthL ),
        ENTRY( "TestESetReadOnlyL", CTestSDKEditors::TestESetReadOnlyL ),
        ENTRY( "TestEIsReadOnlyL", CTestSDKEditors::TestEIsReadOnlyL ),
        ENTRY( "TestECheckNotReadOnlyL", CTestSDKEditors::TestECheckNotReadOnlyL ),
        ENTRY( "TestESetAllowPicturesL", CTestSDKEditors::TestESetAllowPicturesL ),
        ENTRY( "TestECheckRemovePicturesL", CTestSDKEditors::TestECheckRemovePicturesL ),
        ENTRY( "TestESetRightWrapGutterL", CTestSDKEditors::TestESetRightWrapGutterL ),
        ENTRY( "TestEUndoL", CTestSDKEditors::TestEUndoL ),
        ENTRY( "TestEClearUndoL", CTestSDKEditors::TestEClearUndoL ),
        ENTRY( "TestESetAllowUndoL", CTestSDKEditors::TestESetAllowUndoL ),
        ENTRY( "TestESupportsUndoL", CTestSDKEditors::TestESupportsUndoL ),
        ENTRY( "TestECanUndoL", CTestSDKEditors::TestECanUndoL ),
        ENTRY( "TestESetWordDelimitersL", CTestSDKEditors::TestESetWordDelimitersL ),
        ENTRY( "TestEGetWordInfoL", CTestSDKEditors::TestEGetWordInfoL ),
        ENTRY( "TestEMoveCursorL", CTestSDKEditors::TestEMoveCursorL ),
        ENTRY( "TestEMoveDisplayL", CTestSDKEditors::TestEMoveDisplayL ),
        ENTRY( "TestECheckValidityOfCharsL", CTestSDKEditors::TestECheckValidityOfCharsL ),
        ENTRY( "TestESetOnlyASCIICharsL", CTestSDKEditors::TestESetOnlyASCIICharsL ),
        ENTRY( "TestEOnlyASCIICharsL", CTestSDKEditors::TestEOnlyASCIICharsL ),
        ENTRY( "TestEAvgLinesInViewRectL", CTestSDKEditors::TestEAvgLinesInViewRectL ),
        ENTRY( "TestEAvgCharsPerLineL", CTestSDKEditors::TestEAvgCharsPerLineL ),
        ENTRY( "TestESetAvgLinesInViewRectL", CTestSDKEditors::TestESetAvgLinesInViewRectL ),
        ENTRY( "TestESetAvgCharsPerLineL", CTestSDKEditors::TestESetAvgCharsPerLineL ),
        ENTRY( "TestESetEdwinSizeObserverL", CTestSDKEditors::TestESetEdwinSizeObserverL ),
        ENTRY( "TestEMinimumHeightL", CTestSDKEditors::TestEMinimumHeightL ),
        ENTRY( "TestEMaximumHeightL", CTestSDKEditors::TestEMaximumHeightL ),
        ENTRY( "TestESetMinimumHeightL", CTestSDKEditors::TestESetMinimumHeightL ),
        ENTRY( "TestESetMaximumHeightL", CTestSDKEditors::TestESetMaximumHeightL ),
        ENTRY( "TestEInsertDeleteCharsL", CTestSDKEditors::TestEInsertDeleteCharsL ),
        ENTRY( "TestESetNonPrintingCharsVisibilityL", CTestSDKEditors::TestESetNonPrintingCharsVisibilityL ),
        ENTRY( "TestENonPrintingCharsVisibilityL", CTestSDKEditors::TestENonPrintingCharsVisibilityL ),
        ENTRY( "TestESetAvkonWrapL", CTestSDKEditors::TestESetAvkonWrapL ),
        ENTRY( "TestESetAknEditorCaseL", CTestSDKEditors::TestESetAknEditorCaseL ),
        ENTRY( "TestESetAknEditorPermittedCaseModesL", CTestSDKEditors::TestESetAknEditorPermittedCaseModesL ),
        ENTRY( "TestESetAknEditorNumericKeymapL", CTestSDKEditors::TestESetAknEditorNumericKeymapL ),
        ENTRY( "TestESetAknEditorInputModeL", CTestSDKEditors::TestESetAknEditorInputModeL ),
        ENTRY( "TestESetAknEditorAllowedInputModesL", CTestSDKEditors::TestESetAknEditorAllowedInputModesL ),
        ENTRY( "TestESetAknEditorSpecialCharacterTableL", CTestSDKEditors::TestESetAknEditorSpecialCharacterTableL ),
        ENTRY( "TestESetAknEditorFlagsL", CTestSDKEditors::TestESetAknEditorFlagsL ),
        ENTRY( "TestEEnableCcpuSupportL", CTestSDKEditors::TestEEnableCcpuSupportL ),
        ENTRY( "TestESetAknEditorCurrentInputModeL", CTestSDKEditors::TestESetAknEditorCurrentInputModeL ),
        ENTRY( "TestEAknEditorCurrentInputModeL", CTestSDKEditors::TestEAknEditorCurrentInputModeL ),
        ENTRY( "TestESetAknEditorCurrentCaseL", CTestSDKEditors::TestESetAknEditorCurrentCaseL ),
        ENTRY( "TestESetAknEditorLocalLanguageL", CTestSDKEditors::TestESetAknEditorLocalLanguageL ),
        ENTRY( "TestENotifyEditorStateObserverOfStateChangeL", CTestSDKEditors::TestENotifyEditorStateObserverOfStateChangeL ),
        ENTRY( "TestESetSuppressBackgroundDrawingL", CTestSDKEditors::TestESetSuppressBackgroundDrawingL ),
        ENTRY( "TestEIsBackgroundDrawingSuppressedL", CTestSDKEditors::TestEIsBackgroundDrawingSuppressedL ),
        ENTRY( "TestESetTextLinesRectL", CTestSDKEditors::TestESetTextLinesRectL ),
        ENTRY( "TestESetScrollRectL", CTestSDKEditors::TestESetScrollRectL ),
        ENTRY( "TestEGetTextLinesRectL", CTestSDKEditors::TestEGetTextLinesRectL ),
        ENTRY( "TestESetCursorVisibleL", CTestSDKEditors::TestESetCursorVisibleL ),
        ENTRY( "TestESetMaximumHeightInLinesL", CTestSDKEditors::TestESetMaximumHeightInLinesL ),
        ENTRY( "TestEMaximumHeightInLinesL", CTestSDKEditors::TestEMaximumHeightInLinesL ),
        ENTRY( "TestECcpuIsFocusedL", CTestSDKEditors::TestECcpuIsFocusedL ),
        ENTRY( "TestECcpuCanCutL", CTestSDKEditors::TestECcpuCanCutL ),
        ENTRY( "TestECcpuCutL", CTestSDKEditors::TestECcpuCutL ),
        ENTRY( "TestECcpuCanCopyL", CTestSDKEditors::TestECcpuCanCopyL ),
        ENTRY( "TestECcpuCopyL", CTestSDKEditors::TestECcpuCopyL ),
        ENTRY( "TestECcpuCanPasteL", CTestSDKEditors::TestECcpuCanPasteL ),
        ENTRY( "TestECcpuPasteL", CTestSDKEditors::TestECcpuPasteL ),
        ENTRY( "TestECcpuCanUndoL", CTestSDKEditors::TestECcpuCanUndoL ),
        ENTRY( "TestECcpuUndoL", CTestSDKEditors::TestECcpuUndoL ),
        ENTRY( "TestEAknEdwinFlagsL", CTestSDKEditors::TestEAknEdwinFlagsL ),
        ENTRY( "TestECreateTextViewL", CTestSDKEditors::TestECreateTextViewL ),
        ENTRY( "TestETextViewL", CTestSDKEditors::TestETextViewL ),
        ENTRY( "TestETextLayoutL", CTestSDKEditors::TestETextLayoutL ),
        ENTRY( "TestESetUndoBufferL", CTestSDKEditors::TestESetUndoBufferL ),
        ENTRY( "TestESetUndoableTextL", CTestSDKEditors::TestESetUndoableTextL ),
        ENTRY( "TestESetMaxLengthL", CTestSDKEditors::TestESetMaxLengthL ),
        ENTRY( "TestEMaxLengthL", CTestSDKEditors::TestEMaxLengthL ),
        ENTRY( "TestEAddFlagToUserFlagsL", CTestSDKEditors::TestEAddFlagToUserFlagsL ),
        ENTRY( "TestERemoveFlagFromUserFlagsL", CTestSDKEditors::TestERemoveFlagFromUserFlagsL ),
        ENTRY( "TestEUserFlagsL", CTestSDKEditors::TestEUserFlagsL ),
        ENTRY( "TestESetCharFormatLayerL", CTestSDKEditors::TestESetCharFormatLayerL ),
        ENTRY( "TestESetParaFormatLayerL", CTestSDKEditors::TestESetParaFormatLayerL ),
        ENTRY( "TestESetSkinBackgroundControlContextL", CTestSDKEditors::TestESetSkinBackgroundControlContextL ),
        ENTRY( "TestESetAlignmentL", CTestSDKEditors::TestESetAlignmentL ),
        ENTRY( "TestESetPictographAnimationCallBackL", CTestSDKEditors::TestESetPictographAnimationCallBackL ),
        ENTRY( "TestESetUpperFullFormattingLengthL", CTestSDKEditors::TestESetUpperFullFormattingLengthL ),
        ENTRY( "TestESetSuppressNotifyDrawL", CTestSDKEditors::TestESetSuppressNotifyDrawL ),
        ENTRY( "TestESetSuppressFormattingL", CTestSDKEditors::TestESetSuppressFormattingL ),
        ENTRY( "TestEEditObserverL", CTestSDKEditors::TestEEditObserverL ),
        ENTRY( "TestETrappedDrawL", CTestSDKEditors::TestETrappedDrawL ),
        ENTRY( "TestEDrawContentsL", CTestSDKEditors::TestEDrawContentsL ),
        ENTRY( "TestEBaseConstructL", CTestSDKEditors::TestEBaseConstructL ),
        ENTRY( "TestEFormatTextL", CTestSDKEditors::TestEFormatTextL ),
        ENTRY( "TestEDeleteHighlightL", CTestSDKEditors::TestEDeleteHighlightL ),
        ENTRY( "TestEOkToDeleteSelectionL", CTestSDKEditors::TestEOkToDeleteSelectionL ),
        ENTRY( "TestEDeleteL", CTestSDKEditors::TestEDeleteL ),
        ENTRY( "TestETrappedSizeChangedL", CTestSDKEditors::TestETrappedSizeChangedL ),
        ENTRY( "TestEHandleSizeChangedL", CTestSDKEditors::TestEHandleSizeChangedL ),
        ENTRY( "TestECancelSelectionL", CTestSDKEditors::TestECancelSelectionL ),
        ENTRY( "TestEMoveCursorToChunkStartL", CTestSDKEditors::TestEMoveCursorToChunkStartL ),
        ENTRY( "TestECancelInsertCharFormatL", CTestSDKEditors::TestECancelInsertCharFormatL ),
        ENTRY( "TestEPlaceDataOnClipboardL", CTestSDKEditors::TestEPlaceDataOnClipboardL ),
        ENTRY( "TestEReportEdwinEventL", CTestSDKEditors::TestEReportEdwinEventL ),
        ENTRY( "TestESetLineCursorDetailsL", CTestSDKEditors::TestESetLineCursorDetailsL ),
        ENTRY( "TestECopyDocumentContentL", CTestSDKEditors::TestECopyDocumentContentL ),
        ENTRY( "TestEDisplayFindTextNotFoundL", CTestSDKEditors::TestEDisplayFindTextNotFoundL ),
        ENTRY( "TestEHandleTextPastedL", CTestSDKEditors::TestEHandleTextPastedL ),
        ENTRY( "TestECreateCustomDrawL", CTestSDKEditors::TestECreateCustomDrawL ),
        ENTRY( "TestEReadAknResourceL", CTestSDKEditors::TestEReadAknResourceL ),
        ENTRY( "TestECreateLayoutL", CTestSDKEditors::TestECreateLayoutL ),
        ENTRY( "TestECreateTextAndLayoutL", CTestSDKEditors::TestECreateTextAndLayoutL ),
        ENTRY( "TestECheckEdwinExtensionL", CTestSDKEditors::TestECheckEdwinExtensionL ),
        ENTRY( "TestEEdwinExtensionL", CTestSDKEditors::TestEEdwinExtensionL ),
        ENTRY( "TestEMopSupplyObjectL", CTestSDKEditors::TestEMopSupplyObjectL ),
        ENTRY( "TestESetTextSkinColorIdL", CTestSDKEditors::TestESetTextSkinColorIdL ),
        ENTRY( "TestESetHighlightStyleL", CTestSDKEditors::TestESetHighlightStyleL ),
        
        ENTRY( "TestGETCEikGlobalTextEditorL", CTestSDKEditors::TestGETCEikGlobalTextEditorL ),
        ENTRY( "TestGETCEikGlobalTextEditorPL", CTestSDKEditors::TestGETCEikGlobalTextEditorPL ),
        ENTRY( "TestGETDeconstructorL", CTestSDKEditors::TestGETDeconstructorL ),
        ENTRY( "TestGETConstructL", CTestSDKEditors::TestGETConstructL ),
        ENTRY( "TestGETSetButtonGroupL", CTestSDKEditors::TestGETSetButtonGroupL ),
        ENTRY( "TestGETSetLineCursorBitmapL", CTestSDKEditors::TestGETSetLineCursorBitmapL ),
        ENTRY( "TestGETRunFontDialogL", CTestSDKEditors::TestGETRunFontDialogL ),
        ENTRY( "TestGETRunTabsDialogL", CTestSDKEditors::TestGETRunTabsDialogL ),
        ENTRY( "TestGETRunIndentsDialogL", CTestSDKEditors::TestGETRunIndentsDialogL ),
        ENTRY( "TestGETSetGraphicsDeviceL", CTestSDKEditors::TestGETSetGraphicsDeviceL ),
        ENTRY( "TestGETRunFindDialogL", CTestSDKEditors::TestGETRunFindDialogL ),
        ENTRY( "TestGETRunFindAgainDialogL", CTestSDKEditors::TestGETRunFindAgainDialogL ),
        ENTRY( "TestGETRunReplaceDialogL", CTestSDKEditors::TestGETRunReplaceDialogL ),
        ENTRY( "TestGETInitFindL", CTestSDKEditors::TestGETInitFindL ),
        ENTRY( "TestGETDoFindL", CTestSDKEditors::TestGETDoFindL ),
        ENTRY( "TestGETRunParaDialogsL", CTestSDKEditors::TestGETRunParaDialogsL ),
        ENTRY( "TestGETRunPaginateDialogL", CTestSDKEditors::TestGETRunPaginateDialogL ),
        ENTRY( "TestGETGlobalTextL", CTestSDKEditors::TestGETGlobalTextL ),
        ENTRY( "TestGETApplyParaFormatL", CTestSDKEditors::TestGETApplyParaFormatL ),
        ENTRY( "TestGETApplyCharFormatL", CTestSDKEditors::TestGETApplyCharFormatL ),
        ENTRY( "TestGETBoldItalicUnderlineEventL", CTestSDKEditors::TestGETBoldItalicUnderlineEventL ),
        ENTRY( "TestGETUpdateButtonGroupL", CTestSDKEditors::TestGETUpdateButtonGroupL ),
        ENTRY( "TestGETConstructFromResourceL", CTestSDKEditors::TestGETConstructFromResourceL ),
        ENTRY( "TestGETOfferKeyEventL", CTestSDKEditors::TestGETOfferKeyEventL ),
        ENTRY( "TestGETActivateL", CTestSDKEditors::TestGETActivateL ),
        ENTRY( "TestGETHandlePointerEventL", CTestSDKEditors::TestGETHandlePointerEventL ),
        ENTRY( "TestGETLineCursorWidthL", CTestSDKEditors::TestGETLineCursorWidthL ),
        ENTRY( "TestGETBaseConstructL", CTestSDKEditors::TestGETBaseConstructL ),
        ENTRY( "TestGETWriteInternalStateL", CTestSDKEditors::TestGETWriteInternalStateL ),
        
        ENTRY( "TestRETCEikRichTextEditorL", CTestSDKEditors::TestRETCEikRichTextEditorL ),
        ENTRY( "TestRETCEikRichTextEditorPL", CTestSDKEditors::TestRETCEikRichTextEditorPL ),
        ENTRY( "TestRETDeconstructorL", CTestSDKEditors::TestRETDeconstructorL ),
        ENTRY( "TestRETConstructL", CTestSDKEditors::TestRETConstructL ),
        ENTRY( "TestRETRichTextL", CTestSDKEditors::TestRETRichTextL ),
        ENTRY( "TestRETInsertObjectOPL", CTestSDKEditors::TestRETInsertObjectOPL ),
        ENTRY( "TestRETInsertObjectL", CTestSDKEditors::TestRETInsertObjectL ),
        ENTRY( "TestRETInsertObjectTPL", CTestSDKEditors::TestRETInsertObjectTPL ),
        ENTRY( "TestRETInsertObjectWPL", CTestSDKEditors::TestRETInsertObjectWPL ),
        ENTRY( "TestRETReEditObjectL", CTestSDKEditors::TestRETReEditObjectL ),
        ENTRY( "TestRETObjectCursorPosL", CTestSDKEditors::TestRETObjectCursorPosL ),
        ENTRY( "TestRETCheckForObjectL", CTestSDKEditors::TestRETCheckForObjectL ),
        ENTRY( "TestRETEditPictureFormatL", CTestSDKEditors::TestRETEditPictureFormatL ),
        ENTRY( "TestRETPictureFormatChangedL", CTestSDKEditors::TestRETPictureFormatChangedL ),
        ENTRY( "TestRETGetEmbeddedAppL", CTestSDKEditors::TestRETGetEmbeddedAppL ),
        ENTRY( "TestRETUpdatePictureFormatL", CTestSDKEditors::TestRETUpdatePictureFormatL ),
        ENTRY( "TestRETUpdatePictureFormatPL", CTestSDKEditors::TestRETUpdatePictureFormatPL ),
        ENTRY( "TestRETSetDefaultIconicDoorSizeL", CTestSDKEditors::TestRETSetDefaultIconicDoorSizeL ),
        ENTRY( "TestRETDefaultIconicDoorSizeL", CTestSDKEditors::TestRETDefaultIconicDoorSizeL ),
        ENTRY( "TestRETUpdatePictureSizeL", CTestSDKEditors::TestRETUpdatePictureSizeL ),
        ENTRY( "TestRETUpdatePictureSizePL", CTestSDKEditors::TestRETUpdatePictureSizePL ),
        ENTRY( "TestRETSetParserObserverL", CTestSDKEditors::TestRETSetParserObserverL ),
        ENTRY( "TestRETSetPhoneNumberGroupingL", CTestSDKEditors::TestRETSetPhoneNumberGroupingL ),
        ENTRY( "TestRETOfferKeyEventL", CTestSDKEditors::TestRETOfferKeyEventL ),
        ENTRY( "TestRETHandlePointerEventL", CTestSDKEditors::TestRETHandlePointerEventL ),
        ENTRY( "TestRETConstructFromResourceL", CTestSDKEditors::TestRETConstructFromResourceL ),
        ENTRY( "TestRETActivateL", CTestSDKEditors::TestRETActivateL ),
        ENTRY( "TestRETCopyDocumentContentL", CTestSDKEditors::TestRETCopyDocumentContentL ),
        ENTRY( "TestRETWriteInternalStateL", CTestSDKEditors::TestRETWriteInternalStateL ),
        ENTRY( "TestRETEditObserverL", CTestSDKEditors::TestRETEditObserverL ),
        ENTRY( "TestRETRefreshParsersL", CTestSDKEditors::TestRETRefreshParsersL ),
        
        ENTRY( "TestSECEikSecretEditorL", CTestSDKEditors::TestSECEikSecretEditorL ),
        ENTRY( "TestSEDeconstructorL", CTestSDKEditors::TestSEDeconstructorL ),
        ENTRY( "TestSEConstructFromResourceL", CTestSDKEditors::TestSEConstructFromResourceL ),
        ENTRY( "TestSEMinimumSizeL", CTestSDKEditors::TestSEMinimumSizeL ),
        ENTRY( "TestSEOfferKeyEventL", CTestSDKEditors::TestSEOfferKeyEventL ),
        ENTRY( "TestSEGetColorUseListL", CTestSDKEditors::TestSEGetColorUseListL ),
        ENTRY( "TestSEHandleResourceChangeL", CTestSDKEditors::TestSEHandleResourceChangeL ),
        ENTRY( "TestSEInputCapabilitiesL", CTestSDKEditors::TestSEInputCapabilitiesL ),
        ENTRY( "TestSEHandlePointerEventL", CTestSDKEditors::TestSEHandlePointerEventL ),
        ENTRY( "TestSEGetTextL", CTestSDKEditors::TestSEGetTextL ),
        ENTRY( "TestSESetTextL", CTestSDKEditors::TestSESetTextL ),
        ENTRY( "TestSEInitializeDisplayL", CTestSDKEditors::TestSEInitializeDisplayL ),
        ENTRY( "TestSEResetL", CTestSDKEditors::TestSEResetL ),
        ENTRY( "TestSESetMaxLengthL", CTestSDKEditors::TestSESetMaxLengthL ),
        ENTRY( "TestSEAknSetFontL", CTestSDKEditors::TestSEAknSetFontL ),
        ENTRY( "TestSEAknSetAlignmentL", CTestSDKEditors::TestSEAknSetAlignmentL ),
        ENTRY( "TestSESetDefaultInputModeL", CTestSDKEditors::TestSESetDefaultInputModeL ),
        ENTRY( "TestSEMaxLengthL", CTestSDKEditors::TestSEMaxLengthL ),
        ENTRY( "TestSEBufferL", CTestSDKEditors::TestSEBufferL ),
        ENTRY( "TestSERevealSecretTextL", CTestSDKEditors::TestSERevealSecretTextL ),
        ENTRY( "TestSEEnableSCTL", CTestSDKEditors::TestSEEnableSCTL ),
        ENTRY( "TestSESetSkinBackgroundControlContextL", CTestSDKEditors::TestSESetSkinBackgroundControlContextL ),
        ENTRY( "TestSEAppendCharacterL", CTestSDKEditors::TestSEAppendCharacterL ),
        ENTRY( "TestSEUpdateL", CTestSDKEditors::TestSEUpdateL ),
        ENTRY( "TestSESizeChangedL", CTestSDKEditors::TestSESizeChangedL ),
        ENTRY( "TestSESetSkinTextColorL", CTestSDKEditors::TestSESetSkinTextColorL ),
        ENTRY( "TestSESetFeatureL", CTestSDKEditors::TestSESetFeatureL ),
        ENTRY( "TestSEGetFeatureL", CTestSDKEditors::TestSEGetFeatureL ),
        ENTRY( "TestSESupportsFeatureL", CTestSDKEditors::TestSESupportsFeatureL ),
        ENTRY( "TestSEFocusChangedL", CTestSDKEditors::TestSEFocusChangedL ),
        
        ENTRY( "TestMFNECEikMfneFieldL", CTestSDKEditors::TestMFNECEikMfneFieldL ),
        ENTRY( "TestMFNEIsEditableL", CTestSDKEditors::TestMFNEIsEditableL ),
        ENTRY( "TestMFNEIsValidL", CTestSDKEditors::TestMFNEIsValidL ),
        ENTRY( "TestMFNEHighlightTypeL", CTestSDKEditors::TestMFNEHighlightTypeL ),
        ENTRY( "TestMFNEHandleKeyL", CTestSDKEditors::TestMFNEHandleKeyL ),
        ENTRY( "TestMFNEHandleDeHighlightL", CTestSDKEditors::TestMFNEHandleDeHighlightL ),
        ENTRY( "TestMFNEHandleLeftOrRightArrowL", CTestSDKEditors::TestMFNEHandleLeftOrRightArrowL ),
        
        ENTRY( "TestMFNEDeconstructorL", CTestSDKEditors::TestMFNEDeconstructorL ),
        ENTRY( "TestMFNERNewL", CTestSDKEditors::TestMFNERNewL ),
        ENTRY( "TestMFNEHNewL", CTestSDKEditors::TestMFNEHNewL ),
        ENTRY( "TestMFNESetTextL", CTestSDKEditors::TestMFNESetTextL ),
        
        ENTRY( "TestMFNENDeconstructorL", CTestSDKEditors::TestMFNENDeconstructorL ),
        ENTRY( "TestMFNENRNewL", CTestSDKEditors::TestMFNENRNewL ),
        ENTRY( "TestMFNENVNewL", CTestSDKEditors::TestMFNENVNewL ),
        ENTRY( "TestMFNENSetMinimumAndMaximumL", CTestSDKEditors::TestMFNENSetMinimumAndMaximumL ),
        ENTRY( "TestMFNENGetMinimumAndMaximumL", CTestSDKEditors::TestMFNENGetMinimumAndMaximumL ),
        ENTRY( "TestMFNENSetValueL", CTestSDKEditors::TestMFNENSetValueL ),
        ENTRY( "TestMFNENValueL", CTestSDKEditors::TestMFNENValueL ),
        ENTRY( "TestMFNENIsValidL", CTestSDKEditors::TestMFNENIsValidL ),
        ENTRY( "TestMFNENSetUninitialisedL", CTestSDKEditors::TestMFNENSetUninitialisedL ),
        ENTRY( "TestMFNENIsUninitialisedL", CTestSDKEditors::TestMFNENIsUninitialisedL ),
        ENTRY( "TestMFNENSetDigitTypeL", CTestSDKEditors::TestMFNENSetDigitTypeL ),
        ENTRY( "TestMFNENDigitTypeL", CTestSDKEditors::TestMFNENDigitTypeL ),
        ENTRY( "TestMFNENRefreshDigitTypeL", CTestSDKEditors::TestMFNENRefreshDigitTypeL ),
        
        ENTRY( "TestMFNESCDeconstructorL", CTestSDKEditors::TestMFNESCDeconstructorL ),
        ENTRY( "TestMFNESCRNewL", CTestSDKEditors::TestMFNESCRNewL ),
        ENTRY( "TestMFNESCNewL", CTestSDKEditors::TestMFNESCNewL ),
        ENTRY( "TestMFNESCSetTextL", CTestSDKEditors::TestMFNESCSetTextL ),
        ENTRY( "TestMFNESDeconstructorL", CTestSDKEditors::TestMFNESDeconstructorL ),
        ENTRY( "TestMFNESRNewL", CTestSDKEditors::TestMFNESRNewL ),
        ENTRY( "TestMFNESNewL", CTestSDKEditors::TestMFNESNewL ),
        ENTRY( "TestMFNESAddSymbolicItemL", CTestSDKEditors::TestMFNESAddSymbolicItemL ),
        ENTRY( "TestMFNESSetCurrentSymbolicItemToIdL", CTestSDKEditors::TestMFNESSetCurrentSymbolicItemToIdL ),
        ENTRY( "TestMFNESIdOfCurrentSymbolicItemL", CTestSDKEditors::TestMFNESIdOfCurrentSymbolicItemL ),
        ENTRY( "TestMFNESSetUninitialisedL", CTestSDKEditors::TestMFNESSetUninitialisedL ),
        ENTRY( "TestMFNESIsUninitialisedL", CTestSDKEditors::TestMFNESIsUninitialisedL ),
        
        ENTRY( "TestMFNEMCEikMfneL", CTestSDKEditors::TestMFNEMCEikMfneL ),
        ENTRY( "TestMFNEMDeconstructorL", CTestSDKEditors::TestMFNEMDeconstructorL ),
        ENTRY( "TestMFNEMCreateFieldArrayL", CTestSDKEditors::TestMFNEMCreateFieldArrayL ),
        ENTRY( "TestMFNEMAddFieldL", CTestSDKEditors::TestMFNEMAddFieldL ),
        ENTRY( "TestMFNEMResetFieldArrayL", CTestSDKEditors::TestMFNEMResetFieldArrayL ),
        ENTRY( "TestMFNEMBorderMarginsL", CTestSDKEditors::TestMFNEMBorderMarginsL ),
        ENTRY( "TestMFNEMDrawNowAndLeaveWithTimeDateFormatInfoMsgL", CTestSDKEditors::TestMFNEMDrawNowAndLeaveWithTimeDateFormatInfoMsgL ),
        ENTRY( "TestMFNEMFieldL", CTestSDKEditors::TestMFNEMFieldL ),
        ENTRY( "TestMFNEMReadTimeL", CTestSDKEditors::TestMFNEMReadTimeL ),
        ENTRY( "TestMFNEMReadDateL", CTestSDKEditors::TestMFNEMReadDateL ),
        ENTRY( "TestMFNEMReadTimeAndDateL", CTestSDKEditors::TestMFNEMReadTimeAndDateL ),
        ENTRY( "TestMFNEMReadDurationL", CTestSDKEditors::TestMFNEMReadDurationL ),
        ENTRY( "TestMFNEMReadTimeOffsetL", CTestSDKEditors::TestMFNEMReadTimeOffsetL ),
        ENTRY( "TestMFNEMConvertL", CTestSDKEditors::TestMFNEMConvertL ),
        ENTRY( "TestMFNEMTConvertL", CTestSDKEditors::TestMFNEMTConvertL ),
        ENTRY( "TestMFNEMCurrentFieldL", CTestSDKEditors::TestMFNEMCurrentFieldL ),
        ENTRY( "TestMFNEMNumFieldsL", CTestSDKEditors::TestMFNEMNumFieldsL ),
        ENTRY( "TestMFNEMSetMfneAlignmentL", CTestSDKEditors::TestMFNEMSetMfneAlignmentL ),
        ENTRY( "TestMFNEMSetUpAndDownKeysConsumedL", CTestSDKEditors::TestMFNEMSetUpAndDownKeysConsumedL ),
        ENTRY( "TestMFNEMSetSuppressBackgroundDrawingL", CTestSDKEditors::TestMFNEMSetSuppressBackgroundDrawingL ),
        ENTRY( "TestMFNEMSetFeatureL", CTestSDKEditors::TestMFNEMSetFeatureL ),
        ENTRY( "TestMFNEMGetFeatureL", CTestSDKEditors::TestMFNEMGetFeatureL ),
        ENTRY( "TestMFNEMSupportsFeatureL", CTestSDKEditors::TestMFNEMSupportsFeatureL ),
        ENTRY( "TestMFNEMFontL", CTestSDKEditors::TestMFNEMFontL ),
        ENTRY( "TestMFNEMSetFontL", CTestSDKEditors::TestMFNEMSetFontL ),
        ENTRY( "TestMFNEMSetSkinBackgroundControlContextL", CTestSDKEditors::TestMFNEMSetSkinBackgroundControlContextL ),
        ENTRY( "TestMFNEMHandleMfneCommandL", CTestSDKEditors::TestMFNEMHandleMfneCommandL ),
        ENTRY( "TestMFNEMSetUseOverrideColorsL", CTestSDKEditors::TestMFNEMSetUseOverrideColorsL ),
        ENTRY( "TestMFNEMOfferKeyEventL", CTestSDKEditors::TestMFNEMOfferKeyEventL ),
        ENTRY( "TestMFNEMPrepareForFocusLossL", CTestSDKEditors::TestMFNEMPrepareForFocusLossL ),
        ENTRY( "TestMFNEMMinimumSizeL", CTestSDKEditors::TestMFNEMMinimumSizeL ),
        ENTRY( "TestMFNEMGetColorUseListL", CTestSDKEditors::TestMFNEMGetColorUseListL ),
        ENTRY( "TestMFNEMHandleResourceChangeL", CTestSDKEditors::TestMFNEMHandleResourceChangeL ),
        ENTRY( "TestMFNEMInputCapabilitiesL", CTestSDKEditors::TestMFNEMInputCapabilitiesL ),
        ENTRY( "TestMFNEMHandlePointerEventL", CTestSDKEditors::TestMFNEMHandlePointerEventL ),
        ENTRY( "TestMFNEMMopSupplyObjectL", CTestSDKEditors::TestMFNEMMopSupplyObjectL ),
        ENTRY( "TestMFNEMSetSkinTextColorL", CTestSDKEditors::TestMFNEMSetSkinTextColorL ),
        ENTRY( "TestMFNEMFocusChangedL", CTestSDKEditors::TestMFNEMFocusChangedL ),
        ENTRY( "TestMFNEMWriteInternalStateL", CTestSDKEditors::TestMFNEMWriteInternalStateL ),
        ENTRY( "TestMFNEMHandleInteractionL", CTestSDKEditors::TestMFNEMHandleInteractionL ),
        ENTRY( "TestMFNEMFieldIsAboutToBeDeHighlightedL", CTestSDKEditors::TestMFNEMFieldIsAboutToBeDeHighlightedL ),
        ENTRY( "TestMFNEMMfneSizeL", CTestSDKEditors::TestMFNEMMfneSizeL ),
        ENTRY( "TestMFNEMPMfneSizeL", CTestSDKEditors::TestMFNEMPMfneSizeL ),
        ENTRY( "TestMFNEMSizeChangedL", CTestSDKEditors::TestMFNEMSizeChangedL ),
        ENTRY( "TestMFNEMMakeVisibleL", CTestSDKEditors::TestMFNEMMakeVisibleL ),
        
        ENTRY( "TestMFNENECEikNumberEditorL", CTestSDKEditors::TestMFNENECEikNumberEditorL ),
        ENTRY( "TestMFNENEConstructL", CTestSDKEditors::TestMFNENEConstructL ),
        ENTRY( "TestMFNENESetMinimumAndMaximumL", CTestSDKEditors::TestMFNENESetMinimumAndMaximumL ),
        ENTRY( "TestMFNENEGetMinimumAndMaximumL", CTestSDKEditors::TestMFNENEGetMinimumAndMaximumL ),
        ENTRY( "TestMFNENESetNumberL", CTestSDKEditors::TestMFNENESetNumberL ),
        ENTRY( "TestMFNENENumberL", CTestSDKEditors::TestMFNENENumberL ),
        ENTRY( "TestMFNENEConstructFromResourceL", CTestSDKEditors::TestMFNENEConstructFromResourceL ),
        ENTRY( "TestMFNENEHandlePointerEventL", CTestSDKEditors::TestMFNENEHandlePointerEventL ),
        
        ENTRY( "TestMFNERECEikRangeEditorL", CTestSDKEditors::TestMFNERECEikRangeEditorL ),
        ENTRY( "TestMFNEREConstructL", CTestSDKEditors::TestMFNEREConstructL ),
        ENTRY( "TestMFNERESetMinimumAndMaximumL", CTestSDKEditors::TestMFNERESetMinimumAndMaximumL ),
        ENTRY( "TestMFNEREGetMinimumAndMaximumL", CTestSDKEditors::TestMFNEREGetMinimumAndMaximumL ),
        ENTRY( "TestMFNERESetRangeL", CTestSDKEditors::TestMFNERESetRangeL ),
        ENTRY( "TestMFNERERangeL", CTestSDKEditors::TestMFNERERangeL ),
        ENTRY( "TestMFNEREConstructFromResourceL", CTestSDKEditors::TestMFNEREConstructFromResourceL ),
        ENTRY( "TestMFNEREHandlePointerEventL", CTestSDKEditors::TestMFNEREHandlePointerEventL ),
        
        ENTRY( "TestMFNETECEikTimeEditorL", CTestSDKEditors::TestMFNETECEikTimeEditorL ),
        ENTRY( "TestMFNETEDeconstructorL", CTestSDKEditors::TestMFNETEDeconstructorL ),
        ENTRY( "TestMFNETEConstructL", CTestSDKEditors::TestMFNETEConstructL ),
        ENTRY( "TestMFNETESetTimeL", CTestSDKEditors::TestMFNETESetTimeL ),
        ENTRY( "TestMFNETETimeL", CTestSDKEditors::TestMFNETETimeL ),
        ENTRY( "TestMFNETESetUninitialisedL", CTestSDKEditors::TestMFNETESetUninitialisedL ),
        ENTRY( "TestMFNETEIsUninitialisedL", CTestSDKEditors::TestMFNETEIsUninitialisedL ),
        ENTRY( "TestMFNETESetMinimumAndMaximumL", CTestSDKEditors::TestMFNETESetMinimumAndMaximumL ),
        ENTRY( "TestMFNETEGetMinimumAndMaximumL", CTestSDKEditors::TestMFNETEGetMinimumAndMaximumL ),
        ENTRY( "TestMFNETEConstructFromResourceL", CTestSDKEditors::TestMFNETEConstructFromResourceL ),
        ENTRY( "TestMFNETEPrepareForFocusLossL", CTestSDKEditors::TestMFNETEPrepareForFocusLossL ),
        ENTRY( "TestMFNETEHandlePointerEventL", CTestSDKEditors::TestMFNETEHandlePointerEventL ),
        
        ENTRY( "TestMFNEDECEikDateEditorL", CTestSDKEditors::TestMFNEDECEikDateEditorL ),
        ENTRY( "TestMFNEDEDeconstructorL", CTestSDKEditors::TestMFNEDEDeconstructorL ),
        ENTRY( "TestMFNEDEConstructL", CTestSDKEditors::TestMFNEDEConstructL ),
        ENTRY( "TestMFNEDESetDateL", CTestSDKEditors::TestMFNEDESetDateL ),
        ENTRY( "TestMFNEDEDateL", CTestSDKEditors::TestMFNEDEDateL ),
        ENTRY( "TestMFNEDESetUninitialisedL", CTestSDKEditors::TestMFNEDESetUninitialisedL ),
        ENTRY( "TestMFNEDEIsUninitialisedL", CTestSDKEditors::TestMFNEDEIsUninitialisedL ),
        ENTRY( "TestMFNEDESetMinimumAndMaximumL", CTestSDKEditors::TestMFNEDESetMinimumAndMaximumL ),
        ENTRY( "TestMFNEDEGetMinimumAndMaximumL", CTestSDKEditors::TestMFNEDEGetMinimumAndMaximumL ),
        ENTRY( "TestMFNEDEOfferKeyEventL", CTestSDKEditors::TestMFNEDEOfferKeyEventL ),
        ENTRY( "TestMFNEDEConstructFromResourceL", CTestSDKEditors::TestMFNEDEConstructFromResourceL ),
        ENTRY( "TestMFNEDEPrepareForFocusLossL", CTestSDKEditors::TestMFNEDEPrepareForFocusLossL ),
        ENTRY( "TestMFNEDEHandlePointerEventL", CTestSDKEditors::TestMFNEDEHandlePointerEventL ),
        
        ENTRY( "TestMFNETDECEikTimeAndDateEditorL", CTestSDKEditors::TestMFNETDECEikTimeAndDateEditorL ),
        ENTRY( "TestMFNETDEDeconstructorL", CTestSDKEditors::TestMFNETDEDeconstructorL ),
        ENTRY( "TestMFNETDEConstructL", CTestSDKEditors::TestMFNETDEConstructL ),
        ENTRY( "TestMFNETDESetTimeAndDateL", CTestSDKEditors::TestMFNETDESetTimeAndDateL ),
        ENTRY( "TestMFNETDETimeAndDateL", CTestSDKEditors::TestMFNETDETimeAndDateL ),
        ENTRY( "TestMFNETDESetUninitialisedL", CTestSDKEditors::TestMFNETDESetUninitialisedL ),
        ENTRY( "TestMFNETDEIsUninitialisedL", CTestSDKEditors::TestMFNETDEIsUninitialisedL ),
        ENTRY( "TestMFNETDESetMinimumAndMaximumL", CTestSDKEditors::TestMFNETDESetMinimumAndMaximumL ),
        ENTRY( "TestMFNETDEGetMinimumAndMaximumL", CTestSDKEditors::TestMFNETDEGetMinimumAndMaximumL ),
        ENTRY( "TestMFNETDEOfferKeyEventL", CTestSDKEditors::TestMFNETDEOfferKeyEventL ),
        ENTRY( "TestMFNETDEConstructFromResourceL", CTestSDKEditors::TestMFNETDEConstructFromResourceL ),
        ENTRY( "TestMFNETDEPrepareForFocusLossL", CTestSDKEditors::TestMFNETDEPrepareForFocusLossL ),
        ENTRY( "TestMFNETDEHandlePointerEventL", CTestSDKEditors::TestMFNETDEHandlePointerEventL ),
        
        ENTRY( "TestMFNETDUECEikDurationEditorL", CTestSDKEditors::TestMFNETDUECEikDurationEditorL ),
        ENTRY( "TestMFNETDUEDeconstructorL", CTestSDKEditors::TestMFNETDUEDeconstructorL ),
        ENTRY( "TestMFNETDUEConstructL", CTestSDKEditors::TestMFNETDUEConstructL ),
        ENTRY( "TestMFNETDUESetMinimumAndMaximumL", CTestSDKEditors::TestMFNETDUESetMinimumAndMaximumL ),
        ENTRY( "TestMFNETDUEGetMinimumAndMaximumL", CTestSDKEditors::TestMFNETDUEGetMinimumAndMaximumL ),
        ENTRY( "TestMFNETDUESetDurationL", CTestSDKEditors::TestMFNETDUESetDurationL ),
        ENTRY( "TestMFNETDUEDurationL", CTestSDKEditors::TestMFNETDUEDurationL ),
        ENTRY( "TestMFNETDUEConstructFromResourceL", CTestSDKEditors::TestMFNETDUEConstructFromResourceL ),
        ENTRY( "TestMFNETDUEPrepareForFocusLossL", CTestSDKEditors::TestMFNETDUEPrepareForFocusLossL ),
        ENTRY( "TestMFNETDUEHandlePointerEventL", CTestSDKEditors::TestMFNETDUEHandlePointerEventL ),
        
        ENTRY( "TestMFNETOECEikTimeOffsetEditorL", CTestSDKEditors::TestMFNETOECEikTimeOffsetEditorL ),
        ENTRY( "TestMFNETOEDeconstructorL", CTestSDKEditors::TestMFNETOEDeconstructorL ),
        ENTRY( "TestMFNETOEConstructL", CTestSDKEditors::TestMFNETOEConstructL ),
        ENTRY( "TestMFNETOESetMinimumAndMaximumL", CTestSDKEditors::TestMFNETOESetMinimumAndMaximumL ),
        ENTRY( "TestMFNETOEGetMinimumAndMaximumL", CTestSDKEditors::TestMFNETOEGetMinimumAndMaximumL ),
        ENTRY( "TestMFNETOESetTimeOffsetL", CTestSDKEditors::TestMFNETOESetTimeOffsetL ),
        ENTRY( "TestMFNETOETimeOffsetL", CTestSDKEditors::TestMFNETOETimeOffsetL ),
        ENTRY( "TestMFNETOEConstructFromResourceL", CTestSDKEditors::TestMFNETOEConstructFromResourceL ),
        ENTRY( "TestMFNETOEPrepareForFocusLossL", CTestSDKEditors::TestMFNETOEPrepareForFocusLossL ),
        ENTRY( "TestMFNETOEHandlePointerEventL", CTestSDKEditors::TestMFNETOEHandlePointerEventL ),
        ENTRY( "TestEikEdwinSmileyInputL", CTestSDKEditors::TestEikEdwinSmileyInputL ),       
        ENTRY( "TestEEnableKineticScrollingL", CTestSDKEditors::TestEEnableKineticScrollingL ),
        ENTRY( "TestEEnableKineticScrollingPhysicsL", CTestSDKEditors::TestEEnableKineticScrollingPhysicsL ),
        };

    const TInt count = sizeof( KFunctions ) / sizeof( TStifFunctionInfo );

    return RunInternalL( KFunctions, count, aItem );

    }

//  [End of File]
