/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Test AknButton.h
*
*/



/*
 *  INCLUDE FILES
 */
#include <stiftestinterface.h>
#include <settingserverclient.h>
#include <e32property.h>
#include <coemain.h>

#include "testsdkgenericbutton.h"
#include "testsdkgenericbuttoninclude.h"


// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CTestSDKGENERICBUTTON::CTestSDKGENERICBUTTON
// C++ default constructor can NOT contain any code, that
// might leave.
// -----------------------------------------------------------------------------
//
CTestSDKGENERICBUTTON::CTestSDKGENERICBUTTON( CTestModuleIf& aTestModuleIf ):
    CScriptBase( aTestModuleIf )
    {
    }

// -----------------------------------------------------------------------------
// CTestSDKGENERICBUTTON::ConstructL
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CTestSDKGENERICBUTTON::ConstructL()
    {
    RSettingServer settingServer;
    CleanupClosePushL( settingServer );
    TInt ret = settingServer.Connect();
    if(ret != KErrNone)
        {
        User::Leave(ret);
        }
    TLoggerSettings loggerSettings; 
    ret = settingServer.GetLoggerSettings(loggerSettings);
    if(ret != KErrNone)
        {
        User::Leave(ret);
        } 
    settingServer.Close();
    CleanupStack::PopAndDestroy( &settingServer );

    TFileName logFileName;
    
    if(loggerSettings.iAddTestCaseTitle)
        {
        TName title;
        TestModuleIf().GetTestCaseTitleL(title);
        logFileName.Format(KtestsdkgenericbuttonLogFileWithTitle, &title);
        }
    else
        {
        logFileName.Copy(KtestsdkgenericbuttonLogFile);
        }

    iLog = CStifLogger::NewL( KtestsdkgenericbuttonLogPath, 
                          logFileName,
                          CStifLogger::ETxt,
                          CStifLogger::EFile,
                          EFalse );
    
    TRAPD ( err, iOffset = CCoeEnv::Static()->AddResourceFileL(
            _L("C:\\resource\\testsdkgenericbutton.rsc") ) );
    if ( KErrNone != err )
        {
        _LIT ( KGenericbuttonRsc, "Z:\\resource\\testsdkgenericbutton.rsc" );
        iOffset = CCoeEnv::Static()->AddResourceFileL( KGenericbuttonRsc );
        }
    
    SendTestClassVersion();
    }

// -----------------------------------------------------------------------------
// CTestSDKGENERICBUTTON::NewL
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CTestSDKGENERICBUTTON* CTestSDKGENERICBUTTON::NewL( CTestModuleIf& aTestModuleIf )
    {
    CTestSDKGENERICBUTTON* self = new( ELeave ) CTestSDKGENERICBUTTON( aTestModuleIf );

    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop( self );

    return self;

    }

CTestSDKGENERICBUTTON::~CTestSDKGENERICBUTTON()
    { 

    Delete();

    delete iLog; 

    CCoeEnv::Static()->DeleteResourceFile( iOffset );
    }

//-----------------------------------------------------------------------------
// CTestSDKGENERICBUTTON::SendTestClassVersion
// Method used to send version of test class
//-----------------------------------------------------------------------------
//
void CTestSDKGENERICBUTTON::SendTestClassVersion()
    {
    TVersion moduleVersion;
    moduleVersion.iMajor = TEST_CLASS_VERSION_MAJOR;
    moduleVersion.iMinor = TEST_CLASS_VERSION_MINOR;
    moduleVersion.iBuild = TEST_CLASS_VERSION_BUILD;

    TFileName moduleName;
    moduleName = KModuleName;

    TBool newVersionOfMethod = ETrue;
    TestModuleIf().SendTestModuleVersion( moduleVersion, moduleName, 
        newVersionOfMethod );
    }

// ========================== OTHER EXPORTED FUNCTIONS =========================

// -----------------------------------------------------------------------------
// LibEntryL is a polymorphic Dll entry point.
// Returns: CScriptBase: New CScriptBase derived object
// -----------------------------------------------------------------------------
//
EXPORT_C CScriptBase* LibEntryL( 
    CTestModuleIf& aTestModuleIf )
    {
    return ( CScriptBase* ) CTestSDKGENERICBUTTON::NewL( aTestModuleIf );
    }
//End file


