/*
* Copyright (c) 2006-2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Defines the observer interface for the CameseUtility library
*
*/


#ifndef CAMESEOBSERVER_H
#define CAMESEOBSERVER_H

/**
* MCameseObserver
*  Notification interface used by the Camese Utility to report progress.
*
*  @lib CameseUtility.dll
*  @since 5.0
*/
class MCameseObserver
    {
    public:
        enum TLicenseAcquisitionState
            {
            EIdle = 0,
            ESendingContentStorageStatus,
            ERetrievingDRMHeaderFromFileHandle,
            EProcessingDRMHeader,            
            ERetrievingChallenge,
            ERetrievingChallengeFromFileHandle,
            ERetrievingLicense,
            EProcessingLicense,
            EAddingLicense,
            ESendingLicenseStorageStatus,
            ELicensingComplete,
            EInvisibleRedirection,
            ESendingDrmHeaderStatus
            };

    public:
        /**
         * Progress notification generated by the Camese Utility.
         * @param aState Current state of the license acquisition process.
         */
        virtual void OnLicenseAcquisitionProgress(TLicenseAcquisitionState aState) = 0;
    };

#endif  // CAMESEOBSERVER_H

// End of File
