/* GStreamer
 * Copyright (C) <1999> Erik Walthinsen <omega@temple-baptist.com>
 *
 * gstavi.c: plugin registering
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gst/gst-i18n-plugin.h"

#include "gstavidemux.h"
#include "gstavimux.h"
#include "gstavisubtitle.h"

static gboolean
plugin_init (GstPlugin * plugin)
{
  gst_riff_init ();

#ifdef ENABLE_NLS
  setlocale (LC_ALL, "");
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif /* ENABLE_NLS */

  if (!gst_element_register (plugin, "avidemux", GST_RANK_PRIMARY,
          GST_TYPE_AVI_DEMUX) ||
      !gst_element_register (plugin, "avimux", GST_RANK_PRIMARY,
          GST_TYPE_AVI_MUX) ||
      !gst_element_register (plugin, "avisubtitle", GST_RANK_PRIMARY,
          GST_TYPE_AVI_SUBTITLE)) {
    return FALSE;
  }

  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "avi",
    "AVI stream handling",
    plugin_init, VERSION, "LGPL", GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN)

#ifdef SYMBIAN
EXPORT_C GstPluginDesc* _GST_PLUGIN_DESC()
{
    return &gst_plugin_desc;
}

#endif
