/****************************************************************************
**
** Copyright (C) 2008-2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (developer.feedback@nokia.com)
**
** This file is part of the HbCore module of the UI Extensions for Mobile.
**
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this file.
** Please review the following information to ensure the GNU Lesser General
** Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at developer.feedback@nokia.com.
**
****************************************************************************/

#ifndef HBPANGESTURE_P_H
#define HBPANGESTURE_P_H

#include "hbglobal.h"
#include "hbgestures_p.h"
#include "hbpointrecorder_p.h"

#include <QTime>
#include <QPoint>
#include <QList>
#include <QDebug>

class HbPanGesture;

class HB_CORE_PRIVATE_EXPORT HbPanGesturePrivate
{
public:
    Q_DECLARE_PUBLIC(HbPanGesture)

    QPointF mStartPos;

    QPointF mSceneStartPos;
    QPointF mSceneLastOffset;
    QPointF mSceneOffset;

    // for the recognizer
    QPointF mDeltaSinceLastTimeStamp;
    QPointF mSceneDeltaSinceLastTimeStamp;
    QTime mLastTimeStamp;

    HbPanGesture *q_ptr;

    HbPointRecorder mAxisX;
    HbPointRecorder mAxisY;
    HbPointRecorder mSceneAxisX;
    HbPointRecorder mSceneAxisY;

    qreal mThresholdSquare;

    bool mIgnoreMouseEvents;
    int mFollowedTouchPointId;
};

#endif // HBPANGESTURE_P_H

