/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#include "lunchwidget.h"
#include <QRect>
#include <QPainter>
#include <QUrl>
#include <hbapplication>
#include <tstestpropertydefs.h>
#include <HbComboBox>
#include <HbCheckBox>
#include <qservicemanager.h>


QTM_USE_NAMESPACE

#define hbApp qobject_cast<HbApplication*>(qApp)

lunchwidget::lunchwidget(QGraphicsItem *parent)
    : HbWidget(parent), mPluginPublisher(TsTestProperty::KTsTestPath)
{
    mLoadLabel = new HbLabel;
    QServiceManager manager;
    bool ok = manager.addService(":/tsfakelplugin.xml");
    if (!ok) {
        int err  = manager.error();
        QString mess;
        mess = tr("Load service: %1").arg(err);
        mLoadLabel->setPlainText(mess);
    }
    else {
        mLoadLabel->setPlainText("Load service: Ok");
    }
    
    mTenLabel= new HbLabel("10x");        
    mOneLabel= new HbLabel("1x");            
    
    
    mAdd = new HbPushButton("Add");
    mRemove = new HbPushButton("Remove all");
    
    
    mTenCombo = new HbComboBox();
    mOneCombo = new HbComboBox();
    for (int i=0; i<10; i++) {
        QString num;
        num.setNum(i);
        mTenCombo->addItem(num);
        mOneCombo->addItem(num);
    }
    mRunningCheckBox = new HbCheckBox("Is Running");
    mRunningCheckBox->setCheckState(Qt::Checked);
    mCloseableCheckBox = new HbCheckBox("Is Closeable");
    mCloseableCheckBox->setCheckState(Qt::Checked);
    
    mGridLayout = new QGraphicsGridLayout();
    mGridLayout->addItem(mOneLabel, 0, 0, 1, 3);
    mGridLayout->addItem(mTenLabel, 0, 3, 1, 3);
    mGridLayout->addItem(mOneCombo, 1, 0, 1, 3);
    mGridLayout->addItem(mTenCombo, 1, 3, 1, 3);
    mGridLayout->addItem(mRunningCheckBox, 2, 0, 1, 6);
    mGridLayout->addItem(mCloseableCheckBox, 3, 0, 1, 6);
    mGridLayout->addItem(mAdd, 4, 0, 1, 6);
    mGridLayout->addItem(mRemove, 5, 0, 1, 6);
    mGridLayout->addItem(mLoadLabel, 6, 0, 1, 6);    
    setLayout(mGridLayout);


    connect(mAdd, SIGNAL(released()), this, SLOT(add()));
    connect(mRemove, SIGNAL(released()), this, SLOT(remove()));
    
    
    mPluginPublisher.setValue(TsTestProperty::KPluginPath, 0);
    mPluginPublisher.sync();

}

lunchwidget::~lunchwidget()
{

}

void lunchwidget::add()
{
    int ten = mTenCombo->currentText().toInt();
    int one = mOneCombo->currentText().toInt();
    int num = ten*10+one;
    bool running = false;
    bool closeable = false;
    if (mRunningCheckBox->checkState() == Qt::Checked) {
        running = true;
    }
    if (mCloseableCheckBox->checkState() == Qt::Checked) {
        closeable = true;
    }
    
    int message = 0;
    setByte(message, 0, num);
    setByte(message, 1, running);
    setByte(message, 2, closeable);
    
    mPluginPublisher.setValue(TsTestProperty::KPluginPath, message);
    mPluginPublisher.sync();
}

void lunchwidget::remove()
{
    int message = -1;    
    
    mPluginPublisher.setValue(TsTestProperty::KPluginPath, message);
    mPluginPublisher.sync();
}
    

void lunchwidget::setByte(int& numtoset, int byte, char value)
{
    if(byte>3 || byte<0) {
        return;
    }
    int multiple = 255;//0b00000000000000000000000011111111;
    unsigned int temp = 0;
    temp = temp | value;
    temp = temp & multiple;
    temp = temp << byte*8;
    numtoset = numtoset | temp;
}

char lunchwidget::byte(int numtoget, int byte)
{
    char ret = 0;
    if(byte>3 || byte<0) {
        return ret;
    }
    numtoget = numtoget>>8*byte;
    ret = static_cast<char>(numtoget);
    
    return ret;
    
}
