/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#include <QtTest/QtTest>

#include "t_tsentrykeyhandling.h"
#include "tsentrykey.h"
#include "tsentrykeygenerator.h"
void T_TsEntryKeyHandling::testKeyGeneration()
{
    int errNo, iter;
    const int rootWindowGroupId(1);
    const int embApps(30);
    
    RWsSession::TWindowGroupChainInfo  item;
    RArray<RWsSession::TWindowGroupChainInfo> items(embApps);
    
    //generate root window
    item.iId = rootWindowGroupId;
    item.iParentId = -1;
    items.Append(item);
    
    //add some embedded windows
    for (iter = rootWindowGroupId; iter < rootWindowGroupId + embApps;) {
        item.iParentId = iter;
        item.iId = ++iter;
        items.Append(item);
    }
    TTsEntryKey root;
    errNo = TsEntryKeyGeneraror::Generate(root, rootWindowGroupId, items.Array());
    QCOMPARE(errNo, KErrNone);
    
    TTsEntryKey key;
    for (iter = 0; iter < items.Count(); ++iter) {
        errNo = TsEntryKeyGeneraror::Generate(key, items[iter].iId,
                                                         items.Array());
        QCOMPARE(errNo, KErrNone);
        QCOMPARE(key, root);
    }
    
    //bad handle
    items.Reset();
    item.iId = rootWindowGroupId;
    item.iParentId = rootWindowGroupId;
    items.Append(item);    
    TTsEntryKey bad;
    errNo = TsEntryKeyGeneraror::Generate(bad, rootWindowGroupId, items.Array());
    QCOMPARE(errNo, KErrBadHandle);
    
    //not found
    items.Reset();
    item.iId = rootWindowGroupId;
    item.iParentId = rootWindowGroupId;
    items.Append(item);    
    TTsEntryKey notFound;
    errNo = TsEntryKeyGeneraror::Generate(notFound, 15002900, items.Array());
    QCOMPARE(errNo, KErrNotFound);
    
    
}

QTEST_MAIN(T_TsEntryKeyHandling)
