/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#ifndef AFMANAGER_H
#define AFMANAGER_H

#include <QObject>
#include <QVariant>
#include <QList>
#include <QPixmap>

class AfManager : public QObject
{

    Q_OBJECT

public:
    AfManager(QObject *parent = 0);
    ~AfManager();

public slots:
    QList<QVariantHash> activitiesList();
    void launchActivity(const QString &uri);
    void launchActivity(int applicationId, const QString &activityId);
    void setActivitiesList(const QList<QVariantHash>&);
    void getThumbnail(QSize resolution, const QString &thumbnailId, void * =0);
    void emitDataChanged();
    void clearActivities();

signals:
    void thumbnailReady(QPixmap, void *);
    void dataChanged();

private:
    QList<QVariantHash> mData;
};

#endif // AFMANAGER_H
