/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#include "mocktstask.h"

TsTaskContent::TsTaskContent(const QString &name, bool closable, bool active) : mName(name), mClosable(closable), mActive(active) 
{
}

TsTask::TsTask(TsTaskContent *content, TsTaskLauncher &launcher) : mContent(content), mLauncher(launcher)
{
}

TsTask::~TsTask()
{
    delete mContent;
}

bool TsTask::isClosable() const
{   
    return mContent->mClosable;
}

bool TsTask::isActive() const
{   
    return mContent->mActive;
}

QPixmap TsTask::screenshot() const
{
    return QPixmap();
}

QString TsTask::name() const 
{
    return mContent->mName;
}

void TsTask::open()
{
}

void TsTask::close()
{
}
