/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#include "mocktstaskmonitor.h"

TsTaskMonitor::TsTaskMonitor(QObject* parent)
:
    QObject(parent)
{
}

TsTaskMonitor::~TsTaskMonitor()
{}

QList<TsTaskChange> TsTaskMonitor::changeList(bool /*fullList*/)
{
    void* ptr(this);
    return static_cast<MockTsTaskMonitor*>(ptr)->mTasks;
}

MockTsTaskMonitor::MockTsTaskMonitor(QObject *parent)
:
    TsTaskMonitor(parent)
{
    mTasks =  QList<TsTaskChange>();
}

MockTsTaskMonitor::~MockTsTaskMonitor()
{}

void MockTsTaskMonitor::setTaskList(QList<TsTaskChange> tasks)
{
    mTasks = tasks;
    emit taskListChanged();
}

void MockTsTaskMonitor::clearTasks()
{
    mTasks.clear();
}
