/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#include "t_tsdevicedialogplugin.h"

#include <QtTest/QtTest>
#include <HbDeviceDialogInterface>

#include <qvaluespacesubscriber.h>
#include <qvaluespacepublisher.h>
QTM_USE_NAMESPACE

#include <tstestutils.h>
#include <tspropertydefs.h>

#include "tsdevicedialogplugin.h"

void T_TsDeviceDialogPlugin::testCreation()
{
    TsDeviceDialogPlugin *deviceDialogPlugin = new TsDeviceDialogPlugin;
    delete deviceDialogPlugin;
}

void T_TsDeviceDialogPlugin::testAccessAllowed()
{
    TsDeviceDialogPlugin deviceDialogPlugin;
    QVERIFY(deviceDialogPlugin.accessAllowed(QString(), QVariantMap(), QVariantMap()));
}

void T_TsDeviceDialogPlugin::testDialogInfo()
{
    TsDeviceDialogPlugin deviceDialogPlugin;

    HbDeviceDialogPlugin::DeviceDialogInfo info;
    deviceDialogPlugin.deviceDialogInfo(QString(), QVariantMap(), &info);
    QVERIFY(info.group == HbDeviceDialogPlugin::GenericDeviceDialogGroup);
    QVERIFY(info.flags == HbDeviceDialogPlugin::SingleInstance);
    QVERIFY(info.priority == HbDeviceDialogPlugin::DefaultPriority);
}

void T_TsDeviceDialogPlugin::testDialogTypes()
{
    TsDeviceDialogPlugin deviceDialogPlugin;

    QStringList dialogTypes = deviceDialogPlugin.deviceDialogTypes();
    QCOMPARE(1, dialogTypes.count());
    QCOMPARE(QString("com.nokia.taskswitcher.tsdevicedialogplugin/1.0"), dialogTypes.first());
}

void T_TsDeviceDialogPlugin::testPluginFlags()
{
    TsDeviceDialogPlugin deviceDialogPlugin;

    QVERIFY(deviceDialogPlugin.pluginFlags() & HbDeviceDialogPlugin::PreloadPlugin);
    QVERIFY(deviceDialogPlugin.pluginFlags() & HbDeviceDialogPlugin::KeepPluginLoaded);
}

void T_TsDeviceDialogPlugin::testError()
{
    TsDeviceDialogPlugin deviceDialogPlugin;
    QCOMPARE(0, deviceDialogPlugin.error());
}

void T_TsDeviceDialogPlugin::testCreateDialog()
{
    TsDeviceDialogPlugin deviceDialogPlugin;
    QVERIFY(!deviceDialogPlugin.createDeviceDialog("InvalidDialogType", QVariantMap()));
    foreach(const QString &dialogType, deviceDialogPlugin.deviceDialogTypes()) {
        HbDeviceDialogInterface *dialog = deviceDialogPlugin.createDeviceDialog(dialogType, QVariantMap());
        QVERIFY(dialog);
        QVERIFY(0 != dialog->deviceDialogWidget());
        QVERIFY(false == dialog->setDeviceDialogParameters(QVariantMap()));
        dialog->closeDeviceDialog(true);
        QVERIFY(0 == dialog->deviceDialogError());
        delete dialog;
    }
}

void T_TsDeviceDialogPlugin::testNoCrashOnOrientationChange()
{
    TsDeviceDialogPlugin deviceDialogPlugin;
    HbDeviceDialogInterface *dialog = deviceDialogPlugin.createDeviceDialog(deviceDialogPlugin.deviceDialogTypes().first(), QVariantMap());
    QVERIFY(dialog);
    mMainWindow.setOrientation(Qt::Vertical);
    QCoreApplication::processEvents();
    mMainWindow.setOrientation(Qt::Horizontal);
    QCoreApplication::processEvents();
    delete dialog;
}

void T_TsDeviceDialogPlugin::testCreateDeviceDialogTwoTimes()
{
    TsDeviceDialogPlugin deviceDialogPlugin;
    HbDeviceDialogInterface *dialog1 = deviceDialogPlugin.createDeviceDialog(deviceDialogPlugin.deviceDialogTypes().first(), QVariantMap());
    QVERIFY(dialog1);
    HbDeviceDialogInterface *dialog2 = deviceDialogPlugin.createDeviceDialog(deviceDialogPlugin.deviceDialogTypes().first(), QVariantMap());
    QVERIFY(dialog2);

    delete dialog1;
    delete dialog2;
}

void T_TsDeviceDialogPlugin::testCorrectSignalSenderIsReturned()
{
    TsDeviceDialogPlugin deviceDialogPlugin;
    HbDeviceDialogInterface *dialog = deviceDialogPlugin.createDeviceDialog(deviceDialogPlugin.deviceDialogTypes().first(), QVariantMap());
    QVERIFY(dialog);
    QVERIFY(dialog->signalSender());
}

void T_TsDeviceDialogPlugin::testDialogSendsItsStatusNotifications()
{
    QString tsVisibilityPath = QString("%1/%2").arg(TsProperty::KTsPath).arg(TsProperty::KVisibilityPath);
    
    TsDeviceDialogPlugin deviceDialogPlugin;
    HbDeviceDialogInterface *dialog = deviceDialogPlugin.createDeviceDialog(deviceDialogPlugin.deviceDialogTypes().first(), QVariantMap());
    QVERIFY(dialog);
    QCOMPARE(QValueSpaceSubscriber(tsVisibilityPath).value().toBool(), true);
    
    dialog->closeDeviceDialog(true);
    QCOMPARE(QValueSpaceSubscriber(tsVisibilityPath).value().toBool(), false);
    
    delete dialog;
}

void T_TsDeviceDialogPlugin::testDialogCanBeDismissedThroughProperty()
{
    QString tsDismissRequestPath = QString("%1/%2").arg(TsProperty::KTsPath).arg(TsProperty::KDismissRequestPath);
    
    TsDeviceDialogPlugin deviceDialogPlugin;
    HbDeviceDialogInterface *dialog = deviceDialogPlugin.createDeviceDialog(deviceDialogPlugin.deviceDialogTypes().first(), QVariantMap());
    QVERIFY(dialog);
    QCOMPARE(QValueSpaceSubscriber(tsDismissRequestPath).value().toBool(), false);

    QValueSpacePublisher dismissRequestPublisher(TsProperty::KTsPath);
    dismissRequestPublisher.setValue(TsProperty::KDismissRequestPath, static_cast<int>(true));
    dismissRequestPublisher.sync();
    
    QVERIFY(TsTestUtils::waitForSignal(dialog->signalSender(), SIGNAL(deviceDialogClosed()), 3000));
    
    delete dialog;
}

QTEST_MAIN(T_TsDeviceDialogPlugin)
