/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#include "t_tsdocumentloader.h"

#include <QtTest/QtTest>
#include <QGraphicsWidget>

#include "tsdocumentloader.h"

void T_TsDocumentLoader::initTestCase()
{
    mDocumentLoader = new TsDocumentLoader();
    bool ok(false);
    mDocumentLoader->load(":/resource/test.docml", &ok);
    QVERIFY(ok);
}

void T_TsDocumentLoader::cleanupTestCase()
{
    delete mDocumentLoader;
    mDocumentLoader = NULL;
}

void T_TsDocumentLoader::taskGridIsCreated()
{
    QGraphicsWidget *grid = mDocumentLoader->findWidget("grid");
    QVERIFY(grid);
    QCOMPARE(grid->metaObject()->className(), "TsTasksGrid");
}

void T_TsDocumentLoader::taskSwitcherGridItemIsCreated()
{
    QGraphicsWidget *item = mDocumentLoader->findWidget("item");
    QVERIFY(item);
    QCOMPARE(item->metaObject()->className(), "TsTasksGridItem");
}

void T_TsDocumentLoader::noItemsLabelIsCreated()
{
    QGraphicsWidget *noItemsLabel = mDocumentLoader->findWidget("noitemslabel");
    QVERIFY(noItemsLabel);
    QCOMPARE(noItemsLabel->metaObject()->className(), "TsNoItemsLabel");
}

void T_TsDocumentLoader::baseClassIsUsedForOtherTypes()
{
    QGraphicsWidget *hbwidget = mDocumentLoader->findWidget("hbwidget");
    QVERIFY(hbwidget);
    QCOMPARE(hbwidget->metaObject()->className(), "HbWidget");
}

QTEST_MAIN(T_TsDocumentLoader)
