/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#include <QtTest/QtTest>
#include "tsserializeddataprovider.h"
#include "t_tsmodel.h"
#include "t_tsserializeddataprovider.h"

void T_TsSerializedDataProvider::testModelDataChanged()
{
    CTsSerializedDataProvider* provider(0);
    
    mNotifications = 0;
    provider = CTsSerializedDataProvider::NewL(*this);
    T_TsModel emptyModel(0);
    QVERIFY(0 == provider->Data().Length());
    provider->dataChanged(emptyModel);
    QVERIFY(1 == mNotifications);
    QVERIFY(0 < provider->Data().Length());
    delete provider;
    
    mNotifications = 0;
    provider = CTsSerializedDataProvider::NewL(*this);
    T_TsModel model(2);
    QVERIFY(0 == provider->Data().Length());
    provider->dataChanged(model);
    QVERIFY(1 == mNotifications);
    QVERIFY(0 < provider->Data().Length());
    delete provider;
}

void T_TsSerializedDataProvider::testItemDataChanged()
{
    CTsSerializedDataProvider* provider(0);
    
    mNotifications = 0;
    provider = CTsSerializedDataProvider::NewL(*this);
    T_TsModel model(1);
    QVERIFY(0 == provider->Data().Length());
    provider->dataChanged(model.itemL(0));
    QVERIFY(0 == mNotifications);
    QVERIFY(0 == provider->Data().Length());
    delete provider;
}

void T_TsSerializedDataProvider::DataChanged()
{
    ++mNotifications;
}

QTEST_MAIN(T_TsSerializedDataProvider)
