use strict;

my $pkgbase = ";Language - standard language definitions
\&EN,FI,ZH,JA

; standard SIS file header
\#{\"HelloWorldBasicREPLACE1\", \"HelloWorldBasicREPLACE1\", \"HelloWorldBasicREPLACE1\", \"HelloWorldBasicREPLACE1\"},(REPLACEUID),1,0,0

;Localised Vendor name
\%{\"Vendor-EN\", \"Vendor-FI\", \"Vendor-ZH\", \"Vendor-JA\"}

;Unique Vendor name
:\"Vendor\"

;Supports Series 60 v 3.0
[0x101F7961], 0, 0, 0, {\"S60ProductID\", \"S60ProductID\", \"S60ProductID\", \"S60ProductID\"}

";

my $pkgfiles = ";Files
\"\\epoc32\\release\\armv5\\urel\\HelloWorldBasicREPLACE2.exe\" -\"!:\\sys\\bin\\HelloWorldBasicREPLACE2.exe\"

\"\\epoc32\\data\\z\\resource\\apps\\HelloWorldBasicREPLACE2.rsc\" -\"!:\\resource\\apps\\HelloWorldBasicREPLACE2.rsc\"
\"\\epoc32\\data\\z\\resource\\apps\\HelloWorldBasicREPLACE2.r09\" -\"!:\\resource\\apps\\HelloWorldBasicREPLACE2.r09\"
\"\\epoc32\\data\\z\\resource\\apps\\HelloWorldBasicREPLACE2.r31\" -\"!:\\resource\\apps\\HelloWorldBasicREPLACE2.r31\"
\"\\epoc32\\data\\z\\resource\\apps\\HelloWorldBasicREPLACE2.r32\" -\"!:\\resource\\apps\\HelloWorldBasicREPLACE2.r32\"

\"\\epoc32\\data\\z\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.rsc\" -\"!:\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.rsc\"
\"\\epoc32\\data\\z\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.r09\" -\"!:\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.r09\"
\"\\epoc32\\data\\z\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.r31\" -\"!:\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.r31\"
\"\\epoc32\\data\\z\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.r32\" -\"!:\\private\\10003a3f\\import\\apps\\HelloWorldBasicREPLACE2_reg.r32\"
\"\\epoc32\\data\\z\\resource\\apps\\helloworldbasicREPLACE2_aif.mif\" -\"!:\\resource\\apps\\helloworldbasicREPLACE2_aif.mif\"
;end
";

my $appnum = shift;
my $baseuid = 0xA000018A;
my $defaultappforpkg = 5;
my $filenum = $appnum/$defaultappforpkg;
if ($appnum%$defaultappforpkg > 0) 
    {
    $filenum++;
    }

generate();

sub generate()
    {
    my $i = 0;
    for ( $i=1; $i<=$filenum; $i++ ) 
        {
        my $filepart =".\\sis\\helloworldbasicPart".$i."\.pkg";
        open FW, ">$filepart" or die "Couldn't open $filepart to write";
        binmode FW;
        print FW replaceheader($i);
        my $fb = filesbegin($i);
        my $fe = filesend($i);
        for(my $f=$fb; $f<=$fe; $f++)
            {
            print FW replacefiles($f);
            }        
        close FW;    
        }    
    }
    
sub filesend()
    {
    my $fileiter = shift;
    my $fend = $fileiter*$defaultappforpkg;
    if($fend>$appnum)
        {
        $fend = $appnum;
        }
    return $fend;
    }
    
sub filesbegin()
    {
    my $fileiter = shift;
    my $fbegin = ($fileiter-1)*$defaultappforpkg+1;
    return $fbegin;
    }    
    
sub replaceheader()
    {
    my $it = shift;
    my $tempbuf = $pkgbase;
    $tempbuf =~ s/REPLACE1/$it/sg;
    $it = ($it-1)*$defaultappforpkg + 1;
    my $tempuid = uid($it);
    $tempbuf =~ s/REPLACEUID/$tempuid/sg;
    return $tempbuf;
    }
    
sub replacefiles()
    {
    my $it = shift;
    my $tempbuf = $pkgfiles;
    $tempbuf =~ s/REPLACE2/$it/sg;
    return $tempbuf;
    }    
    
sub uid
    {
    my $iter = shift;
    my $uuid = $baseuid + $iter -1;
    my $hu = sprintf '%#X',  $uuid;
    $hu =~s/X/x/;
    return $hu;
    }
