/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#include "lunchwidget.h"
#include <hbapplication>
#include <QStringList>
#include <HbComboBox>
#include <HbIcon>
#include <hbMainWindow>
#include <hbinstance.h>
#include "tstasksettings.h"
#include <XQConversions>
#include <e32base.h>
#include <QFile>
#include <QTextStream>
#include <QTimer>
#include <hblineedit.h>
#include <HbValidator>

#define hbApp qobject_cast<HbApplication*>(qApp)

lunchwidget::lunchwidget(QGraphicsItem *parent)
    : HbWidget(parent), mActionCounter(0)
{
    mFile = new QFile("c:\\data\\helloworldstarter.txt");    
    mFile->open(QIODevice::Append | QIODevice::Text);
    mStream = new QTextStream(mFile);
    
    mResultLabel = new HbLabel("idle");        
    mTenLabel= new HbLabel("10x");        
    mOneLabel= new HbLabel("1x");        
    mPlusLabel= new HbLabel("+");        
   
    
    mStartButton = new HbPushButton("Start");
    mCloseButton = new HbPushButton("Close");
    mAutoButton = new HbPushButton("Auto");
    
    
    mTenCombo = new HbComboBox();
    mOneCombo = new HbComboBox();
    for (int i=0; i<10; i++) {
        QString num;
        num.setNum(i);
        mTenCombo->addItem(num);
        mOneCombo->addItem(num);
    }

    mTimesEdid = new HbLineEdit("300");
    mTimesEdid->setObjectName("TimesEditLine");     
    mQTimesValidator = new QIntValidator(this); 
    mQTimesValidator->setRange(0, 1000000);
    mTimesValidator = new HbValidator(this);
    mTimesValidator->addField(mQTimesValidator, "300");
    mTimesEdid->setValidator(mTimesValidator);
    
    mTimesLabel = new HbLabel("Times:");
    mCounterLabel = new HbLabel("Count:");
    mCounterValueLabel = new HbLabel("");
    
    mGridLayout = new QGraphicsGridLayout();
    mGridLayout->addItem(mResultLabel, 0, 0, 1, 6);
    mGridLayout->addItem(mStartButton, 1, 0, 1, 2);
    mGridLayout->addItem(mCloseButton, 1, 3, 1, 2);
    mGridLayout->addItem(mAutoButton, 1, 5, 1, 2);
    mGridLayout->addItem(mTenLabel, 2, 0, 1, 2);
    mGridLayout->addItem(mPlusLabel, 2, 2, 1, 2);
    mGridLayout->addItem(mOneLabel, 2, 4, 1, 2);    
    mGridLayout->addItem(mTenCombo, 3, 0, 1, 3);
    mGridLayout->addItem(mOneCombo, 3, 4, 1, 3);
    mGridLayout->addItem(mTimesLabel, 4, 0, 1, 2);
    mGridLayout->addItem(mTimesEdid, 4, 3, 1, 4);
    mGridLayout->addItem(mCounterLabel, 5, 0, 1, 3);
    mGridLayout->addItem(mCounterValueLabel, 5, 4, 1, 3);
    
    setLayout(mGridLayout);
    
    connect( mStartButton, SIGNAL(released()), this, SLOT(start()) );
    connect( mCloseButton, SIGNAL(released()), this, SLOT(stop()) );
    connect( mAutoButton, SIGNAL(released()), this, SLOT(automat()) );
    
    mTimer = new QTimer(this);
    connect(mTimer, SIGNAL(timeout()), this, SLOT(timeout()));
    
}

lunchwidget::~lunchwidget()
{
    delete mFile;
    delete mStream;  
    delete mQTimesValidator;
    delete mTimesValidator;
}

void lunchwidget::start() 
{
    int ten = mTenCombo->currentText().toInt();
    int one = mOneCombo->currentText().toInt();
    int num = ten*10+one;
    for (int i=1; i<=num; i++) {        
        QString application;
        application = tr("HelloWorldBasic%1").arg(i);
        mResultLabel->setPlainText(application);
        HBufC *appName = XQConversions::qStringToS60Desc(application);
        CleanupStack::PushL(appName);   

        RProcess process;
        CleanupClosePushL(process);

        bool result = false;
        if (process.Create(*appName, KNullDesC()) == KErrNone) {        
            // wait until process reports it's ready
            TRequestStatus stat;
            process.Rendezvous(stat);
            process.Resume();
            User::WaitForRequest(stat);
            
            if (stat.Int() == KErrNone) {                
                result = true;
                User::After(1000);
            }    
        }
        
        CleanupStack::PopAndDestroy(&process);
        CleanupStack::PopAndDestroy(appName);
    }
}

void lunchwidget::stop()
{
    RProcess application;
    TFindProcess finder(_L("*hello*"));
    TFullName fullname;
     while (finder.Next(fullname) == KErrNone) {
         TInt err = application.Open(fullname);
         if (err==KErrNone && (application.FileName().Find(_L("HelloWorldBasic"))>=0 || application.FileName().Find(_L("helloworldbasic"))>=0)) {
             application.Terminate(KErrCancel);
             User::After(1000);
         }
         application.Close();
     }
}

void lunchwidget::timeout()
{
    if(mActionCounter == mTimes) {
        stop();
        mTimer->stop();
        *mStream<<"end\n";
        mStream->flush();
        enableControls(true);
    }
    if(!mOpened) {
        start();
        mOpened = true;
    }
    else {
        stop();
        mOpened = false;
        mActionCounter++;
        *mStream<<mActionCounter<<"\n";
        mStream->flush();
        setCounterLabel(mActionCounter);
    }
    
    
}

void lunchwidget::automat()
{
    mTimes = times();
    mActionCounter = 0;
    *mStream<<"auto open\n";
    mStream->flush();
    mOpened = false;
    enableControls(false);
    mTimer->start(2000);
}

void lunchwidget::enableControls(bool enable)
{    
    mStartButton->setEnabled(enable);
    mCloseButton->setEnabled(enable);
    mAutoButton->setEnabled(enable);
    mTenCombo->setEnabled(enable);
    mOneCombo->setEnabled(enable);
    mTimesEdid->setEnabled(enable);
}

void lunchwidget::setCounterLabel(int count)
{
    QString num;
    num.setNum(count);
    mCounterValueLabel->setPlainText(num);
}

int lunchwidget::times()
{
    QString ttext = mTimesEdid->text();
    bool ok;
    int times = ttext.toInt(&ok);
    if(!ok) {
        times = 0;
    }
    return times;
}
