/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#ifndef LUNCHWIDGET_H_
#define LUNCHWIDGET_H_

#include <hbwidget.h>
#include <QGraphicsLinearLayout>
#include <QGraphicsGridLayout>
#include <HbPushButton>
#include <hblabel.h>

class HbComboBox;
class QFile;
class QTextStream;
class QTimer;
class HbValidator;
class HbLineEdit;

class lunchwidget: public HbWidget
{
    Q_OBJECT
public:
    lunchwidget(QGraphicsItem *parent = 0);
    ~lunchwidget();

private:

    QGraphicsGridLayout *mGridLayout;
    HbPushButton *mStartButton;
    HbPushButton *mCloseButton;
    HbPushButton *mAutoButton;
    HbComboBox *mTenCombo;
    HbComboBox *mOneCombo;
    HbLineEdit* mTimesEdid;
    HbLabel* mResultLabel;    
    HbLabel* mTenLabel;    
    HbLabel* mPlusLabel;    
    HbLabel* mOneLabel;        
    HbLabel* mTimesLabel;
    HbLabel* mCounterLabel;
    HbLabel* mCounterValueLabel;
    
    QFile* mFile;
    QTextStream* mStream;
    
    QTimer* mTimer;
    int mActionCounter;
    int mTimes;
    bool mOpened;
    
    QIntValidator* mQTimesValidator;
    HbValidator* mTimesValidator;
    

private:

    
private slots:
    void start();
    void stop();
    void automat();
    void timeout();

private:    
    void enableControls(bool enable);
    void setCounterLabel(int count);
    int times();

};

#endif /* LUNCHWIDGET_H_*/
