/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#ifndef TSTESTMODEL_H
#define TSTESTMODEL_H

#include <QObject>
#include <QVariantHash>
#include <QColor>
#include <QPixmap>


#include <qvaluespacesubscriber.h>
QTM_USE_NAMESPACE

#if defined(Q_OS_SYMBIAN)
    #include <fbs.h>
#endif

class TsTestModel : public QObject
{
    Q_OBJECT

public:
    TsTestModel(QObject *parent = 0);
    virtual ~TsTestModel();

public slots:
    QList<QVariantHash> taskList() const;
    QList<QVariantHash> taskList(int limit) const;
    
    bool openTask(const QVariant &id);
    bool closeTask(const QVariant &id);
    

private slots:
    void verifyConnection();
    void checkValue();
    
signals:
    void dataChanged();    
    
private:
    void removeAll();
    char byte(int numtoget, int byte);
    QColor generateColor(int item);
    QPixmap generatePixmap(int item);
    void addItem(bool running, bool closeable);
    void addItems(int num, bool running, bool closeable);
    
private:
    QList<QVariantHash> mData;
    bool mWasValid;
#if defined(Q_OS_SYMBIAN)
    QList<CFbsBitmap*> mBitmaps;
#endif
    QValueSpaceSubscriber mSubscriber;
};

#endif // TSTESTMODEL_H
