/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#ifndef LUNCWIDGET_H_
#define LUNCWIDGET_H_

#include <hbwidget.h>
#include <QGraphicsLinearLayout>
#include <QGraphicsGridLayout>
#include <QTimer>
#include <HbPushButton>
#include <hblabel.h>
#include <qvaluespacepublisher.h>

QTM_USE_NAMESPACE

class HbComboBox;
class HbCheckBox;

class lunchwidget: public HbWidget
{
    Q_OBJECT
public:
    lunchwidget(QGraphicsItem *parent = 0);
    ~lunchwidget();


private slots:
        
    void remove();
    void add();

private:
    void setByte(int& numtoset, int byte, char value);
    char byte(int numtoget, int byte);
    
private:
    HbLabel* mLoadLabel;    
    HbLabel* mTenLabel;    
    HbLabel* mOneLabel; 
    HbComboBox *mTenCombo;
    HbComboBox *mOneCombo;
    HbCheckBox* mRunningCheckBox;
    HbCheckBox* mCloseableCheckBox;
    QGraphicsGridLayout *mGridLayout;
    HbPushButton *mAdd;
    HbPushButton *mRemove;
    QValueSpacePublisher mPluginPublisher;
};

#endif /* LUNCWIDGET_H_*/
