/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

#include "afmanager.h"
#include <QPixmap>

const char myName [] = "TestActivityManager";

AfManager::AfManager(QObject *parent) : QObject(parent)
{
    setObjectName(myName);
    mData = QList<QVariantHash>();
}

AfManager::~AfManager()
{
}

QList<QVariantHash> AfManager::activitiesList()
{
    return mData;
}

void AfManager::setActivitiesList(const QList<QVariantHash>& activities)
{
    mData = activities;
}

void AfManager::launchActivity(const QString &uri)
{
    Q_UNUSED(uri);
}

void AfManager::launchActivity(int applicationId, const QString &activityId)
{
    Q_UNUSED(applicationId);
    Q_UNUSED(activityId);
}

void AfManager::getThumbnail(QSize resolution, const QString &thumbnailId, void *userData)
{
    Q_UNUSED(thumbnailId);
    Q_UNUSED(resolution);
    emit thumbnailReady(QPixmap(), userData);
}

void AfManager::emitDataChanged()
{
    emit dataChanged();
}

void AfManager::clearActivities()
{
    mData.clear();
}
