/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
#ifndef T_TSMODEL_H
#define T_TSMODEL_H



#include <QObject>
#include <qlist.h>
#include <QSharedPointer>
#include <QVariant>
#include <QModelIndex>

#include "mocktstask.h"
#include "mocktstaskmonitor.h"

class TsModel;
class TsTaskChangeInfo;

/**
* @test Test class for TsModel
*/
class T_TsModel : public QObject, public TsTaskLauncher
{
    Q_OBJECT

private slots:
    void testData();
    void testRowCount();
    void testOpenApplication();
    void testCloseApplication();
    void testActivityWithNoIdDisplaysProperApplicationName();
    void testDataChangedSignalIsEmittedWhenActivityScreenshotIsUpdated();
    void testCustomNameIsUsedIfPresent();
    void testInsert1();
    void testDelete1();
    void testChange1();
    void testMove1();
    void testFullUpdateFromActivities();

private slots:
    void initTestCase();
    void cleanupTestCase();

private:
    QObject *activityService();
    QList<QVariantHash> activityDataSet(int)const;
    QList<TsTaskChange> appDataSetFull(int);
    QList<TsTaskChange> changeDataSet5New();
    QList<TsTaskChange> changeDataSetDelete1(int index);
    QList<TsTaskChange> changeDataSetInsert1(int index);
    QList<TsTaskChange> changeDataSetChange1(int index);
    QList<TsTaskChange> changeDataSetMove1(int newIndex, int oldIndex);
    void clearModel();
    
    int activityDataSetsCount()const;
   

private:
    TsModel *mModel;
    TsTaskMonitor *mAppSrv;
    QObject *mActSrv;
};

Q_DECLARE_METATYPE(QModelIndex)

#endif //T_TSMODEL_H
