/*
* Copyright (c) 2006-2007 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Thumbnail server
 *
*/
// Created by TraceCompiler 2.3.0
// DO NOT EDIT, CHANGES WILL BE LOST

#ifndef __THUMBNAILSERVERTRACES_H__
#define __THUMBNAILSERVERTRACES_H__

#define KOstTraceComponentID 0x102830ab

#define CTHUMBNAILSERVER_CONSTRUCTL 0x860061
#define CTHUMBNAILSERVER_CTHUMBNAILSERVER 0x860063
#define CTHUMBNAILSERVER_HANDLESESSIONOPENED 0x860064
#define CTHUMBNAILSERVER_HANDLESESSIONERROR 0x860065
#define DUP1_CTHUMBNAILSERVER_HANDLESESSIONERROR 0x860066
#define CTHUMBNAILSERVER_THREADFUNCTIONL 0x860067
#define DUP1_CTHUMBNAILSERVER_THREADFUNCTIONL 0x860068
#define CTHUMBNAILSERVER_ADDSESSION 0x860069
#define CTHUMBNAILSERVER_DROPSESSION 0x86006a
#define DUP1_CTHUMBNAILSERVER_DROPSESSION 0x86006b
#define DUP2_CTHUMBNAILSERVER_DROPSESSION 0x86006c
#define DUP3_CTHUMBNAILSERVER_DROPSESSION 0x86006d
#define CTHUMBNAILSERVER_SHUTDOWNNOTIFICATION 0x86006e
#define DUP1_CTHUMBNAILSERVER_SHUTDOWNNOTIFICATION 0x86006f
#define CTHUMBNAILSERVER_ADDBITMAPTOPOOLL 0x860070
#define DUP1_CTHUMBNAILSERVER_ADDBITMAPTOPOOLL 0x860071
#define DUP2_CTHUMBNAILSERVER_ADDBITMAPTOPOOLL 0x860072
#define CTHUMBNAILSERVER_STORETHUMBNAILL 0x860073
#define DUP1_CTHUMBNAILSERVER_STORETHUMBNAILL 0x860074
#define DUP2_CTHUMBNAILSERVER_STORETHUMBNAILL 0x860075
#define DUP3_CTHUMBNAILSERVER_STORETHUMBNAILL 0x860076
#define DUP4_CTHUMBNAILSERVER_STORETHUMBNAILL 0x860077
#define CTHUMBNAILSERVER_FETCHTHUMBNAILL 0x860078
#define CTHUMBNAILSERVER_DELETEBITMAPFROMPOOL 0x860079
#define DUP1_CTHUMBNAILSERVER_DELETEBITMAPFROMPOOL 0x86007a
#define DUP2_CTHUMBNAILSERVER_DELETEBITMAPFROMPOOL 0x86007b
#define DUP3_CTHUMBNAILSERVER_DELETEBITMAPFROMPOOL 0x86007c
#define DUP4_CTHUMBNAILSERVER_DELETEBITMAPFROMPOOL 0x86007d
#define CTHUMBNAILSERVER_DELETETHUMBNAILSL 0x86007e
#define CTHUMBNAILSERVER_RESOLVEMIMETYPEL 0x86007f
#define DUP1_CTHUMBNAILSERVER_RESOLVEMIMETYPEL 0x860080
#define DUP1_CTHUMBNAILSERVER_RESOLVEPROVIDERL 0x860081
#define DUP2_CTHUMBNAILSERVER_RESOLVEPROVIDERL 0x860082
#define CTHUMBNAILSERVER_RESOLVEPROVIDERL 0x860083
#define DUP1_CTHUMBNAILSERVER_GETPROVIDERL 0x860084
#define CTHUMBNAILSERVER_PRELOADPROVIDERS 0x860085
#define CTHUMBNAILSERVER_DEQUETASK 0x860086
#define DUP1_CTHUMBNAILSERVER_DEQUETASK 0x860087
#define CTHUMBNAILSERVER_STOREFORDRIVEL 0x860088
#define DUP1_CTHUMBNAILSERVER_STOREFORDRIVEL 0x860089
#define DUP2_CTHUMBNAILSERVER_STOREFORDRIVEL 0x86008a
#define DUP3_CTHUMBNAILSERVER_STOREFORDRIVEL 0x86008b
#define DUP4_CTHUMBNAILSERVER_STOREFORDRIVEL 0x86008c
#define DUP5_CTHUMBNAILSERVER_STOREFORDRIVEL 0x86008d
#define DUP6_CTHUMBNAILSERVER_STOREFORDRIVEL 0x86008e
#define CTHUMBNAILSERVER_STOREFORPATHL 0x86008f
#define CTHUMBNAILSERVER_OPENSTORESL 0x860090
#define CTHUMBNAILSERVER_CLOSESTOREFORDRIVEL 0x860091
#define CTHUMBNAILSERVER_ADDUNMOUNTOBSERVERSL 0x860092
#define CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860093
#define DUP1_CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860094
#define DUP2_CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860095
#define DUP3_CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860096
#define DUP4_CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860097
#define DUP5_CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860098
#define DUP6_CTHUMBNAILSERVER_MEMORYCARDSTATUSCHANGEDL 0x860099
#define CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x86009a
#define DUP2_CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x86009b
#define DUP3_CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x86009c
#define DUP4_CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x86009d
#define DUP5_CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x86009e
#define DUP6_CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x86009f
#define DUP7_CTHUMBNAILSERVER_UPDATETHUMBNAILSL 0x8600a0
#define CTHUMBNAILSERVER_RENAMETHUMBNAILSL 0x8600a1
#define _E32MAIN 0x8600a2
#define DUP2__E32MAIN 0x8600a3
#define DUP1__E32MAIN 0x8600a4
#define CTHUMBNAILSERVER_CLOSEREMOVABLEDRIVESL 0x8600a5
#define CTHUMBNAILSERVER_OPENREMOVABLEDRIVESL 0x8600a6
#define CTHUMBNAILSERVER_FORMATNOTIFICATION 0x8600a7
#define CTHUMBNAILSERVER_RECONNECTCALLBACK 0x8600a8
#define DUP1_CTHUMBNAILSERVER_RECONNECTCALLBACK 0x8600a9
#define CTHUMBNAILSERVER_ISPUBLICPATH 0x8600aa
#define DUP1_CTHUMBNAILSERVER_ISPUBLICPATH 0x8600ab
#define CTHUMBNAILSERVER_STARTUNMOUNTTIMEOUT 0x8600ac
#define DUP1_CTHUMBNAILSERVER_STARTUNMOUNTTIMEOUT 0x8600ad
#define CTHUMBNAILSERVER_UNMOUNTCALLBACK 0x8600ae
#define DUP1_CTHUMBNAILSERVER_UNMOUNTCALLBACK 0x8600af


#ifndef __KERNEL_MODE__
#ifndef __OSTTRACEGEN1_TUINT32_CONST_TDESC16REF__
#define __OSTTRACEGEN1_TUINT32_CONST_TDESC16REF__

inline TBool OstTraceGen1( TUint32 aTraceID, const TDesC16& aParam1 )
    {
    TBool retval;
    TInt size = aParam1.Size();
    // BTrace assumes that parameter size is atleast 4 bytes
    if (size % 4 == 0)
        {
        TUint8* ptr = ( TUint8* )aParam1.Ptr();
        // Data is written directly and length is determined from trace message length
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, size );
        }
    else
        {
        TUint8 data[ KOstMaxDataLength ];
        TUint8* ptr = data;
        if (size > KOstMaxDataLength)
            {
            size = KOstMaxDataLength;
            }
        TInt sizeAligned = ( size + 3 ) & ~3;
        memcpy( ptr, aParam1.Ptr(), size );
        ptr += size;
        // Fillers are written to get 32-bit alignment
        while ( size++ < sizeAligned )
            {
            *ptr++ = 0;
            }
        ptr -= sizeAligned;
        size = sizeAligned;
        // Data is written directly and length is determined from trace message length
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, size );
        }
    return retval;
    }

#endif // __OSTTRACEGEN1_TUINT32_CONST_TDESC16REF__

#endif


#ifndef __OSTTRACEGEN3_TUINT32_TINT_TINT_TUINT__
#define __OSTTRACEGEN3_TUINT32_TINT_TINT_TUINT__

inline TBool OstTraceGen3( TUint32 aTraceID, TInt aParam1, TInt aParam2, TUint aParam3 )
    {
    TBool retval = BTraceFiltered8( EXTRACT_GROUP_ID(aTraceID), EOstTraceActivationQuery, KOstTraceComponentID, aTraceID );
    if ( retval )
        {
        TUint8 data[ 12 ];
        TUint8* ptr = data;
        *( ( TInt* )ptr ) = aParam1;
        ptr += sizeof ( TInt );
        *( ( TInt* )ptr ) = aParam2;
        ptr += sizeof ( TInt );
        *( ( TUint* )ptr ) = aParam3;
        ptr += sizeof ( TUint );
        ptr -= 12;
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, 12 );
        }
    return retval;
    }

#endif // __OSTTRACEGEN3_TUINT32_TINT_TINT_TUINT__


#ifndef __OSTTRACEGEN3_TUINT32_TINT32_TINT32_TUINT32__
#define __OSTTRACEGEN3_TUINT32_TINT32_TINT32_TUINT32__

inline TBool OstTraceGen3( TUint32 aTraceID, TInt32 aParam1, TInt32 aParam2, TUint32 aParam3 )
    {
    TBool retval = BTraceFiltered8( EXTRACT_GROUP_ID(aTraceID), EOstTraceActivationQuery, KOstTraceComponentID, aTraceID );
    if ( retval )
        {
        TUint8 data[ 12 ];
        TUint8* ptr = data;
        *( ( TInt* )ptr ) = aParam1;
        ptr += sizeof ( TInt );
        *( ( TInt* )ptr ) = aParam2;
        ptr += sizeof ( TInt );
        *( ( TUint* )ptr ) = aParam3;
        ptr += sizeof ( TUint );
        ptr -= 12;
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, 12 );
        }
    return retval;
    }

#endif // __OSTTRACEGEN3_TUINT32_TINT32_TINT32_TUINT32__



#ifndef __KERNEL_MODE__
#ifndef __OSTTRACEGEN2_TUINT32_CONST_TDESC16REF_TUINT16__
#define __OSTTRACEGEN2_TUINT32_CONST_TDESC16REF_TUINT16__

inline TBool OstTraceGen2( TUint32 aTraceID, const TDesC16& aParam1, TUint16 aParam2 )
    {
    TBool retval = BTraceFiltered8( EXTRACT_GROUP_ID(aTraceID), EOstTraceActivationQuery, KOstTraceComponentID, aTraceID );
    if ( retval )
        {
        TInt length = 0;
        // Check that parameter lenght is not too long
        TInt length1 = aParam1.Size();
        if ((length + length1 + sizeof ( TUint32 )) > KOstMaxDataLength)
            {
            length1 = KOstMaxDataLength - (length + sizeof ( TUint32 ));
            }
        TInt lengthAligned1 = ( length1 + 3 ) & ~3;
        if (lengthAligned1 > 0)
            {
            length = length + sizeof ( TUint32 ) + lengthAligned1;
            }
        TUint8 data[ KOstMaxDataLength ];
        TUint8* ptr = data;
        // Set length to zero and calculate it againg
        // when adding parameters
        length = 0;
        if (length1 > 0)
            {
            // Number of elements is written before data
            // In case of Unicode string, number of elements is half of length
            *( ( TUint32* )ptr ) = length1 / (aParam1.Size() / aParam1.Length());
            ptr += sizeof ( TUint32 );
            memcpy( ptr, aParam1.Ptr(), length1 );
            ptr += length1;
            // Fillers are written to get 32-bit alignment
            while ( length1++ < lengthAligned1 )
                {
                *ptr++ = 0;
                }
            length += sizeof ( TUint32 ) + lengthAligned1;
            }
        else if (length + sizeof ( TUint32 ) <= KOstMaxDataLength)
            {
            *( ( TUint32* )ptr ) = 0;
            ptr += sizeof ( TUint32 );
            length += sizeof ( TUint32 );
            }
        // Check that there are enough space to next parameter
        if ((length + sizeof ( TUint16 )) <= KOstMaxDataLength)
            {
            *( ( TUint16* )ptr ) = aParam2;
            ptr += sizeof ( TUint16 );
            length += sizeof ( TUint16 );
            }
        *( ( TUint8* )ptr ) = 0;
        ptr += sizeof ( TUint8 );
        *( ( TUint8* )ptr ) = 0;
        ptr += sizeof ( TUint8 );
        ptr -= length;
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, length );
        }
    return retval;
    }

#endif // __OSTTRACEGEN2_TUINT32_CONST_TDESC16REF_TUINT16__

#endif


#ifndef __OSTTRACEGEN2_TUINT32_TINT_TINT__
#define __OSTTRACEGEN2_TUINT32_TINT_TINT__

inline TBool OstTraceGen2( TUint32 aTraceID, TInt aParam1, TInt aParam2 )
    {
    TBool retval = BTraceFiltered8( EXTRACT_GROUP_ID(aTraceID), EOstTraceActivationQuery, KOstTraceComponentID, aTraceID );
    if ( retval )
        {
        TUint8 data[ 8 ];
        TUint8* ptr = data;
        *( ( TInt* )ptr ) = aParam1;
        ptr += sizeof ( TInt );
        *( ( TInt* )ptr ) = aParam2;
        ptr += sizeof ( TInt );
        ptr -= 8;
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, 8 );
        }
    return retval;
    }

#endif // __OSTTRACEGEN2_TUINT32_TINT_TINT__


#ifndef __OSTTRACEGEN2_TUINT32_TINT32_TINT32__
#define __OSTTRACEGEN2_TUINT32_TINT32_TINT32__

inline TBool OstTraceGen2( TUint32 aTraceID, TInt32 aParam1, TInt32 aParam2 )
    {
    TBool retval = BTraceFiltered8( EXTRACT_GROUP_ID(aTraceID), EOstTraceActivationQuery, KOstTraceComponentID, aTraceID );
    if ( retval )
        {
        TUint8 data[ 8 ];
        TUint8* ptr = data;
        *( ( TInt* )ptr ) = aParam1;
        ptr += sizeof ( TInt );
        *( ( TInt* )ptr ) = aParam2;
        ptr += sizeof ( TInt );
        ptr -= 8;
        retval = OstSendNBytes( EXTRACT_GROUP_ID(aTraceID), EOstTrace, KOstTraceComponentID, aTraceID, ptr, 8 );
        }
    return retval;
    }

#endif // __OSTTRACEGEN2_TUINT32_TINT32_TINT32__



#endif

// End of file

