/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0""
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:           
*       Provides the CAknFepUICtrlCandidateCharacter definition.
*
*/












#ifndef __AKN_FEP_CANDIDATE_CHARACTER_PANE_H__
#define __AKN_FEP_CANDIDATE_CHARACTER_PANE_H__

#include <e32std.h>
#include <coecntrl.h>

#include "AknFepUICtrlCandidatePane.h"

class CEikLabel;
class MAknFepUIEventObserver;

/**
 * Control representing the selected candidate. Is a window owning control,
 * that appears over the candidate pane such that it obscures the labels
 * beneath. Can be hidden, for example if there is no visible selection, 
 * or if highlighting is disabled.
 */
NONSHARABLE_CLASS(CAknFepUICtrlCandidateCharacter) : public CCoeControl
    {
public:
    enum
        {
		EOneCandidate = 1,
        EMaxSelectedCandidateLength = 10 // extend buffer for phrase input
        };
public:

    /**
     * first phase construction
     */
    static CAknFepUICtrlCandidateCharacter* NewL( RWindowTreeNode& aParent, 
    		                                      MAknFepUIEventObserver* aObserver );

    /**
     * destructor
     */
    ~CAknFepUICtrlCandidateCharacter();

    /**
     * Set the text buffer of the character.
     *
     * @param aCharacter, the label will be filled with the characters from aCharacter
     */
    void SetText( const TDesC& aCharacter );

    /**
     * Get the text of the character
     *
     */
	const TDesC* Text() const;

public: // from CCoeControl
    /**
     * size changed
     */
    virtual void SizeChanged();

    /**
     * count component controls
     *
     * @return number of contained controls
     */
    TInt CountComponentControls() const;

    /**
     * Component control
     *
     * @param aIndex the control to return, must be between 0 and the number of controls
     * @return pointer to contained control, ownership is not passed
     */
    CCoeControl* ComponentControl(TInt aIndex) const;

    /**
     * draw
     *
     * @param aRect rectangle
     */
    virtual void Draw( const TRect& aRect ) const;
    
    /**
     * Set character highlight state
     *
     * @param bHighlight highlight or not
     */
    void SetHighlight( TBool bHightlight );

protected:
    /**
     * second phase construction
     */
    void ConstructL( RWindowTreeNode& aParent, MAknFepUIEventObserver* aObserver );

     /**
      * constructor
      */
    CAknFepUICtrlCandidateCharacter();

    /**
     * layout the rectangles
     */
    void LayoutRects();

    /**
     * layout contained controls
     */
    void LayoutContainedControls();

    /**
     * layout the background frames
     *
     * @param aOuterRect filled with outer rect coords
     * @param aInnerRect filled with inner rect coords
     *
     */
    void CalculateFrameRects(TRect& aOuterRect, TRect& aInnerRect) const;
    
private:
    TAknLayoutRect iRectShadow;
    TAknLayoutRect iRectHighlight;
	TBufC<EMaxSelectedCandidateLength> iBuffer;
	
private: // the following are owned
    CEikLabel* iCandidateLabel;
	TBool iIsHighligt;
    };

#endif //__AKN_FEP_CANDIDATE_CHARACTER_PANE_H__

// End of file
