/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0""
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:           
*       Provides the CAknFepUICtrlContainerChinese methods.
*
*/












#include <coemain.h>
#include <eikenv.h>
#include <eikappui.h>
#ifdef SYMBIAN_ENABLE_SPLIT_HEADERS
#include <uikon/eikdefmacros.h>
#endif


#include <AknLayoutDef.h>
#include <AknLayout.lag>
#include <AknUtils.h>
#include <AknsDrawUtils.h>
#include <AknsFrameBackgroundControlContext.h>
#include <skinlayout.cdl.h>
#include <AknDef.h>
#include <coemain.h>
#include "AknFepUiInputStateBase.h"

#include "AknFepUiInterfacePanic.h"
#include "AknFepUIAvkonCtrlContainerChinese.h"
#include "AknFepUIAvkonCtrlCandidatePane.h"
#include "AknFepUIAvkonCtrlInputPane.h"
#include "AknFepUIAvkonCtrlPinyinPopup.h"
#include "aknfepuictrlpinyineep.h"
#include "AknFepManager.h"
#include "aknfepchineseuidataconv.h"
#include "aknfepuilayoutdatamgr.h"

MAknFepUICtrlContainerChinese::~MAknFepUICtrlContainerChinese()
	{
	}
	
CAknFepUICtrlContainerChinese::CAknFepUICtrlContainerChinese()
    :
    iPaneLayout(ELayoutInput),
    iContainerPosition(TPoint(0,0)),
    isPCLPosed(EFalse)
    {

    }

CAknFepUICtrlContainerChinese* CAknFepUICtrlContainerChinese::NewL()
    {
    CAknFepUICtrlContainerChinese* self = new(ELeave) CAknFepUICtrlContainerChinese;
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop();
    return self;
    }

MAknFepUICtrlInputPane* CAknFepUICtrlContainerChinese::InputPane() const
    {
    return iInputPane;
    }

MAknFepUICtrlCandidatePane* CAknFepUICtrlContainerChinese::CandidatePane() const
    {
    return iCandidatePane;
    }

MAknFepUICtrlPinyinPopup* CAknFepUICtrlContainerChinese::PinyinPopupWindow() const
    {
    return iPinyinPopupWindow;
    }

MAknFepUICtrlEditPane* CAknFepUICtrlContainerChinese::EditPaneWindow() const
    {
    return iEditPane;
    }

TBool CAknFepUICtrlContainerChinese::IsEnabled() const
    {
    return iEnabled;
    }

void CAknFepUICtrlContainerChinese::Enable(TBool aEnable)
    {
	if(!COMPARE_BOOLS(iEnabled, aEnable))
        {
        iEnabled = aEnable;
        if(aEnable)
            {
            Window().SetOrdinalPosition(0, ECoeWinPriorityFep); // right at the front
            // make sure we are not faded even if a query has appeared
            Window().SetFaded(EFalse, RWindowTreeNode::EFadeIncludeChildren); 
            ClaimPointerGrab(ETrue);
            // Set enable to capture outside pointer down event to close UI.
            SetPointerCapture( ETrue );
            }
        else
            {
            // make sure that the popup window is disabled as well
            iInputPane->MakeVisible(aEnable); 
            iPinyinPopupWindow->Enable(aEnable);
            iEditPane->Enable(aEnable);
            iCandidatePane->Enable(aEnable);
            ClaimPointerGrab(EFalse);
        	// Set disable to capture outside pointer event
            SetPointerCapture( EFalse );
            }
        MakeVisible(aEnable);
        }
    if ( aEnable == EFalse )
        {
        if ( iFepMan )
            {
            iFepMan->PinyinPhraseCreation( EFalse );
            iFepMan->EntryPhrase( EFalse );
            iFepMan->EnableKeyStar( ETrue );
            iFepMan->PhraseCreation( EFalse );
            }
        PinyinPopupWindow()->ResetStrokeArray();
        PinyinPopupWindow()->SetLastResouce( 0 );
	    iPinyinPopupWindow->ResetInputLayoutMiniQwertyZhuyin();
#ifdef RD_INTELLIGENT_TEXT_INPUT
	    iEditPane->ResetAllArray();
	    iEditPane->SetEffictiveLength( 0 );
	    iEditPane->SetChangeState( EFalse );
#endif
        }
    else
    	{
		Window().Invalidate();
    	}
    }  
  
void CAknFepUICtrlContainerChinese::ConstructL()
    {
    CreateWindowL();
    SetNonFocusing();
    RWindow& window=Window();
        
    // Need receive drag events.
    window.PointerFilter( EPointerFilterDrag, 0 );
    window.SetOrdinalPosition(0, ECoeWinPriorityFep); // right at the front
    MakeVisible(EFalse);

    iEikonEnv->EikAppUi()->AddToStackL(this, ECoeStackPriorityDefault, ECoeStackFlagRefusesFocus);

    iLafDataMgr = CAknFepUiLayoutDataMgr::NewL();
    iInputPane = CAknFepUICtrlInputPane::NewL(window, CAknFepUICtrlInputPane::ELayoutPhraseInputPane, iLafDataMgr);
    iCandidatePane = CAknFepUICtrlCandidatePane::NewL(window, iLafDataMgr, this );
    iPinyinPopupWindow = CAknFepUICtrlPinyinPopup::NewL(window , iLafDataMgr);
    iEditPane = CAknFepUICtrlPinyinEEP::NewL( window, iLafDataMgr );
    iInputPane->SetMopParent(this);
    iCandidatePane->SetMopParent(this);
    iEditPane->SetMopParent(this);

    iInputPane->SetSizeChangedObserver(this);
    iPinyinPopupWindow->SetSizeChangedObserver(this);
    iPinyinPopupWindow->MakeVisible(EFalse);
    iPinyinPopupWindow->SetMopParent( this );
    iEditPane->Enable(EFalse);

    iCandidatePane->SetPaneLayout(iPaneLayout); // set pane layout
    iCandidatePane->SetVisibleCandidateCount(iPaneLayout);
 	iHorizLine = 
 	    CAknFepChineseUIDataConv::AnyToLayoutRect(iLafDataMgr->RequestData(EHorizLine));	    
 	iEEPFirstHorizLine = 
 	    CAknFepChineseUIDataConv::AnyToLayoutRect(iLafDataMgr->RequestData(EEEPFirstHorizLine));
 	iEEPSecondHorizLine = 
 	    CAknFepChineseUIDataConv::AnyToLayoutRect(iLafDataMgr->RequestData(EEEPSecondHorizLine));
 	TInt index = ConvertLayoutToIndex();
    if ( index == 2 || index == 3 )
        {
        index = 0;
        }
    iInputPane->SetLayoutIndex(index);
    TRect outerRect = TRect();
    TRect innerRect = TRect();
    CalculateFrameRects(outerRect, innerRect);

    iBgContext = CAknsFrameBackgroundControlContext::NewL(KAknsIIDQsnFrPopup, outerRect, innerRect, ETrue);
    LayoutContainer();
    ActivateL();
    }

CAknFepUICtrlContainerChinese::~CAknFepUICtrlContainerChinese()
    {
    iEikonEnv->EikAppUi()->RemoveFromStack( this );
    delete iLafDataMgr;
    delete iInputPane;
    delete iCandidatePane;
    delete iPinyinPopupWindow;
    delete iEditPane;
    delete iBgContext;
    }

CCoeControl* CAknFepUICtrlContainerChinese::ComponentControl(TInt aIndex) const 
    {
    CCoeControl* controls[] = 
        {
        iInputPane,
        iCandidatePane,
        iEditPane,
        iPinyinPopupWindow
        } ;

    for (TUint ii = 0; (ii < sizeof(controls) / sizeof(CCoeControl*)) ; ii++)
        {
        if (controls[ii] && aIndex-- == 0)
            {
            return controls[ii] ;
            }
        }
    // shouldn't be called while no components.
    return NULL ;
    }

TInt CAknFepUICtrlContainerChinese::CountComponentControls() const
    {
    CCoeControl* controls[] = 
        {
        iInputPane,
        iCandidatePane,
        iEditPane,
        iPinyinPopupWindow
        } ;

    TInt count = 0 ;
    for (TUint ii = 0 ; ii < (sizeof(controls) / sizeof(CCoeControl*)) ; ii++)
        {
        if(controls[ii])
            {
            count++ ;
            }
        }
    return count ;
    }

TInt CAknFepUICtrlContainerChinese::ConvertLayoutToIndex() const
    {
    TInt layout = -1;
    // switch on the cases in reverse order, and count our way through
    // the possible layouts to determine the index into the layout
    // this means that it is easier to add another layout in between
    switch(iPaneLayout)
        {
        case ELayoutKeystroke: //index 3
            layout++;
        case ELayoutPhraseCreation: //index 2
            layout++;
	    case ELayoutCandidate: //index 1
		    layout++;
	    case ELayoutInput: //index 0
		    layout++;
        default:
            break;
        }
    return layout;
    }

void CAknFepUICtrlContainerChinese::LayoutFrames()
    {
    TRect outerRect;
    TRect innerRect;
    CalculateFrameRects(outerRect, innerRect);
    iBgContext->SetFrameRects(outerRect, innerRect);
    iBgContext->SetParentPos(PositionRelativeToScreen());
    }

void CAknFepUICtrlContainerChinese::CalculateFrameRects(TRect& aOuterRect, TRect& aInnerRect) const
    {
    TRect windowRect = Rect();
    TPoint lPoint(0,0);
    TPoint rPoint(0,0);
    TAknLayoutRect topLeft;
    topLeft.LayoutRect(windowRect, SkinLayout::Submenu_skin_placing_Line_2());

    TAknLayoutRect bottomRight;
    bottomRight.LayoutRect(windowRect, SkinLayout::Submenu_skin_placing_Line_5());
    lPoint.iX = bottomRight.Rect().iTl.iX;
    lPoint.iY = bottomRight.Rect().iTl.iY;
    rPoint.iX = bottomRight.Rect().iBr.iX;
    rPoint.iY = bottomRight.Rect().iBr.iY;

    aOuterRect = TRect(topLeft.Rect().iTl, bottomRight.Rect().iBr);
    aInnerRect = TRect(topLeft.Rect().iBr, bottomRight.Rect().iTl);
    }

void CAknFepUICtrlContainerChinese::Draw(const TRect& /*aRect*/) const
    {
    CWindowGc& gc = SystemGc();
    TBool skinnedDraw = EFalse;
    MAknsSkinInstance* skin = AknsUtils::SkinInstance();

    TRect outerRect;
    TRect innerRect;
    CalculateFrameRects(outerRect, innerRect);
    gc.Clear(Rect());

    skinnedDraw = AknsDrawUtils::DrawFrame(
	    skin, gc, 
	    outerRect, innerRect, 
	    KAknsIIDQsnFrPopupSub, KAknsIIDQsnFrPopupCenterSubmenu); 

    TRgb separatorColor = iHorizLine.Color();
    AknsUtils::GetCachedColor( skin, separatorColor,
          KAknsIIDQsnLineColors, EAknsCIQsnLineColorsCG8 );
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );
    gc.SetBrushColor( separatorColor );

    if(!skinnedDraw)
	    {
	    iRectCoverMainPaneInput.DrawRect(gc);
	    iRectFirstShadowInput.DrawRect(gc);
	    iRectOutlineFrameInput.DrawRect(gc);
	    iRectInsideAreaInput.DrawRect(gc);
	    }
	    
    TInt index = ConvertLayoutToIndex();
    if ( iInputPane->IsVisible( ) || iPinyinPopupWindow->IsVisible() || 
            iPhraseCreationLaf)
        {
        if ( index == 0 || index == 1 )
            {
            iHorizLine.DrawRect(gc);
            }
        }
    if ( index == 2 )
        {
        iEEPFirstHorizLine.DrawRect(gc);
        iEEPSecondHorizLine.DrawRect(gc);
        }
    else if ( index == 3 )
        {
        iEEPFirstHorizLine.DrawRect(gc);
        }

    } 

void CAknFepUICtrlContainerChinese::SizeChanged()
    {
    iLafDataMgr->ReadLafInfo();
    LayoutRects();
    LayoutContainedControls();
    LayoutFrames();
    }

void CAknFepUICtrlContainerChinese::SetLayout(TPaneLayout aPaneLayout)
    {
    if(iPaneLayout != aPaneLayout)
        {
        iPaneLayout = aPaneLayout;
        SetControlVisibility();
        // set visible candidate length 
        iCandidatePane->SetPaneLayout(aPaneLayout);
        TInt index = ConvertLayoutToIndex();
        if ( index == 2 || index == 3)
            {
            index = 0;
            }
        iCandidatePane->SetVisibleCandidateCount(aPaneLayout - index);
        iInputPane->SetLayoutIndex( index );
        LayoutContainer();
        DrawDeferred();
        }
    }

void CAknFepUICtrlContainerChinese::FocusCandidatePane(TBool aValue)
    {
    //iInputPane->SetHighlighted(!aValue);
    iCandidatePane->SetHighlighted(aValue);
    }

void CAknFepUICtrlContainerChinese::SelectionPopupEnabled(TBool /*aEnabled*/)
    {
    // ensure that the input pane is only visible if the popup is not enabled
    SetControlVisibility();
    }

TTypeUid::Ptr CAknFepUICtrlContainerChinese::MopSupplyObject(TTypeUid aId)
    {
    if (aId.iUid == MAknsControlContext::ETypeId)
        return ( MAknsControlContext::SupplyMopObject(aId, iBgContext));
    return CCoeControl::MopSupplyObject(aId);
    }

void CAknFepUICtrlContainerChinese::SelectionPopupSizeChanged(TInt /*aNumLines*/)
    {
    LayoutContainer();
    DrawDeferred();
    }

void CAknFepUICtrlContainerChinese::LayoutPinyinPopupWindow()
    {
	// Use the same rect in Zhuyin input & Phrase creation mode.
	TRect rect = Rect();
	TAknWindowLineLayout popupRect;
	TInt index = ConvertLayoutToIndex();
    switch ( index )
        {
        case 0:
        	popupRect = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EECWindowLayout ));
            break;
        case 2:
        	popupRect = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EECPLayout ));
            break;
        default:        	
            break;
        }
	
    AknLayoutUtils::LayoutControl( iPinyinPopupWindow, rect, popupRect );
    }

void CAknFepUICtrlContainerChinese::LayoutPinyinEEPWindow()
    {
    TRect rect = Rect();  
    TAknWindowLineLayout layoutEEPWindow;
    if ( iPaneLayout == ELayoutPhraseCreation )
    	{
		layoutEEPWindow =
    	    CAknFepChineseUIDataConv::AnyToWindowLine(iLafDataMgr->RequestData(EEntryCPLayout));
    	}
    else
    	{
		layoutEEPWindow =
    	    	    CAknFepChineseUIDataConv::AnyToWindowLine(iLafDataMgr->RequestData(EEntryCLayout));
    	}       
    AknLayoutUtils::LayoutControl(iEditPane, rect, layoutEEPWindow);
    }

void CAknFepUICtrlContainerChinese::SetControlVisibility()
    {
    TBool popupEnabled = iPinyinPopupWindow->IsEnabled();

    switch(iPaneLayout)
	    {
    case ELayoutCandidate:
        // predicative candidate state
        iInputPane->MakeVisible(EFalse);
        iPhraseCreationLaf = EFalse;
        break;
    case ELayoutInput:
        // input state
        iInputPane->MakeVisible(!popupEnabled);
        iPhraseCreationLaf = EFalse;
        break;
    case ELayoutPhraseCreation:
        if ( !iPhraseCreationLaf )
            {
            // input state
            iInputPane->MakeVisible( !popupEnabled );
            }
        else
            {
            iPhraseCreationLaf= EFalse;
            }
    default:
	    break;
	    }
    }

void CAknFepUICtrlContainerChinese::SetIsShownWithPopupWindows(TBool aValue)
    {
    if(!COMPARE_BOOLS(iIsShownWithPopupWindows,aValue))	
        { 
        iIsShownWithPopupWindows = aValue;
        // need to layout container first, so that the parent rect is the right size...
        LayoutContainer();
        // ... now we can layout the rects relative to the resized parent
        LayoutRects();
        // don't need to layout controls, only the rects are affected
        DrawDeferred();
        }
    }

void CAknFepUICtrlContainerChinese::SetContainerPosition(TPoint aCurPos, TInt aHeight)
    {
    TRect rect;
    AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EScreen, rect);
    TInt windowHeight = 0;
    TInt index = ConvertLayoutToIndex();
    switch ( index )
        {
    	// Zhuyin input & phrase creation use the same rect
        case 2:
        	windowHeight = CAknFepChineseUIDataConv::AnyToInt( iLafDataMgr->RequestData( EPopupHeightEEP ));
        	isPCLPosed = ETrue;
            break;
        case 1:
        	windowHeight = CAknFepChineseUIDataConv::AnyToInt( iLafDataMgr->RequestData( EPopupHeightEntry ));
        	isPCLPosed = EFalse;
            break;
        default:
        	windowHeight = CAknFepChineseUIDataConv::AnyToInt( iLafDataMgr->RequestData( EPopupHeightEP ));
        	isPCLPosed = EFalse;
            break;
        }
    // If cursor is covered by the container, move it to the top
    if( aCurPos.iY > rect.iBr.iY - windowHeight )
    	{
        iContainerPosition.iY = aCurPos.iY - windowHeight - aHeight;
    	}
    else
    	{
        iContainerPosition.iY = rect.iBr.iY - windowHeight ;
    	}
    LayoutContainer();
    }

void CAknFepUICtrlContainerChinese::ShowHorizontalScrollArrows(TBool aValue)
    {
    iCandidatePane->ShowHorizontalScrollArrows(aValue);
    }    
   
void CAknFepUICtrlContainerChinese::ShowVerticalScrollArrows(TBool aValue)
    {
    iCandidatePane->ShowVerticalScrollArrows(aValue);
    }

void CAknFepUICtrlContainerChinese::LayoutInputPane()
    {
    TRect rect = Rect();
    TAknWindowLineLayout entryPaneWindowLine;
    TInt index = ConvertLayoutToIndex();
    switch ( index )
        {
        case 2:
        	entryPaneWindowLine = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EECPLayout ));
            break;
        case 1:
        	entryPaneWindowLine = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EECWindowLayout ));
            break;
        default:
        	entryPaneWindowLine = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EECWindowLayout ));
            break;
        }
    AknLayoutUtils::LayoutControl(iInputPane, rect, entryPaneWindowLine );
    }

void CAknFepUICtrlContainerChinese::LayoutContainedControls()
    {
    LayoutInputPane();
    // layout candidate pane
    TAknWindowLineLayout candidatePaneWindowLine ;    
    TInt index = ConvertLayoutToIndex();    
    switch ( index )
        {
        case 2:
        	candidatePaneWindowLine = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EEPCandidateLayout ));
            break;
        case 1:
        	candidatePaneWindowLine = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( ECandidateLayout ));
            break;
        default:
        	candidatePaneWindowLine = CAknFepChineseUIDataConv::AnyToWindowLine( iLafDataMgr->RequestData( EECandidateLayout ));
            break;
        }
    // Layout candidate pane.
    AknLayoutUtils::LayoutControl( iCandidatePane, Rect(), candidatePaneWindowLine );
    
    if (index == 2)
        {
        if ( isPCLPosed )
            {
            iEditPane->Enable( ETrue ); 
            LayoutPinyinPopupWindow();
            LayoutPinyinEEPWindow();
            }
        }
    else if ( index == 0 || index == 1 ) 
        {
        iEditPane->Enable(EFalse);
        LayoutPinyinPopupWindow();
        }
    else
        {
        iEditPane->Enable(ETrue);
        iPinyinPopupWindow->Enable(EFalse);
        LayoutPinyinEEPWindow();
        }
    }

void CAknFepUICtrlContainerChinese::LayoutContainer()
    {
    TInt layoutIndex = ConvertLayoutToIndex(); // 0 : input state layout, 1 : candidate state layout
    TRect rect;
    switch ( layoutIndex )
        {
        case 2:
            rect = CAknFepChineseUIDataConv::AnyToRect( iLafDataMgr->RequestData( EPopupRectEEP ));
            break;
        case 1:
            rect = CAknFepChineseUIDataConv::AnyToRect( iLafDataMgr->RequestData( EPopupRectEntry ));
            break;
        default:
            rect = CAknFepChineseUIDataConv::AnyToRect( iLafDataMgr->RequestData( EPopupRectCandatate ));
            break;
        }

    // Set container rect.
    rect.iBr.iY = iContainerPosition.iY + rect.Height();
    rect.iTl.iY = iContainerPosition.iY;    
    SetRect(rect); 
    }

void CAknFepUICtrlContainerChinese::LayoutRects()
    {
    TInt index = ConvertLayoutToIndex();
    TRect rect = Rect();

    if ( index == 3 )
        {
        index = 0;
        }
    
    switch (index) // 0 : input state, 1: predicative candidate state
	    {
	    case 0:
		    iRectCoverMainPaneInput = CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectCoverMainPaneInputEntry ));
		    iRectFirstShadowInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectFirstShadowInputEntry ));
		    iRectOutlineFrameInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectOutlineFrameInputEntry ));
		    iRectInsideAreaInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectInsideAreaInputEntry ));
		    break;
        case 1:
		    iRectCoverMainPaneInput = CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectCoverMainPaneInputCandidate ));
		    iRectFirstShadowInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectFirstShadowInputCandidate ));
		    iRectOutlineFrameInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectOutlineFrameInputCandidate ));
		    iRectInsideAreaInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectInsideAreaInputCandidate ));
		    break;
        case 2:
		    iRectCoverMainPaneInput = CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectCoverMainPaneInputEEP));
		    iRectFirstShadowInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectFirstShadowInputEEP ));
		    iRectOutlineFrameInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectOutlineFrameInputEEP ));
		    iRectInsideAreaInput= CAknFepChineseUIDataConv::AnyToLayoutRect( iLafDataMgr->RequestData( ERectInsideAreaInputEEP ));
            break;
        default: 
            break;
	    }
    }

void CAknFepUICtrlContainerChinese::HandleResourceChange(TInt aType)
    {
    // maybe should be KEikDynamicLayoutVariantSwitch_APAC, need to have a try after it's ready.
    if(aType == KEikDynamicLayoutVariantSwitch)
        {
        LayoutContainer();
        }
    else
        {
        CCoeControl::HandleResourceChange(aType);
        }
    }
void CAknFepUICtrlContainerChinese::SetControlInVisible( TBool aVisible )
    {
    ShowVerticalScrollArrows( EFalse );
    if ( aVisible == EFalse )
        {
        iCandidatePane->SetInVisiable();
        }
    iPinyinPopupWindow->MakeVisible( EFalse );
    iInputPane->MakeVisible( EFalse );
    iPhraseCreationLaf= ETrue;
    }


TInt& CAknFepUICtrlContainerChinese::IsPhraseCreation()
    {
    return iPhraseCreation;
    }

void CAknFepUICtrlContainerChinese::PhraseCreation(  TBool aPhraseCreation )
    {
    if ( iPhraseCreation != aPhraseCreation )
        {
        iPhraseCreation = aPhraseCreation;
        }
    }

void CAknFepUICtrlContainerChinese::SetFepMan( MAknFepManagerUIInterface* aFepMan )
    {
    iFepMan = aFepMan;
    }

void CAknFepUICtrlContainerChinese::HandlePointerEventL(const TPointerEvent& aPointerEvent)
	{	
	CCoeControl::HandlePointerEventL(aPointerEvent);
	TRect rect = Rect();
	// If click out of the container, close container.
	if (( aPointerEvent.iType == TPointerEvent::EButton1Down )  
	 && ( !rect.Contains( aPointerEvent.iPosition )))
		{
		CloseUI();
		// simulation pointer event to application.
		Window().SetOrdinalPosition(-1);
		User::After(50000);
		TRawEvent eventDown;   
		eventDown.Set( TRawEvent::EButton1Down, 
				       aPointerEvent.iParentPosition.iX, 
				       aPointerEvent.iParentPosition.iY );
		CCoeEnv::Static()->WsSession().SimulateRawEvent( eventDown );
		User::After(1000);
		TRawEvent eventUp; 
		eventUp.Set( TRawEvent::EButton1Up, 
				     aPointerEvent.iParentPosition.iX, 
				     aPointerEvent.iParentPosition.iY );
		CCoeEnv::Static()->WsSession().SimulateRawEvent( eventUp );		
		}	
	return;
	}

void CAknFepUICtrlContainerChinese::CloseUI()
	{
	// Hide container
	if( iFepUiState )
		{
		iFepUiState->CloseUI();
		}
	}

void CAknFepUICtrlContainerChinese::SetFepUiStateCtrl( MAknFepUiStateCtrl* aFepUiState )
    {
    iFepUiState = aFepUiState;
    }

void CAknFepUICtrlContainerChinese::SubmitSelectedTextL(const TDesC& aText)
    {
	// Commit text
    if ( iFepUiState )
        {
		iFepUiState->SubmitTextL( aText );
        }
    }

void CAknFepUICtrlContainerChinese::CloseContainer()
	{
	CloseUI();
	}
