// Copyright (c) 2002-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// Name        : CDeflateCompBytecode.cpp
// Part of     : deflatecomp
// deflate ECOM plugin, CSigCompBytecode implementation
// Version     : 1.
//



#include <e32base.h>
#include <badesca.h>
#include <hash.h>

#include "DeflateCompBytecode.h"


/** bytecode for static compression with optional dictionary */
static const TUint8 KStaticDeflateBytecode[] =
    {
0x1c, 0x0a, 0xa0, 0x75, 0x0a, 0x0f, 0x86, 0x04, 0xa1, 0x6a, 0x00, 0x05, 
0xa1, 0x6a, 0x1c, 0x02, 0xa0, 0x42, 0xfc, 0x17, 0xc0, 0x7b, 0x00, 0x07, 
0x15, 0x07, 0x1f, 0xa0, 0x75, 0x06, 0x00, 0xc0, 0x7b, 0x63, 0x00, 0x13, 
0x63, 0xc0, 0x7b, 0x23, 0x1d, 0x03, 0x2a, 0xe2, 0x1e, 0x20, 0x27, 0x04, 
0x07, 0x00, 0x17, 0x00, 0x01, 0x30, 0xa0, 0xbf, 0x88, 0x00, 0xa0, 0xc0, 
0xa0, 0xc7, 0x18, 0x01, 0x00, 0x89, 0x00, 0x17, 0x50, 0x88, 0x20, 0x06, 
0x06, 0x22, 0x21, 0x01, 0x13, 0x21, 0x01, 0x23, 0x16, 0x9f, 0xdc, 0x0e, 
0x2c, 0xa4, 0x01, 0x23, 0x2c, 0xa0, 0x7d, 0xa0, 0xf5, 0xa0, 0x75, 0xa0, 
0x85, 0x06, 0x00, 0x0e, 0x26, 0x01, 0x07, 0x13, 0x50, 0x01, 0x13, 0x01, 
0x05, 0x10, 0x01, 0x07, 0x10, 0x53, 0x17, 0x50, 0x0e, 0x06, 0x1e, 0xe1, 
0x0e, 0x22, 0x50, 0x09, 0x11, 0x02, 0x0e, 0x24, 0x50, 0x01, 0x12, 0x01, 
0x02, 0x12, 0x02, 0x04, 0x12, 0x51, 0x17, 0x50, 0x01, 0x0a, 0x0d, 0x10, 
0x0e, 0x26, 0xa0, 0xff, 0x0e, 0x24, 0x00, 0x0e, 0x22, 0x01, 0x06, 0x12, 
0x02, 0x02, 0x12, 0x01, 0x07, 0x11, 0x01, 0x04, 0x13, 0x51, 0x06, 0x12, 
0x53, 0x1d, 0x51, 0x2a, 0xed, 0x06, 0x12, 0x55, 0x1e, 0x20, 0xe6, 0x01, 
0x05, 0x00, 0xff, 0x00, 0x0e, 0x28, 0x01, 0x17, 0x50, 0x04, 0x1f, 0x06, 
0x06, 0x0e, 0x26, 0x01, 0x01, 0x13, 0x50, 0x02, 0x13, 0x02, 0x05, 0x10, 
0x01, 0x07, 0x10, 0x01, 0x04, 0x13, 0x50, 0x06, 0x14, 0x53, 0x1d, 0x50, 
0x20, 0xe1, 0x06, 0x14, 0x50, 0x0e, 0x2a, 0x63, 0x14, 0x54, 0x52, 0x23, 
0x22, 0x55, 0x52, 0x16, 0x9f, 0x45
    };

/** bytecode for static compression with uploaded dictionary */
static const TUint8 KStaticUploadDeflateBytecode[] =
    {
0x0f, 0x86, 0x04, 0xa1, 0xcf, 0x00, 0x05, 0xa1, 0xcf, 0x1c, 0x02, 0xa0, 
0x42, 0xfc, 0x1c, 0x02, 0xa0, 0x7b, 0xf7, 0x1c, 0xc0, 0x7b, 0xa1, 0xcf, 
0xf2, 0x13, 0x63, 0xc0, 0x7b, 0x23, 0x0e, 0x28, 0x61, 0x07, 0x14, 0xa1, 
0xcd, 0x0e, 0x2a, 0x54, 0x06, 0x15, 0x08, 0x0f, 0xa1, 0xc5, 0x04, 0x54, 
0xa1, 0xcd, 0x00, 0x06, 0x0e, 0xa1, 0xcd, 0x63, 0x0e, 0xa0, 0x7b, 0x54, 
0x20, 0x54, 0xa1, 0xcd, 0x00, 0x06, 0x01, 0x0d, 0xa1, 0xc5, 0x55, 0x20, 
0x12, 0x20, 0x06, 0xa0, 0x75, 0x1c, 0x02, 0xa0, 0x7d, 0xe5, 0x16, 0x1f, 
0x0f, 0x86, 0x04, 0xa1, 0xcf, 0x00, 0x05, 0xa1, 0xcf, 0x1c, 0x02, 0xa0, 
0x42, 0xe3, 0x1f, 0xa0, 0x75, 0x06, 0x00, 0xc0, 0x7b, 0xa1, 0xcd, 0x00, 
0x0e, 0xa0, 0x46, 0xc1, 0xcd, 0x1d, 0x03, 0x2a, 0xe8, 0x1e, 0x20, 0x27, 
0x04, 0x07, 0x00, 0x17, 0x00, 0x01, 0x30, 0xa0, 0xbf, 0x88, 0x00, 0xa0, 
0xc0, 0xa0, 0xc7, 0x18, 0x01, 0x00, 0x89, 0x00, 0x17, 0x50, 0x88, 0x31, 
0x06, 0x06, 0x22, 0x21, 0x01, 0x13, 0x21, 0x01, 0x23, 0x16, 0x9f, 0xdc, 
0x0e, 0x22, 0xa4, 0x86, 0x0f, 0xa0, 0x6d, 0x04, 0xa1, 0x50, 0xa0, 0x75, 
0xa0, 0xd4, 0x06, 0x0d, 0xa0, 0x6d, 0xa1, 0x58, 0x24, 0x23, 0x22, 0xa0, 
0x7d, 0xa1, 0x50, 0xa0, 0x75, 0xa0, 0xd4, 0x06, 0x00, 0x0e, 0x26, 0x01, 
0x07, 0x13, 0x50, 0x01, 0x13, 0x01, 0x05, 0x10, 0x01, 0x07, 0x10, 0x53, 
0x17, 0x50, 0x0e, 0x07, 0x1f, 0x9f, 0xd0, 0x0e, 0x22, 0x50, 0x09, 0x11, 
0x02, 0x0e, 0x24, 0x50, 0x01, 0x12, 0x01, 0x02, 0x12, 0x02, 0x04, 0x12, 
0x51, 0x17, 0x50, 0x01, 0x0a, 0x0d, 0x10, 0x0e, 0x26, 0xa0, 0xff, 0x0e, 
0x24, 0x00, 0x0e, 0x22, 0x01, 0x06, 0x12, 0x02, 0x02, 0x12, 0x01, 0x07, 
0x11, 0x01, 0x04, 0x13, 0x51, 0x06, 0x12, 0x53, 0x1d, 0x51, 0x2a, 0xed, 
0x06, 0x12, 0x55, 0x1e, 0x20, 0xe6, 0x01, 0x05, 0x00, 0xff, 0x00, 0x0e, 
0x28, 0x01, 0x17, 0x50, 0x04, 0x1f, 0x06, 0x06, 0x0e, 0x26, 0x01, 0x01, 
0x13, 0x50, 0x02, 0x13, 0x02, 0x05, 0x10, 0x01, 0x07, 0x10, 0x01, 0x04, 
0x13, 0x50, 0x06, 0x14, 0x53, 0x1d, 0x50, 0x20, 0xe1, 0x06, 0x14, 0x50, 
0x0e, 0x2a, 0x63, 0x14, 0x54, 0x52, 0x23, 0x22, 0x55, 0x52, 0x16, 0x9f, 
0x33
    };

/** bytecode for dynamic compression with optional dictionary */
static const TUint8 KDynamicDeflateBytecode[] =
    {
0x1c, 0x02, 0xa0, 0x7d, 0x13, 0x20, 0xa1, 0x36, 0xa0, 0x7d, 0xa0, 0x8e, 
0x06, 0x01, 0x0f, 0x86, 0x04, 0xa1, 0xbd, 0x00, 0x05, 0xa1, 0xbd, 0x1c, 
0x02, 0xa0, 0x42, 0xfc, 0x1c, 0x02, 0x2c, 0xf7, 0x17, 0x56, 0x00, 0x06, 
0x15, 0x06, 0x1c, 0x06, 0x2e, 0xed, 0x1f, 0x2e, 0x06, 0x00, 0x56, 0x63, 
0x00, 0x13, 0x63, 0x56, 0x23, 0x1c, 0x02, 0x2c, 0xed, 0x17, 0x56, 0x00, 
0x06, 0x17, 0x06, 0x1c, 0x06, 0x2e, 0xe3, 0x1f, 0x2e, 0x06, 0x00, 0x56, 
0xa1, 0xbb, 0x00, 0x0e, 0xa0, 0x46, 0xc1, 0xbb, 0x1d, 0x03, 0x2a, 0xeb, 
0x1e, 0x20, 0x27, 0x04, 0x07, 0x00, 0x17, 0x00, 0x01, 0x30, 0xa0, 0xbf, 
0x88, 0x00, 0xa0, 0xc0, 0xa0, 0xc7, 0x18, 0x01, 0x00, 0x89, 0x00, 0x17, 
0x50, 0x88, 0x86, 0x06, 0x06, 0x22, 0x21, 0x01, 0x13, 0x21, 0x01, 0x23, 
0x16, 0x9f, 0xdc, 0x0e, 0x2c, 0xa4, 0x88, 0x0e, 0x20, 0x61, 0x07, 0x10, 
0xa1, 0xbb, 0x0e, 0x22, 0x50, 0x06, 0x11, 0x08, 0x0f, 0xa1, 0xb3, 0x04, 
0x50, 0xa1, 0xbb, 0x00, 0x06, 0x0e, 0xa1, 0xbb, 0x63, 0x0d, 0xa1, 0xb3, 
0x51, 0x2e, 0x0e, 0x34, 0x50, 0x23, 0x2c, 0xa0, 0x7d, 0x50, 0xa1, 0xbb, 
0x00, 0x06, 0x00, 0x0e, 0x26, 0x01, 0x07, 0x13, 0x50, 0x01, 0x13, 0x01, 
0x05, 0x10, 0x01, 0x07, 0x10, 0x53, 0x17, 0x50, 0x0e, 0x07, 0x1f, 0x9f, 
0xc1, 0x0e, 0x22, 0x50, 0x09, 0x11, 0x02, 0x0e, 0x24, 0x50, 0x01, 0x12, 
0x01, 0x02, 0x12, 0x02, 0x04, 0x12, 0x51, 0x17, 0x50, 0x01, 0x0a, 0x0d, 
0x10, 0x0e, 0x26, 0xa0, 0xff, 0x0e, 0x24, 0x00, 0x0e, 0x22, 0x01, 0x06, 
0x12, 0x02, 0x02, 0x12, 0x01, 0x07, 0x11, 0x01, 0x04, 0x13, 0x51, 0x06, 
0x12, 0x53, 0x1d, 0x51, 0x2a, 0xed, 0x06, 0x12, 0x55, 0x1e, 0x20, 0xe6, 
0x01, 0x05, 0x00, 0xff, 0x00, 0x0e, 0x28, 0x01, 0x17, 0x50, 0x04, 0x1f, 
0x06, 0x06, 0x0e, 0x26, 0x01, 0x01, 0x13, 0x50, 0x02, 0x13, 0x02, 0x05, 
0x10, 0x01, 0x07, 0x10, 0x01, 0x04, 0x13, 0x50, 0x06, 0x14, 0x53, 0x1d, 
0x50, 0x20, 0xe1, 0x06, 0x14, 0x50, 0x0e, 0x2a, 0x63, 0x14, 0x54, 0x52, 
0x23, 0x22, 0x55, 0x52, 0x16, 0x9f, 0x24
    };

/** bytecode for dynamic compression with uploaded dictionary */
static const TUint8 KDynamicUploadDeflateBytecode[] =
    {
0x0f, 0x86, 0x04, 0xa2, 0x13, 0x00, 0x05, 0xa2, 0x13, 0x1c, 0x02, 0xa0, 
0x42, 0xfc, 0x1c, 0x02, 0xa0, 0x7b, 0xf7, 0x1c, 0xc0, 0x7b, 0xa2, 0x13, 
0xf2, 0x13, 0x63, 0xc0, 0x7b, 0x23, 0x0e, 0x2a, 0xc0, 0x7b, 0x06, 0x15, 
0x08, 0x0f, 0xa2, 0x09, 0x04, 0xc0, 0x7b, 0xa2, 0x11, 0x00, 0x06, 0x0e, 
0xa2, 0x11, 0x63, 0x20, 0xc0, 0x7b, 0xa2, 0x11, 0x00, 0x06, 0x01, 0x0d, 
0xa2, 0x09, 0x55, 0x20, 0x12, 0x20, 0x06, 0xa0, 0x75, 0x1c, 0x02, 0xa0, 
0x7d, 0xe8, 0x0f, 0xa0, 0x6d, 0x04, 0xa1, 0x94, 0xa0, 0x75, 0xa0, 0xeb, 
0x06, 0x0d, 0xa0, 0x6d, 0xa1, 0x9c, 0x20, 0x12, 0x20, 0x06, 0xa0, 0x67, 
0x20, 0xa1, 0x94, 0xa0, 0x75, 0xa0, 0xeb, 0x06, 0x01, 0x16, 0x37, 0x0f, 
0x86, 0x04, 0xa2, 0x13, 0x00, 0x05, 0xa2, 0x13, 0x1c, 0x02, 0xa0, 0x42, 
0xfc, 0x1c, 0x02, 0x20, 0xf7, 0x17, 0x50, 0x00, 0x06, 0x14, 0x06, 0x1c, 
0x06, 0x22, 0xed, 0x1f, 0x22, 0x06, 0x00, 0x50, 0xa2, 0x11, 0x00, 0x16, 
0x0c, 0x1f, 0xa0, 0x75, 0x06, 0x00, 0xc0, 0x7b, 0xa2, 0x11, 0x00, 0x0e, 
0xa0, 0x46, 0xc2, 0x11, 0x1d, 0x03, 0x2a, 0xea, 0x1e, 0x20, 0x28, 0x04, 
0x07, 0x00, 0x17, 0x00, 0x01, 0x30, 0xa0, 0xbf, 0x88, 0x00, 0xa0, 0xc0, 
0xa0, 0xc7, 0x18, 0x01, 0x00, 0x89, 0x00, 0x17, 0x50, 0x88, 0xa0, 0x46, 
0x07, 0x07, 0x22, 0x21, 0x01, 0x13, 0x21, 0x01, 0x23, 0x16, 0x9f, 0xdb, 
0x0e, 0x24, 0xa4, 0x8e, 0x0e, 0x20, 0x61, 0x07, 0x10, 0xa2, 0x11, 0x0e, 
0x22, 0x50, 0x06, 0x11, 0x08, 0x0f, 0xa2, 0x09, 0x04, 0x50, 0xa2, 0x11, 
0x00, 0x06, 0x0e, 0xa2, 0x11, 0x63, 0x0d, 0xa2, 0x09, 0x51, 0x26, 0x0e, 
0x2c, 0x50, 0x12, 0xa0, 0x67, 0x06, 0x2e, 0x23, 0x24, 0xa0, 0x7d, 0x50, 
0xa2, 0x11, 0x00, 0x06, 0x00, 0x0e, 0x26, 0x01, 0x07, 0x13, 0x50, 0x01, 
0x13, 0x01, 0x05, 0x10, 0x01, 0x07, 0x10, 0x53, 0x17, 0x50, 0x0e, 0x07, 
0x1f, 0x9f, 0xbc, 0x0e, 0x22, 0x50, 0x09, 0x11, 0x02, 0x0e, 0x24, 0x50, 
0x01, 0x12, 0x01, 0x02, 0x12, 0x02, 0x04, 0x12, 0x51, 0x17, 0x50, 0x01, 
0x0a, 0x0d, 0x10, 0x0e, 0x26, 0xa0, 0xff, 0x0e, 0x24, 0x00, 0x0e, 0x22, 
0x01, 0x06, 0x12, 0x02, 0x02, 0x12, 0x01, 0x07, 0x11, 0x01, 0x04, 0x13, 
0x51, 0x06, 0x12, 0x53, 0x1d, 0x51, 0x2a, 0xed, 0x06, 0x12, 0x55, 0x1e, 
0x20, 0xe6, 0x01, 0x05, 0x00, 0xff, 0x00, 0x0e, 0x28, 0x01, 0x17, 0x50, 
0x04, 0x1f, 0x06, 0x06, 0x0e, 0x26, 0x01, 0x01, 0x13, 0x50, 0x02, 0x13, 
0x02, 0x05, 0x10, 0x01, 0x07, 0x10, 0x01, 0x04, 0x13, 0x50, 0x06, 0x14, 
0x53, 0x1d, 0x50, 0x20, 0xe1, 0x06, 0x14, 0x50, 0x0e, 0x2a, 0x63, 0x14, 
0x54, 0x52, 0x23, 0x22, 0x55, 0x52, 0x16, 0x9f, 0x1e
    };

/** bytecodes parameters */
const TDeflateCompBytecode KDeflateBytecodes[] =
    {
        // iBytecode, iBytecodeSize,
        // iBytecodeInit, iBytecodeStart, iStateStart, iStateSize, iCBufStart
        {
        KStaticDeflateBytecode, sizeof(KStaticDeflateBytecode),
        0x80, 0x85, 0x75, 0x16a-0x75, 0x16a
        },
        {
        KStaticUploadDeflateBytecode, sizeof(KStaticUploadDeflateBytecode),
        0x80, 0xd4, 0x75, 0x1c5-0x75, 0x1cf
        },
        {
        KDynamicDeflateBytecode, sizeof(KDynamicDeflateBytecode),
        0x80, 0x8e, 0x7d, 0x1b3-0x7d, 0x1bd
        },
        {
        KDynamicUploadDeflateBytecode, sizeof(KDynamicUploadDeflateBytecode),
        0x80, 0xeb, 0x75, 0x209-0x75, 0x213
        }
    };
