/*
* Copyright (c) 2009-2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html."
* Initial Contributors:
* Nokia Corporation - initial contribution.
* Contributors:
*
* Description:
* MSRP Implementation
*
*/

#ifndef CMSRPSTRINGS_H
#define CMSRPSTRINGS_H

// EXTERNAL HEADERS
#include <e32base.h>
#include <stringpool.h>

/*
* CLASS DEFINION
*/
class CMSRPStrings : public CBase
	{
	public:

	    /**
        * Constructor
        */
		static CMSRPStrings* NewL();
	    /**
        * Constructor
        */
		static CMSRPStrings* NewLC();
	    /**
        * Destructor
        */
		~CMSRPStrings();

	    /**
        * Increment couter by one
        */
		void IncrementUsageCount();
	    /**
        * Decrement couter by one
        */
		void DecrementUsageCount();
	    /**
        * Get counter value
        */
		TUint UsageCount() const;

	    /**
        * Get MSRPStrConsts constant
        */
		const RStringPool& Pool() const;
	    /**
        * Get MSRPStrConsts constants
        */
		static const TStringTable& Table();

	private:

	    /**
        * Constructor
        */
		CMSRPStrings();
	    /**
        * Constructor
        */
		void ConstructL();

	private: // Data

		// The string pool handle object
		RStringPool iPool;
		// Counter
		TUint iUsageCount;
	};

#endif // CMSRPSTRINGS_H

// End of File
