// Copyright (c) 1998-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#if !defined(__MSVRCPT_H__)
#define __MSVRCPT_H__

class RWriteStream;

//**********************************
// CMsvRecipient
//**********************************
//
// Base class for  multiple recipients
//

class CMsvRecipient : public CBase
/** Base class for information relating to a message recipient. 
@publishedAll
@released
*/
	{
public:
	/** Message sending status for a recipient. 
@publishedAll
@released
*/
	enum TRecipientStatus 
							{	
	/** Message is not sent. */
							ENotYetSent=0,
	/** Message has been sent. */
							ESentSuccessfully=1,
	/** Message sending failed. */
				 			EFailedToSend=2};
	IMPORT_C virtual void InternalizeL(RReadStream& aStream);
	IMPORT_C virtual void ExternalizeL(RWriteStream& aStream) const;
	inline TRecipientStatus Status() const{return iStatus;};
	inline void SetStatus(TRecipientStatus aStatus){iStatus=aStatus;};
	inline TInt Error() const{return iError;};
	inline void SetError(TInt aError){iError=aError;};
	inline const TTime& Time() const{return iTime;};
	inline TTime& Time(){return iTime;};
	inline TInt Retries() const{return iRetries;};
	inline void IncreaseRetries(){iRetries++;};
	inline void ResetRetries(){iRetries=0;};
#if (defined SYMBIAN_MESSAGESTORE_HEADER_BODY_USING_SQLDB)	
	inline void SetRetries(TInt aRetries){iRetries = aRetries;};
	inline void SetTimeValue(TInt64 aTime){iTime = aTime;};
#endif
protected:
	IMPORT_C CMsvRecipient();
private:
	TRecipientStatus iStatus;
	TInt   iError;
	TInt   iRetries;
	TTime	 iTime;
	};



#endif
