// Copyright (c) 2001-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// This file contains the API definition for the classes 
// CMsgUrlHandlerApplication, CMsgUrlHandlerAppView, 
// CMsgUrlHandlerAppUi, CMsgUrlHandlerDocument.
// 
//

/**
 @file
*/

#ifndef __MSGURLHANDLERAPP_H__
#define __MSGURLHANDLERAPP_H__

#include <coeccntx.h>

#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>

#include <uikon.hrh> 

#include <msgurlhandler.rsg>


/**
	@class
	Dependencies : CEikApplication
	Comments :	Defines the application's UID and manufactures a new, 
				blank document.
	@since 7.0
*/
class CMsgUrlHandlerApplication : public CEikApplication
/**
@internalComponent
@released
*/
	{
private: 

/**
	@fn				CreateDocumentL()
	Intended Usage	:	This function is inherited from class CApaApplication.
						This function is called by the UI framework at
						application start-up. It creates an instance of the
						document class.
	@since			7.0
	@leave		KErrNoMemory.
	@return			Returns the document class
 */
	CApaDocument* CreateDocumentL();

/**
	@fn				AppDllUid() const
	Intended Usage	:	The function is called by the UI framework to ask for the
						application's UID.
	@since			7.0
	@return			Returns the apps uid.
 */
	TUid AppDllUid() const;
	};

/**
	@class
	Dependencies : CEikAppUi
	Comments :	This class handles command generated by the menu items, toolbar
				buttons and shortcut keys. It delegates drawing and screen based
				interaction to the app view and other controls.
	@since 7.0
*/
class CMsgUrlHandlerAppUi : public CEikAppUi
/**
@internalComponent
@released
*/
    {

public:

/**
	@fn				CMsgUrlHandlerAppUi()
	Intended Usage	:	Constructor. First phase of two-phase construction method. Does 
						non-allocating construction.
	@since			7.0
 */
	CMsgUrlHandlerAppUi();

/**
	@fn				~CMsgUrlHandlerAppUi()
	Intended Usage	:	Destructor.
	@since			7.0
 */
	~CMsgUrlHandlerAppUi();

private:

/**
	@fn				ConstructL()
	Intended Usage	:	Second phase of two-phase construction method. Does any 
						allocations required to fully construct the object.

						This function is called by Eikon hence no NewL().

						Starts the Idle time active object which calls the callback
						function. This starts the background task.
						This background task is encapsulated in the callback function. 
	@since			7.0
	@pre 			First phase of construction is complete
	@post			The object is fully constructed and initialised.
					The background task has started.
 */
    void ConstructL();

/**
	@fn				ProcessCommandParametersL(TApaCommand aCommand,TFileName& aDocumentName,const TDesC8& aTail)
	Intended Usage	:	This function is inherirted from class CEikAppUi.
						Reads and assigns the commandline (i.e the url) from apparc.  
	@since			7.0
	@param			aCommand			The shell command sent to the application. 
	@param			aDocumentName		At call time, the name of the document as specified
										on the command line. On return, the name for the 
										file which will be created by the calling framework. 
	@param			aTail				Command line tail.  
	@return			Whether the final value of aDocumentName represents an existing file.
					For this form of the function this is ETrue if the Uikon application 
					framework needs to open an existing file called aDocumentName. 
					Otherwise, this will be EFalse if the Uikon application framework 
					needs to create the file.
	@pre 			None
	@post			The commandline is assigned.
 */
	TBool ProcessCommandParametersL(TApaCommand aCommand,TFileName& aDocumentName,const TDesC8& aTail);

/**
	@fn				HandleCommandL(TInt aCommand)
	Intended Usage	:	Closes the application from the menu item and the shortcut
						key Ctrl-e.
	@since			7.0
	@param			aCommand		A command ID. 
	@pre 			None
	@post			Application is closed if the menu item or the shortcut key is used. 
 */
	void HandleCommandL(TInt aCommand);	

/**
	@fn				static TInt IdleConstructCallbackL(TAny* aThis)
	Intended Usage	:	This is an idle constructor for the callback function.
						It calls the idle constructor.
	@since			7.0
	@param			aThis		Not used 
	@return			If returned true than the active object is scheduled to run again 
					later. If returned false than the active object is no longer scheduled 
					to run. 
	@pre 			The idle active object has started.
	@post			Runs the background task.
 */
	static TInt IdleConstructCallbackL(TAny* aThis);

/**
	@fn				IdleConstructL()
	Intended Usage	:	Idle constructor. Calls the LoadStartPageL function.
	@since			7.0
	@pre 			The idle active object has started.
	@post			Runs the background task.
 */
	void IdleConstructL();

/**
	@fn				LoadStartPageL()
	Intended Usage	:	If the command line exists than it calls the 
						LaunchMailEditor function. 
	@return			void 
	@pre 			The idle active object is running.
	@post			calls the LaunchMailEditor function if the command line exists. 
 */
	void LoadStartPageL();

/**
	@fn				LaunchMailEditorL(const TDesC& aUrl)
	Intended Usage	:	Parses the url (i.e the command line) and 
						launches the correct mail editor.
	Error Condition	:	This function leaves with KErrNotFound if the messaging
						scheme is not found.
	@since			7.0
	@leave		KErrNotSupported
	@param			aUrl		A url descriptor
	@pre 			None
	@post			Parses the url and launches the correct mail editor.
 */
	void LaunchMailEditorL(const TDesC& aUrl);

private:
	/** The descriptor buffer that contains the commandline from apparc
		i.e the messaging url.
	*/
	HBufC* iCommandLineFileName;

	/** The Idle active object */
	CIdle* iIdleConstructor;
	};


/**
	@class
	Dependencies : CEikDocument
	Comments :	Launches the App UI
	@since 7.0
*/
class CMsgUrlHandlerDocument : public CEikDocument
/**
@internalComponent
@released
*/
	{
public:

/**
	@fn				NewL(CEikApplication& aApp)
	Intended Usage	:	Static factory constructor. Uses two phase construction and 
						leaves nothing on the CleanupStack.
	@since			7.0
	@leave		KErrNoMemory.
	@param			aApp		The CEikApplication app
	@return			A pointer to the newly created CMsgUrlHandlerDocument object. 
	@pre 			None
	@post			A fully constructed and initialised CMsgUrlHandlerDocument object.
 */
	static CMsgUrlHandlerDocument* NewL(CEikApplication& aApp);

private:

/**
	@fn				CMsgUrlHandlerDocument(CEikApplication& aApp)
	Intended Usage	:	Constructor. First phase of two-phase construction method. Does 
						non-allocating construction.
	@param			aApp		The CEikApplication app
	@since			7.0
 */
	CMsgUrlHandlerDocument(CEikApplication& aApp);

/**
	@fn				ConstructL()
	Intended Usage	:	Second phase of two-phase construction method. Does any 
						allocations required to fully construct the object.
	@since			7.0
	@leave		KErrNoMemory.
	@pre 			First phase of construction is complete
	@post			The object is fully constructed and initialised.
 */
	void ConstructL();

/**
	@fn				CEikAppUi* CreateAppUiL()
	Intended Usage	:	This function is inherited from CEikDocument.
						Launches the App UI.
	@since			7.0
	@leave		KErrNoMemory.
	@return			Returns a pointer to CEikAppUi  
	@pre 			App is created
	@post			None
 */
	CEikAppUi* CreateAppUiL();
	};


#endif
