/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description: Telephony Multimedia Service - TestApp
 *
 */

#ifndef CTMSTESTENGINE_H
#define CTMSTESTENGINE_H

//#define __PLAY_WAV_FROM_FILE__
//#define __RECORD_WAV_TO_FILE__

// INCLUDES
#include <QTextEdit>
#include <QObject>
#include <e32base.h>
#include <tmsfactory.h>
#include <tmscall.h>
#include <tmsstream.h>
#include <tmsstreamobsrvr.h>
#include <tmsformat.h>
#include <tmsclientsinkobsrvr.h>
#include <tmsclientsourceobsrvr.h>
#include <tmseffectobsrvr.h>
#include <tmsglobalroutingobsrvr.h>
#include <tmsdtmf.h>
#include <tmsdtmfobsrvr.h>
#include <tmsringtone.h>
#include <tmsringtoneobsrvr.h>
#include <tmsinbandtone.h>
#include <tmsinbandtoneobsrvr.h>
#include <tmsbuffer.h>
#include "mtmstestengine.h"

using namespace TMS;

// CLASS DECLARATION
/**
 *  CTmsTestEngine application engine class.
 */
class CTmsTestEngine : public CBase,
                       public TMSStreamObserver,
                       public TMSClientSourceObserver,
                       public TMSClientSinkObserver,
                       public TMSEffectObserver,
                       public TMSGlobalRoutingObserver,
                       public TMSRingToneObserver,
                       public TMSDTMFObserver,
                       public TMSInbandToneObserver,
                       public MTmsTestEngine
    {
public:
    enum TAppState
        {
        ENotReady = 0,
        EReady,
        EStreaming
        };

    /**
     * NewL()
     *
     * Create new CTmsTestEngine object
     * return a pointer to the created instance of CTmsTestEngine
     * @param aView a Pointer to CTmsTestView.
     */
    static CTmsTestEngine* NewL(QTextEdit* statusDisplay);

    /**
     * NewLC()
     *
     */
    static CTmsTestEngine* NewLC(QTextEdit* statusDisplay);

    /**
     * Destructor
     *
     */
    ~CTmsTestEngine();

    void GetSupportedDownlinkFormats(TBool aDisplayCodecs = EFalse);
    void GetSupportedUplinkFormats(TBool aDisplayCodecs = EFalse);
    void SetDownlinkFormat(TMSFormatType aCodecFormat);
    void OpenDownlink();
    void StartDownlink();
    void StopDownlink();
    void CloseDownlink();
    void GetMaxVolume();
    void GetVolume();
    void SetVolume(guint aVolume);
    void MuteSpeaker();
    void SetMaxVolume();
    void VolumeUp();
    void VolumeDn();

    void SetUplinkFormat(TMSFormatType aCodecFormat);
    void OpenUplink();
    void StartUplink();
    void StopUplink();
    void CloseUplink();
    void GetMaxGain();
    void GetGain();
    void SetMaxGain();
    void MuteMic();

    void GetSupportedBitrates();
    gint GetSupportedBitrates(BitRateVector& aBrArr);
    void SelectMinBitrate();
    void SelectMaxBitrate();
    void SetBitrate(TUint aBitrate);
    void GetBitrate();
    void GetBitrate(TUint& aBitrate);
    void ToggleVad();
    void GetVad();
    void ToggleCng();
    void GetCng();
    void TogglePlc();
    void GetPlc();
    void SetDnLinkG711ALAW();
    void SetDnLinkG711uLAW();
    void SetDnLinkILBC20MS();
    void SetDnLinkILBC30MS();
    void SetUpLinkG711ALAW();
    void SetUpLinkG711uLAW();
    void SetUpLinkILBC20MS();
    void SetUpLinkILBC30MS();
    void GetDnLinkG711Mode();
    void GetDnLinkILBCMode();
    void GetUpLinkG711Mode();
    void GetUpLinkILBCMode();

    void SetOutputDevice(TMSAudioOutput device);
    void SetHandset();
    void SetLoudSpeaker();
    void GetAudioDevice();
    void GetAvailableOutput();
    void DoLoopback();
    void OneTouchLoopback();
    void EndCall();

    void InitDTMFTonePlayerDnlink();
    void InitDTMFTonePlayerUplink();
    void DTMFTonePlayDnlink();
    void DTMFTonePlayUplink();
    void CloseDTMFPlayerDnlink();
    void CloseDTMFPlayerUplink();

    gint CreateRingTonePlayer();
    void InitRingTonePlayerFromProfiles();
    void InitRingTonePlayerFromFile();
    void InitRingToneVideoPlayer();
    void InitRingToneSequencePlayer();
    void InitRingToneWithTTS();
    void InitRingToneBeepOnce();
    void InitRingToneSilent();
    void InitRingToneUnsecureVoIP();
    void PlayRingTone();
    void StopRingTone();
    void MuteRingTone();
    void PauseVideoRingTone();
    void CloseRingTonePlayer();
    void DeinitRingTonePlayer();

    void SetCallType(TMSCallType calltype);

    void CreateInbandTonePlayer();
    void StartInbandTone(TMSInbandToneType inbandtonetype);
    void StopInbandTone();

    gint CreateFactory();
    gint CreateCall(TMSCallType calltype);
    gint CreateUplink();
    gint CreateDownlink();
    gint CreateClientSource();
    gint CreateModemSource();
    gint AddClientSourceToStream();
    gint AddModemSourceToStream();
    gint CreateClientSink();
    gint CreateModemSink();
    gint AddClientSinkToStream();
    gint AddModemSinkToStream();
    gint CreateMicSource();
    gint AddMicSourceToStream();
    gint CreateSpeakerSink();
    gint AddSpeakerSinkToStream();

    gint CreateVolumeEffect();
    gint AddVolumeEffectToStream();
    gint CreateGainEffect();
    gint CreateGlobalRouting();
    gint AddGainEffectToStream();

    void CreateGlobalVol();
    void CreateGlobalGain();
    void GetGlobalVol();
    void GetGlobalMaxVol();
    void SetGlobalVol();
    void GetGlobalGain();
    void GetGlobalMaxGain();
    void SetGlobalGain();

    //From TMSClientSourceObserver
    void FillBuffer(TMSBuffer& buffer);
    void BufferProcessed(const TMSBuffer* buffer, gint reason);

    //From TMSClientSinkObserver
    void ProcessBuffer(const TMSBuffer* buffer);

    //From TMSStreamObserver
    void TMSStreamEvent(const TMSStream& stream, TMSSignalEvent event);

    //From TMSClientSinkObserver
    void EffectsEvent(const TMSEffect& tmseffect, TMSSignalEvent event);

    //From TMSGlobalRoutingObserver
    void GlobalRoutingEvent(const TMSGlobalRouting& routing,
            TMSSignalEvent event, TMSAudioOutput output);

    //From TMSRingToneObserver
    void RingtoneEvent(const TMSRingTone& rt, TMSSignalEvent event);

    //From TMSDTMFObserver
    void DTMFEvent(const TMSDTMF& dtmf, TMSSignalEvent event);

    //From TMSInbandToneObserver
    void InbandToneEvent(const TMSInbandTone& inbandtone, TMSSignalEvent event);

private:

    void ConstructL(QTextEdit* statusDisplay);
    CTmsTestEngine();

    void ConfigureDecoder();
    void ConfigureEncoder();

    void DisplayFormat(TMSFormatType aFormat);
    void DisplayDevice(TMSAudioOutput device);
    void DisplayText(const QString& str, const gint num = 0);

#ifdef __RECORD_WAV_TO_FILE__
    void WriteToFile(const guint8* str, const guint len);
#endif //__RECORD_WAV_TO_FILE__

private:

    // For text printing to the display
    QTextEdit* iStatusDisplay;

    // Dn/Uplink, DTMF, Ring tone APIs
    TMSFactory*       iFactory;
    TMSCall*          iTmsCall;
    TMSCallType       iCallType;
    TMSStream*        iTmsDnlink;
    TMSStream*        iTmsUplink;
    TMSSource*        iTmsClientSource;
    TMSSource*        iTmsMicSource;
    TMSSource*        iTmsModemSource;
    TMSSink*          iTmsClientSink;
    TMSSink*          iTmsSpeakerSink;
    TMSSink*          iTmsModemSink;
    TMSDTMF*          iDTMFTonePlayerDn;
    TMSDTMF*          iDTMFTonePlayerUp;
    TMSEffect*        iTmsUplinkEffect;
    TMSEffect*        iTmsDnlinkEffect;
    TMSEffect*        iGlobalVol;
    TMSEffect*        iGlobalGain;
    TMSGlobalRouting* iTmsGlobalRouting;
    TMSRingTone*      iTmsRingTonePlayer;
    TMSInbandTone*    iInbandTonePlayer;

    // Codec format APIs
    TMSFormat* iDecFormatIntfc;
    TMSFormat* iEncFormatIntfc;

    // For internal app state control
    TAppState iDnLinkStatus;
    TAppState iUpLinkStatus;
    TMSFormatType iDnLinkCodec;
    TMSFormatType iUpLinkCodec;
    TBool iOneTouchLoopback;
    TInt iHasDTMFObserver;

    // For storing codec configuration locally
    TBool iPlc;
    TBool iCng;
    TBool iVad;
    TBool iSpkr;
    guint iMaxGain;
    guint iMaxVolume;
    guint iVolume;
    TUint iBitrate;
    BitRateVector iBitratesVector;
    OutputVector iAvailableoutputs;

    // For streaming buffer control
    TBool iPlayBufReady;
    TBool iRecBufReady;
    TInt iPlayBufMaxLen;
    TMSBuffer* iPlayBuf;
    TMSBuffer* iRecBuf;
    TUint iSeqNum;
    TUint iSeqNumIncrement;
    gint iSizeCopy;
    guint8* iDesCopy;

    TMS::FormatVector iUplCodecs;
    TMS::FormatVector iDnlCodecs;
    GString* iRTStr;
    GString* iTTSStr;

#ifdef __WINSCW__
    TInt iBufIndex;
#endif //__WINSCW__

#ifdef __PLAY_WAV_FROM_FILE__
    RFile iFile;
    TInt iFileLen;
    TInt iReadSize;
    TInt iReadPos;
    TBool iEOF;
    RFs iFs;
    HBufC8* iBuf;
#endif

#ifdef __RECORD_WAV_TO_FILE__
    RFile iFile;
    TInt iWriteLen;
    TInt iReadPos;
    RFs iFs;
    HBufC8* iWriteBuf;
#endif //__RECORD_WAV_TO_FILE__
    };

#endif //CTMSTESTENGINE_H

// End of file
