/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  This class implements ECOM controller plugin for playback of
*				 audio contents in 3GPP container family (e.g. 3GP, MP4, M4A, 3G2).
*
*/


#ifndef C3GPAUDIOPLAYCONTROLLERPLUGIN_H
#define C3GPAUDIOPLAYCONTROLLERPLUGIN_H

// INCLUDES
#include "AdvancedAudioPlayController.h"

//#ifdef __AAC_PLUS_DECODER_PLUGIN
//#include "MmfEnhAacPlusUtil.h"
#include <EAacPlusUtil.h>
//#endif

#include "3gpDataSourceAdapter.h"


// FORWARD DECLARATION
class C3GPAudioPlayControllerDecoderBuilder;

// CLASS DECLARATION

/**
*  This class implements 3GPAudioPlayControllerPlugin
*
*  @lib 3GPAudioPlayControllerPlugin.lib
*  @since 3.0
*/
class C3GPAudioPlayControllerPlugin : public CAdvancedAudioPlayController
    {
	public:  // Constructors and destructor

		/**
		* Two-phased constructor.
		*/
		static C3GPAudioPlayControllerPlugin* NewL();

		/**
		* Destructor
		*/
		virtual ~C3GPAudioPlayControllerPlugin();

    protected: // Functions from base classes (MDataSink)

    protected: // Functions from base classes (MAdvancedAudioOutputObserver)

    private: // Functions from base classes

        /**
		* From CAdvancedAudioPlayController
        * Format specific initialization for Data Source
        * @since 3.0
        * @return void
        */
        void DoAddDataSourceL();

        /**
		* From CAdvancedAudioPlayController
        * Format specific initialization for Data Sink
        * @since 3.0
        * @return void
        */
        void DoAddDataSinkL();
        
        /**
		* From CAdvancedAudioPlayController
        * Stops playback.
        * @since 3.0
        * @return void
        */
		void DoStopL(TInt aError);

        /**
		* From CAdvancedAudioPlayController
        * Retrieves config data for codec.
        * @since 5.0
        * @return void
        */
        TInt GetCodecConfigData(RArray<TInt>& aCodecConfigData);

        /**
		* From CAdvancedAudioPlayController
        * Instantiates the codec.
        * @since 5.0
        * @return CAdvancedAudioDecoder*
        */
        CAdvancedAudioDecoder* BuildDecoderL();

    private:

        /**
        * C++ default constructor.
        */
        C3GPAudioPlayControllerPlugin();

        /**
        * By default Symbian 2nd phase constructor is private.
        */
		void ConstructL();

        /**
        * Read 3GP header for information for decoder initialization.
        * @return void
        */
		void DoReadHeaderL(CMMFDataBuffer* aBuffer);

    private:    // Data

		// Builder for decoder object
    	C3GPAudioPlayControllerDecoderBuilder* iDecoderBuilder;

        TBool iInitFillBuffers;
        TUint32 iAudioType;

#ifdef __AAC_PLUS_DECODER_PLUGIN
		CEAacPlusUtil* iAacUtil;
		TInt    iOutFrameSize;		//Size of PCM Samples generated by decoder
		TInt    iNoOfSamples;		//Number of PCM Samples generated by decoder per frame
		TInt    iSamplingFrequency;	//Sampling freq of AAC Code decoder
		TInt    iNoOfChannels;		//No of output channel 1=Mono; 2=Stereo
		TInt	iProfile;			// MPEG Audio Profile 1=AAC-LC Stream; 3=AAC-LTP Stream
		TInt	iOutSamplingFrequency; //Sampling Frequence for the output samples
		TInt	iExtObjectType;	//Type of extended object (5=SBR/HE AAC profile; 6=PS is present)
		TInt	iDownSampledMode; // 0=Normal Mode; 1=Down Sampled mode
		// Format type - ADIF, ADTS, Raw
		CEAacPlusUtil::TEAacPlusFormatType iFormatType;
#endif
        };

#endif // C3GPAUDIOPLAYCONTROLLERPLUGIN_H

// End of File
