/*
* Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   
*	CDCDCDigitalZoom 
*		Scaling of image to display size & zooming.
*		Includes support for different scaling and crop sizes with pan&scan.
*		Pan can use previously computed scaled data when changing.
*		Based on IMAAMI scaling algorithm.
*
*/



#ifndef __DIGITAL_ZOOM_H
#define __DIGITAL_ZOOM_H

#include <e32std.h> // for Fundamental Types
#include <e32base.h> // for Fundamental Types
#include <eikenv.h>
#include "DCDefines.h"

//Const tables for computation speed-up
const TUint16 KDivTable[4 * 256] =
{
				  32768, 21845, 16384, 13107, 10923,  9362,  8192,  7282,
     6554,  5958,  5461,  5041,  4681,  4369,  4096,  3855,  3641,  3449,
     3277,  3121,  2979,  2849,  2731,  2621,  2521,  2427,  2341,  2260,
     2185,  2114,  2048,  1986,  1928,  1872,  1820,  1771,  1725,  1680,
     1638,  1598,  1560,  1524,  1489,  1456,  1425,  1394,  1365,  1337,
     1311,  1285,  1260,  1237,  1214,  1192,  1170,  1150,  1130,  1111,
     1092,  1074,  1057,  1040,  1024,  1008,   993,   978,   964,   950,
      936,   923,   910,   898,   886,   874,   862,   851,   840,   830,
      819,   809,   799,   790,   780,   771,   762,   753,   745,   736,
      728,   720,   712,   705,   697,   690,   683,   676,   669,   662,
      655,   649,   643,   636,   630,   624,   618,   612,   607,   601,
      596,   590,   585,   580,   575,   570,   565,   560,   555,   551,
      546,   542,   537,   533,   529,   524,   520,   516,   512,   508,
      504,   500,   496,   493,   489,   485,   482,   478,   475,   471,
      468,   465,   462,   458,   455,   452,   449,   446,   443,   440,
      437,   434,   431,   428,   426,   423,   420,   417,   415,   412,
      410,   407,   405,   402,   400,   397,   395,   392,   390,   388,
      386,   383,   381,   379,   377,   374,   372,   370,   368,   366,
      364,   362,   360,   358,   356,   354,   352,   350,   349,   347,
      345,   343,   341,   340,   338,   336,   334,   333,   331,   329,
      328,   326,   324,   323,   321,   320,   318,   317,   315,   314,
      312,   311,   309,   308,   306,   305,   303,   302,   301,   299,
      298,   297,   295,   294,   293,   291,   290,   289,   287,   286,
      285,   284,   282,   281,   280,   279,   278,   277,   275,   274,
      273,   272,   271,   270,   269,   267,   266,   265,   264,   263,
      262,   261,   260,   259,   258,   257,   256,   255,   254,   253,
      252,   251,   250,   249,   248,   247,   246,   245,   245,   244,
      243,   242,   241,   240,   239,   238,   237,   237,   236,   235,
      234,   233,   232,   232,   231,   230,   229,   228,   228,   227,
      226,   225,   224,   224,   223,   222,   221,   221,   220,   219,
      218,   218,   217,   216,   216,   215,   214,   213,   213,   212,
      211,   211,   210,   209,   209,   208,   207,   207,   206,   205,
      205,   204,   204,   203,   202,   202,   201,   200,   200,   199,
      199,   198,   197,   197,   196,   196,   195,   194,   194,   193,
      193,   192,   192,   191,   191,   190,   189,   189,   188,   188,
      187,   187,   186,   186,   185,   185,   184,   184,   183,   183,
      182,   182,   181,   181,   180,   180,   179,   179,   178,   178,
      177,   177,   176,   176,   175,   175,   174,   174,   173,   173,
      172,   172,   172,   171,   171,   170,   170,   169,   169,   168,
      168,   168,   167,   167,   166,   166,   165,   165,   165,   164,
      164,   163,   163,   163,   162,   162,   161,   161,   161,   160,
      160,   159,   159,   159,   158,   158,   158,   157,   157,   156,
      156,   156,   155,   155,   155,   154,   154,   153,   153,   153,
      152,   152,   152,   151,   151,   151,   150,   150,   150,   149,
      149,   149,   148,   148,   148,   147,   147,   147,   146,   146,
      146,   145,   145,   145,   144,   144,   144,   143,   143,   143,
      142,   142,   142,   142,   141,   141,   141,   140,   140,   140,
      139,   139,   139,   139,   138,   138,   138,   137,   137,   137,
      137,   136,   136,   136,   135,   135,   135,   135,   134,   134,
      134,   133,   133,   133,   133,   132,   132,   132,   132,   131,
      131,   131,   131,   130,   130,   130,   130,   129,   129,   129,
      129,   128,   128,   128,   128,   127,   127,   127,   127,   126,
      126,   126,   126,   125,   125,   125,   125,   124,   124,   124,
      124,   123,   123,   123,   123,   122,   122,   122,   122,   122,
      121,   121,   121,   121,   120,   120,   120,   120,   120,   119,
      119,   119,   119,   119,   118,   118,   118,   118,   117,   117,
      117,   117,   117,   116,   116,   116,   116,   116,   115,   115,
      115,   115,   115,   114,   114,   114,   114,   114,   113,   113,
      113,   113,   113,   112,   112,   112,   112,   112,   111,   111,
      111,   111,   111,   111,   110,   110,   110,   110,   110,   109,
      109,   109,   109,   109,   109,   108,   108,   108,   108,   108,
      107,   107,   107,   107,   107,   107,   106,   106,   106,   106,
      106,   106,   105,   105,   105,   105,   105,   105,   104,   104,
      104,   104,   104,   104,   103,   103,   103,   103,   103,   103,
      102,   102,   102,   102,   102,   102,   101,   101,   101,   101,
      101,   101,   101,   100,   100,   100,   100,   100,   100,    99,
       99,    99,    99,    99,    99,    99,    98,    98,    98,    98,
       98,    98,    98,    97,    97,    97,    97,    97,    97,    97,
       96,    96,    96,    96,    96,    96,    96,    95,    95,    95,
       95,    95,    95,    95,    94,    94,    94,    94,    94,    94,
       94,    93,    93,    93,    93,    93,    93,    93,    93,    92,
       92,    92,    92,    92,    92,    92,    92,    91,    91,    91,
       91,    91,    91,    91,    91,    90,    90,    90,    90,    90,
       90,    90,    90,    89,    89,    89,    89,    89,    89,    89,
       89,    88,    88,    88,    88,    88,    88,    88,    88,    87,
       87,    87,    87,    87,    87,    87,    87,    87,    86,    86,
       86,    86,    86,    86,    86,    86,    86,    85,    85,    85,
       85,    85,    85,    85,    85,    85,    84,    84,    84,    84,
       84,    84,    84,    84,    84,    83,    83,    83,    83,    83,
       83,    83,    83,    83,    83,    82,    82,    82,    82,    82,
       82,    82,    82,    82,    82,    81,    81,    81,    81,    81,
       81,    81,    81,    81,    81,    80,    80,    80,    80,    80,
       80,    80,    80,    80,    80,    79,    79,    79,    79,    79,
       79,    79,    79,    79,    79,    78,    78,    78,    78,    78,
       78,    78,    78,    78,    78,    78,    77,    77,    77,    77,
       77,    77,    77,    77,    77,    77,    77,    76,    76,    76,
       76,    76,    76,    76,    76,    76,    76,    76,    76,    75,
       75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
       74,    74,    74,    74,    74,    74,    74,    74,    74,    74,
       74,    74,    73,    73,    73,    73,    73,    73,    73,    73,
       73,    73,    73,    73,    72,    72,    72,    72,    72,    72,
       72,    72,    72,    72,    72,    72,    72,    71,    71,    71,
       71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
       70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
       70,    70,    70,    69,    69,    69,    69,    69,    69,    69,
       69,    69,    69,    69,    69,    69,    69,    68,    68,    68,
       68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
       68,    67,    67,    67,    67,    67,    67,    67,    67,    67,
       67,    67,    67,    67,    67,    67,    66,    66,    66,    66,
       66,    66,    66,    66,    66,    66,    66,    66,    66,    66,
       66,    65,    65,    65,    65,    65,    65,    65,    65,    65,
       65,    65,    65,    65,    65,    65,    65,    64,    64,    64,
       64,    64,    64,    64,    64,    64
};




// Class definition
class CDCDigitalZoom : public CBase
{
public:
	
	// Struct definition
	struct DCDigitalZoomParams
	{
		TInt sizeX;		//Output size
		TInt sizeY;
		TReal scaleX;	//Scaling factors
		TReal scaleY;
		TInt allShiftX;	//Pan location
		TInt allShiftY;
		TInt newShiftX;	//Change in pan (used for speed-up)
		TInt newShiftY;	//only one value at time can be >0
	};
	
	//Standard class functions
	CDCDigitalZoom();
	void ConstructL();	
	static CDCDigitalZoom* NewL();
	static CDCDigitalZoom* NewLC();
	~CDCDigitalZoom();

	// Process original image and store output image (main function)
	void ProcessL(const CFbsBitmap* aOriPtr, CFbsBitmap* aOutPtr);

	//Set processing parameters
	void SetParameters(DCDigitalZoomParams* params);
	
	//Get current processing parameters
	void GetParameters(DCDigitalZoomParams* params);
	
protected:

	//Parameters
	DCDigitalZoomParams iParams;

private:

	//Do actual resizing	
	void DecimateL(const CFbsBitmap* aOriPtr, CFbsBitmap* aOutPtr,
						   TInt aOutSizeX, TInt aOutSizeY,
						   TInt aOriSizeX, TInt aOriSizeY,
						   TReal aZoomX, TReal aZoomY,
						   TInt allShiftX, TInt allShiftY,
						   TInt newShiftX, TInt newShiftY);
};
#endif // ifndef __DIGITAL_ZOOM_H
//----IMAAMI----
