/*
* Copyright (c) 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Widget interface with utilities for scrollbar widget.
*
*/

#ifndef I_ALF_SCROLLBARWIDGET_H
#define I_ALF_SCROLLBARWIDGET_H

//WidgetModel includes
#include <alf/ialfwidget.h>
#include <alf/alfevent.h>
#include <alf/alfwidgetevents.h>
#include <alf/ialfwidgetfactory.h>

//osn includes
#include <osn/osndefines.h>
#include <osn/ustring.h>

namespace Alf
    {
namespace alfscrollbarwidget
    {
    /**
     * @namespace alfscrollbarwidget
     * 
     * ident specifies the unique identifier for the grid widget.
     */
    static const IfId ident =
        {
        0, "alfscrollbarwidget"
        };
    static const Utf8* const KBaseElementName = "BaseElement";
    }

/**
 * Enumeration of selectionchanged events generated by the grid widget.
 */
enum
    {
    EEventScrollBarClicked = ELastCommonWidgetEvent+1111,
    EEventScrollBarTouchDown,
    EEventScrollBarDrag
    };
    
    
/**
 * Interface for the scrollbar widget.
 *
 * Default visualization of scrollbar contains following components.
 * <ul>
 * <li>Thumb (The size of the Thumb shows the amount of scrollable content)</li>
 * <li>Track (Place holder for Thumb)</li>
 * </ul>
 * 
 * A scrollbar widget is used along with a scrollable widget,  
 * <ul> 
 * <li>to show the amount of scrollable content inside scrollable widget by 
 * means of thumb size</li>
 * <li>to generate scroll events(MoveUp and Movedown, PageUp PageDown and drag)
 * </li>
 * <li>to show the view start position in the scrollbale content</li>
 * </ul>
 *
 * The communication between scrollbar and scrollable widget happens through 
 * events. Scrollbar handles only pointer events which are converted to higher
 * level events like <b>EEventScrollUp, EEventScrollDown, EEventScrollLeft,
 * EEventScrollRight, EEventScrollPageUp, EEventScrollPageDown, 
 * EEventScrollPageLeft and EEventScrollPageRight</b>
 * and sent to scrollable widget.Scrollable widget can also generate similar 
 * higher level events in response to key and pointer events.In which case it 
 * is scrollable widget's resposibility to send these events to scrollbar.
 *
 */
class IAlfScrollBarWidget: public IAlfWidget
    {
public:
    /**
     * Get the type of widget.
     * 
     * @return The type of widget
     */
    static  const IfId& type()
        {
        return alfscrollbarwidget::ident;
        }

    /**
     * Gets the Base Element Name.
     *
     * @return The base element's name
     */
    static inline const char* baseElementName()
        {
        return alfscrollbarwidget::KBaseElementName;
        }
        
    /**
     * Destructor.
     */	
    virtual ~IAlfScrollBarWidget() {}
    /**
     * Sets whether or not tactile feedback is enabled.
     *
     * @param aFlag Whether or not tactile is enabled.
     */
    virtual void enableTactile(bool aFlag) = 0; 
    
    /**
     * Returns the state of tactile feedback whether it is enabled/disabled.
     *
     * @param aEnabled Whether or not tactile is enabled.
     */
    virtual bool IsTactileEnabled() = 0;

    };

    } // namespace Alf

#endif // IALF_SCROLLBARWIDGET_H
//End Of File
