/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessageChannel.h"

#include "JSMessagePort.h"
#include "MessageChannel.h"
#include "MessagePort.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessageChannel);

/* Hash table */

static const HashTableValue JSMessageChannelTableValues[3] =
{
    { "port1", DontDelete|ReadOnly, (intptr_t)jsMessageChannelPort1, (intptr_t)0 },
    { "port2", DontDelete|ReadOnly, (intptr_t)jsMessageChannelPort2, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMessageChannelTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSMessageChannelTableValues, 0 };
#else
    { 4, 3, JSMessageChannelTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSMessageChannelPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSMessageChannelPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMessageChannelPrototypeTableValues, 0 };
#else
    { 1, 0, JSMessageChannelPrototypeTableValues, 0 };
#endif

static const HashTable* getJSMessageChannelPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelPrototypeTable);
}
const ClassInfo JSMessageChannelPrototype::s_info = { "MessageChannelPrototype", 0, 0, getJSMessageChannelPrototypeTable };

JSObject* JSMessageChannelPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageChannel>(exec, globalObject);
}

static const HashTable* getJSMessageChannelTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelTable);
}
const ClassInfo JSMessageChannel::s_info = { "MessageChannel", 0, 0, getJSMessageChannelTable };

JSMessageChannel::JSMessageChannel(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessageChannel> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSMessageChannel::~JSMessageChannel()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSMessageChannel::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMessageChannelPrototype(JSMessageChannelPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSMessageChannel::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageChannel, Base>(exec, getJSMessageChannelTable(exec), this, propertyName, slot);
}

bool JSMessageChannel::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageChannel, Base>(exec, getJSMessageChannelTable(exec), this, propertyName, descriptor);
}

JSValue jsMessageChannelPort1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageChannel* castedThis = static_cast<JSMessageChannel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MessageChannel* imp = static_cast<MessageChannel*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->port1()));
}

JSValue jsMessageChannelPort2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSMessageChannel* castedThis = static_cast<JSMessageChannel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    MessageChannel* imp = static_cast<MessageChannel*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->port2()));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MessageChannel* object)
{
    return getDOMObjectWrapper<JSMessageChannel>(exec, globalObject, object);
}
MessageChannel* toMessageChannel(JSC::JSValue value)
{
    return value.inherits(&JSMessageChannel::s_info) ? static_cast<JSMessageChannel*>(asObject(value))->impl() : 0;
}

}
