/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2D.h"

#include "CanvasGradient.h"
#include "CanvasPattern.h"
#include "CanvasRenderingContext2D.h"
#include "CanvasStyle.h"
#include "ImageData.h"
#include "JSCanvasGradient.h"
#include "JSImageData.h"
#include "JSTextMetrics.h"
#include "KURL.h"
#include "PlatformString.h"
#include "TextMetrics.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCanvasRenderingContext2D);

/* Hash table */

static const HashTableValue JSCanvasRenderingContext2DTableValues[17] =
{
    { "globalAlpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalAlpha), (intptr_t)setJSCanvasRenderingContext2DGlobalAlpha },
    { "globalCompositeOperation", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalCompositeOperation), (intptr_t)setJSCanvasRenderingContext2DGlobalCompositeOperation },
    { "lineWidth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineWidth), (intptr_t)setJSCanvasRenderingContext2DLineWidth },
    { "lineCap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineCap), (intptr_t)setJSCanvasRenderingContext2DLineCap },
    { "lineJoin", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineJoin), (intptr_t)setJSCanvasRenderingContext2DLineJoin },
    { "miterLimit", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DMiterLimit), (intptr_t)setJSCanvasRenderingContext2DMiterLimit },
    { "shadowOffsetX", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetX), (intptr_t)setJSCanvasRenderingContext2DShadowOffsetX },
    { "shadowOffsetY", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetY), (intptr_t)setJSCanvasRenderingContext2DShadowOffsetY },
    { "shadowBlur", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowBlur), (intptr_t)setJSCanvasRenderingContext2DShadowBlur },
    { "shadowColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowColor), (intptr_t)setJSCanvasRenderingContext2DShadowColor },
    { "font", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFont), (intptr_t)setJSCanvasRenderingContext2DFont },
    { "textAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextAlign), (intptr_t)setJSCanvasRenderingContext2DTextAlign },
    { "textBaseline", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextBaseline), (intptr_t)setJSCanvasRenderingContext2DTextBaseline },
    { "strokeStyle", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DStrokeStyle), (intptr_t)setJSCanvasRenderingContext2DStrokeStyle },
    { "fillStyle", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFillStyle), (intptr_t)setJSCanvasRenderingContext2DFillStyle },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContext2DTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 8191, JSCanvasRenderingContext2DTableValues, 0 };
#else
    { 36, 31, JSCanvasRenderingContext2DTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCanvasRenderingContext2DConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContext2DConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };
#else
    { 1, 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };
#endif

class JSCanvasRenderingContext2DConstructor : public DOMConstructorObject {
public:
    JSCanvasRenderingContext2DConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSCanvasRenderingContext2DConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSCanvasRenderingContext2DPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2DConstructor", 0, &JSCanvasRenderingContext2DConstructorTable, 0 };

bool JSCanvasRenderingContext2DConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2DConstructor, DOMObject>(exec, &JSCanvasRenderingContext2DConstructorTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext2DConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContext2DConstructor, DOMObject>(exec, &JSCanvasRenderingContext2DConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[45] =
{
    { "save", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSave), (intptr_t)0 },
    { "restore", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRestore), (intptr_t)0 },
    { "scale", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionScale), (intptr_t)2 },
    { "rotate", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRotate), (intptr_t)1 },
    { "translate", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTranslate), (intptr_t)2 },
    { "transform", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTransform), (intptr_t)6 },
    { "setTransform", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetTransform), (intptr_t)6 },
    { "createLinearGradient", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t)4 },
    { "createRadialGradient", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t)6 },
    { "clearRect", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearRect), (intptr_t)4 },
    { "fillRect", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillRect), (intptr_t)4 },
    { "beginPath", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBeginPath), (intptr_t)0 },
    { "closePath", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClosePath), (intptr_t)0 },
    { "moveTo", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMoveTo), (intptr_t)2 },
    { "lineTo", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionLineTo), (intptr_t)2 },
    { "quadraticCurveTo", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t)4 },
    { "bezierCurveTo", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t)6 },
    { "arcTo", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArcTo), (intptr_t)5 },
    { "rect", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRect), (intptr_t)4 },
    { "arc", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArc), (intptr_t)6 },
    { "fill", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFill), (intptr_t)0 },
    { "stroke", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStroke), (intptr_t)0 },
    { "clip", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClip), (intptr_t)0 },
    { "isPointInPath", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t)2 },
    { "fillText", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillText), (intptr_t)0 },
    { "strokeText", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeText), (intptr_t)0 },
    { "measureText", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMeasureText), (intptr_t)1 },
    { "setAlpha", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetAlpha), (intptr_t)1 },
    { "setCompositeOperation", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation), (intptr_t)1 },
    { "setLineWidth", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth), (intptr_t)1 },
    { "setLineCap", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineCap), (intptr_t)1 },
    { "setLineJoin", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin), (intptr_t)1 },
    { "setMiterLimit", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit), (intptr_t)1 },
    { "clearShadow", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearShadow), (intptr_t)0 },
    { "setStrokeColor", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor), (intptr_t)0 },
    { "setFillColor", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetFillColor), (intptr_t)0 },
    { "strokeRect", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t)0 },
    { "drawImage", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImage), (intptr_t)0 },
    { "drawImageFromRect", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect), (intptr_t)0 },
    { "setShadow", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetShadow), (intptr_t)0 },
    { "createPattern", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t)0 },
    { "createImageData", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateImageData), (intptr_t)2 },
    { "getImageData", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetImageData), (intptr_t)4 },
    { "putImageData", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionPutImageData), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCanvasRenderingContext2DPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 4095, JSCanvasRenderingContext2DPrototypeTableValues, 0 };
#else
    { 134, 127, JSCanvasRenderingContext2DPrototypeTableValues, 0 };
#endif

const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", 0, &JSCanvasRenderingContext2DPrototypeTable, 0 };

JSObject* JSCanvasRenderingContext2DPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext2D>(exec, globalObject);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", &JSCanvasRenderingContext::s_info, &JSCanvasRenderingContext2DTable, 0 };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasRenderingContext2D> impl)
    : JSCanvasRenderingContext(structure, globalObject, impl)
{
}

JSObject* JSCanvasRenderingContext2D::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCanvasRenderingContext2DPrototype(JSCanvasRenderingContext2DPrototype::createStructure(JSCanvasRenderingContextPrototype::self(exec, globalObject)));
}

bool JSCanvasRenderingContext2D::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, this, propertyName, slot);
}

bool JSCanvasRenderingContext2D::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, this, propertyName, descriptor);
}

JSValue jsCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->globalAlpha());
    return result;
}

JSValue jsCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->globalCompositeOperation());
    return result;
}

JSValue jsCanvasRenderingContext2DLineWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->lineWidth());
    return result;
}

JSValue jsCanvasRenderingContext2DLineCap(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lineCap());
    return result;
}

JSValue jsCanvasRenderingContext2DLineJoin(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lineJoin());
    return result;
}

JSValue jsCanvasRenderingContext2DMiterLimit(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->miterLimit());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->shadowOffsetX());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->shadowOffsetY());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowBlur(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->shadowBlur());
    return result;
}

JSValue jsCanvasRenderingContext2DShadowColor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->shadowColor());
    return result;
}

JSValue jsCanvasRenderingContext2DFont(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->font());
    return result;
}

JSValue jsCanvasRenderingContext2DTextAlign(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->textAlign());
    return result;
}

JSValue jsCanvasRenderingContext2DTextBaseline(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsString(exec, imp->textBaseline());
    return result;
}

JSValue jsCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->strokeStyle(exec);
}

JSValue jsCanvasRenderingContext2DFillStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* castedThis = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->fillStyle(exec);
}

JSValue jsCanvasRenderingContext2DConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCanvasRenderingContext2D* domObject = static_cast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return JSCanvasRenderingContext2D::getConstructor(exec, domObject->globalObject());
}
void JSCanvasRenderingContext2D::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSCanvasRenderingContext2D, Base>(exec, propertyName, value, &JSCanvasRenderingContext2DTable, this, slot);
}

void setJSCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setGlobalAlpha(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setGlobalCompositeOperation(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DLineWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setLineWidth(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DLineCap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setLineCap(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DLineJoin(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setLineJoin(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DMiterLimit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setMiterLimit(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setShadowOffsetX(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setShadowOffsetY(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowBlur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setShadowBlur(value.toFloat(exec));
}

void setJSCanvasRenderingContext2DShadowColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setShadowColor(valueToStringWithNullCheck(exec, value));
}

void setJSCanvasRenderingContext2DFont(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setFont(value.toString(exec));
}

void setJSCanvasRenderingContext2DTextAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setTextAlign(value.toString(exec));
}

void setJSCanvasRenderingContext2DTextBaseline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    imp->setTextBaseline(value.toString(exec));
}

void setJSCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSCanvasRenderingContext2D*>(thisObject)->setStrokeStyle(exec, value);
}

void setJSCanvasRenderingContext2DFillStyle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSCanvasRenderingContext2D*>(thisObject)->setFillStyle(exec, value);
}

JSValue JSCanvasRenderingContext2D::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasRenderingContext2DConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->save();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->restore();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float sx = args.at(0).toFloat(exec);
    float sy = args.at(1).toFloat(exec);

    imp->scale(sx, sy);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float angle = args.at(0).toFloat(exec);

    imp->rotate(angle);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float tx = args.at(0).toFloat(exec);
    float ty = args.at(1).toFloat(exec);

    imp->translate(tx, ty);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float m11 = args.at(0).toFloat(exec);
    float m12 = args.at(1).toFloat(exec);
    float m21 = args.at(2).toFloat(exec);
    float m22 = args.at(3).toFloat(exec);
    float dx = args.at(4).toFloat(exec);
    float dy = args.at(5).toFloat(exec);

    imp->transform(m11, m12, m21, m22, dx, dy);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float m11 = args.at(0).toFloat(exec);
    float m12 = args.at(1).toFloat(exec);
    float m21 = args.at(2).toFloat(exec);
    float m22 = args.at(3).toFloat(exec);
    float dx = args.at(4).toFloat(exec);
    float dy = args.at(5).toFloat(exec);

    imp->setTransform(m11, m12, m21, m22, dx, dy);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x0 = args.at(0).toFloat(exec);
    float y0 = args.at(1).toFloat(exec);
    float x1 = args.at(2).toFloat(exec);
    float y1 = args.at(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createLinearGradient(x0, y0, x1, y1, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x0 = args.at(0).toFloat(exec);
    float y0 = args.at(1).toFloat(exec);
    float r0 = args.at(2).toFloat(exec);
    float x1 = args.at(3).toFloat(exec);
    float y1 = args.at(4).toFloat(exec);
    float r1 = args.at(5).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createRadialGradient(x0, y0, r0, x1, y1, r1, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float width = args.at(2).toFloat(exec);
    float height = args.at(3).toFloat(exec);

    imp->clearRect(x, y, width, height);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float width = args.at(2).toFloat(exec);
    float height = args.at(3).toFloat(exec);

    imp->fillRect(x, y, width, height);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->beginPath();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->closePath();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);

    imp->moveTo(x, y);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);

    imp->lineTo(x, y);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float cpx = args.at(0).toFloat(exec);
    float cpy = args.at(1).toFloat(exec);
    float x = args.at(2).toFloat(exec);
    float y = args.at(3).toFloat(exec);

    imp->quadraticCurveTo(cpx, cpy, x, y);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float cp1x = args.at(0).toFloat(exec);
    float cp1y = args.at(1).toFloat(exec);
    float cp2x = args.at(2).toFloat(exec);
    float cp2y = args.at(3).toFloat(exec);
    float x = args.at(4).toFloat(exec);
    float y = args.at(5).toFloat(exec);

    imp->bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x1 = args.at(0).toFloat(exec);
    float y1 = args.at(1).toFloat(exec);
    float x2 = args.at(2).toFloat(exec);
    float y2 = args.at(3).toFloat(exec);
    float radius = args.at(4).toFloat(exec);

    imp->arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float width = args.at(2).toFloat(exec);
    float height = args.at(3).toFloat(exec);

    imp->rect(x, y, width, height);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float radius = args.at(2).toFloat(exec);
    float startAngle = args.at(3).toFloat(exec);
    float endAngle = args.at(4).toFloat(exec);
    bool anticlockwise = args.at(5).toBoolean(exec);

    imp->arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->fill();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->stroke();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->clip();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = jsBoolean(imp->isPointInPath(x, y));
    return result;
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->fillText(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->strokeText(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& text = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->measureText(text)));
    return result;
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float alpha = args.at(0).toFloat(exec);

    imp->setAlpha(alpha);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& compositeOperation = args.at(0).toString(exec);

    imp->setCompositeOperation(compositeOperation);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float width = args.at(0).toFloat(exec);

    imp->setLineWidth(width);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& cap = args.at(0).toString(exec);

    imp->setLineCap(cap);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    const UString& join = args.at(0).toString(exec);

    imp->setLineJoin(join);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    float limit = args.at(0).toFloat(exec);

    imp->setMiterLimit(limit);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());

    imp->clearShadow();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->setStrokeColor(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->setFillColor(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->strokeRect(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->drawImage(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->drawImageFromRect(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->setShadow(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->createPattern(exec, args);
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float sw = args.at(0).toFloat(exec);
    float sh = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createImageData(sw, sh, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    CanvasRenderingContext2D* imp = static_cast<CanvasRenderingContext2D*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float sx = args.at(0).toFloat(exec);
    float sy = args.at(1).toFloat(exec);
    float sw = args.at(2).toFloat(exec);
    float sh = args.at(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getImageData(sx, sy, sw, sh, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwError(exec, TypeError);
    JSCanvasRenderingContext2D* castedThisObj = static_cast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    return castedThisObj->putImageData(exec, args);
}


}
