/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMFormData.h"

#include "DOMFormData.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMFormData);

/* Hash table */

static const HashTableValue JSDOMFormDataTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFormDataConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDOMFormDataTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDOMFormDataTableValues, 0 };
#else
    { 2, 1, JSDOMFormDataTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSDOMFormDataConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDOMFormDataConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDOMFormDataConstructorTableValues, 0 };
#else
    { 1, 0, JSDOMFormDataConstructorTableValues, 0 };
#endif

class JSDOMFormDataConstructor : public DOMConstructorObject {
public:
    JSDOMFormDataConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSDOMFormDataConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSDOMFormDataPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
    static JSObject* constructDOMFormData(ExecState* exec, JSObject* constructor, const ArgList&)
    {
        return asObject(toJS(exec, static_cast<JSDOMFormDataConstructor*>(constructor)->globalObject(), DOMFormData::create()));
    }
    virtual ConstructType getConstructData(ConstructData& constructData)
    {
        constructData.native.function = constructDOMFormData;
        return ConstructTypeHost;
    }
};

const ClassInfo JSDOMFormDataConstructor::s_info = { "FormDataConstructor", 0, &JSDOMFormDataConstructorTable, 0 };

bool JSDOMFormDataConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMFormDataConstructor, DOMObject>(exec, &JSDOMFormDataConstructorTable, this, propertyName, slot);
}

bool JSDOMFormDataConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMFormDataConstructor, DOMObject>(exec, &JSDOMFormDataConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMFormDataPrototypeTableValues[2] =
{
    { "append", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsDOMFormDataPrototypeFunctionAppend), (intptr_t)2 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDOMFormDataPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDOMFormDataPrototypeTableValues, 0 };
#else
    { 2, 1, JSDOMFormDataPrototypeTableValues, 0 };
#endif

const ClassInfo JSDOMFormDataPrototype::s_info = { "FormDataPrototype", 0, &JSDOMFormDataPrototypeTable, 0 };

JSObject* JSDOMFormDataPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMFormData>(exec, globalObject);
}

bool JSDOMFormDataPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMFormDataPrototypeTable, this, propertyName, slot);
}

bool JSDOMFormDataPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMFormDataPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMFormData::s_info = { "FormData", 0, &JSDOMFormDataTable, 0 };

JSDOMFormData::JSDOMFormData(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMFormData> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDOMFormData::~JSDOMFormData()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDOMFormData::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMFormDataPrototype(JSDOMFormDataPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDOMFormData::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMFormData, Base>(exec, &JSDOMFormDataTable, this, propertyName, slot);
}

bool JSDOMFormData::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMFormData, Base>(exec, &JSDOMFormDataTable, this, propertyName, descriptor);
}

JSValue jsDOMFormDataConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMFormData* domObject = static_cast<JSDOMFormData*>(asObject(slotBase));
    return JSDOMFormData::getConstructor(exec, domObject->globalObject());
}
JSValue JSDOMFormData::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMFormDataConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsDOMFormDataPrototypeFunctionAppend(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDOMFormData::s_info))
        return throwError(exec, TypeError);
    JSDOMFormData* castedThisObj = static_cast<JSDOMFormData*>(asObject(thisValue));
    return castedThisObj->append(exec, args);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMFormData* object)
{
    return getDOMObjectWrapper<JSDOMFormData>(exec, globalObject, object);
}
DOMFormData* toDOMFormData(JSC::JSValue value)
{
    return value.inherits(&JSDOMFormData::s_info) ? static_cast<JSDOMFormData*>(asObject(value))->impl() : 0;
}

}
