/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATAGRID)

#include "JSDataGridColumn.h"

#include "DataGridColumn.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDataGridColumn);

/* Hash table */

static const HashTableValue JSDataGridColumnTableValues[8] =
{
    { "id", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnId), (intptr_t)setJSDataGridColumnId },
    { "label", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnLabel), (intptr_t)setJSDataGridColumnLabel },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnType), (intptr_t)setJSDataGridColumnType },
    { "sortable", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSortable), (intptr_t)setJSDataGridColumnSortable },
    { "sortDirection", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSortDirection), (intptr_t)setJSDataGridColumnSortDirection },
    { "primary", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnPrimary), (intptr_t)setJSDataGridColumnPrimary },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDataGridColumnTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSDataGridColumnTableValues, 0 };
#else
    { 17, 15, JSDataGridColumnTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSDataGridColumnConstructorTableValues[7] =
{
    { "NEVER_SORTED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnNEVER_SORTED), (intptr_t)0 },
    { "ALWAYS_SORTED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnALWAYS_SORTED), (intptr_t)0 },
    { "SOMETIMES_SORTED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSOMETIMES_SORTED), (intptr_t)0 },
    { "NATURAL_SORT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnNATURAL_SORT), (intptr_t)0 },
    { "SORT_ASCENDING", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSORT_ASCENDING), (intptr_t)0 },
    { "SORC_DESCENDING", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSORC_DESCENDING), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDataGridColumnConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSDataGridColumnConstructorTableValues, 0 };
#else
    { 17, 15, JSDataGridColumnConstructorTableValues, 0 };
#endif

class JSDataGridColumnConstructor : public DOMConstructorObject {
public:
    JSDataGridColumnConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSDataGridColumnConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSDataGridColumnPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDataGridColumnConstructor::s_info = { "DataGridColumnConstructor", 0, &JSDataGridColumnConstructorTable, 0 };

bool JSDataGridColumnConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDataGridColumnConstructor, DOMObject>(exec, &JSDataGridColumnConstructorTable, this, propertyName, slot);
}

bool JSDataGridColumnConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDataGridColumnConstructor, DOMObject>(exec, &JSDataGridColumnConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDataGridColumnPrototypeTableValues[7] =
{
    { "NEVER_SORTED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnNEVER_SORTED), (intptr_t)0 },
    { "ALWAYS_SORTED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnALWAYS_SORTED), (intptr_t)0 },
    { "SOMETIMES_SORTED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSOMETIMES_SORTED), (intptr_t)0 },
    { "NATURAL_SORT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnNATURAL_SORT), (intptr_t)0 },
    { "SORT_ASCENDING", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSORT_ASCENDING), (intptr_t)0 },
    { "SORC_DESCENDING", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataGridColumnSORC_DESCENDING), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDataGridColumnPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSDataGridColumnPrototypeTableValues, 0 };
#else
    { 17, 15, JSDataGridColumnPrototypeTableValues, 0 };
#endif

const ClassInfo JSDataGridColumnPrototype::s_info = { "DataGridColumnPrototype", 0, &JSDataGridColumnPrototypeTable, 0 };

JSObject* JSDataGridColumnPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDataGridColumn>(exec, globalObject);
}

bool JSDataGridColumnPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDataGridColumnPrototype, JSObject>(exec, &JSDataGridColumnPrototypeTable, this, propertyName, slot);
}

bool JSDataGridColumnPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDataGridColumnPrototype, JSObject>(exec, &JSDataGridColumnPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDataGridColumn::s_info = { "DataGridColumn", 0, &JSDataGridColumnTable, 0 };

JSDataGridColumn::JSDataGridColumn(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<DataGridColumn> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDataGridColumn::~JSDataGridColumn()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDataGridColumn::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDataGridColumnPrototype(JSDataGridColumnPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDataGridColumn::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDataGridColumn, Base>(exec, &JSDataGridColumnTable, this, propertyName, slot);
}

bool JSDataGridColumn::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDataGridColumn, Base>(exec, &JSDataGridColumnTable, this, propertyName, descriptor);
}

JSValue jsDataGridColumnId(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* castedThis = static_cast<JSDataGridColumn*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThis->impl());
    JSValue result = jsString(exec, imp->id());
    return result;
}

JSValue jsDataGridColumnLabel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* castedThis = static_cast<JSDataGridColumn*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThis->impl());
    JSValue result = jsString(exec, imp->label());
    return result;
}

JSValue jsDataGridColumnType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* castedThis = static_cast<JSDataGridColumn*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}

JSValue jsDataGridColumnSortable(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* castedThis = static_cast<JSDataGridColumn*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->sortable());
    return result;
}

JSValue jsDataGridColumnSortDirection(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* castedThis = static_cast<JSDataGridColumn*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->sortDirection());
    return result;
}

JSValue jsDataGridColumnPrimary(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* castedThis = static_cast<JSDataGridColumn*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThis->impl());
    JSValue result = jsBoolean(imp->primary());
    return result;
}

JSValue jsDataGridColumnConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDataGridColumn* domObject = static_cast<JSDataGridColumn*>(asObject(slotBase));
    return JSDataGridColumn::getConstructor(exec, domObject->globalObject());
}
void JSDataGridColumn::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSDataGridColumn, Base>(exec, propertyName, value, &JSDataGridColumnTable, this, slot);
}

void setJSDataGridColumnId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDataGridColumn* castedThisObj = static_cast<JSDataGridColumn*>(thisObject);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThisObj->impl());
    imp->setId(value.toString(exec));
}

void setJSDataGridColumnLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDataGridColumn* castedThisObj = static_cast<JSDataGridColumn*>(thisObject);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThisObj->impl());
    imp->setLabel(value.toString(exec));
}

void setJSDataGridColumnType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDataGridColumn* castedThisObj = static_cast<JSDataGridColumn*>(thisObject);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThisObj->impl());
    imp->setType(value.toString(exec));
}

void setJSDataGridColumnSortable(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDataGridColumn* castedThisObj = static_cast<JSDataGridColumn*>(thisObject);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThisObj->impl());
    imp->setSortable(value.toInt32(exec));
}

void setJSDataGridColumnSortDirection(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDataGridColumn* castedThisObj = static_cast<JSDataGridColumn*>(thisObject);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThisObj->impl());
    imp->setSortDirection(value.toInt32(exec));
}

void setJSDataGridColumnPrimary(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDataGridColumn* castedThisObj = static_cast<JSDataGridColumn*>(thisObject);
    DataGridColumn* imp = static_cast<DataGridColumn*>(castedThisObj->impl());
    imp->setPrimary(value.toBoolean(exec));
}

JSValue JSDataGridColumn::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataGridColumnConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsDataGridColumnNEVER_SORTED(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsDataGridColumnALWAYS_SORTED(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsDataGridColumnSOMETIMES_SORTED(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsDataGridColumnNATURAL_SORT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsDataGridColumnSORT_ASCENDING(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsDataGridColumnSORC_DESCENDING(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DataGridColumn* object)
{
    return getDOMObjectWrapper<JSDataGridColumn>(exec, globalObject, object);
}
DataGridColumn* toDataGridColumn(JSC::JSValue value)
{
    return value.inherits(&JSDataGridColumn::s_info) ? static_cast<JSDataGridColumn*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATAGRID)
