/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClipboard.h"

#include "Clipboard.h"
#include "FileList.h"
#include "JSFileList.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSClipboard);

/* Hash table */

static const HashTableValue JSClipboardTableValues[6] =
{
    { "dropEffect", DontDelete, (intptr_t)jsClipboardDropEffect, (intptr_t)setJSClipboardDropEffect },
    { "effectAllowed", DontDelete, (intptr_t)jsClipboardEffectAllowed, (intptr_t)setJSClipboardEffectAllowed },
    { "types", DontDelete|ReadOnly, (intptr_t)jsClipboardTypes, (intptr_t)0 },
    { "files", DontDelete|ReadOnly, (intptr_t)jsClipboardFiles, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsClipboardConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClipboardTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSClipboardTableValues, 0 };
#else
    { 17, 15, JSClipboardTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSClipboardConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClipboardConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSClipboardConstructorTableValues, 0 };
#else
    { 1, 0, JSClipboardConstructorTableValues, 0 };
#endif

class JSClipboardConstructor : public DOMConstructorObject {
public:
    JSClipboardConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSClipboardConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSClipboardPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSClipboardConstructor::s_info = { "ClipboardConstructor", 0, &JSClipboardConstructorTable, 0 };

bool JSClipboardConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboardConstructor, DOMObject>(exec, &JSClipboardConstructorTable, this, propertyName, slot);
}

bool JSClipboardConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClipboardConstructor, DOMObject>(exec, &JSClipboardConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSClipboardPrototypeTableValues[5] =
{
    { "clearData", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionClearData, (intptr_t)1 },
    { "getData", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionGetData, (intptr_t)1 },
    { "setData", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionSetData, (intptr_t)2 },
    { "setDragImage", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionSetDragImage, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSClipboardPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSClipboardPrototypeTableValues, 0 };
#else
    { 8, 7, JSClipboardPrototypeTableValues, 0 };
#endif

const ClassInfo JSClipboardPrototype::s_info = { "ClipboardPrototype", 0, &JSClipboardPrototypeTable, 0 };

JSObject* JSClipboardPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClipboard>(exec, globalObject);
}

bool JSClipboardPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSClipboardPrototypeTable, this, propertyName, slot);
}

bool JSClipboardPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSClipboardPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSClipboard::s_info = { "Clipboard", 0, &JSClipboardTable, 0 };

JSClipboard::JSClipboard(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Clipboard> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSClipboard::~JSClipboard()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSClipboard::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSClipboardPrototype(JSClipboardPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSClipboard::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboard, Base>(exec, &JSClipboardTable, this, propertyName, slot);
}

bool JSClipboard::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClipboard, Base>(exec, &JSClipboardTable, this, propertyName, descriptor);
}

JSValue jsClipboardDropEffect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    return jsStringOrUndefined(exec, imp->dropEffect());
}

JSValue jsClipboardEffectAllowed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    return jsStringOrUndefined(exec, imp->effectAllowed());
}

JSValue jsClipboardTypes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slot.slotBase()));
    return castedThis->types(exec);
}

JSValue jsClipboardFiles(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClipboard* castedThis = static_cast<JSClipboard*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Clipboard* imp = static_cast<Clipboard*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->files()));
}

JSValue jsClipboardConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSClipboard* domObject = static_cast<JSClipboard*>(asObject(slot.slotBase()));
    return JSClipboard::getConstructor(exec, domObject->globalObject());
}
void JSClipboard::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSClipboard, Base>(exec, propertyName, value, &JSClipboardTable, this, slot);
}

void setJSClipboardDropEffect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    Clipboard* imp = static_cast<Clipboard*>(static_cast<JSClipboard*>(thisObject)->impl());
    imp->setDropEffect(value.toString(exec));
}

void setJSClipboardEffectAllowed(ExecState* exec, JSObject* thisObject, JSValue value)
{
    Clipboard* imp = static_cast<Clipboard*>(static_cast<JSClipboard*>(thisObject)->impl());
    imp->setEffectAllowed(value.toString(exec));
}

JSValue JSClipboard::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClipboardConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsClipboardPrototypeFunctionClearData(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->clearData(exec, args);
}

JSValue JSC_HOST_CALL jsClipboardPrototypeFunctionGetData(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->getData(exec, args);
}

JSValue JSC_HOST_CALL jsClipboardPrototypeFunctionSetData(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->setData(exec, args);
}

JSValue JSC_HOST_CALL jsClipboardPrototypeFunctionSetDragImage(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->setDragImage(exec, args);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Clipboard* object)
{
    return getDOMObjectWrapper<JSClipboard>(exec, globalObject, object);
}
Clipboard* toClipboard(JSC::JSValue value)
{
    return value.inherits(&JSClipboard::s_info) ? static_cast<JSClipboard*>(asObject(value))->impl() : 0;
}

}
