/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElementInstance.h"

#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSSVGElement.h"
#include "JSSVGElementInstance.h"
#include "JSSVGElementInstanceList.h"
#include "JSSVGUseElement.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include "SVGUseElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGElementInstance);

/* Hash table */

static const HashTableValue JSSVGElementInstanceTableValues[49] =
{
    { "correspondingElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceCorrespondingElement, (intptr_t)0 },
    { "correspondingUseElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceCorrespondingUseElement, (intptr_t)0 },
    { "parentNode", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceParentNode, (intptr_t)0 },
    { "childNodes", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceChildNodes, (intptr_t)0 },
    { "firstChild", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceFirstChild, (intptr_t)0 },
    { "lastChild", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceLastChild, (intptr_t)0 },
    { "previousSibling", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstancePreviousSibling, (intptr_t)0 },
    { "nextSibling", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceNextSibling, (intptr_t)0 },
    { "onabort", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnabort, (intptr_t)setJSSVGElementInstanceOnabort },
    { "onblur", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnblur, (intptr_t)setJSSVGElementInstanceOnblur },
    { "onchange", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnchange, (intptr_t)setJSSVGElementInstanceOnchange },
    { "onclick", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnclick, (intptr_t)setJSSVGElementInstanceOnclick },
    { "oncontextmenu", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOncontextmenu, (intptr_t)setJSSVGElementInstanceOncontextmenu },
    { "ondblclick", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndblclick, (intptr_t)setJSSVGElementInstanceOndblclick },
    { "onerror", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnerror, (intptr_t)setJSSVGElementInstanceOnerror },
    { "onfocus", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnfocus, (intptr_t)setJSSVGElementInstanceOnfocus },
    { "oninput", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOninput, (intptr_t)setJSSVGElementInstanceOninput },
    { "onkeydown", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnkeydown, (intptr_t)setJSSVGElementInstanceOnkeydown },
    { "onkeypress", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnkeypress, (intptr_t)setJSSVGElementInstanceOnkeypress },
    { "onkeyup", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnkeyup, (intptr_t)setJSSVGElementInstanceOnkeyup },
    { "onload", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnload, (intptr_t)setJSSVGElementInstanceOnload },
    { "onmousedown", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmousedown, (intptr_t)setJSSVGElementInstanceOnmousedown },
    { "onmousemove", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmousemove, (intptr_t)setJSSVGElementInstanceOnmousemove },
    { "onmouseout", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmouseout, (intptr_t)setJSSVGElementInstanceOnmouseout },
    { "onmouseover", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmouseover, (intptr_t)setJSSVGElementInstanceOnmouseover },
    { "onmouseup", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmouseup, (intptr_t)setJSSVGElementInstanceOnmouseup },
    { "onmousewheel", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmousewheel, (intptr_t)setJSSVGElementInstanceOnmousewheel },
    { "onbeforecut", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnbeforecut, (intptr_t)setJSSVGElementInstanceOnbeforecut },
    { "oncut", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOncut, (intptr_t)setJSSVGElementInstanceOncut },
    { "onbeforecopy", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnbeforecopy, (intptr_t)setJSSVGElementInstanceOnbeforecopy },
    { "oncopy", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOncopy, (intptr_t)setJSSVGElementInstanceOncopy },
    { "onbeforepaste", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnbeforepaste, (intptr_t)setJSSVGElementInstanceOnbeforepaste },
    { "onpaste", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnpaste, (intptr_t)setJSSVGElementInstanceOnpaste },
    { "ondragenter", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragenter, (intptr_t)setJSSVGElementInstanceOndragenter },
    { "ondragover", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragover, (intptr_t)setJSSVGElementInstanceOndragover },
    { "ondragleave", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragleave, (intptr_t)setJSSVGElementInstanceOndragleave },
    { "ondrop", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndrop, (intptr_t)setJSSVGElementInstanceOndrop },
    { "ondragstart", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragstart, (intptr_t)setJSSVGElementInstanceOndragstart },
    { "ondrag", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndrag, (intptr_t)setJSSVGElementInstanceOndrag },
    { "ondragend", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragend, (intptr_t)setJSSVGElementInstanceOndragend },
    { "onreset", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnreset, (intptr_t)setJSSVGElementInstanceOnreset },
    { "onresize", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnresize, (intptr_t)setJSSVGElementInstanceOnresize },
    { "onscroll", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnscroll, (intptr_t)setJSSVGElementInstanceOnscroll },
    { "onsearch", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnsearch, (intptr_t)setJSSVGElementInstanceOnsearch },
    { "onselect", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnselect, (intptr_t)setJSSVGElementInstanceOnselect },
    { "onselectstart", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnselectstart, (intptr_t)setJSSVGElementInstanceOnselectstart },
    { "onsubmit", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnsubmit, (intptr_t)setJSSVGElementInstanceOnsubmit },
    { "onunload", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnunload, (intptr_t)setJSSVGElementInstanceOnunload },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementInstanceTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 4095, JSSVGElementInstanceTableValues, 0 };
#else
    { 137, 127, JSSVGElementInstanceTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGElementInstancePrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsSVGElementInstancePrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsSVGElementInstancePrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsSVGElementInstancePrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementInstancePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGElementInstancePrototypeTableValues, 0 };
#else
    { 8, 7, JSSVGElementInstancePrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGElementInstancePrototype::s_info = { "SVGElementInstancePrototype", 0, &JSSVGElementInstancePrototypeTable, 0 };

JSObject* JSSVGElementInstancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElementInstance>(exec, globalObject);
}

bool JSSVGElementInstancePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGElementInstancePrototypeTable, this, propertyName, slot);
}

bool JSSVGElementInstancePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGElementInstancePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGElementInstance::s_info = { "SVGElementInstance", 0, &JSSVGElementInstanceTable, 0 };

JSSVGElementInstance::JSSVGElementInstance(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElementInstance> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGElementInstance::~JSSVGElementInstance()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), impl());
}

JSObject* JSSVGElementInstance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGElementInstancePrototype(JSSVGElementInstancePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGElementInstance::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, slot);
}

bool JSSVGElementInstance::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, descriptor);
}

JSValue jsSVGElementInstanceCorrespondingElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->correspondingElement()));
}

JSValue jsSVGElementInstanceCorrespondingUseElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->correspondingUseElement()));
}

JSValue jsSVGElementInstanceParentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->parentNode()));
}

JSValue jsSVGElementInstanceChildNodes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->childNodes()));
}

JSValue jsSVGElementInstanceFirstChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->firstChild()));
}

JSValue jsSVGElementInstanceLastChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->lastChild()));
}

JSValue jsSVGElementInstancePreviousSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->previousSibling()));
}

JSValue jsSVGElementInstanceNextSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nextSibling()));
}

JSValue jsSVGElementInstanceOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnblur(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnchange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onchange()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onclick()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOncontextmenu(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncontextmenu()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndblclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondblclick()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnfocus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOninput(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oninput()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnkeydown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeydown()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnkeypress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeypress()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnkeyup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeyup()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmousedown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousedown()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmousemove(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousemove()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmouseout(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseout()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmouseover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseover()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmouseup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseup()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmousewheel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousewheel()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnbeforecut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecut()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOncut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncut()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnbeforecopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecopy()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOncopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncopy()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnbeforepaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforepaste()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnpaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onpaste()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragenter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragenter()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragover()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragleave(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragleave()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndrop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondrop()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragstart()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndrag(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondrag()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragend(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragend()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnreset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onreset()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnresize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onresize()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnscroll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onscroll()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnsearch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onsearch()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnselect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onselect()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnselectstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onselectstart()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnsubmit(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onsubmit()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onunload()) {
        if (JSObject* jsFunction = listener->jsFunction(imp->scriptExecutionContext()))
            return jsFunction;
    }
    return jsNull();
}

void JSSVGElementInstance::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGElementInstance, Base>(exec, propertyName, value, &JSSVGElementInstanceTable, this, slot);
}

void setJSSVGElementInstanceOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnabort(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnblur(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnchange(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnclick(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncontextmenu(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndblclick(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnerror(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnfocus(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOninput(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnkeydown(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnkeypress(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnkeyup(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnload(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmousedown(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmousemove(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmouseout(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmouseover(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmouseup(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmousewheel(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnbeforecut(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncut(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnbeforecopy(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncopy(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnbeforepaste(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnpaste(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragenter(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragover(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragleave(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndrop(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragstart(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndrag(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragend(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnreset(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnresize(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnscroll(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnsearch(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnselect(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnselectstart(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnsubmit(globalObject->createJSAttributeEventListener(value));
}

void setJSSVGElementInstanceOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnunload(globalObject->createJSAttributeEventListener(value));
}

JSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstance* castedThisObj = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstance* castedThisObj = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstance* castedThisObj = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* event = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return result;
}

SVGElementInstance* toSVGElementInstance(JSC::JSValue value)
{
    return value.inherits(&JSSVGElementInstance::s_info) ? static_cast<JSSVGElementInstance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
